/*
 * Decompiled with CFR 0.152.
 */
package com.sun.sunvts.bean;

import com.sun.deg.sunvts.ms.ServerAdapter;

public class LogBean {
    private String logs = null;
    private int noOfTestErrorLines = 30;
    private int noOfVTSKErrorLines = 30;
    private int noOfTestInfoLines = 30;
    private int noOfUnixMsgsLines = 30;
    private int noOfTestVerboseLines = 30;
    private int noOfTSSRLines = 30;
    private int noOfVTSReportLines = 30;
    private String hostName = null;
    private boolean mfgExist = false;
    private String logname = null;
    private ServerAdapter serverAdapter = ServerAdapter.getServerAdapter();
    private static LogBean logbean = null;

    private LogBean() {
    }

    public static LogBean getLogBean() {
        if (logbean == null) {
            logbean = new LogBean();
        }
        return logbean;
    }

    public void viewLog(String logname, int numLines) throws Exception {
        this.logname = logname;
        if (this.getLogname().equalsIgnoreCase("Test Error")) {
            this.setNoOfTestErrorLines(numLines);
            this.viewTestErrorLogs();
        }
        if (this.getLogname().equalsIgnoreCase("VTSK Error")) {
            this.setNoOfVTSKErrorLines(numLines);
            this.viewVTSKErrorLogs();
        }
        if (this.getLogname().equalsIgnoreCase("Test Information")) {
            this.setNoOfTestInfoLines(numLines);
            this.viewTestInfo();
        }
        if (this.getLogname().equalsIgnoreCase("Unix Messages")) {
            this.setNoOfUnixMsgsLines(numLines);
            this.viewUnixMsgs();
        }
        if (this.getLogname().equalsIgnoreCase("Test Verbose")) {
            this.setNoOfTestVerboseLines(numLines);
            this.viewTestVerbose();
        }
        if (this.getLogname().equalsIgnoreCase("TSSR")) {
            this.setNoOfTSSRLines(numLines);
            this.viewTSSR();
        }
        if (this.getLogname().equalsIgnoreCase("Report")) {
            this.setNoOfVTSReportLines(numLines);
            this.viewVTSReport();
        }
    }

    public void deleteLog(String logname) throws Exception {
        if (logname.equals("Test Error")) {
            logbean.deleteTestErrorLogs();
        } else if (logname.equals("VTSK Error")) {
            logbean.deleteVTSKErrorLogs();
        } else if (logname.equals("Test Information")) {
            logbean.deleteTestInfo();
        } else if (logname.equals("Test Verbose")) {
            logbean.deleteTestVerbose();
        } else {
            if (logname.equals("Unix Messages")) {
                throw new Exception("Invalid Operation: Unix is system log unable to delete");
            }
            if (logname.equals("Report")) {
                logbean.deleteVTSReportLogs();
            } else if (logname.equals("TSSR")) {
                logbean.deleteTSSRLogs();
            }
        }
    }

    public String getLogs() {
        return this.logs;
    }

    public void setLogs(String logs) {
        this.logs = logs;
    }

    public int getNoOfTestErrorLines() {
        return this.noOfTestErrorLines;
    }

    public void setNoOfTestErrorLines(int noOfTestErrorLines) {
        this.noOfTestErrorLines = noOfTestErrorLines;
    }

    public int getNoOfVTSKErrorLines() {
        return this.noOfVTSKErrorLines;
    }

    public void setNoOfVTSKErrorLines(int noOfVTSKErrorLines) {
        this.noOfVTSKErrorLines = noOfVTSKErrorLines;
    }

    public int getNoOfTestInfoLines() {
        return this.noOfTestInfoLines;
    }

    public void setNoOfTestInfoLines(int noOfTestInfoLines) {
        this.noOfTestInfoLines = noOfTestInfoLines;
    }

    public int getNoOfUnixMsgsLines() {
        return this.noOfUnixMsgsLines;
    }

    public void setNoOfUnixMsgsLines(int noOfUnixMsgsLines) {
        this.noOfUnixMsgsLines = noOfUnixMsgsLines;
    }

    public int getNoOfTestVerboseLines() {
        return this.noOfTestVerboseLines;
    }

    public void setNoOfTestVerboseLines(int noOfTestVerboseLines) {
        this.noOfTestVerboseLines = noOfTestVerboseLines;
    }

    public int getNoOfTSSRLines() {
        return this.noOfTSSRLines;
    }

    public void setNoOfTSSRLines(int noOfTSSRLines) {
        this.noOfTSSRLines = noOfTSSRLines;
    }

    public int getNoOfVTSReportLines() {
        return this.noOfVTSReportLines;
    }

    public void setNoOfVTSReportLines(int noOfTSSRLines) {
        this.noOfVTSReportLines = noOfTSSRLines;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String clearView() {
        this.setLogs("");
        return "clearedLogs";
    }

    public String viewTestErrorLogs() throws Exception {
        this.setLogs("");
        this.logs = this.serverAdapter.getLog("sunvts.err", this.getNoOfTestErrorLines());
        this.setLogs(this.logs);
        return "showLogs";
    }

    public String viewVTSKErrorLogs() throws Exception {
        this.setLogs("");
        this.logs = this.serverAdapter.getLog("vtsk.err", this.getNoOfVTSKErrorLines());
        this.setLogs(this.logs);
        return "showLogs";
    }

    public String viewTestInfo() throws Exception {
        this.setLogs("");
        this.logs = this.serverAdapter.getLog("sunvts.info", this.getNoOfTestInfoLines());
        this.setLogs(this.logs);
        return "showLogs";
    }

    public String viewUnixMsgs() throws Exception {
        this.setLogs("");
        this.logs = this.serverAdapter.getLog("messages", this.getNoOfUnixMsgsLines());
        this.setLogs(this.logs);
        return "showLogs";
    }

    public String viewTestVerbose() throws Exception {
        this.setLogs("");
        this.logs = this.serverAdapter.getLog("sunvts.verbose", this.getNoOfTestVerboseLines());
        System.out.println("VERBOSE LOGS:" + this.logs);
        this.setLogs(this.logs);
        return "showLogs";
    }

    public String viewTSSR() throws Exception {
        this.setLogs("");
        this.dumpTSSRLog();
        this.logs = this.serverAdapter.getLog("tssr_log", this.getNoOfTSSRLines());
        this.setLogs(this.logs);
        return "showLogs";
    }

    public String viewVTSReport() throws Exception {
        this.setLogs("");
        this.dumpReportLog();
        this.logs = this.serverAdapter.getLog("sunvts.rpt", this.getNoOfVTSReportLines());
        this.setLogs(this.logs);
        return "showLogs";
    }

    public String deleteTestErrorLogs() throws Exception {
        this.serverAdapter.deleteLog("sunvts.err");
        this.setLogs("");
        return "deleteLogs";
    }

    public String deleteVTSKErrorLogs() throws Exception {
        this.serverAdapter.deleteLog("vtsk.err");
        this.setLogs("");
        return "deleteLogs";
    }

    public String deleteTestInfo() throws Exception {
        this.serverAdapter.deleteLog("sunvts.info");
        this.setLogs("");
        return "deleteLogs";
    }

    public String deleteTestVerbose() throws Exception {
        this.serverAdapter.deleteLog("sunvts.verbose");
        this.setLogs("");
        return "deleteLogs";
    }

    public String deleteTSSRLogs() throws Exception {
        this.serverAdapter.deleteLog("tssr_log");
        this.setLogs("");
        return "deleteLogs";
    }

    public String deleteVTSReportLogs() throws Exception {
        this.serverAdapter.deleteLog("sunvts.rpt");
        this.setLogs("");
        return "deleteLogs";
    }

    public void checkMfgExist() {
        try {
            String mfgPresent = this.serverAdapter.checkManuf();
            if (mfgPresent != null) {
                this.setMfgExist(Boolean.parseBoolean(mfgPresent));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void dumpTSSRLog() throws Exception {
        this.serverAdapter.createTSSRLog();
    }

    public void dumpReportLog() throws Exception {
        this.serverAdapter.createReportLog();
    }

    public void setMfgExist(boolean mfgExist) {
        this.mfgExist = mfgExist;
    }

    public boolean isMfgExist() {
        return this.mfgExist;
    }

    public String getLogname() {
        return this.logname;
    }

    public void setLogname(String logname) {
        this.logname = logname;
    }
}

