/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.view.alarm;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public final class CCAlarmObject
implements Comparable,
Serializable {
    private static final long serialVersionUID = -3947818787749956796L;
    public static final int DOWN = 1;
    public static final int CRITICAL = 2;
    public static final int MAJOR = 3;
    public static final int MINOR = 4;
    public static final int OK = 5;
    private int severity = 5;

    public CCAlarmObject() {
        this(5);
    }

    public CCAlarmObject(int n) {
        this.setSeverity(n);
    }

    public int getSeverity() {
        return this.severity;
    }

    public void setSeverity(int n) {
        if (n != 1 && n != 2 && n != 3 && n != 4 && n != 5) {
            throw new IllegalArgumentException("Invalid severity: " + n);
        }
        this.severity = n;
    }

    public String toString() {
        String string = "ok";
        if (this.severity == 1) {
            string = "down";
        } else if (this.severity == 2) {
            string = "critical";
        } else if (this.severity == 3) {
            string = "major";
        } else if (this.severity == 4) {
            string = "minor";
        }
        return string;
    }

    public int compareTo(Object object) throws ClassCastException {
        int n = ((CCAlarmObject)object).getSeverity();
        return this.severity > n ? -1 : (this.severity == n ? 0 : 1);
    }

    public boolean equals(Object object) {
        if (object instanceof CCAlarmObject) {
            return this.severity == ((CCAlarmObject)object).getSeverity();
        }
        return false;
    }

    public int hashCode() {
        return this.severity;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.severity);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.severity = objectInputStream.readInt();
        if (this.severity != 1 && this.severity != 2 && this.severity != 3 && this.severity != 4 && this.severity != 5) {
            throw new InvalidObjectException("Invalid severity: " + this.severity);
        }
    }
}

