/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.taglib.html;

import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.CommandField;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.html.HtmlDisplayField;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.common.CCImage;
import com.sun.web.ui.taglib.common.CCDisplayFieldTagBase;
import com.sun.web.ui.taglib.header.CCHtmlHeaderTag;
import com.sun.web.ui.view.html.CCHref;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTag;
import javax.servlet.jsp.tagext.Tag;

public class CCHrefTag
extends CCDisplayFieldTagBase
implements BodyTag {
    protected static final String ATTRIB_ANCHOR = "anchor";
    protected static final String ATTRIB_FORM = "form";
    protected static final String ATTRIB_QUERYPARAMS = "queryParams";
    protected static final String ATTRIB_SUBMITFORMDATA = "submitformData";
    protected static final String ATTRIB_TARGET = "target";
    protected static final String ATTRIB_TITLE = "title";
    protected static final String ATTRIB_TRIM = "trim";
    protected static final String ATTRIB_TYPE = "type";
    protected static final String ATTRIB_IS_POPUP = "isPopup";
    private BodyContent bodyContent = null;
    private CommandField field = null;
    private String className = null;

    public int doStartTag() throws JspException {
        this.reset();
        return 2;
    }

    public void reset() {
        super.reset();
        this.field = null;
        this.className = null;
    }

    public int doAfterBody() throws JspException {
        return 0;
    }

    public void doInitBody() throws JspException {
    }

    protected String getHTMLStringInternal(Tag tag, PageContext pageContext, View view) throws JspException {
        if (tag == null) {
            throw new IllegalArgumentException("parent cannot be null");
        }
        if (pageContext == null) {
            throw new IllegalArgumentException("pageContext cannot be null");
        }
        if (view == null) {
            throw new IllegalArgumentException("view cannot be null");
        }
        this.checkChildType(view, CommandField.class);
        this.field = (CommandField)view;
        this.setParent(tag);
        this.setPageContext(pageContext);
        this.setAttributes();
        NonSyncStringBuffer nonSyncStringBuffer = new NonSyncStringBuffer(8192);
        nonSyncStringBuffer.append("<a");
        if (this.getAnchor() != null && this.getType() != null && (this.getType().equals("jumpTop") || this.getType().equals("jump"))) {
            CCHrefTag.appendAttribute(nonSyncStringBuffer, "href", "#" + this.getAnchor());
        } else {
            CCHrefTag.appendAttribute(nonSyncStringBuffer, "href", this.getURLString(tag, pageContext, this.field));
        }
        CCHrefTag.appendAttribute(nonSyncStringBuffer, "name", this.field.getQualifiedName());
        CCHrefTag.appendAttribute(nonSyncStringBuffer, "id", this.getElementId());
        CCHrefTag.appendAttribute(nonSyncStringBuffer, "class", this.getStyleClass());
        CCHrefTag.appendAttribute(nonSyncStringBuffer, ATTRIB_TARGET, this.getTarget());
        CCHrefTag.appendAttribute(nonSyncStringBuffer, ATTRIB_TITLE, this.getMessage(this.getTitle()));
        this.initOnClickAttribute();
        this.appendCommonHtmlAttributes(nonSyncStringBuffer);
        this.appendJavaScriptAttributes(nonSyncStringBuffer);
        if (this.field instanceof HtmlDisplayField) {
            this.appendExtraHtml((HtmlDisplayField)this.field, nonSyncStringBuffer);
        }
        nonSyncStringBuffer.append(">");
        this.appendLinkIcon(nonSyncStringBuffer);
        BodyContent bodyContent = this.getBodyContent();
        if (bodyContent != null) {
            if (this.getTrim() == null || this.isTrue(this.getTrim())) {
                nonSyncStringBuffer.append(bodyContent.getString().trim());
            } else {
                nonSyncStringBuffer.append(bodyContent.getString());
            }
        }
        nonSyncStringBuffer.append("</a>");
        return nonSyncStringBuffer.toString();
    }

    private void appendExtraValues(CommandField commandField, NonSyncStringBuffer nonSyncStringBuffer) throws JspException {
        Map map = commandField.getExtraValuesMap();
        if (map == null || map.size() == 0) {
            return;
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Object v = map.get(k);
            if (v == null) continue;
            try {
                nonSyncStringBuffer.append("&amp;").append(k).append("=").append(URLEncoder.encode(v.toString(), this.encoding));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                CCDebug.trace3(this.encoding + " encoding is not supported.");
            }
        }
    }

    private void appendLinkIcon(NonSyncStringBuffer nonSyncStringBuffer) throws JspException {
        if (this.getType() == null) {
            return;
        }
        if (this.getType().equals("jump")) {
            nonSyncStringBuffer.append(CCHrefTag.getImageHTMLString(CCImage.HREF_ANCHOR, "10", "16"));
        } else if (this.getType().equals("jumpTop")) {
            nonSyncStringBuffer.append(CCHrefTag.getImageHTMLString(CCImage.HREF_TOP, "10", "11"));
        }
    }

    private void appendPopupQuery(NonSyncStringBuffer nonSyncStringBuffer) throws JspException {
        boolean bl = false;
        CCHref cCHref = null;
        if (this.field instanceof CCHref) {
            cCHref = (CCHref)this.field;
        }
        if (cCHref != null && cCHref.getIsPopup() != null) {
            bl = cCHref.getIsPopup();
        } else if (this.getIsPopup() != null) {
            bl = this.isTrue(this.getIsPopup());
        } else {
            CCHtmlHeaderTag cCHtmlHeaderTag = (CCHtmlHeaderTag)CCHrefTag.findAncestorWithClass((Tag)this, (Class)CCHtmlHeaderTag.class);
            boolean bl2 = bl = cCHtmlHeaderTag != null && this.isTrue(cCHtmlHeaderTag.getIsPopup());
        }
        if (bl) {
            nonSyncStringBuffer.append("&amp;").append("com_sun_web_ui_popup").append("=").append("true");
        }
    }

    private void appendQueryParams(NonSyncStringBuffer nonSyncStringBuffer) throws JspException {
        String string = this.getQueryParams();
        if (string != null && string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "&");
            while (stringTokenizer.hasMoreTokens()) {
                StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), "=");
                try {
                    if (stringTokenizer2.hasMoreTokens()) {
                        nonSyncStringBuffer.append("&amp;").append(URLEncoder.encode(stringTokenizer2.nextToken(), this.encoding));
                    }
                    if (!stringTokenizer2.hasMoreTokens()) continue;
                    nonSyncStringBuffer.append("=").append(URLEncoder.encode(stringTokenizer2.nextToken(), this.encoding));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    CCDebug.trace3(this.encoding + " encoding is not supported.");
                }
            }
        }
    }

    public String getURLString(Tag tag, PageContext pageContext, CommandField commandField) throws JspException {
        this.setParent(tag);
        this.setPageContext(pageContext);
        ViewBean viewBean = this.getParentViewBean();
        HttpServletResponse httpServletResponse = (HttpServletResponse)pageContext.getResponse();
        NonSyncStringBuffer nonSyncStringBuffer = new NonSyncStringBuffer(httpServletResponse.encodeURL(viewBean.getModuleURL() + "/" + viewBean.getRequestInvocationName()));
        nonSyncStringBuffer.append("?").append(commandField.getQualifiedName()).append("=");
        if (this.getDefaultValue() != null) {
            try {
                nonSyncStringBuffer.append(URLEncoder.encode(this.getDefaultValue(), this.encoding));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                CCDebug.trace3(this.encoding + " encoding is not supported.");
            }
        }
        this.appendPopupQuery(nonSyncStringBuffer);
        this.appendQueryParams(nonSyncStringBuffer);
        this.appendExtraValues(commandField, nonSyncStringBuffer);
        if (!this.isTrue(this.getSubmitFormData())) {
            nonSyncStringBuffer.append("&amp;").append("jato.pageSession").append("=").append(viewBean.getPageSessionAttributeString(false));
            if (this.getAnchor() != null) {
                nonSyncStringBuffer.append("#").append(this.getAnchor());
            }
        }
        return nonSyncStringBuffer.toString();
    }

    private void initOnClickAttribute() {
        if (this.getForm() == null || !this.isTrue(this.getSubmitFormData())) {
            return;
        }
        NonSyncStringBuffer nonSyncStringBuffer = new NonSyncStringBuffer();
        if (this.getOnClick() != null) {
            nonSyncStringBuffer.append(this.getOnClick()).append(";");
        }
        nonSyncStringBuffer.append("javascript:var f=document.").append(this.getForm()).append(";if (f != null) {f.action=this.href").append(";f.submit();return false}");
        this.setOnClick(nonSyncStringBuffer.toString());
    }

    protected void setAttributes() {
        if (this.field.getValue() != null) {
            this.setDefaultValue(this.field.getValue().toString());
        }
        if (this.field instanceof CCHref) {
            CCHref cCHref = (CCHref)this.field;
            if (cCHref.getElementId() != null) {
                this.setElementId(cCHref.getElementId());
            }
            if (cCHref.getType() != null) {
                this.setType(cCHref.getType());
            }
            if (cCHref.getTitle() != null) {
                this.setTitle(cCHref.getTitle());
            }
        }
    }

    public String getStyleClass() {
        String string = super.getStyleClass();
        if (string == null && this.getType() != null) {
            if (this.getType().equals("jump")) {
                string = "JmpLnk";
            } else if (this.getType().equals("jumpTop")) {
                string = "JmpTopLnk";
            }
        }
        return string;
    }

    public BodyContent getBodyContent() {
        return this.bodyContent;
    }

    public void setBodyContent(BodyContent bodyContent) {
        this.bodyContent = bodyContent;
    }

    public String getAnchor() {
        return (String)this.getValue(ATTRIB_ANCHOR);
    }

    public void setAnchor(String string) {
        this.setValue(ATTRIB_ANCHOR, string);
    }

    public String getForm() {
        if (this.getValue(ATTRIB_FORM) != null) {
            return (String)this.getValue(ATTRIB_FORM);
        }
        return this.getFormName();
    }

    public void setForm(String string) {
        this.setValue(ATTRIB_FORM, string);
    }

    public String getQueryParams() {
        return (String)this.getValue(ATTRIB_QUERYPARAMS);
    }

    public void setQueryParams(String string) {
        this.setValue(ATTRIB_QUERYPARAMS, string);
    }

    public String getSubmitFormData() {
        return this.getValue(ATTRIB_SUBMITFORMDATA) != null ? (String)this.getValue(ATTRIB_SUBMITFORMDATA) : "false";
    }

    public void setSubmitFormData(String string) {
        if (string != null && !string.toLowerCase().equals("true") && !string.toLowerCase().equals("false")) {
            CCDebug.trace1("Invalid parameter: " + string);
            return;
        }
        this.setValue(ATTRIB_SUBMITFORMDATA, string);
    }

    public String getTarget() {
        return (String)this.getValue(ATTRIB_TARGET);
    }

    public void setTarget(String string) {
        this.setValue(ATTRIB_TARGET, string);
    }

    public String getTitle() {
        return (String)this.getValue(ATTRIB_TITLE);
    }

    public void setTitle(String string) {
        this.setValue(ATTRIB_TITLE, string);
    }

    public String getTrim() {
        return (String)this.getValue(ATTRIB_TRIM);
    }

    public void setTrim(String string) {
        if (string != null && !string.toLowerCase().equals("true") && !string.toLowerCase().equals("false")) {
            CCDebug.trace1("Invalid parameter: " + string);
            return;
        }
        this.setValue(ATTRIB_TRIM, string);
    }

    public String getType() {
        return (String)this.getValue(ATTRIB_TYPE);
    }

    public void setType(String string) {
        if (string != null && !string.equals("jump") && !string.equals("jumpTop")) {
            CCDebug.trace1("Invalid parameter: " + string);
            return;
        }
        this.setValue(ATTRIB_TYPE, string);
    }

    public void setIsPopup(String string) {
        if (string != null && !string.toLowerCase().equals("true") && !string.toLowerCase().equals("false")) {
            CCDebug.trace1("Invalid parameter: " + string);
            return;
        }
        this.setValue(ATTRIB_IS_POPUP, string);
    }

    public String getIsPopup() {
        return (String)this.getValue(ATTRIB_IS_POPUP);
    }

    public String getActionURLJavascript(Tag tag, PageContext pageContext, CommandField commandField) throws JspException {
        if (this.getFormName() == null) {
            return null;
        }
        NonSyncStringBuffer nonSyncStringBuffer = new NonSyncStringBuffer();
        String string = this.getURLString(tag, pageContext, commandField);
        nonSyncStringBuffer.append("javascript:var f=document.").append(this.getFormName()).append(";if (f != null) {f.action='").append(string).append("' + f.elements['").append("jato.pageSession").append("'].value;f.submit();}");
        return nonSyncStringBuffer.toString();
    }
}

