/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.taglib.help;

import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.View;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.common.CCHelpDescriptor;
import com.sun.web.ui.common.CCHelpLoader;
import com.sun.web.ui.common.CCI18N;
import com.sun.web.ui.common.CCImage;
import com.sun.web.ui.common.CCServerInterface;
import com.sun.web.ui.common.CCSystem;
import com.sun.web.ui.taglib.help.CCHelpTag;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;

public class CCHelpWindowTag
extends CCHelpTag {
    public static final String PARAM_APPNAME = "appName";
    public static final String PARAM_HELPFILE = "helpFile";
    public static final String PARAM_MASTHEADALT = "mastheadAlt";
    public static final String PARAM_MASTHEADTITLE = "mastheadTitle";
    public static final String PARAM_PAGETITLE = "pageTitle";
    public static final String PARAM_WINDOWTITLE = "windowTitle";
    public static final String PARAM_FIRSTLOAD = "firstLoad";
    public static final String PARAM_SHOWCLOSEBUTTON = "showCloseButton";
    public static final String PARAM_HELPLOGOWIDTH = "helpLogoWidth";
    public static final String PARAM_HELPLOGOHEIGHT = "helpLogoHeight";
    public static final String PARAM_MERGE = "merge";
    public static final String PARAM_VERSIONFILE = "versionFile";
    public static final String PARAM_VERSIONTOOLTIP = "versionTooltip";
    public static final String PARAM_PATHPREFIX = "pathPrefix";
    public static final String HELPTYPE_HELP2 = "help2";
    public static final String HELPTYPE_HELP = "help";
    public static final String HELPTYPE_DEFAULT = "help";
    protected static final String ATTRIB_ANCHOR = "anchor";
    protected static final String ATTRIB_HEIGHT = "height";
    protected static final String ATTRIB_HELPFILENAME = "helpFileName";
    protected static final String ATTRIB_HELPTOOLTIP = "helpTooltip";
    protected static final String ATTRIB_HELPTYPE = "helpType";
    protected static final String ATTRIB_MASTHEADALT = "mastheadAlt";
    protected static final String ATTRIB_MASTHEADTITLE = "mastheadTitle";
    protected static final String ATTRIB_MERGE = "merge";
    protected static final String ATTRIB_PAGETITLE = "pageTitle";
    protected static final String ATTRIB_PATHPREFIX = "pathPrefix";
    protected static final String ATTRIB_APPNAME = "appName";
    protected static final String ATTRIB_SHOWCLOSEBUTTON = "showCloseButton";
    protected static final String ATTRIB_SHOWLINKICON = "showLinkIcon";
    protected static final String ATTRIB_STATUS = "status";
    protected static final String ATTRIB_HELPLOGOWIDTH = "helpLogoWidth";
    protected static final String ATTRIB_HELPLOGOHEIGHT = "helpLogoHeight";
    protected static final String ATTRIB_VERSIONTOOLTIP = "versionTooltip";
    protected static final String ATTRIB_VERSIONFILENAME = "versionFileName";
    protected static final String ATTRIB_WIDTH = "width";
    protected static final String ATTRIB_WINDOWTITLE = "windowTitle";
    protected static final String ATTRIB_ONCLICK = "onClick";
    private static final String HELP2_DEFAULT_HEIGHT = "500";
    private static final String HELP2_DEFAULT_WIDTH = "750";
    private static final String HELP2_DEFAULT_TARGET = "help2_Window";
    private static final String HELP_DEFAULT_HEIGHT = "480";
    private static final String HELP_DEFAULT_WIDTH = "640";
    private static final String HELP_DEFAULT_TARGET = "help_Window";
    private static final String DEFAULT_HELPDIR = "html";
    private static final String HELP2_DISPLAY_URL = "/cchelp2/Help2";
    private static final String HELP_DISPLAY_URL = "/cchelp/Help";
    private NonSyncStringBuffer displayURL;
    private String defaultTarget;
    private String defaultHeight;
    private String defaultWidth;
    private boolean isHelp2;

    public void reset() {
        super.reset();
        this.displayURL = null;
        this.defaultTarget = null;
        this.defaultHeight = null;
        this.defaultWidth = null;
        this.isHelp2 = false;
    }

    protected String getHTMLStringInternal(Tag tag, PageContext pageContext, View view) throws JspException {
        super.getHTMLStringInternal(tag, pageContext, view);
        this.setAttributes();
        NonSyncStringBuffer nonSyncStringBuffer = new NonSyncStringBuffer(8192);
        try {
            this.displayURL = new NonSyncStringBuffer("");
            String string = this.getRequestContext().getRequest().getContextPath();
            if (this.isHelp2) {
                if (this.isIe()) {
                    this.displayURL.append(string + HELP2_DISPLAY_URL + "Ie");
                } else if (this.isNav4()) {
                    this.displayURL.append(string + HELP2_DISPLAY_URL + "Nav4");
                } else if (this.isGecko()) {
                    this.displayURL.append(string + HELP2_DISPLAY_URL + "Nav6up");
                } else {
                    this.displayURL.append(string + HELP2_DISPLAY_URL + "Nav6up");
                }
                this.defaultTarget = CCSystem.isAppInConsole() ? HELP2_DEFAULT_TARGET : "help2_Window_" + this.getAppName();
                this.defaultHeight = HELP2_DEFAULT_HEIGHT;
                this.defaultWidth = HELP2_DEFAULT_WIDTH;
            } else {
                this.displayURL.append(string + HELP_DISPLAY_URL);
                this.defaultTarget = CCSystem.isAppInConsole() ? HELP_DEFAULT_TARGET : "help_Window_" + this.getAppName();
                this.defaultHeight = HELP_DEFAULT_HEIGHT;
                this.defaultWidth = HELP_DEFAULT_WIDTH;
            }
            this.appendOpeningTag(nonSyncStringBuffer);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            CCDebug.trace1(this.encoding + " encoding is not supported.");
        }
        if (this.getBodyContent() != null) {
            nonSyncStringBuffer.append(this.getBodyContent().getString());
        }
        nonSyncStringBuffer.append("</a>");
        return nonSyncStringBuffer.toString();
    }

    private void appendOpeningTag(NonSyncStringBuffer nonSyncStringBuffer) throws JspException, UnsupportedEncodingException {
        nonSyncStringBuffer.append("<a").append(" href=\"").append(this.displayURL.toString());
        NonSyncStringBuffer nonSyncStringBuffer2 = new NonSyncStringBuffer(8192);
        this.addEncodedParameter(nonSyncStringBuffer2, "appName", this.getAppName());
        this.addEncodedParameter(nonSyncStringBuffer2, PARAM_HELPFILE, this.getLocalizedTextFile(this.getHelpFileName()));
        if (this.getAnchor() != null) {
            nonSyncStringBuffer2.append(URLEncoder.encode("#", this.encoding)).append(URLEncoder.encode(this.getAnchor(), this.encoding));
        }
        this.addEncodedParameter(nonSyncStringBuffer2, "merge", this.getMerge());
        this.addEncodedParameter(nonSyncStringBuffer2, "windowTitle", this.getMessage(this.getWindowTitle()));
        this.addEncodedParameter(nonSyncStringBuffer2, "mastheadTitle", this.getMessage(this.getMastheadTitle()));
        this.addEncodedParameter(nonSyncStringBuffer2, "mastheadAlt", this.getMessage(this.getMastheadAlt()));
        this.addEncodedParameter(nonSyncStringBuffer2, "pageTitle", this.getMessage(this.getPageTitle()));
        if (this.isHelp2) {
            this.addEncodedParameter(nonSyncStringBuffer2, PARAM_FIRSTLOAD, "true");
        }
        if (!this.isHelp2) {
            this.addEncodedParameter(nonSyncStringBuffer2, "showCloseButton", this.getShowCloseButton());
        }
        this.addEncodedParameter(nonSyncStringBuffer2, "helpLogoWidth", this.getHelpLogoWidth());
        this.addEncodedParameter(nonSyncStringBuffer2, "helpLogoHeight", this.getHelpLogoHeight());
        this.addEncodedParameter(nonSyncStringBuffer2, "pathPrefix", this.getPathPrefix());
        nonSyncStringBuffer.append(nonSyncStringBuffer2.toString());
        nonSyncStringBuffer.append("\"");
        CCHelpWindowTag.appendAttribute(nonSyncStringBuffer, "class", this.getStyleClass());
        CCHelpWindowTag.appendAttribute(nonSyncStringBuffer, "target", this.defaultTarget);
        CCHelpWindowTag.appendAttribute(nonSyncStringBuffer, "title", this.getMessage(this.getHelpTooltip()));
        NonSyncStringBuffer nonSyncStringBuffer3 = new NonSyncStringBuffer();
        if (this.getStatus() != null) {
            nonSyncStringBuffer3.append("javascript:").append("window.status='").append(CCHelpWindowTag.escapeJsQuotes(this.getMessage(this.getStatus()))).append("'; return true");
            CCHelpWindowTag.appendAttribute(nonSyncStringBuffer, "onmouseover", nonSyncStringBuffer3.toString());
            CCHelpWindowTag.appendAttribute(nonSyncStringBuffer, "onfocus", nonSyncStringBuffer3.toString());
            nonSyncStringBuffer3 = new NonSyncStringBuffer("javascript: window.status=''; return true");
            CCHelpWindowTag.appendAttribute(nonSyncStringBuffer, "onmouseout", nonSyncStringBuffer3.toString());
            CCHelpWindowTag.appendAttribute(nonSyncStringBuffer, "onblur", nonSyncStringBuffer3.toString());
        }
        String string = this.isHelp2 ? "resizable" : "scrollbars,resizable";
        nonSyncStringBuffer3 = new NonSyncStringBuffer();
        if (this.getOnClick() != null) {
            nonSyncStringBuffer3.append(this.getOnClick());
        }
        nonSyncStringBuffer3.append(this.getOpenWindowJavascript("", this.defaultTarget, Integer.parseInt(this.getHeight() != null ? this.getHeight() : this.defaultHeight), Integer.parseInt(this.getWidth() != null ? this.getWidth() : this.defaultWidth), string));
        CCHelpWindowTag.appendAttribute(nonSyncStringBuffer, "onclick", nonSyncStringBuffer3.toString());
        if (this.getTabIndex() != null) {
            CCHelpWindowTag.appendAttribute(nonSyncStringBuffer, "tabindex", this.getTabIndex());
        }
        nonSyncStringBuffer.append(">");
        if (this.isTrue(this.getShowLinkIcon())) {
            nonSyncStringBuffer.append(CCHelpWindowTag.getImageHTMLString(CCImage.HREF_LINK, Integer.parseInt("10"), Integer.parseInt("12")));
        }
    }

    private void addEncodedParameter(NonSyncStringBuffer nonSyncStringBuffer, String string, String string2) throws UnsupportedEncodingException {
        if (nonSyncStringBuffer == null || string == null || string2 == null) {
            return;
        }
        nonSyncStringBuffer.append(nonSyncStringBuffer.length() == 0 ? "?" : "&amp;").append(string).append("=").append(URLEncoder.encode(string2, this.encoding));
    }

    private String getLocalizedTextFile(String string) {
        String string2;
        CCDebug.trace3("file param: " + string);
        if (string == null) {
            return null;
        }
        NonSyncStringBuffer nonSyncStringBuffer = new NonSyncStringBuffer(256);
        NonSyncStringBuffer nonSyncStringBuffer2 = new NonSyncStringBuffer(256);
        String string3 = null;
        String string4 = this.getPathPrefix();
        if (string4 != null && string4.length() > 0) {
            boolean bl = false;
            string2 = this.getRequestContext().getRequest().getContextPath();
            if ((string4 + "/").startsWith(string2 + "/")) {
                int n = string2.length() + 1;
                string4 = string4.substring(n);
                bl = true;
            }
            nonSyncStringBuffer.append(this.getAppName()).append("/").append(string4);
            if (this.isHelp2 || !bl) {
                nonSyncStringBuffer.append("/").append(DEFAULT_HELPDIR);
            }
            CCDebug.trace3("PathPrefix: " + nonSyncStringBuffer.toString());
        } else {
            nonSyncStringBuffer.append(this.getAppName()).append("/").append(DEFAULT_HELPDIR);
        }
        if (!nonSyncStringBuffer.toString().startsWith("/")) {
            nonSyncStringBuffer.insert(0, "/");
        }
        CCDebug.trace3("PathPrefix: " + nonSyncStringBuffer.toString());
        HttpServletRequest httpServletRequest = this.getRequestContext().getRequest();
        string2 = httpServletRequest.getContextPath();
        String string5 = nonSyncStringBuffer.toString();
        if (this.isHelp2) {
            string = "help/" + string;
        }
        ArrayList<Locale> arrayList = new ArrayList<Locale>();
        arrayList.add(CCI18N.getTagsLocale(this.pageContext.getRequest()));
        arrayList.add(Locale.ENGLISH);
        if ((string5 + "/").startsWith(string2 + "/")) {
            CCDebug.trace3("help file in same app");
            string5 = string5.substring(string2.length());
            ServletContext servletContext = this.getRequestContext().getServletContext();
            for (int i = 0; i < arrayList.size(); ++i) {
                String string6 = string5 + "/" + (Locale)arrayList.get(i) + "/" + string;
                string6 = string6.replaceAll("//*", "/");
                CCDebug.trace3("URLPATH 1 : " + string6);
                String string7 = string6;
                int n = string7.indexOf("?");
                if (n >= 0) {
                    string7 = string6.substring(0, n);
                }
                try {
                    if (this.getHelpType().equalsIgnoreCase("help")) {
                        CCDebug.trace3("Checking for help 1.0 localized file");
                        if (servletContext.getResource(string7) == null) continue;
                        string3 = string2 + string6;
                        CCDebug.trace3("help file found: " + string3);
                        break;
                    }
                    CCDebug.trace3("Checking for help2 localized file");
                    string3 = string2 + string6;
                    CCDebug.trace3("check localizedFile: " + string3);
                    if (servletContext.getResource(string6) != null) break;
                    String string8 = CCSystem.getHelpUrlHeader(httpServletRequest);
                    URL uRL = new URL(string8 + string3);
                    InputStream inputStream = uRL.openStream();
                    inputStream.close();
                    break;
                }
                catch (MalformedURLException malformedURLException) {
                    string3 = null;
                    CCDebug.trace2("getResource failed for " + string6);
                    continue;
                }
                catch (IOException iOException) {
                    string3 = null;
                    CCDebug.trace2("getResource failed with IOException " + string6);
                }
            }
        } else {
            String string9 = CCSystem.getHelpUrlHeader(httpServletRequest);
            String string10 = nonSyncStringBuffer.toString() + "/";
            for (int i = 0; i < arrayList.size(); ++i) {
                String string11 = string10 + (Locale)arrayList.get(i) + "/" + string;
                try {
                    URL uRL = new URL(string9 + string11);
                    InputStream inputStream = uRL.openStream();
                    inputStream.close();
                    string3 = string11;
                    break;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    continue;
                }
                catch (MalformedURLException malformedURLException) {
                    CCDebug.trace1("MalformedURLException", malformedURLException);
                    continue;
                }
                catch (IOException iOException) {
                    CCDebug.trace1("IOE", iOException);
                }
            }
        }
        CCDebug.trace3("Localized help file: " + string3 + "\n");
        return string3;
    }

    public String getStyleClass() {
        String string = super.getStyleClass();
        if (string == null) {
            string = this.getType() != null && this.getType().equals("field") ? "HlpFldLnk" : "HlpPgeLnk";
        }
        return string;
    }

    protected void setAttributes() {
        String string = this.getRequestContext().getRequest().getContextPath();
        if (string == null) {
            CCDebug.trace1("Unable to obtain app name from request.");
        } else if (string.startsWith("/")) {
            string = string.substring(1).trim();
        }
        if (this.getAppName() == null) {
            this.setAppName(string);
        }
        String string2 = this.getAppName();
        try {
            boolean bl = string != null && !string.equals(this.getAppName());
            String string3 = bl ? string2 : string;
            String string4 = null;
            string4 = string3.startsWith("/") ? string3.substring(1).trim() : string3;
            CCServerInterface cCServerInterface = CCSystem.getServerInterface();
            CCHelpDescriptor cCHelpDescriptor = cCServerInterface.getCCHelpDescriptor(string3);
            if (cCHelpDescriptor != null) {
                if (this.getBundleID() == null) {
                    this.setBundleID(string4);
                    if (cCHelpDescriptor.getBundle() != null) {
                        if (bl && CCSystem.isAppInConsole()) {
                            ClassLoader classLoader = CCHelpLoader.getHelpClassLoader(string4);
                            CCI18N.setResourceBundle(this.pageContext.getRequest(), this.pageContext.getResponse(), cCHelpDescriptor.getBundle(), string4, null, classLoader);
                        } else {
                            CCI18N.setResourceBundle(this.pageContext.getRequest(), this.pageContext.getResponse(), cCHelpDescriptor.getBundle(), string4, null);
                        }
                    }
                }
                if (this.getAnchor() == null) {
                    this.setAnchor(cCHelpDescriptor.getAnchor());
                }
                if (this.getHeight() == null) {
                    this.setHeight(cCHelpDescriptor.getHeight());
                }
                if (this.getHelpFileName() == null) {
                    this.setHelpFileName(cCHelpDescriptor.getHelpFileName());
                }
                if (this.getHelpTooltip() == null) {
                    this.setHelpTooltip(cCHelpDescriptor.getHelpTooltip());
                }
                if (this.getMastheadTitle() == null) {
                    this.setMastheadTitle(cCHelpDescriptor.getMastheadTitle());
                }
                if (this.getMastheadAlt() == null) {
                    this.setMastheadAlt(cCHelpDescriptor.getMastheadAlt());
                }
                if (this.getPathPrefix() == null) {
                    this.setPathPrefix(cCHelpDescriptor.getPathPrefix());
                }
                if (this.getStatus() == null) {
                    this.setStatus(cCHelpDescriptor.getStatus());
                }
                if (this.getWidth() == null) {
                    this.setWidth(cCHelpDescriptor.getWidth());
                }
                if (this.getWindowTitle() == null) {
                    this.setWindowTitle(cCHelpDescriptor.getWindowTitle());
                }
                if (this.getShowCloseButton() == null) {
                    this.setShowCloseButton(cCHelpDescriptor.getShowCloseButton() ? "true" : "false");
                }
                if (this.getHelpLogoWidth() == null) {
                    this.setHelpLogoWidth(cCHelpDescriptor.getHelpLogoWidth());
                }
                if (this.getHelpLogoHeight() == null) {
                    this.setHelpLogoHeight(cCHelpDescriptor.getHelpLogoHeight());
                }
                if (this.getHelpType() == null) {
                    this.setHelpType(cCHelpDescriptor.getHelpType());
                }
            } else {
                CCDebug.trace3("Unable to obtain app.xml Help object");
            }
        }
        catch (Exception exception) {
            CCDebug.trace1("Help info object not found");
        }
        String string5 = this.getHelpType();
        if (string5 == null || !string5.equalsIgnoreCase("help") && !string5.equalsIgnoreCase(HELPTYPE_HELP2)) {
            string5 = "help";
            this.setHelpType(string5);
        }
        this.isHelp2 = string5.equalsIgnoreCase(HELPTYPE_HELP2);
        if (this.getPageTitle() == null) {
            this.setPageTitle(this.isHelp2 ? "help2.pageTitle" : "help.pageTitle");
        }
    }

    public String getAppName() {
        return (String)this.getValue("appName");
    }

    public void setAppName(String string) {
        this.setValue("appName", string);
    }

    public String getHeight() {
        return (String)this.getValue(ATTRIB_HEIGHT);
    }

    public void setHeight(String string) {
        this.setValue(ATTRIB_HEIGHT, string);
    }

    public String getHelpTooltip() {
        return (String)this.getValue(ATTRIB_HELPTOOLTIP);
    }

    public void setHelpTooltip(String string) {
        this.setValue(ATTRIB_HELPTOOLTIP, string);
    }

    public String getHelpType() {
        return (String)this.getValue(ATTRIB_HELPTYPE);
    }

    public void setHelpType(String string) {
        this.setValue(ATTRIB_HELPTYPE, string);
    }

    public String getPageTitle() {
        return (String)this.getValue("pageTitle");
    }

    public void setPageTitle(String string) {
        this.setValue("pageTitle", string);
    }

    public String getMastheadTitle() {
        return (String)this.getValue("mastheadTitle");
    }

    public void setMastheadTitle(String string) {
        this.setValue("mastheadTitle", string);
    }

    public String getMastheadAlt() {
        return (String)this.getValue("mastheadAlt");
    }

    public void setMastheadAlt(String string) {
        this.setValue("mastheadAlt", string);
    }

    public String getPathPrefix() {
        return (String)this.getValue("pathPrefix");
    }

    public void setPathPrefix(String string) {
        this.setValue("pathPrefix", string);
    }

    public String getShowCloseButton() {
        return (String)this.getValue("showCloseButton");
    }

    public void setShowCloseButton(String string) {
        if (string != null && !string.toLowerCase().equals("true") && !string.toLowerCase().equals("false")) {
            CCDebug.trace1("Invalid parameter: " + string);
            return;
        }
        this.setValue("showCloseButton", string);
    }

    public String getShowLinkIcon() {
        return (String)this.getValue(ATTRIB_SHOWLINKICON);
    }

    public void setShowLinkIcon(String string) {
        if (string != null && !string.toLowerCase().equals("true") && !string.toLowerCase().equals("false")) {
            CCDebug.trace1("Invalid parameter: " + string);
            return;
        }
        this.setValue(ATTRIB_SHOWLINKICON, string);
    }

    public String getStatus() {
        return (String)this.getValue(ATTRIB_STATUS);
    }

    public void setStatus(String string) {
        this.setValue(ATTRIB_STATUS, string);
    }

    public String getWidth() {
        return (String)this.getValue(ATTRIB_WIDTH);
    }

    public void setWidth(String string) {
        this.setValue(ATTRIB_WIDTH, string);
    }

    public String getWindowTitle() {
        return (String)this.getValue("windowTitle");
    }

    public void setWindowTitle(String string) {
        this.setValue("windowTitle", string);
    }

    public String getAnchor() {
        return (String)this.getValue(ATTRIB_ANCHOR);
    }

    public void setAnchor(String string) {
        this.setValue(ATTRIB_ANCHOR, string);
    }

    public String getHelpFileName() {
        return (String)this.getValue(ATTRIB_HELPFILENAME);
    }

    public void setHelpFileName(String string) {
        this.setValue(ATTRIB_HELPFILENAME, string);
    }

    public String getHelpLogoWidth() {
        return (String)this.getValue("helpLogoWidth");
    }

    public void setHelpLogoWidth(String string) {
        this.setValue("helpLogoWidth", string);
    }

    public String getHelpLogoHeight() {
        return (String)this.getValue("helpLogoHeight");
    }

    public void setHelpLogoHeight(String string) {
        this.setValue("helpLogoHeight", string);
    }

    public String getMerge() {
        return (String)this.getValue("merge");
    }

    public void setMerge(String string) {
        this.setValue("merge", string);
    }

    public String getVersionFileName() {
        return (String)this.getValue(ATTRIB_VERSIONFILENAME);
    }

    public void setVersionFileName(String string) {
        this.setValue(ATTRIB_VERSIONFILENAME, string);
    }

    public String getVersionTooltip() {
        return (String)this.getValue("versionTooltip");
    }

    public void setVersionTooltip(String string) {
        this.setValue("versionTooltip", string);
    }

    public String getOnClick() {
        return (String)this.getValue(ATTRIB_ONCLICK);
    }

    public void setOnClick(String string) {
        this.setValue(ATTRIB_ONCLICK, string);
    }
}

