/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.servlet.topology;

import com.sun.web.ui.servlet.topology.CCTopologyImageData;
import com.sun.web.ui.servlet.topology.CCTopologyRenderer;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;

class CCSessionImageCache
implements HttpSessionBindingListener {
    private static final String CACHE_ATTR = "CCTopologyServlet.imageCache";
    private static final int MAX_IMAGE_LOAD_WAIT = 500;
    private static long lastPutKey;
    private static String lastGetKey;
    private static final Map instanceCache;
    private final Map imageCache;
    private BackgroundRenderer bgRenderer;
    private CacheReaper cacheReaper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CCSessionImageCache(HttpSession httpSession) {
        if (!(httpSession.getAttribute(CACHE_ATTR) instanceof Map)) {
            HttpSession httpSession2 = httpSession;
            synchronized (httpSession2) {
                if (!(httpSession.getAttribute(CACHE_ATTR) instanceof Map)) {
                    httpSession.setAttribute(CACHE_ATTR, new HashMap());
                }
            }
        }
        this.imageCache = (Map)httpSession.getAttribute(CACHE_ATTR);
        httpSession.setAttribute("com.sun.web.ui.servlet.topology.CCSessionImageCache:" + this.hashCode(), (Object)this);
    }

    public static CCSessionImageCache getInstance(HttpSession httpSession) {
        CCSessionImageCache cCSessionImageCache = null;
        Object v = instanceCache.get(httpSession.getId());
        if (v instanceof CCSessionImageCache) {
            cCSessionImageCache = (CCSessionImageCache)v;
        } else {
            cCSessionImageCache = new CCSessionImageCache(httpSession);
            instanceCache.put(httpSession.getId(), cCSessionImageCache);
        }
        return cCSessionImageCache;
    }

    public void valueBound(HttpSessionBindingEvent httpSessionBindingEvent) {
    }

    public void valueUnbound(HttpSessionBindingEvent httpSessionBindingEvent) {
        if (this.bgRenderer != null) {
            this.bgRenderer.stop();
            this.bgRenderer = null;
        }
        if (this.cacheReaper != null) {
            this.cacheReaper.stop();
            this.cacheReaper = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BackgroundRenderer getBackgroundRenderer() {
        if (this.bgRenderer == null) {
            CCSessionImageCache cCSessionImageCache = this;
            synchronized (cCSessionImageCache) {
                if (this.bgRenderer == null) {
                    this.bgRenderer = new BackgroundRenderer();
                    new Thread((Runnable)this.bgRenderer, "CCSessionImageCache.BackgroundRenderer " + this.bgRenderer.hashCode()).start();
                    this.cacheReaper = new CacheReaper();
                    new Thread((Runnable)this.cacheReaper, "CCSessionImageCache.CacheReaper " + this.cacheReaper.hashCode()).start();
                }
            }
        }
        return this.bgRenderer;
    }

    public String cacheImage(CCTopologyRenderer cCTopologyRenderer, Rectangle rectangle, String string) {
        long l;
        lastPutKey = l = Math.max(System.currentTimeMillis(), lastPutKey + 1L);
        String string2 = Long.toString(l);
        CCTopologyImageData cCTopologyImageData = new CCTopologyImageData(cCTopologyRenderer, rectangle, string);
        this.imageCache.put(string2, cCTopologyImageData.asPrimitives());
        this.getBackgroundRenderer().renderImage(cCTopologyImageData);
        return string2;
    }

    public CCTopologyImageData takeImageData(String string) {
        if (lastGetKey != null && !lastGetKey.equals(string)) {
            this.imageCache.remove(lastGetKey);
        }
        lastGetKey = string;
        Object v = this.imageCache.get(lastGetKey);
        return CCTopologyImageData.createFromPrimitives(v);
    }

    static {
        instanceCache = new WeakHashMap();
    }

    private class BackgroundRenderer
    implements Runnable {
        private List queue = new ArrayList();
        private boolean isStopped;

        public synchronized void stop() {
            this.isStopped = true;
            this.notifyAll();
        }

        public synchronized void renderImage(CCTopologyImageData cCTopologyImageData) {
            this.queue.add(cCTopologyImageData);
            this.notifyAll();
        }

        public synchronized void run() {
            while (true) {
                if (this.queue.size() > 0) {
                    ((CCTopologyImageData)this.queue.remove(0)).encodeImage();
                    continue;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.isStopped) break;
            }
            this.queue.clear();
        }
    }

    private class CacheReaper
    implements Runnable {
        private static final long REAP_INTERVAL = 60000L;
        private static final long STALE_DURATION = 120000L;
        private boolean isStopped;

        public void stop() {
            this.isStopped = true;
        }

        public synchronized void run() {
            do {
                long l = System.currentTimeMillis() + 60000L;
                while (System.currentTimeMillis() < l) {
                    try {
                        this.wait(l - System.currentTimeMillis());
                    }
                    catch (InterruptedException interruptedException) {}
                }
                String string = Long.toString(System.currentTimeMillis() - 120000L);
                Iterator iterator = CCSessionImageCache.this.imageCache.keySet().iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    if (string2 == null || string.compareTo(string2) <= 0 && !this.isStopped) continue;
                    iterator.remove();
                }
            } while (!this.isStopped);
            CCSessionImageCache.this.imageCache.clear();
        }
    }
}

