/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.model;

import com.sun.web.ui.model.CCTopologyGroupNode;
import com.sun.web.ui.model.CCTopologyModelInterface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class TierNodeFactory {
    private int globalConnectionIndex = 0;
    private Map nodeInfoMap;
    private ArrayList[] tierInfosList = new ArrayList[]{new ArrayList(), new ArrayList(), new ArrayList()};
    private int tierIndex;

    TierNodeFactory() {
        this.nodeInfoMap = new HashMap();
    }

    CCTopologyModelInterface.Node[][] getTierNodes(CCTopologyModelInterface.Node[][] nodeArray, int n, int n2, CCTopologyModelInterface.Edge[] edgeArray, boolean bl, int n3) {
        CCTopologyModelInterface.Node[] nodeArray2;
        Bucket[] bucketArray = this.getTopBuckets(nodeArray, n, n2, edgeArray, bl, n3);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        CCTopologyModelInterface.Node[][] nodeArray3 = new CCTopologyModelInterface.Node[bucketArray.length][];
        for (int i = 0; i < nodeArray3.length; ++i) {
            nodeArray2 = bucketArray[i].createGroupNode(true);
            arrayList.add(nodeArray2);
            nodeArray3[i] = nodeArray2.getNodes();
        }
        while (arrayList.size() > 0) {
            CCTopologyGroupNode cCTopologyGroupNode = (CCTopologyGroupNode)arrayList.remove(0);
            cCTopologyGroupNode.setLabel(this.shortenGroupLabel(cCTopologyGroupNode.getLabel()));
            nodeArray2 = cCTopologyGroupNode.getNodes();
            for (int i = 0; i < nodeArray2.length; ++i) {
                if (!(nodeArray2[i] instanceof CCTopologyGroupNode)) continue;
                arrayList.add(nodeArray2[i]);
            }
        }
        return nodeArray3;
    }

    Bucket[] getTopBuckets(CCTopologyModelInterface.Node[][] nodeArray, int n, int n2, CCTopologyModelInterface.Edge[] edgeArray, boolean bl, int n3) {
        int n4;
        n2 = Math.min(n2, n - 1);
        int[] nArray = new int[n];
        int n5 = 0;
        int n6 = n2;
        while (n6 < n) {
            nArray[n5++] = n6++;
        }
        n6 = n2 - 1;
        while (n6 >= 0) {
            nArray[n5++] = n6--;
        }
        NodeInfo[][] nodeInfoArray = this.createNodeInfos(nodeArray, edgeArray);
        Bucket[] bucketArray = new Bucket[nArray.length];
        for (n5 = 0; n5 < n; ++n5) {
            bucketArray[n5] = new Bucket(n5, nodeInfoArray[n5]);
            bucketArray[n5].isTop = true;
        }
        if (nodeInfoArray[n2].length > 0) {
            bucketArray[n2].organizeByWithinTierConnectivity();
        }
        List list = bucketArray[n2].bucketList;
        for (n4 = 0; n4 < list.size(); ++n4) {
            ((Bucket)list.get(n4)).organizeByConnectivity();
        }
        for (n5 = 1; n5 < nArray.length; ++n5) {
            bucketArray[nArray[n5]].organizeByConnectivity();
        }
        for (n5 = 1; n5 < nArray.length; ++n5) {
            bucketArray[nArray[n5]].flatten(bl, n3);
        }
        if (bl && bucketArray[n2].getTotalNodeCount() > n3) {
            for (n4 = 0; n4 < list.size(); ++n4) {
                ((Bucket)list.get(n4)).flatten(bl, n3);
            }
        } else {
            bucketArray[n2].flatten(bl, n3);
        }
        for (n5 = 0; n5 < nArray.length; ++n5) {
            bucketArray[n5].removeEmptyBuckets();
        }
        return bucketArray;
    }

    NodeInfo[][] createNodeInfos(CCTopologyModelInterface.Node[][] nodeArray, CCTopologyModelInterface.Edge[] edgeArray) {
        int n;
        NodeInfo[][] nodeInfoArray = new NodeInfo[nodeArray.length][];
        for (n = 0; n < nodeArray.length; ++n) {
            nodeInfoArray[n] = new NodeInfo[nodeArray[n].length];
            for (int i = 0; i < nodeArray[n].length; ++i) {
                nodeInfoArray[n][i] = this.createNodeInfo(nodeArray[n][i], n);
            }
        }
        for (n = 0; n < edgeArray.length; ++n) {
            CCTopologyModelInterface.Node node;
            CCTopologyModelInterface.Node node2 = edgeArray[n].getSource();
            if (node2 == (node = edgeArray[n].getDestination())) continue;
            NodeInfo nodeInfo = this.getNodeInfo(node2);
            NodeInfo nodeInfo2 = this.getNodeInfo(node);
            if (nodeInfo == null || nodeInfo2 == null) continue;
            nodeInfo.peerList.add(nodeInfo2);
            nodeInfo2.peerList.add(nodeInfo);
            nodeInfo.connections.set(nodeInfo2.connectionIndex);
            nodeInfo2.connections.set(nodeInfo.connectionIndex);
        }
        return nodeInfoArray;
    }

    private int connectionIndex() {
        return this.globalConnectionIndex++;
    }

    public NodeInfo createNodeInfo(CCTopologyModelInterface.Node node, int n) {
        NodeInfo nodeInfo = new NodeInfo(node, n, this.connectionIndex());
        this.nodeInfoMap.put(node, nodeInfo);
        this.tierIndex = this.tierInfosList[n].size();
        this.tierInfosList[n].add(nodeInfo);
        return nodeInfo;
    }

    public NodeInfo createNodeInfo(Bucket bucket) {
        NodeInfo nodeInfo = new NodeInfo(bucket, this.connectionIndex());
        this.tierIndex = this.tierInfosList[bucket.tier].size();
        this.tierInfosList[bucket.tier].add(this);
        return nodeInfo;
    }

    public NodeInfo getNodeInfo(CCTopologyModelInterface.Node node) {
        return (NodeInfo)this.nodeInfoMap.get(node);
    }

    public List getTierInfos(int n) {
        return this.tierInfosList[n];
    }

    protected String[] getLabelParts(String string) {
        if (string == null) {
            string = "null";
        }
        String[] stringArray = new String[2];
        int n = string.indexOf("..");
        if (n == -1) {
            stringArray[0] = stringArray[1] = string;
        } else {
            stringArray[0] = string.substring(0, n);
            stringArray[1] = string.substring(n + "..".length());
        }
        return stringArray;
    }

    private String shortenGroupLabel(String string) {
        int n;
        int n2;
        String string2;
        String[] stringArray = this.getLabelParts(string);
        String string3 = stringArray[0];
        if (string3.equals(string2 = stringArray[1])) {
            return string;
        }
        for (n2 = 0; n2 < string3.length() && n2 < string2.length() && string3.charAt(n2) == string2.charAt(n2); ++n2) {
        }
        while (n2 > 0 && Character.isDigit(string3.charAt(n2 - 1))) {
            --n2;
        }
        for (n = 0; n < string3.length() && n < string2.length() && string3.charAt(string3.length() - 1 - n) == string2.charAt(string2.length() - 1 - n); ++n) {
        }
        while (n > 0 && Character.isDigit(string3.charAt(string3.length() - n))) {
            --n;
        }
        if (n > n2) {
            string3 = string3.substring(0, string3.length() - n);
        } else if (n2 > 0) {
            string2 = string2.substring(n2);
        }
        if (n2 > 0 || n > 0) {
            return string3 + "-" + string2;
        }
        return string;
    }

    private final class Bucket {
        public List bucketList = new ArrayList();
        public List nodeList = new ArrayList();
        public int tier;
        public boolean isTop;
        public NodeInfo info;
        private int totalNodeCount = -1;
        public int distance = Integer.MAX_VALUE;

        public String getCompareLabel() {
            return this.nodeList.size() > 0 ? ((NodeInfo)this.nodeList.get((int)0)).node.getLabel() : (this.bucketList.size() == 0 ? "zyz" : ((Bucket)this.bucketList.get(0)).getCompareLabel());
        }

        public Bucket(int n) {
            this.tier = n;
            this.info = TierNodeFactory.this.createNodeInfo(this);
        }

        public Bucket(int n, NodeInfo[] nodeInfoArray) {
            this(n);
            for (int i = 0; i < nodeInfoArray.length; ++i) {
                this.privateAddNode(nodeInfoArray[i]);
            }
        }

        public void addBucketChildren(Bucket bucket) {
            int n;
            for (n = 0; n < bucket.nodeList.size(); ++n) {
                this.privateAddNode((NodeInfo)bucket.nodeList.get(n));
            }
            bucket.nodeList.clear();
            for (n = 0; n < bucket.bucketList.size(); ++n) {
                this.privateAddBucket((Bucket)bucket.bucketList.get(n));
            }
            bucket.bucketList.clear();
        }

        public void addNode(NodeInfo nodeInfo) {
            Bucket bucket = this.getBucket(nodeInfo);
            if (bucket != null) {
                bucket.nodeList.remove(nodeInfo);
            }
            this.privateAddNode(nodeInfo);
            this.info.connections.or(nodeInfo.connections);
        }

        private void privateAddNode(NodeInfo nodeInfo) {
            this.nodeList.add(nodeInfo);
            nodeInfo.parent = this;
        }

        public void addBucket(Bucket bucket) {
            Bucket bucket2 = this.getBucket(bucket);
            if (bucket2 != null) {
                bucket2.removeBucket(bucket);
            }
            this.privateAddBucket(bucket);
            this.info.connections.or(bucket.info.connections);
        }

        public void removeBucket(Bucket bucket) {
            this.bucketList.remove(bucket);
            bucket.info.parent = null;
        }

        public void privateAddBucket(Bucket bucket) {
            this.bucketList.add(bucket);
            bucket.info.parent = this;
        }

        public void add(NodeInfo nodeInfo) {
            if (nodeInfo.bucket != null) {
                this.addBucket(nodeInfo.bucket);
            } else {
                this.addNode(nodeInfo);
                for (int i = 0; i < nodeInfo.peerList.size(); ++i) {
                    ((NodeInfo)nodeInfo.peerList.get((int)i)).connections.set(this.info.connectionIndex);
                }
            }
        }

        public void addBucketNodes(Bucket bucket) {
            for (int i = 0; i < bucket.nodeList.size(); ++i) {
                NodeInfo nodeInfo = (NodeInfo)bucket.nodeList.get(i);
                this.privateAddNode(nodeInfo);
                this.info.connections.or(nodeInfo.connections);
            }
            bucket.nodeList.clear();
        }

        public CCTopologyModelInterface.GroupNode createGroupNode(boolean bl) {
            int n;
            CCTopologyModelInterface.Node[] nodeArray = new CCTopologyModelInterface.Node[this.nodeList.size() + this.bucketList.size()];
            int n2 = 0;
            for (n = 0; n < this.bucketList.size(); ++n) {
                nodeArray[n2++] = ((Bucket)this.bucketList.get(n)).createGroupNode(false);
            }
            for (n = 0; n < this.nodeList.size(); ++n) {
                nodeArray[n2++] = ((NodeInfo)this.nodeList.get((int)n)).node;
            }
            Arrays.sort(nodeArray, new Comparator(){

                public int compare(Object object, Object object2) {
                    try {
                        return ((CCTopologyModelInterface.Node)object).getLabel().compareTo(((CCTopologyModelInterface.Node)object2).getLabel());
                    }
                    catch (Exception exception) {
                        return (object2 == null ? 0 : object2.hashCode()) - (object == null ? 0 : object.hashCode());
                    }
                }
            });
            String string = bl ? String.valueOf(this.hashCode()) : this.createGroupLabel(nodeArray);
            String string2 = bl ? string : string + this.hashCode();
            return new CCTopologyGroupNode(string2, string, nodeArray);
        }

        private void organizeByWithinTierConnectivity() {
            Bucket bucket;
            Object object;
            int n;
            Bucket[] bucketArray = new Bucket[3];
            for (n = 0; n < 3; ++n) {
                bucketArray[n] = new Bucket(this.tier);
                this.addBucket(bucketArray[n]);
            }
            block1: while (this.nodeList.size() > 0) {
                int n2;
                int n3;
                NodeInfo nodeInfo = (NodeInfo)this.nodeList.get(0);
                if (nodeInfo.peerList.size() == 0) {
                    bucketArray[this.tier].addNode(nodeInfo);
                    continue;
                }
                object = new boolean[3];
                Bucket bucket2 = null;
                for (n3 = 0; n3 < nodeInfo.peerList.size(); ++n3) {
                    NodeInfo nodeInfo2 = (NodeInfo)nodeInfo.peerList.get(n3);
                    bucket = this.getBucket(nodeInfo2);
                    if (bucket.tier == this.tier) {
                        if (bucket2 == null) {
                            if (bucket == this) {
                                bucket2 = new Bucket(this.tier);
                                this.addBucket(bucket2);
                                bucket2.add(nodeInfo);
                                bucket2.add(nodeInfo2);
                                continue;
                            }
                            bucket2 = bucket;
                            bucket2.add(nodeInfo);
                            continue;
                        }
                        if (bucket2 == bucket) continue;
                        if (bucket == this) {
                            bucket2.addNode(nodeInfo2);
                            continue;
                        }
                        bucket2.addBucketNodes(bucket);
                        this.removeBucket(bucket);
                        continue;
                    }
                    object[bucket.tier] = true;
                }
                if (bucket2 != null) continue;
                n3 = 0;
                for (n2 = 0; n2 < 3; ++n2) {
                    if (object[n2] == false) continue;
                    ++n3;
                }
                if (n3 > 1) {
                    Bucket bucket3 = new Bucket(this.tier);
                    bucket3.add(nodeInfo);
                    this.privateAddBucket(bucket3);
                    continue;
                }
                if (n3 == 1) {
                    for (n2 = 0; n2 < 3; ++n2) {
                        if (object[n2] == false) continue;
                        bucketArray[n2].add(nodeInfo);
                        continue block1;
                    }
                    continue;
                }
                bucketArray[this.tier].add(nodeInfo);
            }
            for (n = 0; n < bucketArray.length; ++n) {
                object = bucketArray[n].nodeList;
                block6: for (int i = 0; i < object.size(); ++i) {
                    NodeInfo nodeInfo = (NodeInfo)object.get(i);
                    for (int j = 0; j < this.info.peerList.size(); ++j) {
                        bucket = this.getBucket((NodeInfo)this.info.peerList.get(j));
                        if (bucket.tier != this.tier) continue;
                        bucket.addNode(this.info);
                        continue block6;
                    }
                }
            }
        }

        public void organizeByConnectivity() {
            while (this.nodeList.size() + this.bucketList.size() > 2) {
                int n;
                NodeInfo[] nodeInfoArray = this.calculateDistances();
                int n2 = Integer.MAX_VALUE;
                for (n = 0; n < nodeInfoArray.length; ++n) {
                    n2 = Math.min(n2, nodeInfoArray[n].closestDistance);
                }
                for (n = 0; n < nodeInfoArray.length; ++n) {
                    if (nodeInfoArray[n].closestDistance != n2) continue;
                    Bucket bucket = this.getBucket(nodeInfoArray[n].closestNode);
                    if (bucket != this) {
                        bucket.add(nodeInfoArray[n]);
                        bucket.distance = n2;
                        continue;
                    }
                    Bucket bucket2 = new Bucket(this.tier);
                    bucket2.add(nodeInfoArray[n]);
                    bucket2.add(nodeInfoArray[n].closestNode);
                    this.privateAddBucket(bucket2);
                    this.distance = n2;
                }
            }
        }

        public NodeInfo[] calculateDistances() {
            int n;
            NodeInfo[] nodeInfoArray = new NodeInfo[this.nodeList.size() + this.bucketList.size()];
            for (int i = 0; i < this.nodeList.size(); ++i) {
                nodeInfoArray[i] = (NodeInfo)this.nodeList.get(i);
            }
            for (n = 0; n < this.bucketList.size(); ++n) {
                nodeInfoArray[i + n] = ((Bucket)this.bucketList.get((int)n)).info;
            }
            for (n = 0; n < nodeInfoArray.length; ++n) {
                NodeInfo nodeInfo = nodeInfoArray[n];
                nodeInfo.closestDistance = Integer.MAX_VALUE;
                for (int i = 0; i < n; ++i) {
                    NodeInfo nodeInfo2 = nodeInfoArray[i];
                    BitSet bitSet = (BitSet)nodeInfo.connections.clone();
                    bitSet.xor(nodeInfo2.connections);
                    int n2 = bitSet.cardinality();
                    nodeInfo.setDistance(i, n2);
                    if (n2 >= nodeInfo.closestDistance) continue;
                    nodeInfo.closestDistance = n2;
                    nodeInfo.closestNode = nodeInfo2;
                }
            }
            return nodeInfoArray;
        }

        public void flatten(boolean bl, int n) {
            int n2;
            int n3;
            int n4;
            int n5 = bl ? n : Integer.MAX_VALUE;
            int n6 = this.getTotalNodeCount();
            if (n6 <= n) {
                while (this.bucketList.size() > 0) {
                    this.addBucketChildren((Bucket)this.bucketList.remove(0));
                }
                return;
            }
            int n7 = this.nodeList.size();
            for (n4 = 0; n4 < this.bucketList.size(); ++n4) {
                Bucket bucket = (Bucket)this.bucketList.get(n4);
                bucket.flatten(bl, n);
                n7 += bucket.nodeList.size() + bucket.bucketList.size();
            }
            if (n7 <= n) {
                ArrayList arrayList = new ArrayList(this.bucketList);
                this.bucketList.clear();
                while (arrayList.size() > 0) {
                    this.addBucketChildren((Bucket)arrayList.remove(0));
                }
                return;
            }
            n4 = this.nodeList.size() + this.bucketList.size();
            if (bl ? n4 > n : this.nodeList.size() > n) {
                int n8;
                int n9 = this.nodeList.size();
                n3 = 1 + (n9 - 1) / n;
                if (n3 + this.bucketList.size() <= n5) {
                    int n10 = 1 + (n9 - 1) / n3;
                    Collections.sort(this.nodeList);
                    n2 = 0;
                    for (n8 = 0; n8 < n3; ++n8) {
                        Bucket bucket = new Bucket(this.tier);
                        this.privateAddBucket(bucket);
                        int n11 = (n8 + 1) * n10;
                        while (n2 < n11 && n2 < this.nodeList.size()) {
                            bucket.privateAddNode((NodeInfo)this.nodeList.get(n2));
                            ++n2;
                        }
                    }
                    this.nodeList.clear();
                } else {
                    ArrayList<NodeInfo> arrayList = new ArrayList<NodeInfo>();
                    arrayList.addAll(this.nodeList);
                    for (n2 = 0; n2 < this.bucketList.size(); ++n2) {
                        arrayList.add(((Bucket)this.bucketList.get((int)n2)).info);
                    }
                    Collections.sort(arrayList);
                    this.nodeList.clear();
                    this.bucketList.clear();
                    n3 = 1 + (n4 - 1) / n;
                    n2 = 1 + (n4 - 1) / n3;
                    while (bl && n2 > n) {
                        n3 = 1 + (n2 - 1) / n;
                        n2 = 1 + (n2 - 1) / n3;
                    }
                    n2 = 1 + (n4 - 1) / n3;
                    n8 = 0;
                    for (int i = 0; i < n3; ++i) {
                        Bucket bucket = new Bucket(this.tier);
                        this.privateAddBucket(bucket);
                        int n12 = (i + 1) * n2;
                        while (n8 < n12 && n8 < arrayList.size()) {
                            NodeInfo nodeInfo = (NodeInfo)arrayList.get(n8);
                            if (nodeInfo.node != null) {
                                bucket.privateAddNode(nodeInfo);
                            } else {
                                bucket.privateAddBucket(nodeInfo.bucket);
                            }
                            ++n8;
                        }
                        if (n2 <= n) continue;
                        bucket.flatten(bl, n);
                    }
                }
            }
            if (!bl) {
                for (int i = 0; i < this.bucketList.size(); ++i) {
                    Bucket bucket = (Bucket)this.bucketList.get(i);
                    while (bucket.bucketList.size() > 0) {
                        this.privateAddBucket((Bucket)bucket.bucketList.remove(0));
                    }
                }
            }
            boolean bl2 = false;
            n4 = this.nodeList.size() + this.bucketList.size();
            n3 = n - n4;
            if (bl2 && (!this.isTop || n4 == 1) && n3 > 0) {
                ArrayList arrayList = new ArrayList();
                for (n2 = 0; n2 < this.bucketList.size(); ++n2) {
                    arrayList.addAll(((Bucket)this.bucketList.get((int)n2)).bucketList);
                }
                Collections.sort(arrayList, new Comparator(){

                    public int compare(Object object, Object object2) {
                        try {
                            return ((Bucket)object2).distance - ((Bucket)object).distance;
                        }
                        catch (Exception exception) {
                            return (object2 == null ? 0 : object2.hashCode()) - (object == null ? 0 : object.hashCode());
                        }
                    }
                });
                for (n2 = 0; n2 < n3 && n2 < arrayList.size(); ++n2) {
                    this.addBucket((Bucket)arrayList.get(n2));
                }
            }
        }

        public void removeEmptyBuckets() {
            Iterator iterator = this.bucketList.iterator();
            while (iterator.hasNext()) {
                Bucket bucket = (Bucket)iterator.next();
                bucket.removeEmptyBuckets();
                int n = bucket.nodeList.size();
                int n2 = bucket.bucketList.size();
                if (n == 0) {
                    if (n2 == 0) {
                        iterator.remove();
                        continue;
                    }
                    if (n2 != 1) continue;
                    Bucket bucket2 = (Bucket)bucket.bucketList.remove(0);
                    bucket.addBucketChildren(bucket2);
                    continue;
                }
                if (n != 1 || n2 != 0) continue;
                this.privateAddNode((NodeInfo)bucket.nodeList.get(0));
                iterator.remove();
            }
        }

        int getTotalNodeCount() {
            if (this.totalNodeCount == -1) {
                this.totalNodeCount = this.nodeList.size();
                for (int i = 0; i < this.bucketList.size(); ++i) {
                    this.totalNodeCount += ((Bucket)this.bucketList.get(i)).getTotalNodeCount();
                }
            }
            return this.totalNodeCount;
        }

        public Bucket getBucket(NodeInfo nodeInfo) {
            return nodeInfo.parent;
        }

        public Bucket getBucket(Bucket bucket) {
            return bucket.info.parent;
        }

        private String createGroupLabel(CCTopologyModelInterface.Node[] nodeArray) {
            Object object;
            if (nodeArray == null || nodeArray.length == 0) {
                return "null";
            }
            Object[] objectArray = new String[nodeArray.length];
            Object[] objectArray2 = new String[nodeArray.length];
            for (int i = 0; i < nodeArray.length; ++i) {
                object = TierNodeFactory.this.getLabelParts(nodeArray[i].getLabel());
                objectArray[i] = object[0];
                objectArray2[i] = object[1];
            }
            Arrays.sort(objectArray);
            Arrays.sort(objectArray2);
            Object object2 = objectArray[0];
            object = objectArray2[objectArray2.length - 1];
            if (((String)object2).equals(object)) {
                return object2;
            }
            return (String)object2 + ".." + (String)object;
        }
    }

    private class NodeInfo
    implements Comparable {
        public final CCTopologyModelInterface.Node node;
        public final Bucket bucket;
        public Bucket parent;
        public final int connectionIndex;
        public final List peerList = new ArrayList();
        public final BitSet connections = new BitSet(200);
        public int closestDistance;
        public NodeInfo closestNode;
        public int[] nodeDistances = new int[100];

        public String getCompareLabel() {
            return this.node != null ? this.node.getLabel() : (this.bucket != null ? this.bucket.getCompareLabel() : "zyz");
        }

        public int compareTo(Object object) {
            if (!(object instanceof NodeInfo)) {
                return 1;
            }
            return this.getCompareLabel().compareTo(((NodeInfo)object).getCompareLabel());
        }

        public NodeInfo(CCTopologyModelInterface.Node node, int n, int n2) {
            this.node = node;
            this.bucket = null;
            this.connectionIndex = n2;
            Arrays.fill(this.nodeDistances, Integer.MAX_VALUE);
        }

        public NodeInfo(Bucket bucket, int n) {
            this.node = null;
            this.bucket = bucket;
            this.connectionIndex = n;
        }

        public void clearDistances() {
            Arrays.fill(this.nodeDistances, Integer.MAX_VALUE);
        }

        public void setDistance(int n, int n2) {
            if (n >= this.nodeDistances.length) {
                int[] nArray = new int[this.nodeDistances.length * 2];
                System.arraycopy(this.nodeDistances, 0, nArray, 0, this.nodeDistances.length);
                Arrays.fill(nArray, this.nodeDistances.length, nArray.length, Integer.MAX_VALUE);
                this.nodeDistances = nArray;
            }
            this.nodeDistances[n] = n2;
        }

        public int getDistance(int n) {
            try {
                return this.nodeDistances[n];
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return Integer.MAX_VALUE;
            }
        }
    }
}

