/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.model;

import com.iplanet.jato.model.DefaultModel;
import com.sun.web.ui.model.CCFileChooserModelInterface;
import com.sun.web.ui.model.CCFileChooserTimeInterface;
import java.io.File;
import java.io.FileFilter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;

public class CCFileChooserModel
extends DefaultModel
implements CCFileChooserModelInterface,
CCFileChooserTimeInterface {
    private String type = null;
    private Boolean multipleSelect;
    private int fileListBoxHeight = 10;
    private FileChooserFilter fileFilter = null;
    private String filterString = null;
    private String currentFilter;
    private String storedDirectory;
    private String homeDir = "/";
    private String currentDir;
    private Vector selectedFiles = new Vector();
    private String serverName = null;
    private String sortField = "alpha";
    private Locale locale = null;
    private static String DEFAULT_DATEFORMAT = "MM/dd/yy";
    private static String DEFAULT_TIMEFORMAT = "HH:mm";
    private String dateFormat = null;
    private String timeFormat = null;
    private boolean popupMode = false;
    private String alertChild;
    private String productNameAlt = null;
    private String productNameHeight = null;
    private String productNameSrc = null;
    private String productNameWidth = null;

    public void setType(String string) {
        this.type = !string.equals("file") && !string.equals("folder") ? "file" : string;
    }

    public String getType() {
        return this.type;
    }

    public void setMultipleSelect(boolean bl) {
        this.multipleSelect = new Boolean(bl);
    }

    public boolean multipleSelect() {
        boolean bl = false;
        if (this.multipleSelect != null) {
            bl = this.multipleSelect;
        }
        return bl;
    }

    public boolean isMultipleSelectSet() {
        return this.multipleSelect != null;
    }

    public void setPopupMode(boolean bl) {
        this.popupMode = bl;
    }

    public boolean isPopupMode() {
        return this.popupMode;
    }

    public String getProductNameAlt() {
        return this.productNameAlt;
    }

    public void setProductNameAlt(String string) {
        this.productNameAlt = string;
    }

    public String getProductNameHeight() {
        return this.productNameHeight;
    }

    public void setProductNameHeight(String string) {
        this.productNameHeight = string;
    }

    public String getProductNameSrc() {
        return this.productNameSrc;
    }

    public void setProductNameSrc(String string) {
        this.productNameSrc = string;
    }

    public String getProductNameWidth() {
        return this.productNameWidth;
    }

    public void setProductNameWidth(String string) {
        this.productNameWidth = string;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        if (locale != null) {
            this.locale = locale;
        }
    }

    public String[] getSelectedFiles() {
        if (this.selectedFiles.isEmpty()) {
            return null;
        }
        Object[] objectArray = this.selectedFiles.toArray();
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = (String)objectArray[i];
        }
        return stringArray;
    }

    public void addSelectedFile(String string) {
        if (string != null) {
            this.selectedFiles.add(string);
        }
    }

    public void clearFiles() {
        this.selectedFiles.clear();
    }

    public String getCurrentDirectory() {
        return this.currentDir;
    }

    public void setCurrentDirectory(String string) {
        this.currentDir = string;
    }

    public FileFilter instantiateFilter(String string) {
        this.fileFilter = new FileChooserFilter(string);
        return this.fileFilter;
    }

    public FileFilter getFileFilter() {
        if (this.fileFilter == null) {
            this.fileFilter = this.filterString == null ? new FileChooserFilter() : new FileChooserFilter(this.filterString);
        }
        return this.fileFilter;
    }

    public String getFilterString() {
        return this.filterString;
    }

    public void setFilterString(String string) {
        if (string != null) {
            this.filterString = string;
        }
    }

    public int getFileListBoxHeight() {
        return this.fileListBoxHeight;
    }

    public void setFileListBoxHeight(int n) {
        if (n > 0) {
            this.fileListBoxHeight = n;
        }
    }

    public String getDateFormat() {
        if (this.dateFormat == null) {
            return DEFAULT_DATEFORMAT;
        }
        return this.dateFormat;
    }

    public void setDateFormat(String string) {
        this.dateFormat = string == null ? DEFAULT_DATEFORMAT : string;
    }

    public String getTimeFormat() {
        if (this.timeFormat == null) {
            return DEFAULT_TIMEFORMAT;
        }
        return this.timeFormat;
    }

    public void setTimeFormat(String string) {
        this.timeFormat = string == null ? DEFAULT_TIMEFORMAT : string;
    }

    public String getServerName() {
        return this.serverName != null ? this.serverName : this.getLocalHostName();
    }

    public void setServerName(String string) {
        this.serverName = string != null ? string : this.getLocalHostName();
    }

    private String getLocalHostName() {
        String string;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            string = "localhost";
        }
        return string;
    }

    public String getHomeDirectory() {
        return this.homeDir;
    }

    public void setHomeDirectory(String string) {
        if (string != null) {
            this.homeDir = string;
        }
    }

    public boolean canRead(String string) throws Exception {
        if (string == null) {
            throw new Exception("filechooser.dir_is_null");
        }
        File file = new File(string);
        if (!file.exists()) {
            throw new Exception("filechooser.file_does_not_exist");
        }
        return file.canRead();
    }

    public File[] getFiles(String string) {
        int n;
        File file;
        if (string == null) {
            string = this.homeDir;
        }
        if (!(file = new File(string)).exists()) {
            return null;
        }
        if (file.isFile()) {
            return null;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null || fileArray.length == 0) {
            return null;
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        ArrayList<File> arrayList2 = new ArrayList<File>();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                arrayList2.add(fileArray[i]);
                continue;
            }
            arrayList.add(fileArray[i]);
        }
        File[] fileArray2 = new File[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            fileArray2[i] = (File)arrayList.get(i);
        }
        File[] fileArray3 = new File[arrayList2.size()];
        for (n = 0; n < arrayList2.size(); ++n) {
            fileArray3[n] = (File)arrayList2.get(n);
        }
        this.sort(fileArray2);
        this.sort(fileArray3);
        for (n = 0; n < arrayList2.size(); ++n) {
            fileArray[n] = fileArray3[n];
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            fileArray[n + i] = fileArray2[i];
        }
        return fileArray;
    }

    public void sort(File[] fileArray) {
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        if (fileArray.length == 1) {
            return;
        }
        String string = this.getSortField();
        for (int i = fileArray.length - 1; i >= 0; --i) {
            for (int j = 0; j < i; ++j) {
                boolean bl = false;
                if (string.equals("alpha")) {
                    bl = this.inAlphabeticOrderAsc(fileArray[j], fileArray[j + 1]);
                } else if (string.equals("alphd")) {
                    bl = this.inAlphabeticOrderDsc(fileArray[j], fileArray[j + 1]);
                } else if (string.equals("sza")) {
                    bl = this.isSortedBySizeAsc(fileArray[j], fileArray[j + 1]);
                } else if (string.equals("szd")) {
                    bl = this.isSortedBySizeDsc(fileArray[j], fileArray[j + 1]);
                } else if (string.equals("lma")) {
                    bl = this.isSortedByTimeAsc(fileArray[j], fileArray[j + 1]);
                } else if (string.equals("lmd")) {
                    bl = this.isSortedByTimeDsc(fileArray[j], fileArray[j + 1]);
                }
                if (!bl) continue;
                File file = fileArray[j];
                fileArray[j] = fileArray[j + 1];
                fileArray[j + 1] = file;
            }
        }
    }

    private boolean inAlphabeticOrderAsc(File file, File file2) {
        return file.getName().compareToIgnoreCase(file2.getName()) >= 0;
    }

    private boolean inAlphabeticOrderDsc(File file, File file2) {
        return file2.getName().compareToIgnoreCase(file.getName()) >= 0;
    }

    private boolean isSortedBySizeAsc(File file, File file2) {
        if (file.length() == file2.length()) {
            return file.getName().compareToIgnoreCase(file2.getName()) >= 0;
        }
        return file.length() > file2.length();
    }

    private boolean isSortedBySizeDsc(File file, File file2) {
        if (file.length() == file2.length()) {
            return file.getName().compareToIgnoreCase(file2.getName()) >= 0;
        }
        return file.length() < file2.length();
    }

    private boolean isSortedByTimeAsc(File file, File file2) {
        if (file.lastModified() == file2.lastModified()) {
            return file.getName().compareToIgnoreCase(file2.getName()) >= 0;
        }
        return file.lastModified() > file2.lastModified();
    }

    private boolean isSortedByTimeDsc(File file, File file2) {
        if (file.lastModified() == file2.lastModified()) {
            return file.getName().compareToIgnoreCase(file2.getName()) >= 0;
        }
        return file.lastModified() < file2.lastModified();
    }

    public String getSortField() {
        if (this.sortField == null) {
            return "alpha";
        }
        return this.sortField;
    }

    public void setSortField(String string) {
        this.sortField = string == null || !string.equals("alpha") && !string.equals("alphd") && !string.equals("sza") && !string.equals("szd") && !string.equals("lma") && !string.equals("lmd") ? "alpha" : string;
    }

    public void setAlertChildView(String string) {
        if (string != null) {
            this.alertChild = string;
        }
    }

    public String getAlertChildView() {
        return this.alertChild;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.type == "file") {
            stringBuffer.append("Selected File(s): \n");
        } else {
            stringBuffer.append("Selected Folder(s): \n");
        }
        String string = this.getCurrentDirectory();
        String[] stringArray = this.getSelectedFiles();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(string).append(File.separator).append(stringArray[i]).append("\n");
        }
        return stringBuffer.toString();
    }

    private static class FileChooserFilter
    implements FileFilter {
        private String filterString = null;
        private String extPattern = null;
        private String namePattern = null;

        public FileChooserFilter() {
        }

        public FileChooserFilter(String string) {
            if (string != null) {
                this.filterString = string;
                this.filterString.trim();
                int n = string.indexOf(46);
                if (n == -1) {
                    this.namePattern = string;
                } else if (n == 0) {
                    if (string.length() > 1) {
                        this.extPattern = string.substring(1);
                    }
                } else if (n == string.length() - 1) {
                    this.namePattern = string.substring(0, n - 1);
                } else {
                    this.namePattern = string.substring(0, n);
                    this.extPattern = string.substring(n + 1);
                }
            }
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            if (this.filterString == null) {
                return true;
            }
            if (this.filterString.length() == 0) {
                return true;
            }
            if (this.filterString.equals("*")) {
                return true;
            }
            String string = file.getName();
            if (this.filterString.equals(string)) {
                return true;
            }
            String string2 = this.getExtension(string);
            String string3 = this.getName(string);
            if (this.filterString.indexOf(46) == -1) {
                return this.check(string, this.filterString);
            }
            if (this.filterString.indexOf(46) != -1 && string.indexOf(46) == -1) {
                return false;
            }
            boolean bl = this.check(string3, this.namePattern);
            boolean bl2 = this.check(string2, this.extPattern);
            return bl && bl2;
        }

        private boolean check(String string, String string2) {
            boolean bl = false;
            if (string == null && string2 == null) {
                bl = true;
            } else if (string == null && string2 != null) {
                if (string2.equals("*")) {
                    bl = true;
                }
            } else if (string != null && string2 != null) {
                if (string2.equals("*")) {
                    bl = true;
                } else if (string2.equals(string)) {
                    bl = true;
                } else {
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, "*");
                    if (stringTokenizer.countTokens() == 1) {
                        if (string2.endsWith("*") && string2.startsWith("*")) {
                            bl = this.checkPattern(stringTokenizer, string);
                        } else if (string2.endsWith("*")) {
                            String string3 = string2.substring(0, string2.length() - 1);
                            bl = string.startsWith(string3);
                        } else if (string2.startsWith("*")) {
                            String string4 = string2.substring(1, string2.length());
                            bl = string.endsWith(string4);
                        }
                    } else {
                        bl = this.checkPattern(stringTokenizer, string);
                    }
                }
            }
            return bl;
        }

        private boolean checkPattern(StringTokenizer stringTokenizer, String string) {
            int n = 0;
            boolean bl = true;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                int n2 = string.indexOf(string2, n);
                if (n2 == -1) {
                    bl = false;
                    break;
                }
                n = n2 + string2.length();
            }
            return bl;
        }

        private String getExtension(String string) {
            String string2 = null;
            if (string != null) {
                int n = string.indexOf(46);
                if (n == -1) {
                    return null;
                }
                if (n == 0) {
                    string2 = string.substring(1);
                } else if (n < string.length() - 1) {
                    string2 = string.substring(n + 1).toLowerCase();
                }
            }
            return string2;
        }

        private String getName(String string) {
            String string2 = null;
            int n = string.length();
            if (string != null) {
                int n2 = string.indexOf(46);
                if (n2 == -1) {
                    string2 = string;
                } else if (n2 == 0) {
                    string2 = null;
                } else if (n2 <= n - 1) {
                    string2 = string.substring(0, n2);
                }
            }
            return string2;
        }
    }
}

