/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.model;

import com.iplanet.jato.model.DefaultModel;
import com.sun.web.ui.model.CCDateTimeModelInterface;
import com.sun.web.ui.model.CCRepeatInterval;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.TimeZone;

public class CCDateTimeModel
extends DefaultModel
implements CCDateTimeModelInterface,
Serializable {
    private static final long serialVersionUID = 1267832493720833101L;
    private Date startDateTime;
    private Date endTime;
    private String selectedInterval = null;
    private int repeatLimitUnit = -1;
    private int repeatLimitPeriod = -1;
    private int type = 0;
    private int startYear = -1;
    private int endYear = -1;
    private String startDateLabel = null;
    private String startTimeLabel = null;
    private String endTimeLabel = null;
    private String[] intervalCandidates = new String[]{"onetime", "hourly", "daily", "weekly", "monthly"};
    private Hashtable definedIntervals = new Hashtable();
    private String showRequiredMsg = null;
    private TimeZone timeZone = null;

    public CCDateTimeModel() {
        this.createRepeatInterval("hourly", 0, 1, "datetime.repeatHourly");
        this.createRepeatInterval("daily", 1, 1, "datetime.repeatDaily");
        this.createRepeatInterval("weekly", 2, 1, "datetime.repeatWeekly");
        this.createRepeatInterval("monthly", 3, 1, "datetime.repeatMonthly");
        this.createRepeatInterval("mwf", 4, 21, "datetime.repeatMWF");
        this.createRepeatInterval("tt", 4, 10, "datetime.repeatTT");
        this.createRepeatInterval("ss", 4, 96, "datetime.repeatSS");
        this.createRepeatInterval("mtwtf", 4, 31, "datetime.repeatMTWTF");
        this.createRepeatInterval("onetime", 5, 0, "datetime.repeatOnetime");
    }

    public Date getStartDateTime() {
        return this.startDateTime;
    }

    public void setStartDateTime(Date date) {
        this.startDateTime = date;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date date) {
        this.endTime = date;
    }

    public void setRepeatIntervals(String[] stringArray) {
        if (stringArray != null) {
            this.intervalCandidates = stringArray;
        }
    }

    public String[] getRepeatIntervals() {
        return this.intervalCandidates;
    }

    public String getSelectedRepeatIntervalName() {
        return this.selectedInterval;
    }

    public void setSelectedRepeatIntervalName(String string) {
        this.selectedInterval = string;
    }

    public int getRepeatLimitUnit() {
        return this.repeatLimitUnit;
    }

    public void setRepeatLimitUnit(int n) {
        this.repeatLimitUnit = n;
    }

    public int getRepeatLimitPeriod() {
        return this.repeatLimitPeriod;
    }

    public void setRepeatLimitPeriod(int n) {
        this.repeatLimitPeriod = n;
    }

    public void setType(int n) {
        this.type = n;
    }

    public int getType() {
        return this.type;
    }

    public int getRepeatIntervalUnit(String string) {
        int n = -1;
        CCRepeatInterval cCRepeatInterval = (CCRepeatInterval)this.definedIntervals.get(string);
        if (cCRepeatInterval != null) {
            n = cCRepeatInterval.getUnit();
        }
        return n;
    }

    public int getRepeatIntervalAccount(String string) {
        int n = -1;
        CCRepeatInterval cCRepeatInterval = (CCRepeatInterval)this.definedIntervals.get(string);
        if (cCRepeatInterval != null) {
            n = cCRepeatInterval.getAccount();
        }
        return n;
    }

    public String getRepeatIntervalPresentation(String string) {
        String string2 = null;
        CCRepeatInterval cCRepeatInterval = (CCRepeatInterval)this.definedIntervals.get(string);
        if (cCRepeatInterval != null) {
            string2 = cCRepeatInterval.getPresentation();
        }
        return string2;
    }

    public void createRepeatInterval(String string, int n, int n2, String string2) {
        CCRepeatInterval cCRepeatInterval = new CCRepeatInterval(n, n2, string2);
        this.definedIntervals.put(string, cCRepeatInterval);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        DateFormat dateFormat = DateFormat.getDateInstance(0);
        DateFormat dateFormat2 = DateFormat.getTimeInstance(0);
        if (this.timeZone != null) {
            dateFormat.setTimeZone(this.timeZone);
            dateFormat2.setTimeZone(this.timeZone);
        }
        stringBuffer.append("Scheduler DATA:\n");
        stringBuffer.append("\tStart Date: " + dateFormat.format(this.startDateTime));
        if (this.type != 2) {
            stringBuffer.append("\n\tStart Time: " + dateFormat2.format(this.startDateTime));
            if (this.type == 0 || this.type == 3) {
                String string = null;
                if (this.endTime != null) {
                    string = dateFormat2.format(this.endTime);
                }
                stringBuffer.append("\n\tEnd Time: " + string);
            }
            if (this.type == 0) {
                stringBuffer.append("\n\tRepeat Limit, unit: " + this.repeatLimitUnit + ", period: " + this.repeatLimitPeriod);
            }
            if (this.type != 4) {
                stringBuffer.append("\n\t" + this.definedIntervals.get(this.selectedInterval));
            }
        }
        return stringBuffer.toString();
    }

    public boolean isShowRequiredMsgSet() {
        return this.showRequiredMsg != null;
    }

    public boolean getShowRequiredMsg() {
        return this.showRequiredMsg == null ? true : new Boolean(this.showRequiredMsg);
    }

    public void setShowRequiredMsg(boolean bl) {
        this.showRequiredMsg = Boolean.toString(bl);
    }

    public String getStartDateLabel() {
        return this.startDateLabel;
    }

    public void setStartDateLabel(String string) {
        this.startDateLabel = string;
    }

    public String getStartTimeLabel() {
        return this.startTimeLabel;
    }

    public void setStartTimeLabel(String string) {
        this.startTimeLabel = string;
    }

    public String getEndTimeLabel() {
        return this.endTimeLabel;
    }

    public void setEndTimeLabel(String string) {
        this.endTimeLabel = string;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public int getStartYear() {
        return this.startYear;
    }

    public void setStartYear(int n) {
        this.startYear = n;
    }

    public int getEndYear() {
        return this.endYear;
    }

    public void setEndYear(int n) {
        this.endYear = n;
    }
}

