/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.common;

import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;

public class CCClientSniffer {
    private HttpServletRequest request = null;
    private String agent = null;
    private String version = null;
    private int major = -1;

    public CCClientSniffer(HttpServletRequest httpServletRequest) {
        StringTokenizer stringTokenizer;
        this.request = httpServletRequest;
        this.agent = this.getUserAgent().toLowerCase();
        if (this.agent != null) {
            stringTokenizer = new StringTokenizer(this.agent, "/");
            if (stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
            }
            if (stringTokenizer.hasMoreTokens()) {
                this.version = stringTokenizer.nextToken();
            }
            if (this.version != null && (stringTokenizer = new StringTokenizer(this.version)).hasMoreTokens()) {
                this.version = stringTokenizer.nextToken();
            }
        }
        if (this.version != null && (stringTokenizer = new StringTokenizer(this.version, ".")).hasMoreTokens()) {
            try {
                this.major = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public String getUserAgent() {
        String string = null;
        if (this.request != null) {
            string = this.request.getHeader("USER-AGENT");
        }
        return string;
    }

    public int getUserAgentMajor() {
        return this.major;
    }

    public boolean isWin() {
        boolean bl = false;
        if (this.agent != null && (this.agent.indexOf("win") != -1 || this.agent.indexOf("16bit") != -1)) {
            bl = true;
        }
        return bl;
    }

    public boolean isSun() {
        boolean bl = false;
        if (this.agent != null && this.agent.indexOf("sunos") != -1) {
            bl = true;
        }
        return bl;
    }

    public boolean isGecko() {
        boolean bl = false;
        if (this.agent != null && this.agent.indexOf("gecko") != -1) {
            bl = true;
        }
        return bl;
    }

    public boolean isNav() {
        boolean bl = false;
        if (!(this.agent == null || this.agent.indexOf("mozilla") == -1 || this.agent.indexOf("spoofer") != -1 || this.agent.indexOf("compatible") != -1 || this.agent.indexOf("opera") != -1 || this.agent.indexOf("webtv") != -1 || this.agent.indexOf("hotjava") != -1 || this.isGecko() && this.agent.indexOf("netscape") == -1)) {
            bl = true;
        }
        return bl;
    }

    public boolean isNav4() {
        boolean bl = false;
        if (this.isNav() && this.major == 4) {
            bl = true;
        }
        return bl;
    }

    public boolean isNav4up() {
        boolean bl = false;
        if (this.isNav() && this.major >= 4) {
            bl = true;
        }
        return bl;
    }

    public boolean isNav6() {
        boolean bl = false;
        if (this.isNav() && this.major == 5 && this.agent.indexOf("netscape6") != -1) {
            bl = true;
        }
        return bl;
    }

    public boolean isNav6up() {
        boolean bl = false;
        if (this.isNav() && this.major >= 5) {
            bl = true;
        }
        return bl;
    }

    public boolean isNav7() {
        boolean bl = false;
        if (this.isNav() && this.major == 5 && this.agent.indexOf("netscape/7") != -1) {
            bl = true;
        }
        return bl;
    }

    public boolean isNav70() {
        boolean bl = false;
        if (this.isNav() && this.major == 5 && this.agent.indexOf("netscape/7.0") != -1) {
            bl = true;
        }
        return bl;
    }

    public boolean isNav7up() {
        boolean bl = false;
        if (this.isNav() && this.major >= 5 && !this.isNav4() && !this.isNav6()) {
            bl = true;
        }
        return bl;
    }

    public boolean isIe() {
        boolean bl = false;
        if (this.agent != null && this.agent.indexOf("msie") != -1 && this.agent.indexOf("opera") == -1) {
            bl = true;
        }
        return bl;
    }

    public boolean isIe3() {
        boolean bl = false;
        if (this.isIe() && this.major < 4) {
            bl = true;
        }
        return bl;
    }

    public boolean isIe4() {
        boolean bl = false;
        if (this.isIe() && this.major == 4 && this.agent.indexOf("msie 4") != -1) {
            bl = true;
        }
        return bl;
    }

    public boolean isIe5() {
        boolean bl = false;
        if (this.isIe() && this.major == 4 && this.agent.indexOf("msie 5") != -1) {
            bl = true;
        }
        return bl;
    }

    public boolean isIe5up() {
        boolean bl = false;
        if (this.isIe() && !this.isIe3() && !this.isIe4()) {
            bl = true;
        }
        return bl;
    }

    public boolean isIe6() {
        boolean bl = false;
        if (this.isIe() && this.major == 4 && this.agent.indexOf("msie 6") != -1) {
            bl = true;
        }
        return bl;
    }

    public boolean isIe6up() {
        boolean bl = false;
        if (this.isIe() && !this.isIe3() && !this.isIe4() && !this.isIe5()) {
            bl = true;
        }
        return bl;
    }
}

