/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.services.registration;

import com.sun.management.services.common.Debug;
import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.ParserAdapter;

public class WebXmlParser
extends DefaultHandler {
    private static final String FILTER = "filter";
    private static final String FILTER_NAME = "filter-name";
    private static final String FILTER_CLASS = "filter-class";
    private static final String FILTER_MAPPING = "filter-mapping";
    private static final String URL_PATTERN = "url-pattern";
    private CharArrayWriter contents = new CharArrayWriter();
    private Hashtable resDTDs = new Hashtable();
    private String publicId = null;
    private boolean hasFilter = false;
    private boolean hasMapping = false;
    private boolean hasContent = false;
    private boolean isFirstFilter = true;
    private boolean nameMatchesMapping = false;
    private String filter_name = null;
    private String filter_mapping_name = null;
    private String filter_class = null;
    private String url_pattern = null;

    public void parse(InputSource inputSource) throws IOException, SAXException {
        SAXParser sAXParser;
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(false);
        sAXParserFactory.setValidating(false);
        try {
            sAXParser = sAXParserFactory.newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SAXException("Could not create parser!");
        }
        ParserAdapter parserAdapter = new ParserAdapter(sAXParser.getParser());
        parserAdapter.setContentHandler(this);
        try {
            parserAdapter.parse(inputSource);
            Debug.trace3((String)("filter_name: " + this.filter_name));
            Debug.trace3((String)("filter_mapping_name: " + this.filter_mapping_name));
            Debug.trace3((String)("filter_class: " + this.filter_class));
            Debug.trace3((String)("url_pattern: " + this.url_pattern));
        }
        catch (Exception exception) {
            Debug.trace1((String)"web.xml parsing error", (Throwable)exception);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string2.equalsIgnoreCase(FILTER)) {
            this.hasFilter = true;
        } else if (string2.equalsIgnoreCase(FILTER_NAME)) {
            this.contents.reset();
            this.hasContent = true;
        } else if (string2.equalsIgnoreCase(FILTER_CLASS)) {
            this.contents.reset();
            this.hasContent = true;
        } else if (string2.equalsIgnoreCase(FILTER_MAPPING)) {
            this.hasMapping = true;
        } else if (string2.equalsIgnoreCase(URL_PATTERN)) {
            this.contents.reset();
            this.hasContent = true;
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string2.equalsIgnoreCase(FILTER)) {
            this.hasFilter = false;
            this.hasContent = false;
            this.isFirstFilter = false;
        } else if (string2.equalsIgnoreCase(FILTER_NAME)) {
            if (this.hasFilter) {
                if (this.isFirstFilter) {
                    this.filter_name = this.contents.toString().trim();
                }
            } else if (this.hasMapping) {
                this.filter_mapping_name = this.contents.toString().trim();
                if (this.filter_name != null && this.filter_name.equals(this.filter_mapping_name)) {
                    this.nameMatchesMapping = true;
                }
            }
            this.hasContent = false;
        } else if (string2.equalsIgnoreCase(FILTER_CLASS)) {
            if (this.hasFilter && this.isFirstFilter) {
                this.filter_class = this.contents.toString().trim();
            }
            this.hasContent = false;
        } else if (string2.equalsIgnoreCase(FILTER_MAPPING)) {
            this.hasMapping = false;
            this.hasContent = false;
        } else if (string2.equalsIgnoreCase(URL_PATTERN)) {
            if (this.hasMapping && this.filter_name != null && this.filter_name.equals(this.filter_mapping_name)) {
                this.url_pattern = this.contents.toString().trim();
            }
            this.hasContent = false;
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.contents.write(cArray, n, n2);
    }

    public boolean isFilterSet() {
        if (this.filter_name == null || this.filter_mapping_name == null) {
            Debug.trace1((String)"filters are null");
            return false;
        }
        if (!this.nameMatchesMapping) {
            Debug.trace1((String)"filters names don't match");
            return false;
        }
        if (this.url_pattern == null) {
            Debug.trace1((String)"URL pattern is null");
            return false;
        }
        return true;
    }

    public String getFilterImplClassName() {
        return this.filter_class;
    }

    public static String trimWebXml(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        StringBuffer stringBuffer = new StringBuffer(4096);
        String string = null;
        boolean bl = false;
        try {
            while ((string = bufferedReader.readLine()) != null) {
                string = string.trim();
                while (string.length() > 0) {
                    int n;
                    if (bl) {
                        n = string.indexOf("-->");
                        if (n == -1) {
                            string = "";
                            continue;
                        }
                        bl = false;
                        if ((n += 3) > string.length()) {
                            string = "";
                            continue;
                        }
                        string = string.substring(n);
                    }
                    if ((n = string.indexOf("<!--")) != -1) {
                        bl = true;
                        if (n > 0) {
                            stringBuffer.append(string.substring(0, n));
                        }
                        if ((n += 4) > string.length()) {
                            string = "";
                            continue;
                        }
                        string = string.substring(n);
                        continue;
                    }
                    stringBuffer.append(string);
                    string = "";
                }
            }
        }
        catch (Exception exception) {
            Debug.trace1((String)("Error reading web.xml stream: " + exception.getMessage()));
            return null;
        }
        try {
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            inputStreamReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    public static String neuterWebXml(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        n = string.indexOf("<!DOCTYPE", n3);
        if (n != -1) {
            if (n > 0) {
                stringBuffer.append(string.substring(n3, n));
            }
            if ((n2 = string.indexOf(">", n)) == -1) {
                return null;
            }
            n3 = n2 + 1;
        }
        if ((n = string.indexOf("<web-app", n3)) == -1) {
            return null;
        }
        stringBuffer.append(string.substring(n3, n += 8));
        n3 = n;
        n2 = string.indexOf(">", n3);
        if (n2 == -1) {
            return null;
        }
        n3 = n2;
        stringBuffer.append(string.substring(n3));
        return stringBuffer.toString();
    }
}

