/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.services.registration;

import com.sun.management.services.common.Debug;
import com.sun.management.services.registration.AppDescriptorParser;
import com.sun.management.services.registration.CategoryUtility;
import com.sun.management.services.registration.MgmtAppRegistrationService;
import com.sun.management.services.registration.RegistrationException;
import com.sun.management.services.registration.RegistrationInfo;
import com.sun.management.services.registration.RegistrationUtil;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Set;
import org.xml.sax.InputSource;

public class MgmtAppRegistrationServiceImpl
implements MgmtAppRegistrationService {
    private Object osync = new Object();
    private HashMap consoleApps = new HashMap();
    private HashMap registeredApps = new HashMap();
    private HashMap registeredAppDirs = new HashMap();
    private HashMap registeredAppNames = new HashMap();
    private HashMap registeredLoaders = new HashMap();
    private static Hashtable urlTable = new Hashtable();
    private String registrationURL = null;
    private long tmpFileCounter = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getConsoleRegisteredApps() {
        String[] stringArray = new String[]{};
        Object object = this.osync;
        synchronized (object) {
            Set set = this.consoleApps.keySet();
            stringArray = set.toArray(stringArray);
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAllRegisteredApps() {
        String[] stringArray = new String[]{};
        Object object = this.osync;
        synchronized (object) {
            Set set = this.registeredApps.keySet();
            stringArray = set.toArray(stringArray);
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegistrationInfo getRegistrationInfo(String string) {
        RegistrationInfo registrationInfo;
        if (string == null) {
            return null;
        }
        Object object = this.osync;
        synchronized (object) {
            registrationInfo = (RegistrationInfo)this.consoleApps.get(string);
        }
        if (registrationInfo != null) {
            return registrationInfo;
        }
        object = this.osync;
        synchronized (object) {
            registrationInfo = (RegistrationInfo)this.registeredApps.get(string);
        }
        return registrationInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAppRegistered(String string) {
        RegistrationInfo registrationInfo;
        if (string == null) {
            return false;
        }
        Object object = this.osync;
        synchronized (object) {
            registrationInfo = (RegistrationInfo)this.registeredApps.get(string);
        }
        if (registrationInfo != null) {
            return true;
        }
        object = this.osync;
        synchronized (object) {
            registrationInfo = (RegistrationInfo)this.consoleApps.get(string);
        }
        return registrationInfo != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRegisteredAppDir(String string) throws IllegalArgumentException {
        String string2;
        if (string == null) {
            throw new IllegalArgumentException();
        }
        Object object = this.osync;
        synchronized (object) {
            string2 = (String)this.registeredAppDirs.get(string);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPluginName(String string) throws IllegalArgumentException {
        String string2;
        if (string == null) {
            throw new IllegalArgumentException();
        }
        Object object = this.osync;
        synchronized (object) {
            string2 = (String)this.registeredAppNames.get(string);
        }
        return string2;
    }

    public RegistrationInfo parseDescriptor(Reader reader) throws RegistrationException {
        Object var2_2 = null;
        try {
            InputSource inputSource = new InputSource(reader);
            AppDescriptorParser appDescriptorParser = new AppDescriptorParser();
            return appDescriptorParser.parse(inputSource);
        }
        catch (Exception exception) {
            throw new RegistrationException(exception.getMessage());
        }
    }

    public RegistrationInfo registerApp(String string) throws RegistrationException {
        return this.registerApp(new StringReader(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegistrationInfo registerApp(Reader reader) throws RegistrationException {
        RegistrationInfo registrationInfo = null;
        try {
            Object object;
            InputSource inputSource = new InputSource(reader);
            AppDescriptorParser appDescriptorParser = new AppDescriptorParser();
            registrationInfo = appDescriptorParser.parse(inputSource);
            MgmtAppRegistrationServiceImpl.printDebug(registrationInfo);
            String string = registrationInfo.getManagementApp().getPluginName();
            String string2 = registrationInfo.getUrlDesc().getUrl();
            if (registrationInfo.getManagementApp().getCategory().equalsIgnoreCase("Console")) {
                object = this.osync;
                synchronized (object) {
                    this.consoleApps.put(string, registrationInfo);
                }
            }
            object = this.osync;
            synchronized (object) {
                this.registeredApps.put(string, registrationInfo);
            }
            int n = string2.indexOf("/", 1);
            if (n != -1) {
                object = this.osync;
                synchronized (object) {
                    urlTable.put(string2.substring(0, n + 1), string2);
                }
            }
            if ((n = string2.indexOf("/")) >= 0 && (n = (string2 = string2.substring(n + 1)).indexOf("/")) >= 0) {
                string2 = string2.substring(0, n);
            }
            object = this.osync;
            synchronized (object) {
                this.registeredAppDirs.put(string, string2);
                this.registeredAppNames.put(string2, string);
            }
            CategoryUtility.updateRegistrationTimestamp();
            RegistrationUtil.updateRegFile(true);
        }
        catch (Exception exception) {
            throw new RegistrationException(exception.getMessage());
        }
        return registrationInfo;
    }

    public RegistrationInfo registerApp(RegistrationInfo registrationInfo) throws RegistrationException {
        return this.registerApp(registrationInfo, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegistrationInfo registerApp(RegistrationInfo registrationInfo, String string) throws RegistrationException {
        try {
            Object object;
            String string2 = registrationInfo.getManagementApp().getPluginName();
            String string3 = registrationInfo.getUrlDesc().getUrl();
            if (registrationInfo.getManagementApp().getCategory().equalsIgnoreCase("Console")) {
                object = this.osync;
                synchronized (object) {
                    this.consoleApps.put(string2, registrationInfo);
                }
            }
            object = this.osync;
            synchronized (object) {
                this.registeredApps.put(string2, registrationInfo);
            }
            int n = string3.indexOf("/", 1);
            if (n != -1) {
                object = this.osync;
                synchronized (object) {
                    urlTable.put(string3.substring(0, n + 1), string3);
                }
            }
            if ((n = string3.indexOf("/")) >= 0 && (n = (string3 = string3.substring(n + 1)).indexOf("/")) >= 0) {
                string3 = string3.substring(0, n);
            }
            if ((object = string) == null) {
                object = string3;
            }
            if (!((String)object).equals(string3)) {
                String string4 = "App context path \"" + (String)object + "\" does not match Url path name \"" + string3 + "\"";
                Debug.trace1((String)("Registration: " + string4));
                throw new Exception(string4);
            }
            Object object2 = this.osync;
            synchronized (object2) {
                this.registeredAppDirs.put(string2, object);
                this.registeredAppNames.put(object, string2);
            }
            CategoryUtility.updateRegistrationTimestamp();
            RegistrationUtil.updateRegFile(true);
        }
        catch (Exception exception) {
            throw new RegistrationException(exception.getMessage());
        }
        return registrationInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterApp(String string) {
        Object object = this.osync;
        synchronized (object) {
            String string2 = (String)this.registeredAppDirs.get(string);
            this.registeredApps.remove(string);
            this.registeredAppDirs.remove(string);
            this.registeredAppNames.remove(string2);
            urlTable.remove(string2);
            this.registeredLoaders.remove(string);
        }
        CategoryUtility.updateRegistrationTimestamp();
        RegistrationUtil.updateRegFile(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAppURL(String string) {
        String string2;
        if (string == null) {
            return null;
        }
        Object object = this.osync;
        synchronized (object) {
            string2 = (String)urlTable.get(string);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAppLoader(String string, ClassLoader classLoader) {
        Object object = this.osync;
        synchronized (object) {
            this.registeredLoaders.put(string, classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClassLoader getAppLoader(String string) {
        ClassLoader classLoader = null;
        Object object = this.osync;
        synchronized (object) {
            if (string != null) {
                classLoader = (ClassLoader)this.registeredLoaders.get(string);
            }
        }
        return classLoader;
    }

    public static void printDebug(RegistrationInfo registrationInfo) {
        if (registrationInfo == null) {
            return;
        }
        if (!Debug.isOn()) {
            return;
        }
        Debug.trace3((String)"\n---------------------------------------------");
        Debug.trace3((String)"---------- Registration Information ---------\n");
        Debug.trace3((String)registrationInfo.toString());
        Debug.trace3((String)"\n---------------------------------------------\n");
    }
}

