/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.services.common;

import com.sun.management.services.common.DebugTrace;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class DebugTraceImpl
implements DebugTrace {
    private static final int TRACE_OFF = 0;
    private static final String TRACE_HEADER = "Debug trace enabled ";
    private String trace_file;
    private int trace_level = 0;
    private long trace_maxsize;
    private int trace_maxfiles;
    private int trace_stacksize;
    private boolean trace_time = false;
    private boolean trace_method = false;
    private boolean trace_package = false;
    private boolean trace_thread = false;
    private long trace_size;
    private FileOutputStream trace_fo = null;
    private OutputStreamWriter trace_ow = null;
    private BufferedWriter trace_bw = null;
    private PrintWriter trace_pw = null;

    public DebugTraceImpl(String string, int n, String string2, int n2, int n3, int n4) {
        this.trace_level = n;
        this.trace_file = string;
        if (string2 != null) {
            this.trace_method = string2.indexOf(109) >= 0 | string2.indexOf(77) >= 0;
            this.trace_package = string2.indexOf(77) >= 0;
            this.trace_time = string2.indexOf(116) >= 0;
            this.trace_thread = string2.indexOf(112) >= 0;
        }
        this.trace_maxsize = n2 * 0x100000;
        this.trace_maxfiles = n3;
        this.trace_stacksize = n4;
    }

    public synchronized void enableTrace(int n) {
        this.trace_level = n;
        if (this.trace_level > 0) {
            this.openTrace();
        } else {
            this.closeTrace();
        }
    }

    public synchronized void disableTrace() {
        this.closeTrace();
        this.trace_level = 0;
    }

    public int getLevel() {
        return this.trace_level;
    }

    public void trace(int n, String string, String string2, String string3, Throwable throwable) {
        if (this.trace_level >= n) {
            this.writeTrace(string, string2, string3);
            if (throwable != null) {
                this.writeStackTrace(throwable);
            }
        }
    }

    public synchronized void openTrace() {
        if (this.trace_pw != null) {
            return;
        }
        File file = new File(this.trace_file);
        if (file.exists()) {
            this.trace_size = file.length();
        } else {
            try {
                file.createNewFile();
            }
            catch (Exception exception) {
                this.trace_level = 0;
            }
            this.trace_size = 0L;
        }
        if (this.trace_level > 0) {
            try {
                this.trace_fo = new FileOutputStream(this.trace_file, true);
                this.trace_ow = new OutputStreamWriter((OutputStream)this.trace_fo, "UTF-8");
                this.trace_bw = new BufferedWriter(this.trace_ow);
                this.trace_pw = new PrintWriter((Writer)this.trace_bw, true);
            }
            catch (Exception exception) {
                this.trace_level = 0;
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, d MMM yyyy, HH:mm:ss");
            this.writeTrace(TRACE_HEADER + simpleDateFormat.format(new Date()));
        }
    }

    public synchronized void closeTrace() {
        if (this.trace_pw != null) {
            try {
                this.trace_pw.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.trace_pw = null;
        }
        if (this.trace_bw != null) {
            try {
                this.trace_bw.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.trace_bw = null;
        }
        if (this.trace_ow != null) {
            try {
                this.trace_ow.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.trace_ow = null;
        }
        if (this.trace_fo != null) {
            try {
                this.trace_fo.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.trace_fo = null;
        }
    }

    private void writeStackTrace(Throwable throwable) {
        String string = throwable.getClass().getName();
        String string2 = "Exception " + string + ":  " + throwable.getMessage();
        this.writeTrace(string2);
        Throwable throwable2 = throwable.getCause();
        if (throwable2 != null) {
            string2 = "---Root cause: " + throwable2.getMessage();
            this.writeTrace(string2);
        }
        if (this.trace_stacksize < 1) {
            return;
        }
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        int n = stackTraceElementArray.length;
        if (n > this.trace_stacksize) {
            n = this.trace_stacksize;
        }
        for (int i = 0; i < n; ++i) {
            this.writeTrace("    " + stackTraceElementArray[i].toString());
        }
    }

    private void writeTrace(String string, String string2, String string3) {
        Object object;
        String string4 = "";
        if (this.trace_time) {
            object = new SimpleDateFormat("HH:mm:ss");
            string4 = ((DateFormat)object).format(new Date()) + " | ";
        }
        if (this.trace_thread) {
            object = Thread.currentThread();
            string4 = string4 + ((Thread)object).getName() + " | ";
        }
        if (this.trace_method && string2 != null) {
            int n;
            if (!this.trace_package && (n = string2.lastIndexOf(46)) > 0 && n < string2.length() - 1) {
                string2 = string2.substring(n + 1);
            }
            String string5 = string2;
            if (string3 != null) {
                string5 = string5 + ":" + string3;
            }
            string4 = string4 + string5 + " | ";
        }
        if (string == null) {
            string = "null message";
        }
        string4 = string4 + string;
        this.writeTrace(string4);
    }

    private synchronized void writeTrace(String string) {
        if (string == null) {
            return;
        }
        this.trace_size += (long)(string.length() + 1);
        if (this.trace_size > this.trace_maxsize) {
            this.closeTrace();
            this.rollTrace();
            this.openTrace();
            this.trace_size = string.length() + 1;
        }
        try {
            this.trace_pw.println(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void rollTrace() {
        File[] fileArray = new File[this.trace_maxfiles + 1];
        fileArray[0] = new File(this.trace_file);
        for (int i = 1; i < this.trace_maxfiles + 1; ++i) {
            fileArray[i] = new File(this.trace_file + "_" + i);
        }
        try {
            if (fileArray[this.trace_maxfiles + 1].exists()) {
                fileArray[this.trace_maxfiles + 1].delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.trace_maxfiles > 1) {
            for (int i = this.trace_maxfiles; i >= 0; --i) {
                try {
                    if (!fileArray[i].exists()) continue;
                    fileArray[i].renameTo(fileArray[i + 1]);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

