/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.usermgr.users;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.usermgr.common.AdminCommonTools;
import com.sun.wbem.solarisprovider.usermgr.common.AdminSecurityUtil;
import com.sun.wbem.solarisprovider.usermgr.common.SolAccountAttr;
import com.sun.wbem.solarisprovider.usermgr.users.FlatUserObj;
import com.sun.wbem.solarisprovider.usermgr.users.UMgrNative;
import com.sun.wbem.utility.directorytable.DirectoryRow;
import com.sun.wbem.utility.directorytable.DirectoryTable;
import com.sun.wbem.utility.directorytable.DirectoryTableAccessException;
import com.sun.wbem.utility.directorytable.DirectoryTableConnectionException;
import com.sun.wbem.utility.directorytable.DirectoryTableDoesNotExistException;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableFactory;
import com.sun.wbem.utility.directorytable.DirectoryTableInvalidParameterException;
import com.sun.wbem.utility.directorytable.SearchTemplate;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;

public class SolarisShadowTable {
    private static String tableName = "shadow";
    private String emptyString = new String("");
    private String fileType = new String("File");
    private long secondsInaDay = 86400L;
    private String GMT_TIMEZONE = "GMT";
    private String nullPassword = "";
    private String accountLockedValue = UMgrNative.getLockString();
    private String nameCol = "name";
    private String passwdCol = "passwd";
    private String lastchngCol = "lastchg";
    private String minCol = "min";
    private String maxCol = "max";
    private String warnCol = "warn";
    private String inactiveCol = "inactive";
    private String exCol = "expire";
    private String flagCol = "flag";
    private int nameColNum = 0;
    private int passwdColNum = 0;
    private int lastchngColNum = 0;
    private int minColNum = 0;
    private int maxColNum = 0;
    private int warnColNum = 0;
    private int inactiveColNum = 0;
    private int exColNum = 0;
    private int flagColNum = 0;
    private String scope;

    public SolarisShadowTable(String scope) throws Exception {
        this.scope = scope;
    }

    private String setUpExpirationDate(String inputDate) {
        Date date;
        String returnDate = "";
        if (inputDate == null || inputDate.equals("")) {
            return returnDate;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(SolAccountAttr.DATE_FORMAT);
        sdf.setTimeZone(TimeZone.getTimeZone(this.GMT_TIMEZONE));
        sdf.setLenient(false);
        try {
            date = sdf.parse(inputDate);
        }
        catch (Exception e) {
            return returnDate;
        }
        long nsecs = date.getTime();
        nsecs /= 1000L;
        returnDate = String.valueOf(nsecs /= this.secondsInaDay);
        return returnDate;
    }

    private String getExpirationDate(String inputDate) {
        String returnDate = "";
        long tmp = Long.parseLong(inputDate);
        long numSecs = tmp * this.secondsInaDay + 1L;
        Date tmpDate = new Date(numSecs *= 1000L);
        SimpleDateFormat sdf = new SimpleDateFormat(SolAccountAttr.DATE_FORMAT);
        sdf.setTimeZone(TimeZone.getTimeZone(this.GMT_TIMEZONE));
        sdf.setLenient(false);
        String myDate = sdf.format(tmpDate);
        return myDate;
    }

    private boolean isCredProcessingNecessary() {
        String manageCred = "on";
        return true;
    }

    private void modifyCredUserName(String newName, String oldName, ProviderUtility provUtil) throws DirectoryTableException {
        Vector lsOutput;
        String myNewPrincipal;
        String myScopeType = provUtil.getScopeType(this.scope);
        if (!myScopeType.equals("nisplus")) {
            return;
        }
        if (!this.isCredProcessingNecessary()) {
            return;
        }
        String myDomain = provUtil.getScopeDomainName(this.scope);
        String myOldPrincipal = new String(oldName + "." + myDomain);
        if (!myOldPrincipal.endsWith(".")) {
            myOldPrincipal = myOldPrincipal.concat(".");
        }
        if (!(myNewPrincipal = new String(newName + "." + myDomain)).endsWith(".")) {
            myNewPrincipal = myNewPrincipal.concat(".");
        }
        String cmd = new String("/usr/bin/nistbladm -E cname=" + myNewPrincipal + " [cname=" + myOldPrincipal + ",auth_type=LOCAL],cred.org_dir");
        try {
            lsOutput = AdminCommonTools.CMN_exec(cmd, true);
        }
        catch (Exception ex) {
            throw new DirectoryTableException("change principal in cred table failed", ex);
        }
        cmd = new String("/usr/bin/nistbladm -E cname=" + myNewPrincipal + " [cname=" + myOldPrincipal + ",auth_type=DES],cred.org_dir");
        try {
            lsOutput = AdminCommonTools.CMN_exec(cmd, true);
        }
        catch (Exception ex) {
            throw new DirectoryTableException("nistbladm to change principal name in cred table failed", ex);
        }
    }

    private void removeCredTableEntry(FlatUserObj fUserObj, ProviderUtility provUtil) throws DirectoryTableException {
        String myScopeType = provUtil.getScopeType(this.scope);
        if (!myScopeType.equals("nisplus")) {
            return;
        }
        if (!this.isCredProcessingNecessary()) {
            return;
        }
        String myDomain = provUtil.getScopeDomainName(this.scope);
        String myName = fUserObj.getUserName();
        if (myName == null || myName.trim().length() == 0) {
            return;
        }
        String myPrincipal = new String(myName + "." + myDomain);
        if (!myPrincipal.endsWith(".")) {
            myPrincipal = myPrincipal.concat(".");
        }
        String cmd = new String("nisaddcred -r " + myPrincipal);
        try {
            Vector lsOutput = AdminCommonTools.CMN_exec(cmd, true);
        }
        catch (Exception ex) {
            throw new DirectoryTableException("nisaddcred failed to remove credentials", ex);
        }
    }

    private void setupCredTableEntry(FlatUserObj fUserObj, ProviderUtility provUtil) throws DirectoryTableException, Exception {
        String myScopeType = provUtil.getScopeType(this.scope);
        if (!myScopeType.equals("nisplus")) {
            return;
        }
        if (!this.isCredProcessingNecessary()) {
            return;
        }
        String unEncryptedPassword = null;
        if (fUserObj.getCurPassword() != null && fUserObj.getCurPassword().trim().length() != 0) {
            unEncryptedPassword = provUtil.decryptPassword(fUserObj.getCurPassword());
        }
        if (unEncryptedPassword == null || unEncryptedPassword.trim().length() == 0) {
            throw new Exception("Password is null. Unable to setup credentials");
        }
        String myDomain = provUtil.getScopeDomainName(this.scope);
        String myUid = fUserObj.getUserUID();
        if (myUid == null || myUid.trim().length() == 0) {
            return;
        }
        String myName = fUserObj.getUserName();
        if (myName == null || myName.trim().length() == 0) {
            return;
        }
        String myPrincipal = new String(myName + "." + myDomain);
        if (!myPrincipal.endsWith(".")) {
            myPrincipal = myPrincipal.concat(".");
        }
        String cmd = new String("nisaddcred -p " + myUid + " -P " + myPrincipal + " local");
        try {
            Vector lsOutput = AdminCommonTools.CMN_exec(cmd, true);
        }
        catch (Exception ex) {
            throw new DirectoryTableException("nisaddcred failed to add LOCAL credentials", ex);
        }
        String myNetname = new String("unix." + myUid + "@" + myDomain);
        cmd = new String("nisaddcred -p " + myNetname + " -P " + myPrincipal + " -l " + unEncryptedPassword + " des");
        unEncryptedPassword = "";
        try {
            Vector lsOutput = AdminCommonTools.CMN_exec(cmd, true);
        }
        catch (Exception ex) {
            throw new DirectoryTableException("nisaddcred failed to add DES credentials", ex);
        }
        finally {
            cmd = "";
        }
        cmd = "";
        unEncryptedPassword = "";
    }

    private DirectoryTable openShadowTable() throws DirectoryTableException {
        try {
            DirectoryTable dirTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
            dirTable.open(tableName);
            TableDefinitions tabledefs = dirTable.getCurrentTableDefinitions();
            this.nameColNum = tabledefs.getColumnNumber(this.nameCol);
            this.passwdColNum = tabledefs.getColumnNumber(this.passwdCol);
            this.lastchngColNum = tabledefs.getColumnNumber(this.lastchngCol);
            this.minColNum = tabledefs.getColumnNumber(this.minCol);
            this.maxColNum = tabledefs.getColumnNumber(this.maxCol);
            this.warnColNum = tabledefs.getColumnNumber(this.warnCol);
            this.inactiveColNum = tabledefs.getColumnNumber(this.inactiveCol);
            this.exColNum = tabledefs.getColumnNumber(this.exCol);
            this.flagColNum = tabledefs.getColumnNumber(this.flagCol);
            return dirTable;
        }
        catch (DirectoryTableInvalidParameterException ex) {
            throw ex;
        }
        catch (DirectoryTableDoesNotExistException ex) {
            throw ex;
        }
        catch (DirectoryTableConnectionException ex) {
            throw ex;
        }
        catch (DirectoryTableException ex) {
            throw ex;
        }
    }

    private void closeShadowTable(DirectoryTable dirTable) {
        dirTable.close();
        this.nameColNum = 0;
        this.passwdColNum = 0;
        this.lastchngColNum = 0;
        this.minColNum = 0;
        this.maxColNum = 0;
        this.warnColNum = 0;
        this.inactiveColNum = 0;
        this.exColNum = 0;
        this.flagColNum = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteShadowRow(FlatUserObj fUserObj, ProviderUtility provUtil) throws DirectoryTableException {
        DirectoryTable etcTable = null;
        etcTable = this.openShadowTable();
        try {
            DirectoryRow ShadowEntry = etcTable.getRowInstance();
            ShadowEntry.putColumn(this.nameColNum, fUserObj.getUserName());
            ShadowEntry = etcTable.getFirstRow((SearchTemplate)ShadowEntry);
            if (ShadowEntry == null) {
                this.removeCredTableEntry(fUserObj, provUtil);
                return;
            }
            this.removeCredTableEntry(fUserObj, provUtil);
            etcTable.deleteRow(ShadowEntry);
        }
        catch (DirectoryTableInvalidParameterException ex) {
            throw ex;
        }
        catch (DirectoryTableAccessException ex) {
            throw ex;
        }
        catch (DirectoryTableConnectionException ex) {
            throw ex;
        }
        catch (DirectoryTableException ex) {
            throw ex;
        }
        catch (Exception ex) {
        }
        finally {
            if (etcTable != null) {
                this.closeShadowTable(etcTable);
            }
        }
    }

    public void addShadowRow(FlatUserObj fUserObj, ProviderUtility provUtil) throws Exception {
        block24: {
            String writePassword = this.nullPassword;
            String unEncryptedPassword = this.nullPassword;
            if (fUserObj.getCurPassword() != null && fUserObj.getCurPassword().trim().length() != 0) {
                unEncryptedPassword = provUtil.decryptPassword(fUserObj.getCurPassword());
                writePassword = AdminSecurityUtil.createUnixPassword(unEncryptedPassword);
                unEncryptedPassword = "";
            }
            DirectoryTable etcTable = null;
            etcTable = this.openShadowTable();
            try {
                DirectoryRow shadowEntry = etcTable.getRowInstance();
                if (fUserObj.getUserName() != null) {
                    shadowEntry.putColumn(this.nameColNum, fUserObj.getUserName());
                }
                if (writePassword != null) {
                    shadowEntry.putColumn(this.passwdColNum, writePassword);
                    String lastChangedValue = this.computeLastChangeCol();
                    shadowEntry.putColumn(this.lastchngColNum, lastChangedValue);
                }
                if (fUserObj.getIsAccountLocked() || writePassword == null || writePassword.trim().length() == 0) {
                    writePassword = this.accountLockedValue;
                    shadowEntry.putColumn(this.passwdColNum, writePassword);
                }
                if (fUserObj.getMustChangePasswdInDays() != null) {
                    shadowEntry.putColumn(this.minColNum, fUserObj.getMustChangePasswdInDays());
                }
                if (fUserObj.getDoNotReUsePwdForDays() != null) {
                    shadowEntry.putColumn(this.maxColNum, fUserObj.getDoNotReUsePwdForDays());
                }
                if (fUserObj.getWarnBeforePwdExpiresDays() != null) {
                    shadowEntry.putColumn(this.warnColNum, fUserObj.getWarnBeforePwdExpiresDays());
                }
                if (fUserObj.getPwdInactiveDays() != null) {
                    shadowEntry.putColumn(this.inactiveColNum, fUserObj.getPwdInactiveDays());
                }
                String expirationDate = "";
                if (fUserObj.getAccountExpireDate() != null) {
                    expirationDate = this.setUpExpirationDate(fUserObj.getAccountExpireDate());
                }
                if (expirationDate != null) {
                    shadowEntry.putColumn(this.exColNum, expirationDate);
                }
                etcTable.addRow(shadowEntry);
                String myScopeType = provUtil.getScopeType(this.scope);
                if (!myScopeType.equals("nisplus")) break block24;
                this.setupCredTableEntry(fUserObj, provUtil);
                fUserObj.setCurPassword("");
            }
            catch (DirectoryTableInvalidParameterException ex) {
                ex.printStackTrace();
                throw ex;
            }
            catch (DirectoryTableAccessException ex) {
                ex.printStackTrace();
                throw ex;
            }
            catch (DirectoryTableConnectionException ex) {
                ex.printStackTrace();
                throw ex;
            }
            catch (DirectoryTableException ex) {
                ex.printStackTrace();
                throw ex;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
            finally {
                if (etcTable != null) {
                    this.closeShadowTable(etcTable);
                }
            }
        }
    }

    public FlatUserObj getShadowRow(FlatUserObj fUserObj) throws Exception {
        DirectoryTable etcTable = null;
        etcTable = this.openShadowTable();
        fUserObj.setChangePasswd(false);
        fUserObj.setCurPassword(null);
        fUserObj.setAccountExpireDate(null);
        String usrName = fUserObj.getUserName();
        try {
            DirectoryRow shadowEntry = etcTable.getRowInstance();
            shadowEntry.putColumn(this.nameColNum, usrName);
            shadowEntry = etcTable.getFirstRow((SearchTemplate)shadowEntry);
            if (shadowEntry == null) {
                // empty if block
            }
            fUserObj.setMustChangePasswdInDays(shadowEntry.getColumn(this.minColNum));
            fUserObj.setDoNotReUsePwdForDays(shadowEntry.getColumn(this.maxColNum));
            fUserObj.setWarnBeforePwdExpiresDays(shadowEntry.getColumn(this.warnColNum));
            fUserObj.setPwdInactiveDays(shadowEntry.getColumn(this.inactiveColNum));
            String pswd = shadowEntry.getColumn(this.passwdColNum);
            if (pswd.regionMatches(0, this.accountLockedValue, 0, this.accountLockedValue.length())) {
                fUserObj.setIsAccountLocked(true);
            } else {
                fUserObj.setIsAccountLocked(false);
            }
            String exprVal = shadowEntry.getColumn(this.exColNum);
            if (exprVal != null && !exprVal.equals("")) {
                fUserObj.setAccountExpireDate(this.getExpirationDate(exprVal));
            } else {
                fUserObj.setAccountExpireDate("");
            }
            if (pswd.length() != 0) {
                fUserObj.setHasPasswd(true);
            } else {
                fUserObj.setHasPasswd(false);
            }
            fUserObj.setChangePasswd(false);
            fUserObj.setCurPassword(null);
        }
        catch (DirectoryTableInvalidParameterException ex) {
            throw ex;
        }
        catch (DirectoryTableAccessException ex) {
            throw ex;
        }
        catch (DirectoryTableConnectionException ex) {
            throw ex;
        }
        catch (DirectoryTableException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (etcTable != null) {
                this.closeShadowTable(etcTable);
            }
        }
        return fUserObj;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void modifyShadowRow(FlatUserObj fUserObj, ProviderUtility provUtil) throws Exception {
        String writePassword;
        DirectoryRow newEntry;
        DirectoryRow shadowEntry;
        String unEncryptedPassword;
        DirectoryTable etcTable;
        block30: {
            etcTable = null;
            etcTable = this.openShadowTable();
            unEncryptedPassword = "";
            try {
                shadowEntry = etcTable.getRowInstance();
                shadowEntry.putColumn(this.nameColNum, fUserObj.getUserName());
                shadowEntry = etcTable.getFirstRow((SearchTemplate)shadowEntry);
                if (shadowEntry == null) {
                    this.addShadowRow(fUserObj, provUtil);
                    return;
                }
                newEntry = shadowEntry.extractRows(1, 1);
            }
            catch (DirectoryTableInvalidParameterException ex) {
                throw ex;
            }
            catch (DirectoryTableAccessException ex) {
                throw ex;
            }
            catch (DirectoryTableConnectionException ex) {
                throw ex;
            }
            catch (DirectoryTableException e) {
                throw e;
            }
            catch (Exception ex) {
                throw ex;
            }
            newEntry.putColumn(this.nameColNum, fUserObj.getUserName());
            writePassword = shadowEntry.getColumn(this.passwdColNum);
            if (!fUserObj.getChangePasswd()) break block30;
            writePassword = this.nullPassword;
            fUserObj.setIsAccountLocked(false);
            try {
                if (fUserObj.getCurPassword() != null && fUserObj.getCurPassword().trim().length() != 0) {
                    unEncryptedPassword = provUtil.decryptPassword(fUserObj.getCurPassword());
                    writePassword = AdminSecurityUtil.createUnixPassword(unEncryptedPassword);
                }
            }
            catch (Exception ex) {
                System.out.println("Shadow Entry " + fUserObj.getUserName() + " could not decrypt password");
                throw ex;
            }
        }
        String expirationDate = this.setUpExpirationDate(fUserObj.getAccountExpireDate());
        if (fUserObj.getIsAccountLocked()) {
            if (!writePassword.regionMatches(0, this.accountLockedValue, 0, this.accountLockedValue.length())) {
                writePassword = this.accountLockedValue + writePassword;
            }
        } else if (writePassword.regionMatches(0, this.accountLockedValue, 0, this.accountLockedValue.length())) {
            writePassword = writePassword.substring(this.accountLockedValue.length());
        }
        newEntry.putColumn(this.passwdColNum, writePassword);
        String lastChangedValue = "";
        lastChangedValue = !writePassword.equals(shadowEntry.getColumn(this.passwdColNum)) ? (writePassword.trim().length() != 0 ? this.computeLastChangeCol() : "0") : shadowEntry.getColumn(this.lastchngColNum);
        newEntry.putColumn(this.lastchngColNum, lastChangedValue);
        if (fUserObj.getMustChangePasswdInDays() != null) {
            newEntry.putColumn(this.minColNum, fUserObj.getMustChangePasswdInDays());
        }
        if (fUserObj.getDoNotReUsePwdForDays() != null) {
            newEntry.putColumn(this.maxColNum, fUserObj.getDoNotReUsePwdForDays());
        }
        if (fUserObj.getWarnBeforePwdExpiresDays() != null) {
            newEntry.putColumn(this.warnColNum, fUserObj.getWarnBeforePwdExpiresDays());
        }
        if (fUserObj.getPwdInactiveDays() != null) {
            newEntry.putColumn(this.inactiveColNum, fUserObj.getPwdInactiveDays());
        }
        if (expirationDate != null) {
            newEntry.putColumn(this.exColNum, expirationDate);
        }
        etcTable.modifyRow(shadowEntry, newEntry);
        if (unEncryptedPassword.trim().length() == 0) return;
        this.setupCredTableEntry(fUserObj, provUtil);
        return;
        finally {
            if (etcTable != null) {
                this.closeShadowTable(etcTable);
            }
            unEncryptedPassword = "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyShadowUsername(String newName, String oldName, ProviderUtility provUtil) throws DirectoryTableException {
        if (oldName == null || oldName.trim().length() == 0) {
            return;
        }
        DirectoryTable etcTable = null;
        etcTable = this.openShadowTable();
        try {
            DirectoryRow shadowEntry = etcTable.getRowInstance();
            shadowEntry.putColumn(this.nameColNum, oldName);
            shadowEntry = etcTable.getFirstRow((SearchTemplate)shadowEntry);
            if (shadowEntry == null) {
                try {
                    this.modifyCredUserName(newName, oldName, provUtil);
                }
                catch (Exception e) {
                    // empty catch block
                }
                return;
            }
            DirectoryRow searchEntry = etcTable.getRowInstance();
            searchEntry.putColumn(this.nameColNum, oldName);
            shadowEntry.putColumn(this.nameColNum, newName);
            etcTable.modifyRow(searchEntry, shadowEntry);
            this.modifyCredUserName(newName, oldName, provUtil);
        }
        catch (DirectoryTableInvalidParameterException ex) {
            throw ex;
        }
        catch (DirectoryTableAccessException ex) {
            throw ex;
        }
        catch (DirectoryTableConnectionException ex) {
            throw ex;
        }
        catch (DirectoryTableException e) {
            throw e;
        }
        catch (Exception ex) {
        }
        finally {
            if (etcTable != null) {
                this.closeShadowTable(etcTable);
            }
        }
    }

    private String computeLastChangeCol() {
        long timeInMills = System.currentTimeMillis();
        timeInMills /= 1000L;
        String returnDate = String.valueOf(timeInMills /= this.secondsInaDay);
        return returnDate;
    }
}

