/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.usermgr.users;

import com.sun.wbem.solarisprovider.usermgr.common.AdminCommonTools;
import com.sun.wbem.solarisprovider.usermgr.users.FlatUserObj;
import com.sun.wbem.utility.directorytable.DirectoryRow;
import com.sun.wbem.utility.directorytable.DirectoryTable;
import com.sun.wbem.utility.directorytable.DirectoryTableAccessException;
import com.sun.wbem.utility.directorytable.DirectoryTableConnectionException;
import com.sun.wbem.utility.directorytable.DirectoryTableDoesNotExistException;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableFactory;
import com.sun.wbem.utility.directorytable.DirectoryTableInvalidParameterException;
import com.sun.wbem.utility.directorytable.DirectoryTableRowNotUniqueException;
import com.sun.wbem.utility.directorytable.SearchTemplate;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import java.util.StringTokenizer;

public class SolarisAutoHomeTable {
    private String table = new String("auto_home");
    private String emptyString = new String("");
    private String fileType = new String("File");
    private String keyCol = "key";
    private String valueCol = "value";
    private int keyColNum = 0;
    private int valueColNum = 0;
    private String pathDelimiter = ":";
    private String autohomeSeparator = " \t";
    private String scope;

    public SolarisAutoHomeTable(String scope) {
        this.scope = scope;
    }

    private DirectoryTable openAutoHomeTable() throws DirectoryTableException {
        DirectoryTable autohomeTable = null;
        try {
            autohomeTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
        }
        catch (DirectoryTableInvalidParameterException ex) {
            throw ex;
        }
        catch (DirectoryTableConnectionException ex) {
            throw ex;
        }
        try {
            autohomeTable.open(this.table);
            TableDefinitions tabledefs = autohomeTable.getCurrentTableDefinitions();
            this.keyColNum = tabledefs.getColumnNumber(this.keyCol);
            this.valueColNum = tabledefs.getColumnNumber(this.valueCol);
            return autohomeTable;
        }
        catch (DirectoryTableDoesNotExistException ex) {
            autohomeTable.create(this.table);
            return autohomeTable;
        }
        catch (DirectoryTableInvalidParameterException ex) {
            throw ex;
        }
        catch (DirectoryTableConnectionException ex) {
            throw ex;
        }
    }

    private void closeAutoHomeTable(DirectoryTable dirTable) {
        dirTable.close();
        this.keyColNum = 0;
        this.valueColNum = 0;
    }

    public FlatUserObj getAutoHomeRow(FlatUserObj fUserObj) throws DirectoryTableException {
        AdminCommonTools.CMN_Trace3("in getAutoHomeRow");
        DirectoryTable etcTable = null;
        etcTable = this.openAutoHomeTable();
        try {
            DirectoryRow ahEntry = etcTable.getRowInstance();
            ahEntry.putColumn(this.keyColNum, fUserObj.getUserName());
            ahEntry = etcTable.getFirstRow((SearchTemplate)ahEntry);
            if (ahEntry == null) {
                // empty if block
            }
            String pathname = ahEntry.getColumn(this.valueColNum);
            StringTokenizer st = new StringTokenizer(pathname, this.autohomeSeparator);
            int numTokens = st.countTokens();
            for (int i = 0; i < numTokens; ++i) {
                pathname = st.nextToken();
            }
            st = new StringTokenizer(pathname, this.pathDelimiter);
            fUserObj.setHomeDirServer(st.nextToken());
            fUserObj.setHomeDirPathName(st.nextToken());
            fUserObj.setAutoMountHomeDir(true);
        }
        catch (DirectoryTableInvalidParameterException ex) {
            throw ex;
        }
        catch (DirectoryTableAccessException ex) {
            throw ex;
        }
        catch (DirectoryTableConnectionException ex) {
            throw ex;
        }
        catch (DirectoryTableException e) {
            throw e;
        }
        finally {
            if (etcTable != null) {
                this.closeAutoHomeTable(etcTable);
            }
        }
        return fUserObj;
    }

    public void addAutoHomeRow(FlatUserObj fUserObj) throws DirectoryTableException {
        AdminCommonTools.CMN_Trace3("in addAutoHomeRow");
        DirectoryTable etcTable = null;
        etcTable = this.openAutoHomeTable();
        String val = null;
        if (fUserObj.getHomeDirServer() != null) {
            val = fUserObj.getHomeDirServer();
            val = val.concat(this.pathDelimiter);
            val = val.concat(fUserObj.getHomeDirPathName());
        }
        try {
            DirectoryRow ahEntry = etcTable.getRowInstance();
            if (fUserObj.getUserName() != null) {
                ahEntry.putColumn(this.keyColNum, fUserObj.getUserName());
            }
            if (val != null) {
                ahEntry.putColumn(this.valueColNum, val);
            }
            etcTable.addRow(ahEntry);
        }
        catch (DirectoryTableRowNotUniqueException ex) {
            try {
                DirectoryRow ahEntry = etcTable.getRowInstance();
                if (fUserObj.getUserName() != null) {
                    ahEntry.putColumn(this.keyColNum, fUserObj.getUserName());
                }
                etcTable.deleteRow(ahEntry);
                if (fUserObj.getUserName() != null) {
                    ahEntry.putColumn(this.keyColNum, fUserObj.getUserName());
                }
                if (val != null) {
                    ahEntry.putColumn(this.valueColNum, val);
                }
                etcTable.addRow(ahEntry);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        catch (DirectoryTableInvalidParameterException ex) {
            throw ex;
        }
        catch (DirectoryTableAccessException ex) {
            throw ex;
        }
        catch (DirectoryTableConnectionException ex) {
            throw ex;
        }
        catch (DirectoryTableException e) {
            throw e;
        }
        finally {
            if (etcTable != null) {
                this.closeAutoHomeTable(etcTable);
            }
        }
    }

    public void modifyAutoHomeRow(FlatUserObj newUsr, FlatUserObj oldUsr) throws DirectoryTableException {
        AdminCommonTools.CMN_Trace3("in modifyAutoHomeRow");
        DirectoryTable etcTable = null;
        etcTable = this.openAutoHomeTable();
        try {
            DirectoryRow ahEntry = etcTable.getRowInstance();
            String name = newUsr.getUserName();
            if (!name.equals(oldUsr.getUserName())) {
                name = oldUsr.getUserName();
            }
            ahEntry.putColumn(this.keyColNum, name);
            ahEntry = etcTable.getFirstRow((SearchTemplate)ahEntry);
            if (ahEntry == null) {
                // empty if block
            }
            DirectoryRow newEntry = etcTable.getRowInstance();
            String pathname = newUsr.getHomeDirServer();
            pathname = pathname.concat(this.pathDelimiter);
            pathname = pathname.concat(newUsr.getHomeDirPathName());
            newEntry.putColumn(this.keyColNum, newUsr.getUserName());
            String oldValue = ahEntry.getColumn(this.valueColNum);
            StringTokenizer st = new StringTokenizer(oldValue, this.autohomeSeparator);
            int numTokens = st.countTokens();
            String writeValue = "";
            if (numTokens > 1) {
                for (int i = 0; i < numTokens - 1; ++i) {
                    writeValue = writeValue.concat(st.nextToken());
                    writeValue = writeValue.concat(" ");
                }
            }
            writeValue = writeValue.concat(pathname);
            newEntry.putColumn(this.valueColNum, writeValue);
            etcTable.modifyRow(ahEntry, newEntry);
        }
        catch (DirectoryTableInvalidParameterException ex) {
            throw ex;
        }
        catch (DirectoryTableAccessException ex) {
            throw ex;
        }
        catch (DirectoryTableConnectionException ex) {
            throw ex;
        }
        catch (DirectoryTableException e) {
            throw e;
        }
        finally {
            if (etcTable != null) {
                this.closeAutoHomeTable(etcTable);
            }
        }
    }

    public void deleteAutoHomeRow(FlatUserObj fUserObj) throws DirectoryTableException {
        AdminCommonTools.CMN_Trace3("in deleteAutoHomeRow");
        DirectoryTable etcTable = null;
        etcTable = this.openAutoHomeTable();
        try {
            DirectoryRow ahEntry = etcTable.getRowInstance();
            ahEntry.putColumn(this.keyColNum, fUserObj.getUserName());
            ahEntry = etcTable.getFirstRow((SearchTemplate)ahEntry);
            if (ahEntry == null) {
                return;
            }
            etcTable.deleteRow(ahEntry);
        }
        catch (DirectoryTableInvalidParameterException ex) {
            throw ex;
        }
        catch (DirectoryTableAccessException ex) {
            throw ex;
        }
        catch (DirectoryTableConnectionException ex) {
            throw ex;
        }
        catch (DirectoryTableException e) {
            throw e;
        }
        finally {
            if (etcTable != null) {
                this.closeAutoHomeTable(etcTable);
            }
        }
    }
}

