/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.usermgr.execs;

import com.sun.wbem.solarisprovider.usermgr.common.KeyValue;
import com.sun.wbem.solarisprovider.usermgr.common.SolServerException;
import com.sun.wbem.solarisprovider.usermgr.execs.ExecAttrObj;
import com.sun.wbem.solarisprovider.usermgr.execs.ExecAttrTable;
import com.sun.wbem.utility.directorytable.DirectoryRow;
import com.sun.wbem.utility.directorytable.DirectoryTable;
import com.sun.wbem.utility.directorytable.DirectoryTableDoesNotExistException;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableFactory;
import com.sun.wbem.utility.directorytable.SearchTemplate;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class SolarisExecAttrTable
implements ExecAttrTable {
    private static final String table = new String("exec_attr");
    private static final String emptyString = new String("");
    private static final String nameCol = "name";
    private static final String policyCol = "policy";
    private static final String typeCol = "type";
    private static final String res1Col = "res1";
    private static final String res2Col = "res2";
    private static final String idCol = "id";
    private static final String attrCol = "attr";
    private int nameColNum = 0;
    private int policyColNum = 0;
    private int typeColNum = 0;
    private int res1ColNum = 0;
    private int res2ColNum = 0;
    private int idColNum = 0;
    private int attrColNum = 0;
    private String scope;

    public SolarisExecAttrTable(String scopeUrl) {
        this.scope = scopeUrl;
        ExecAttrObj attrObj = new ExecAttrObj();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList readExecAttr(String profName, String type, String id) throws DirectoryTableException {
        ArrayList<ExecAttrObj> alist = new ArrayList<ExecAttrObj>();
        ExecAttrObj attrObj = null;
        DirectoryTable etcTable = this.openExecAttrTable();
        try {
            DirectoryRow execAttrRow = etcTable.getRowInstance();
            DirectoryRow tempAttrRow = null;
            execAttrRow.putColumn(this.nameColNum, profName);
            execAttrRow.putColumn(this.idColNum, id);
            tempAttrRow = etcTable.getFirstRow((SearchTemplate)execAttrRow);
            while (tempAttrRow != null) {
                attrObj = new ExecAttrObj(profName);
                attrObj.setPolicy(tempAttrRow.getColumn(this.policyColNum));
                attrObj.setType(tempAttrRow.getColumn(this.typeColNum));
                attrObj.setId(tempAttrRow.getColumn(this.idColNum));
                String attrList = tempAttrRow.getColumn(this.attrColNum);
                KeyValue.getAttributes(attrList, attrObj.attrSet);
                alist.add(attrObj);
                tempAttrRow = etcTable.getNextRow((SearchTemplate)execAttrRow);
            }
        }
        finally {
            this.closeExecAttrTable(etcTable);
        }
        return alist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ExecAttrObj[] readExecAttrs(String profName, String type, String policy) throws DirectoryTableException {
        ExecAttrObj attrObj = null;
        DirectoryTable etcTable = this.openExecAttrTable();
        Vector<ExecAttrObj> objs = new Vector<ExecAttrObj>();
        Vector<ExecAttrObj> compatObjs = new Vector<ExecAttrObj>();
        boolean useCompatObjs = false;
        try {
            DirectoryRow execAttrRow = etcTable.getRowInstance();
            DirectoryRow tempAttrRow = null;
            execAttrRow.putColumn(this.nameColNum, profName);
            tempAttrRow = etcTable.getFirstRow((SearchTemplate)execAttrRow);
            while (tempAttrRow != null) {
                block17: {
                    String ty;
                    block16: {
                        String pol;
                        block19: {
                            useCompatObjs = false;
                            attrObj = new ExecAttrObj(profName);
                            pol = tempAttrRow.getColumn(this.policyColNum);
                            ty = tempAttrRow.getColumn(this.typeColNum);
                            if (policy == null) break block19;
                            if (pol.equalsIgnoreCase(policy)) {
                                attrObj.setPolicy(policy);
                                break block16;
                            } else if (policy.equalsIgnoreCase("solaris") && pol.equalsIgnoreCase("suser")) {
                                useCompatObjs = true;
                                attrObj.setPolicy(policy);
                                break block16;
                            } else {
                                tempAttrRow = etcTable.getNextRow((SearchTemplate)execAttrRow);
                                continue;
                            }
                        }
                        attrObj.setPolicy(pol);
                    }
                    if (type != null) {
                        if (ty.equalsIgnoreCase(type)) {
                            attrObj.setType(type);
                            break block17;
                        } else {
                            tempAttrRow = etcTable.getNextRow((SearchTemplate)execAttrRow);
                            continue;
                        }
                    }
                    attrObj.setType(ty);
                }
                attrObj.setId(tempAttrRow.getColumn(this.idColNum));
                String attrList = tempAttrRow.getColumn(this.attrColNum);
                KeyValue.getAttributes(attrList, attrObj.attrSet);
                if (useCompatObjs) {
                    compatObjs.addElement(attrObj);
                } else {
                    objs.addElement(attrObj);
                }
                tempAttrRow = etcTable.getNextRow((SearchTemplate)execAttrRow);
            }
        }
        finally {
            this.closeExecAttrTable(etcTable);
        }
        Enumeration compatObjsEnum = compatObjs.elements();
        while (true) {
            if (!compatObjsEnum.hasMoreElements()) {
                ExecAttrObj[] attrList = new ExecAttrObj[objs.size()];
                return objs.toArray(attrList);
            }
            boolean matchFound = false;
            ExecAttrObj compatAttrObj = (ExecAttrObj)compatObjsEnum.nextElement();
            Enumeration objsEnum = objs.elements();
            while (objsEnum.hasMoreElements()) {
                attrObj = (ExecAttrObj)objsEnum.nextElement();
                if (!compatAttrObj.getId().equals(attrObj.getId())) continue;
                matchFound = true;
                break;
            }
            if (matchFound) continue;
            objs.addElement(compatAttrObj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecAttrObj readExecAttr(String profName, String type, String id, String policy) throws DirectoryTableException {
        ExecAttrObj attrObj = null;
        ExecAttrObj[] foundAttrObjs = new ExecAttrObj[2];
        DirectoryTable etcTable = this.openExecAttrTable();
        try {
            DirectoryRow execAttrRow = etcTable.getRowInstance();
            DirectoryRow tempAttrRow = null;
            execAttrRow.putColumn(this.nameColNum, profName);
            execAttrRow.putColumn(this.idColNum, id);
            tempAttrRow = etcTable.getFirstRow((SearchTemplate)execAttrRow);
            while (tempAttrRow != null) {
                attrObj = new ExecAttrObj(profName);
                String pol = tempAttrRow.getColumn(this.policyColNum);
                String ty = tempAttrRow.getColumn(this.typeColNum);
                if (ty.equalsIgnoreCase(type) && (pol.equalsIgnoreCase(policy) || pol.equalsIgnoreCase("suser"))) {
                    attrObj.setPolicy(policy);
                    attrObj.setType(type);
                    attrObj.setId(tempAttrRow.getColumn(this.idColNum));
                    String attrList = tempAttrRow.getColumn(this.attrColNum);
                    KeyValue.getAttributes(attrList, attrObj.attrSet);
                    if (pol.equals("suser")) {
                        foundAttrObjs[1] = attrObj;
                    } else {
                        foundAttrObjs[0] = attrObj;
                    }
                }
                tempAttrRow = etcTable.getNextRow((SearchTemplate)execAttrRow);
            }
        }
        finally {
            this.closeExecAttrTable(etcTable);
        }
        for (int index = 0; index < foundAttrObjs.length; ++index) {
            if (foundAttrObjs[index] == null) continue;
            return foundAttrObjs[index];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExecAttr(ExecAttrObj execAttr) throws DirectoryTableException {
        DirectoryTable etcTable = this.openExecAttrTable();
        try {
            DirectoryRow newAttrRow = etcTable.getRowInstance();
            newAttrRow.putColumn(this.nameColNum, execAttr.getProfName());
            newAttrRow.putColumn(this.idColNum, execAttr.getId());
            DirectoryRow oldAttrRow = etcTable.getFirstRow((SearchTemplate)newAttrRow);
            while (oldAttrRow != null) {
                String pol = oldAttrRow.getColumn(this.policyColNum);
                String ty = oldAttrRow.getColumn(this.typeColNum);
                if (pol.equalsIgnoreCase(execAttr.getPolicy()) && ty.equalsIgnoreCase(execAttr.getType())) break;
                oldAttrRow = etcTable.getNextRow((SearchTemplate)newAttrRow);
            }
            String attrList = oldAttrRow != null ? oldAttrRow.getColumn(this.attrColNum) : null;
            String attrs = KeyValue.putAttributes(attrList, execAttr.attrSet, false);
            newAttrRow.putColumn(this.policyColNum, execAttr.getPolicy());
            newAttrRow.putColumn(this.typeColNum, execAttr.getType());
            newAttrRow.putColumn(this.idColNum, execAttr.getId());
            newAttrRow.putColumn(this.attrColNum, attrs);
            if (oldAttrRow == null) {
                etcTable.addRow(newAttrRow);
            } else {
                etcTable.modifyRow(oldAttrRow, newAttrRow);
            }
        }
        finally {
            this.closeExecAttrTable(etcTable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExecAttr(String profName) throws DirectoryTableException {
        DirectoryTable etcTable = this.openExecAttrTable();
        try {
            DirectoryRow execAttrRow = etcTable.getRowInstance();
            execAttrRow.putColumn(this.nameColNum, profName);
            execAttrRow = etcTable.getFirstRow((SearchTemplate)execAttrRow);
            while (execAttrRow != null) {
                etcTable.deleteRow(execAttrRow);
                execAttrRow = etcTable.getRowInstance();
                execAttrRow.putColumn(this.nameColNum, profName);
                execAttrRow = etcTable.getFirstRow((SearchTemplate)execAttrRow);
            }
        }
        finally {
            this.closeExecAttrTable(etcTable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExecAttr(ExecAttrObj execAttr) throws DirectoryTableException, SolServerException {
        DirectoryTable etcTable = this.openExecAttrTable();
        String profName = execAttr.getProfName();
        String type = execAttr.getType();
        String id = execAttr.getId();
        String policy = execAttr.getPolicy();
        Vector<DirectoryRow> foundRows = new Vector<DirectoryRow>();
        try {
            DirectoryRow templateRow = etcTable.getRowInstance();
            templateRow.putColumn(this.nameColNum, profName);
            templateRow.putColumn(this.idColNum, id);
            DirectoryRow execAttrRow = etcTable.getFirstRow((SearchTemplate)templateRow);
            while (execAttrRow != null) {
                String del_policy = execAttrRow.getColumn(this.policyColNum);
                String del_type = execAttrRow.getColumn(this.typeColNum);
                if (del_type.equalsIgnoreCase(type) && (policy.equalsIgnoreCase("solaris") || del_policy.equalsIgnoreCase("suser"))) {
                    foundRows.add(execAttrRow);
                }
                execAttrRow = etcTable.getNextRow((SearchTemplate)templateRow);
            }
            if (foundRows.size() == 0) {
                throw new SolServerException("EXM_SUS77", (Object)profName, (Object)type, id);
            }
            int numFoundRows = foundRows.size();
            for (int index = 0; index < numFoundRows; ++index) {
                execAttrRow = (DirectoryRow)foundRows.get(index);
                etcTable.deleteRow(execAttrRow);
            }
        }
        finally {
            this.closeExecAttrTable(etcTable);
        }
    }

    public String getPolicy() throws DirectoryTableException {
        return "solaris";
    }

    public void createExecAttrTable() throws DirectoryTableException {
        DirectoryTable execAttrTable = null;
        boolean exists = true;
        try {
            execAttrTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
            execAttrTable.open(table);
        }
        catch (DirectoryTableDoesNotExistException ex) {
            exists = false;
        }
        catch (DirectoryTableException ex) {
            execAttrTable.close();
            throw ex;
        }
        TableDefinitions tbldef = null;
        try {
            if (!exists) {
                tbldef = execAttrTable.getTableDefinitionsInstance();
                tbldef.loadTableDefinitions(table);
                execAttrTable.create(table);
            }
        }
        catch (DirectoryTableException ex) {
            throw ex;
        }
        finally {
            execAttrTable.close();
        }
    }

    private DirectoryTable openExecAttrTable() throws DirectoryTableException {
        DirectoryTableFactory factory = new DirectoryTableFactory();
        DirectoryTable execAttrTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
        try {
            execAttrTable.open(table);
        }
        catch (DirectoryTableDoesNotExistException ex) {
            throw new DirectoryTableException("EXM_TABLE_EMPTY", (Object)table);
        }
        TableDefinitions tabledefs = execAttrTable.getCurrentTableDefinitions();
        this.nameColNum = tabledefs.getColumnNumber(nameCol);
        this.policyColNum = tabledefs.getColumnNumber(policyCol);
        this.typeColNum = tabledefs.getColumnNumber(typeCol);
        this.res1ColNum = tabledefs.getColumnNumber(res1Col);
        this.res2ColNum = tabledefs.getColumnNumber(res2Col);
        this.idColNum = tabledefs.getColumnNumber(idCol);
        this.attrColNum = tabledefs.getColumnNumber(attrCol);
        return execAttrTable;
    }

    private void closeExecAttrTable(DirectoryTable dirTable) {
        dirTable.close();
        this.nameColNum = 0;
        this.policyColNum = 0;
        this.typeColNum = 0;
        this.res1ColNum = 0;
        this.res2ColNum = 0;
        this.idColNum = 0;
        this.attrColNum = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecAttrObj[] listExecAttributes() throws DirectoryTableException {
        ExecAttrObj[] execArray = null;
        int numRows = 0;
        DirectoryTable etcTable = this.openExecAttrTable();
        try {
            DirectoryRow execRow = etcTable.getAll();
            if (execRow == null) {
                throw new DirectoryTableException("EXM_TABLE_EMPTY", (Object)table);
            }
            numRows = execRow.getNumberOfRows();
            execArray = new ExecAttrObj[numRows];
            for (int i = 1; i <= numRows; ++i) {
                ExecAttrObj execAttr = new ExecAttrObj();
                execAttr.setProfName(execRow.getColumn(this.nameColNum, i));
                execAttr.setPolicy(execRow.getColumn(this.policyColNum, i));
                execAttr.setType(execRow.getColumn(this.typeColNum, i));
                execAttr.setId(execRow.getColumn(this.idColNum, i));
                String attrList = execRow.getColumn(this.attrColNum, i);
                KeyValue.getAttributes(attrList, execAttr.attrSet);
                execArray[i - 1] = execAttr;
            }
        }
        finally {
            etcTable.close();
        }
        return execArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getProfCommand(String profName) throws DirectoryTableException {
        ExecAttrObj attrObj = null;
        DirectoryTable etcTable = this.openExecAttrTable();
        try {
            DirectoryRow execAttrRow = etcTable.getRowInstance();
            execAttrRow.putColumn(this.nameColNum, profName);
            execAttrRow = etcTable.getFirstRow((SearchTemplate)execAttrRow);
            if (execAttrRow != null) {
                attrObj = new ExecAttrObj(profName);
                attrObj.setId(execAttrRow.getColumn(this.idColNum));
            }
        }
        finally {
            etcTable.close();
        }
        String cmdId = attrObj.getId();
        StringTokenizer cmdlist = new StringTokenizer(cmdId, ",");
        int num_token = cmdlist.countTokens();
        String[] cmdArray = new String[num_token];
        for (int i = 0; i < num_token; ++i) {
            cmdArray[i] = cmdlist.nextToken();
        }
        return cmdArray;
    }
}

