/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.usermgr.common;

import com.sun.wbem.solarisprovider.usermgr.auths.AuthAttrObj;
import com.sun.wbem.solarisprovider.usermgr.auths.SolarisAuthAttrTable;
import com.sun.wbem.solarisprovider.usermgr.common.ExtAttrObj;
import com.sun.wbem.solarisprovider.usermgr.common.UserException;
import com.sun.wbem.solarisprovider.usermgr.profs.SolarisProfAttrTable;
import com.sun.wbem.solarisprovider.usermgr.users.UserAttrObj;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class UserAttrUtil {
    private String scope;

    public UserAttrUtil(String scopeURL) {
        this.scope = scopeURL;
    }

    public void validateUserAttrKeys(UserAttrObj uao) throws UserException {
        int bad = 0;
        String bad_keys = "";
        String type = uao.getUserType();
        String name = uao.getUserName();
        Hashtable ht = uao.attrSet;
        if (type.equals("role")) {
            if (ht.containsKey("roles")) {
                bad_keys = bad_keys.concat("roles");
                ++bad;
            }
            if (bad > 0) {
                throw new UserException("EXM_UAV1", (Object)name, bad_keys);
            }
        } else {
            if (ht.containsKey("members")) {
                bad_keys = bad_keys.concat("members");
                ++bad;
            }
            if (ht.containsKey("mutex")) {
                if (bad > 0) {
                    bad_keys = bad_keys.concat(", ");
                }
                bad_keys = bad_keys.concat("mutex");
                ++bad;
            }
            if (ht.containsKey("cardinality")) {
                if (bad > 0) {
                    bad_keys = bad_keys.concat(", ");
                }
                bad_keys = bad_keys.concat("cardinality");
                ++bad;
            }
            if (bad > 0) {
                throw new UserException("EXM_UAV2", (Object)name, bad_keys);
            }
        }
    }

    public void validateAuthNames(ExtAttrObj oldAttr, ExtAttrObj newAttr) throws UserException {
        int i;
        SolarisAuthAttrTable sat = null;
        AuthAttrObj[] list = null;
        Vector v1 = newAttr.getAttribute("auths");
        if (v1 == null || v1.size() == 0) {
            return;
        }
        Vector v2 = null;
        if (oldAttr != null) {
            v2 = oldAttr.getAttribute("auths");
        }
        if (v2 != null && v2.size() > 0) {
            v1 = this.getVectorDiff(v1, v2);
        }
        if (v1.size() == 0) {
            return;
        }
        try {
            sat = new SolarisAuthAttrTable(this.scope);
            list = sat.listAuthAttributes();
        }
        catch (Exception ex) {
            throw new UserException("EXM_UAV3", (Object)this.scope, ex.getLocalizedMessage());
        }
        String[] names = new String[list.length];
        for (i = 0; i < list.length; ++i) {
            names[i] = list[i].getAuthName();
        }
        int bad = 0;
        String bad_names = "";
        Enumeration en = v1.elements();
        while (en.hasMoreElements()) {
            String sufx;
            String name;
            boolean bsw = false;
            String test_name = name = (String)en.nextElement();
            i = name.lastIndexOf(46);
            if (i > 0 && ((sufx = name.substring(i)).equals(".*") || sufx.equals(".grant"))) {
                test_name = name.substring(0, i + 1);
                bsw = true;
            }
            boolean bbad = true;
            for (i = 0; i < names.length; ++i) {
                if (bsw) {
                    if (!names[i].startsWith(test_name)) continue;
                    bbad = false;
                    break;
                }
                if (!names[i].equals(test_name)) continue;
                bbad = false;
                break;
            }
            if (!bbad) continue;
            if (bad > 0) {
                bad_names = bad_names.concat(", ");
            }
            bad_names = bad_names.concat(name);
            ++bad;
        }
        if (bad > 0) {
            throw new UserException("EXM_UAV4", (Object)bad_names, this.scope);
        }
    }

    public void validateProfNames(ExtAttrObj oldAttr, ExtAttrObj newAttr) throws UserException {
        String[] names;
        SolarisProfAttrTable sat = null;
        Object list = null;
        Vector v1 = newAttr.getAttribute("profiles");
        if (v1 == null || v1.size() == 0) {
            return;
        }
        Vector v2 = null;
        if (oldAttr != null) {
            v2 = oldAttr.getAttribute("profiles");
        }
        if (v2 != null && v2.size() > 0) {
            v1 = this.getVectorDiff(v1, v2);
        }
        if (v1.size() == 0) {
            return;
        }
        try {
            sat = new SolarisProfAttrTable(this.scope);
            names = sat.getProfilesList();
        }
        catch (Exception ex) {
            throw new UserException("EXM_UAV5", (Object)this.scope, ex.getLocalizedMessage());
        }
        int bad = 0;
        String bad_names = "";
        Enumeration en = v1.elements();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            boolean bbad = true;
            for (int i = 0; i < names.length; ++i) {
                if (!name.equals(names[i])) continue;
                bbad = false;
                break;
            }
            if (!bbad) continue;
            if (bad > 0) {
                bad_names = bad_names.concat(", ");
            }
            bad_names = bad_names.concat(name);
            ++bad;
        }
        if (bad > 0) {
            throw new UserException("EXM_UAV6", (Object)bad_names, this.scope);
        }
    }

    private Vector getVectorDiff(Vector v1, Vector v2) {
        if (v1 == null) {
            return new Vector(0);
        }
        Vector v3 = (Vector)v1.clone();
        if (v2 != null) {
            for (int i = 0; i < v2.size(); ++i) {
                v3.removeElement(v2.elementAt(i));
            }
        }
        return v3;
    }
}

