/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.usermgr.aliases;

import com.sun.wbem.solarisprovider.common.ProviderDirectoryFilter;
import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.usermgr.aliases.EmailAliasObj;
import com.sun.wbem.solarisprovider.usermgr.aliases.SolarisAliasesTable;
import com.sun.wbem.solarisprovider.usermgr.common.UserException;
import com.sun.wbem.solarisprovider.usermgr.common.UserMgrNameNotFoundException;
import com.sun.wbem.utility.directorytable.DirectoryTableAccessException;
import com.sun.wbem.utility.directorytable.DirectoryTableConnectionException;
import com.sun.wbem.utility.directorytable.DirectoryTableDoesNotExistException;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableInvalidParameterException;
import com.sun.wbem.utility.directorytable.DirectoryTableRowNotFoundException;
import com.sun.wbem.utility.directorytable.DirectoryTableRowNotUniqueException;
import java.net.InetAddress;
import java.util.Vector;
import javax.wbem.client.CIMProviderException;

public class UMgrWrapper {
    ProviderUtility provUtil = null;
    private String scope = "";

    public UMgrWrapper(ProviderUtility provUtil, String strScope) throws UserException {
        this.provUtil = provUtil;
        String localhost = "";
        try {
            InetAddress homename = InetAddress.getLocalHost();
            localhost = homename.getHostName();
        }
        catch (Exception ex) {
            localhost = "";
        }
        this.scope = strScope;
    }

    public synchronized Vector getAllEmailAliases() throws CIMProviderException {
        String msg = null;
        Vector v = new Vector();
        try {
            SolarisAliasesTable alias = new SolarisAliasesTable(this.scope);
            v = alias.getAllAliasRows();
        }
        catch (DirectoryTableInvalidParameterException ex) {
            msg = this.writeLog(2, "LM_2039", "LM_2123", null, null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        catch (DirectoryTableDoesNotExistException ex) {
            msg = this.writeLog(2, "LM_2039", "LM_2124", null, null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        catch (DirectoryTableAccessException ex) {
            msg = this.writeLog(2, "LM_2039", "LM_2125", null, null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        catch (DirectoryTableException ex) {
            msg = this.writeLog(2, "LM_2039", "LM_2126", null, null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        catch (Exception ex) {
            msg = this.writeLog(2, "LM_2039", "LM_2128", null, null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        this.writeLog(0, "LM_2038", "LM_2112", null, null, null, null);
        return v;
    }

    public synchronized Vector getAllEmailAliases(ProviderDirectoryFilter pdf) throws CIMProviderException {
        Vector v = new Vector();
        String msg = null;
        try {
            SolarisAliasesTable alias = new SolarisAliasesTable(this.scope);
            v = pdf == null ? alias.getAllAliasRows() : alias.getAllAliasRows(pdf);
        }
        catch (DirectoryTableInvalidParameterException ex) {
            msg = this.writeLog(2, "LM_2039", "LM_2123", null, null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        catch (DirectoryTableDoesNotExistException ex) {
            msg = this.writeLog(2, "LM_2039", "LM_2124", null, null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        catch (DirectoryTableAccessException ex) {
            msg = this.writeLog(2, "LM_2039", "LM_2125", null, null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        catch (DirectoryTableException ex) {
            msg = this.writeLog(2, "LM_2039", "LM_2126", null, null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        catch (Exception ex) {
            msg = this.writeLog(2, "LM_2039", "LM_2128", null, null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        this.writeLog(0, "LM_2038", "LM_2112", null, null, null, null);
        return v;
    }

    public synchronized EmailAliasObj getEmailAliasAttributes(EmailAliasObj aliasObj) throws CIMProviderException {
        EmailAliasObj eobj = new EmailAliasObj();
        String msg = null;
        try {
            SolarisAliasesTable alias = new SolarisAliasesTable(this.scope);
            eobj = alias.getEmailRow(aliasObj.getAliasName());
        }
        catch (DirectoryTableInvalidParameterException ex) {
            msg = this.writeLog(2, "LM_2039", "LM_2129", aliasObj.getAliasName(), null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        catch (DirectoryTableDoesNotExistException ex) {
            msg = this.writeLog(2, "LM_2039", "LM_2130", aliasObj.getAliasName(), null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        catch (DirectoryTableAccessException ex) {
            msg = this.writeLog(2, "LM_2039", "LM_2131", aliasObj.getAliasName(), null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        catch (DirectoryTableException ex) {
            msg = this.writeLog(2, "LM_2039", "LM_2132", aliasObj.getAliasName(), null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        catch (UserMgrNameNotFoundException ex) {
            msg = this.writeLog(2, "LM_2039", "LM_2108", aliasObj.getAliasName(), null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        catch (Exception ex) {
            msg = this.writeLog(2, "LM_2039", "LM_2133", aliasObj.getAliasName(), null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        this.writeLog(0, "LM_2038", "LM_2119", aliasObj.getAliasName(), null, null, null);
        return eobj;
    }

    public synchronized void deleteEmailAlias(EmailAliasObj aliasObj) throws CIMProviderException {
        String str1;
        String msg = null;
        String strAliasname = aliasObj.getAliasName();
        if (strAliasname.equalsIgnoreCase(str1 = "Postmaster")) {
            msg = this.writeLog(2, "LM_2021", "LM_2134", str1, null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        str1 = "MAILER-DAEMON";
        if (strAliasname.equalsIgnoreCase(str1)) {
            msg = this.writeLog(2, "LM_2021", "LM_2134", str1, null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        try {
            SolarisAliasesTable alias = new SolarisAliasesTable(this.scope);
            alias.deleteEmailRow(aliasObj);
            this.performDeleteAliasFromAddresses(aliasObj);
        }
        catch (DirectoryTableInvalidParameterException ex) {
            msg = this.writeLog(2, "LM_2021", "LM_2135", aliasObj.getAliasName(), null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        catch (DirectoryTableDoesNotExistException ex) {
            msg = this.writeLog(2, "LM_2021", "LM_2136", aliasObj.getAliasName(), null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        catch (DirectoryTableAccessException ex) {
            msg = this.writeLog(2, "LM_2021", "LM_2137", aliasObj.getAliasName(), null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        catch (DirectoryTableConnectionException ex) {
            msg = this.writeLog(2, "LM_2021", "LM_2138", aliasObj.getAliasName(), null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        catch (DirectoryTableException ex) {
            msg = this.writeLog(2, "LM_2021", "LM_2140", aliasObj.getAliasName(), null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        catch (UserMgrNameNotFoundException ex) {
            msg = this.writeLog(2, "LM_2021", "LM_2108", aliasObj.getAliasName(), null, null, null);
        }
        catch (Exception ex) {
            msg = this.writeLog(2, "LM_2021", "LM_2139", aliasObj.getAliasName(), null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        this.writeLog(0, "LM_2020", "LM_2113", aliasObj.getAliasName(), null, null, null);
    }

    public synchronized void addEmailAlias(EmailAliasObj aliasObj) throws CIMProviderException {
        String msg = null;
        try {
            SolarisAliasesTable alias = new SolarisAliasesTable(this.scope);
            alias.addEmailRow(aliasObj);
        }
        catch (DirectoryTableInvalidParameterException ex) {
            msg = this.writeLog(2, "LM_2019", "LM_2141", aliasObj.getAliasName(), null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        catch (DirectoryTableRowNotUniqueException ex) {
            msg = this.writeLog(2, "LM_2019", "LM_2111", aliasObj.getAliasName(), null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        catch (DirectoryTableDoesNotExistException ex) {
            msg = this.writeLog(2, "LM_2019", "LM_2142", aliasObj.getAliasName(), null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        catch (DirectoryTableAccessException ex) {
            msg = this.writeLog(2, "LM_2019", "LM_2143", aliasObj.getAliasName(), null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        catch (DirectoryTableConnectionException ex) {
            msg = this.writeLog(2, "LM_2019", "LM_2144", aliasObj.getAliasName(), null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        catch (DirectoryTableException ex) {
            msg = this.writeLog(2, "LM_2019", "LM_2145", aliasObj.getAliasName(), null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        catch (Exception ex) {
            msg = this.writeLog(2, "LM_2019", "LM_2145", aliasObj.getAliasName(), null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        this.writeLog(0, "LM_2018", "LM_2101", aliasObj.getAliasName(), null, null, null);
    }

    public EmailAliasObj modifyEmailAlias(EmailAliasObj newAliasObj, EmailAliasObj oldAliasObj) throws CIMProviderException {
        String msg = null;
        String tmpName = newAliasObj.getAliasName();
        if (!tmpName.equals(oldAliasObj.getAliasName())) {
            Vector vUsers = this.getAllEmailAliases(null);
            for (int ii = 0; ii < vUsers.size(); ++ii) {
                EmailAliasObj tmpAliasObj = (EmailAliasObj)vUsers.elementAt(ii);
                String tmpAlias = tmpAliasObj.getAliasName();
                if (!tmpName.equals(tmpAlias)) continue;
                String[] args = new String[]{tmpName};
                msg = this.writeLog(2, "LM_2023", "LM_2111", tmpName, null, null, null);
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
            }
        }
        try {
            SolarisAliasesTable addAlias = new SolarisAliasesTable(this.scope);
            addAlias.modifyEmailRow(newAliasObj, oldAliasObj.getAliasName());
        }
        catch (DirectoryTableInvalidParameterException ex) {
            msg = this.writeLog(2, "LM_2023", "LM_2146", oldAliasObj.getAliasName(), null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        catch (DirectoryTableRowNotUniqueException ex) {
            msg = this.writeLog(2, "LM_2023", "LM_2111", newAliasObj.getAliasName(), null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        catch (DirectoryTableDoesNotExistException ex) {
            msg = this.writeLog(2, "LM_2023", "LM_2147", oldAliasObj.getAliasName(), null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        catch (DirectoryTableAccessException ex) {
            msg = this.writeLog(2, "LM_2023", "LM_2148", oldAliasObj.getAliasName(), null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        catch (DirectoryTableRowNotFoundException ex) {
            this.addEmailAlias(newAliasObj);
        }
        catch (DirectoryTableConnectionException ex) {
            msg = this.writeLog(2, "LM_2023", "LM_2149", oldAliasObj.getAliasName(), null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        catch (UserMgrNameNotFoundException ex) {
            msg = this.writeLog(2, "LM_2023", "LM_2108", oldAliasObj.getAliasName(), null, null, null);
        }
        catch (Exception ex) {
            msg = this.writeLog(2, "LM_2023", "LM_2150", oldAliasObj.getAliasName(), null, null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        this.writeLog(0, "LM_2022", "LM_2102", newAliasObj.getAliasName(), null, null, null);
        return newAliasObj;
    }

    private void performDeleteAliasFromAddresses(EmailAliasObj aliasObj) throws CIMProviderException {
        EmailAliasObj tmpObj = null;
        EmailAliasObj newObj = null;
        boolean bFoundOne = false;
        String strDanglingAliasToRemove = aliasObj.getAliasName();
        Vector<String> vLines = new Vector<String>();
        int ii = 0;
        int jj = 0;
        String tmpStr = "";
        String msg = null;
        strDanglingAliasToRemove.trim();
        try {
            SolarisAliasesTable aliasTable = new SolarisAliasesTable(this.scope);
            Vector vEmail = aliasTable.getAllAliasRows();
            for (ii = 0; ii < vEmail.size(); ++ii) {
                tmpObj = (EmailAliasObj)vEmail.elementAt(ii);
                String[] strAddresses = tmpObj.getAliasExpansionArray();
                for (jj = 0; jj < strAddresses.length; ++jj) {
                    tmpStr = strAddresses[jj].trim();
                    if (!strDanglingAliasToRemove.equals(tmpStr)) continue;
                    bFoundOne = true;
                    break;
                }
                if (bFoundOne) {
                    vLines.removeAllElements();
                    for (jj = 0; jj < strAddresses.length; ++jj) {
                        tmpStr = strAddresses[jj].trim();
                        if (strDanglingAliasToRemove.equals(tmpStr) || tmpStr == null || tmpStr.equals("")) continue;
                        vLines.addElement(strAddresses[jj]);
                    }
                    Object[] newAddressList = new String[vLines.size()];
                    vLines.copyInto(newAddressList);
                    newObj = (EmailAliasObj)tmpObj.clone();
                    newObj.setAliasMembers((String[])newAddressList);
                    aliasTable.modifyEmailRow(newObj, tmpObj.getAliasName());
                }
                bFoundOne = false;
            }
            return;
        }
        catch (DirectoryTableDoesNotExistException ex) {
            msg = this.writeLog(2, "LM_2099", "LM_2118", aliasObj.getAliasName(), ex.getLocalizedMessage(), null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        catch (DirectoryTableException ex) {
            msg = this.writeLog(2, "LM_2099", "LM_2118", aliasObj.getAliasName(), ex.getLocalizedMessage(), null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        catch (Exception ex) {
            msg = this.writeLog(2, "LM_2099", "LM_2118", aliasObj.getAliasName(), ex.getLocalizedMessage(), null, null);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
    }

    public String writeLog(int severity, String msgId, String detailMsgId, String arg1, String arg2, String arg3, String arg4) {
        String str = this.provUtil.writeLog(severity, msgId, detailMsgId, arg1, arg2, arg3, arg4);
        return str;
    }
}

