/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.serialport;

import com.sun.audit.AuditEvent_serialport_modify;
import com.sun.audit.AuditSession;
import com.sun.wbem.cimom.audit.WbemAuditSession;
import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.serialport.SerialPortData;
import com.sun.wbem.solarisprovider.serialport.SerialPortException;
import com.sun.wbem.solarisprovider.serialport.SerialPortInfo;
import com.sun.wbem.utility.log.LogUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMElement;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.CIMProviderException;
import javax.wbem.client.Debug;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.InstanceProvider;
import javax.wbem.query.NonJoinExp;
import javax.wbem.query.QueryExp;
import javax.wbem.query.SelectExp;
import javax.wbem.query.SelectList;
import javax.wbem.query.WQLParser;

public class Solaris_SerialPortConfiguration
implements InstanceProvider,
Authorizable {
    public static final String SERIAL_MODIFY_RIGHT = "solaris.admin.serialmgr.modify";
    public static final String SERIAL_DELETE_RIGHT = "solaris.admin.serialmgr.delete";
    public static final String SERIAL_READ_RIGHT = "solaris.admin.serialmgr.read";
    SerialPortInfo dat = null;
    int num_ports;
    private CIMOMHandle cimomhandle = null;
    private LogUtil util = null;
    private ProviderUtility provUtil = null;

    public void initialize(CIMOMHandle cimomhandle) throws CIMException {
        this.cimomhandle = cimomhandle;
        this.util = LogUtil.getInstance((CIMOMHandle)cimomhandle);
        String app_name = this.util.getMessage("LM_SERIAL_APP_NAME");
        this.provUtil = new ProviderUtility(cimomhandle, app_name);
    }

    public void cleanup() throws CIMException {
    }

    public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
        this.provUtil.checkRights(SERIAL_READ_RIGHT, op);
        String portName = "";
        String ServiceTag = "";
        this.dat = this.initData();
        Enumeration e = op.getKeys().elements();
        while (e.hasMoreElements()) {
            CIMProperty cp = (CIMProperty)e.nextElement();
            if (cp.getName().equalsIgnoreCase("PortName")) {
                portName = (String)cp.getValue().getValue();
            }
            if (!cp.getName().equalsIgnoreCase("ServiceTag")) continue;
            ServiceTag = (String)cp.getValue().getValue();
        }
        SerialPortData portData = null;
        try {
            portData = this.dat.getPortData(portName);
        }
        catch (SerialPortException spex) {
            String msg = spex.getLocalizedMessage();
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        catch (Exception ex) {
            String msg = this.provUtil.writeLog(2, ex);
            throw new CIMException("CIM_ERR_FAILED", (Object)msg);
        }
        CIMInstance ci = cc.newInstance();
        ci.setProperty("PortName", new CIMValue((Object)portName));
        ci.setProperty("ServiceTag", new CIMValue((Object)ServiceTag));
        ci.setProperty("ServiceEnabled", new CIMValue((Object)new Boolean(portData.isEnableSet())));
        ci.setProperty("PortDeleted", new CIMValue((Object)new Boolean(portData.isDeleted())));
        ci.setProperty("PortmonTag", new CIMValue((Object)portData.getPortMonTag()));
        ci.setProperty("Comment", new CIMValue((Object)portData.getComment()));
        ci.setProperty("BaudRate", new CIMValue((Object)portData.getTTYLabel()));
        ci.setProperty("TerminalType", new CIMValue((Object)portData.getTerminalType()));
        ci.setProperty("TTYFlag_Init", new CIMValue((Object)new Boolean(portData.isInitializeSet())));
        ci.setProperty("TTYFlag_Bidirectional", new CIMValue((Object)new Boolean(portData.isBidirectionalSet())));
        ci.setProperty("TTYFlag_CarrierConnect", new CIMValue((Object)new Boolean(portData.isConnectOnCarrierSet())));
        ci.setProperty("SoftwareCarrier", new CIMValue((Object)new Boolean(portData.isSoftwareCarrier())));
        ci.setProperty("CreateUtmp", new CIMValue((Object)new Boolean(portData.isUTMPSet())));
        ci.setProperty("LoginPrompt", new CIMValue((Object)portData.getPrompt()));
        ci.setProperty("ServiceProgram", new CIMValue((Object)portData.getServiceCmdLine()));
        ci.setProperty("StreamsModules", new CIMValue((Object)portData.getModules()));
        ci.setProperty("Timeout", new CIMValue((Object)portData.getTimeoutVal()));
        ci.setProperty("deviceName", new CIMValue((Object)portData.getDeviceName()));
        if (localOnly) {
            ci = ci.localElements();
        }
        return ci.filterProperties(propList, includeQualifiers, includeClassOrigin);
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
        this.provUtil.checkRights(SERIAL_READ_RIGHT, op);
        String portName = "";
        String ServiceTag = "";
        CIMInstance ci = null;
        this.dat = this.initData();
        SerialPortData portData = null;
        Vector<CIMInstance> ports = new Vector<CIMInstance>();
        for (int i = 0; i < this.num_ports; ++i) {
            ci = cc.newInstance();
            try {
                portData = this.dat.getPortData(this.dat.getPortName(i));
                ci.setProperty("PortName", new CIMValue((Object)this.dat.getPortName(i)));
            }
            catch (SerialPortException spex) {
                String msg = spex.getLocalizedMessage();
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
            }
            catch (Exception e) {
                String msg = this.provUtil.writeLog(2, e);
                throw new CIMException("CIM_ERR_FAILED", (Object)msg);
            }
            ci.setProperty("ServiceTag", new CIMValue((Object)portData.getServiceTag()));
            ci.setProperty("ServiceEnabled", new CIMValue((Object)new Boolean(portData.isEnableSet())));
            ci.setProperty("PortDeleted", new CIMValue((Object)new Boolean(portData.isDeleted())));
            ci.setProperty("PortmonTag", new CIMValue((Object)portData.getPortMonTag()));
            ci.setProperty("Comment", new CIMValue((Object)portData.getComment()));
            ci.setProperty("BaudRate", new CIMValue((Object)portData.getTTYLabel()));
            ci.setProperty("TerminalType", new CIMValue((Object)portData.getTerminalType()));
            ci.setProperty("TTYFlag_Init", new CIMValue((Object)new Boolean(portData.isInitializeSet())));
            ci.setProperty("TTYFlag_Bidirectional", new CIMValue((Object)new Boolean(portData.isBidirectionalSet())));
            ci.setProperty("TTYFlag_CarrierConnect", new CIMValue((Object)new Boolean(portData.isConnectOnCarrierSet())));
            ci.setProperty("SoftwareCarrier", new CIMValue((Object)new Boolean(portData.isSoftwareCarrier())));
            ci.setProperty("CreateUtmp", new CIMValue((Object)new Boolean(portData.isUTMPSet())));
            ci.setProperty("LoginPrompt", new CIMValue((Object)portData.getPrompt()));
            ci.setProperty("ServiceProgram", new CIMValue((Object)portData.getServiceCmdLine()));
            ci.setProperty("StreamsModules", new CIMValue((Object)portData.getModules()));
            ci.setProperty("Timeout", new CIMValue((Object)portData.getTimeoutVal()));
            ci.setProperty("deviceName", new CIMValue((Object)portData.getDeviceName()));
            if (localOnly) {
                ci = ci.localElements();
            }
            ports.addElement(ci.filterProperties(propList, includeQualifiers, includeClassOrigin));
        }
        CIMInstance[] ciArray = new CIMInstance[ports.size()];
        ports.toArray(ciArray);
        return ciArray;
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath op, CIMClass cc) throws CIMException {
        this.provUtil.checkRights(SERIAL_READ_RIGHT, op);
        Vector<CIMObjectPath> ports = new Vector<CIMObjectPath>();
        this.dat = this.initData();
        for (int i = 0; i < this.num_ports; ++i) {
            CIMObjectPath cop = new CIMObjectPath(op.getObjectName(), op.getNameSpace());
            try {
                cop.addKey("PortName", new CIMValue((Object)this.dat.getPortName(i)));
                cop.addKey("ServiceTag", new CIMValue((Object)this.dat.getServiceTag(this.dat.getPortName(i))));
            }
            catch (Exception e) {
                String msg = this.provUtil.writeLog(2, e);
                throw new CIMException("CIM_ERR_FAILED", (Object)msg);
            }
            ports.addElement(cop);
        }
        CIMObjectPath[] copArray = new CIMObjectPath[ports.size()];
        ports.toArray(copArray);
        return copArray;
    }

    private SerialPortInfo initData() throws CIMException {
        try {
            SerialPortInfo priv_data = new SerialPortInfo(this.util);
            this.num_ports = priv_data.initData();
            return priv_data;
        }
        catch (SerialPortException spex) {
            String msg = spex.getLocalizedMessage();
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        catch (Exception e) {
            String msg = this.provUtil.writeLog(2, e);
            throw new CIMException("CIM_ERR_FAILED", (Object)msg);
        }
    }

    public CIMObjectPath createInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void deleteInstance(CIMObjectPath cp) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public synchronized void setInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        this.provUtil.checkRights(SERIAL_MODIFY_RIGHT, op);
        String portName = "";
        this.dat = this.initData();
        portName = (String)ci.getProperty("PortName").getValue().getValue();
        SerialPortData portData = null;
        try {
            portData = this.dat.getPortData(portName);
        }
        catch (SerialPortException spex) {
            String msg = spex.getLocalizedMessage();
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        catch (Exception e) {
            String msg = this.provUtil.writeLog(2, e);
            throw new CIMException("CIM_ERR_FAILED", (Object)msg);
        }
        SerialPortData new_data = new SerialPortData(portName);
        new_data.setDefaults(portName);
        new_data.setPortMonTag(portData.getPortMonTag());
        new_data.setOldPortMonTag(portData.getPortMonTag());
        new_data.setServiceTag(portData.getServiceTag());
        new_data.setOldServiceTag(portData.getServiceTag());
        new_data.setEnable((Boolean)ci.getProperty("ServiceEnabled").getValue().getValue());
        new_data.setTTYLabel((String)ci.getProperty("BaudRate").getValue().getValue());
        new_data.setTerminalType((String)ci.getProperty("TerminalType").getValue().getValue());
        new_data.setServiceTag((String)ci.getProperty("ServiceTag").getValue().getValue());
        new_data.setTTYFlags((Boolean)ci.getProperty("TTYFlag_Init").getValue().getValue(), (Boolean)ci.getProperty("TTYFlag_Bidirectional").getValue().getValue(), (Boolean)ci.getProperty("TTYFlag_CarrierConnect").getValue().getValue());
        new_data.setSoftwareCarrier((Boolean)ci.getProperty("SoftwareCarrier").getValue().getValue());
        new_data.setPortFlags((Boolean)ci.getProperty("CreateUtmp").getValue().getValue());
        new_data.setPrompt((String)ci.getProperty("LoginPrompt").getValue().getValue());
        new_data.setComment((String)ci.getProperty("Comment").getValue().getValue());
        new_data.setPortMonTag((String)ci.getProperty("PortmonTag").getValue().getValue());
        new_data.setServiceCmdLine((String)ci.getProperty("ServiceProgram").getValue().getValue());
        new_data.setModules((String)ci.getProperty("StreamsModules").getValue().getValue());
        new_data.setTimeoutVal((String)ci.getProperty("Timeout").getValue().getValue());
        new_data.setDeviceName((String)ci.getProperty("deviceName").getValue().getValue());
        boolean diff_flag = !new_data.isEqualTo(portData);
        try {
            this.dat.synchronizedSetPortInfo(portName, new_data, diff_flag);
        }
        catch (SerialPortException spex) {
            String msg = spex.getLocalizedMessage();
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)msg);
        }
        catch (Exception e) {
            String msg = this.provUtil.writeLog(2, e);
            throw new CIMException("CIM_ERR_FAILED", (Object)msg);
        }
        try {
            WbemAuditSession wbemAuditSession = this.provUtil.getAuditSession();
            if (wbemAuditSession == null) {
                Debug.trace1((String)"Solaris_SerialPortConfiguration setInstance() : null WbemAuditSession");
                return;
            }
            AuditSession auditSession = (AuditSession)wbemAuditSession.getPlatformAuditSession();
            if (auditSession == null) {
                Debug.trace1((String)"Solaris_SerialPortConfiguration setInstance() : null platform AuditSession.");
                return;
            }
            AuditEvent_serialport_modify sportModEvent = new AuditEvent_serialport_modify(auditSession);
            if (sportModEvent == null) {
                Debug.trace1((String)"Solaris_SerialPortConfiguration setInstance() : null AuditEvent_serialport_modify.");
                return;
            }
            String propertyToken = null;
            propertyToken = this.provUtil.formatAuditToken(ci);
            String scope = this.provUtil.getMgmtScope(op);
            sportModEvent.object_name(op.getObjectName());
            sportModEvent.domain(this.provUtil.getDomainToken(scope));
            sportModEvent.name_service(this.provUtil.getNameServiceToken(scope));
            sportModEvent.auth_used(SERIAL_MODIFY_RIGHT);
            sportModEvent.changed_values(propertyToken);
            sportModEvent.putEvent(0, 0);
        }
        catch (Exception e) {
            Debug.trace1((String)"Solaris_SerialPortConfiguration setInstance() : Auditing threw exception", (Throwable)e);
            return;
        }
    }

    public CIMInstance[] execQuery(CIMObjectPath op, String query, String ql, CIMClass cc) throws CIMException {
        ByteArrayInputStream in = new ByteArrayInputStream(query.getBytes());
        WQLParser parser = new WQLParser((InputStream)in);
        Vector<CIMElement> result = new Vector<CIMElement>();
        try {
            SelectExp q = (SelectExp)parser.querySpecification();
            SelectList attrs = q.getSelectList();
            NonJoinExp from = (NonJoinExp)q.getFromClause();
            QueryExp where = q.getWhereClause();
            CIMInstance[] ciArray = this.enumerateInstances(op, true, false, false, null, cc);
            for (int i = 0; i < ciArray.length; ++i) {
                if (where != null && !where.apply((CIMElement)ciArray[i])) continue;
                result.addElement(attrs.apply((CIMElement)ciArray[i]));
            }
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_FAILED", (Object)e.toString());
        }
        CIMInstance[] ciArray = new CIMInstance[result.size()];
        result.toArray(ciArray);
        return ciArray;
    }
}

