/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.serialport;

import com.sun.wbem.solarisprovider.serialport.SerialPortData;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMClient;

public class SerialPortMgrWrapper {
    CIMClient cimClient = null;
    CIMObjectPath serialPortConfig = null;

    public void init(CIMClient cc) throws CIMException {
        this.cimClient = cc;
        this.serialPortConfig = new CIMObjectPath("Solaris_SerialPortConfiguration");
    }

    public Vector getSerialPorts() throws CIMException {
        Vector port_list = null;
        SerialPortData dat = null;
        String portName = "";
        Enumeration e = this.cimClient.enumerateInstances(this.serialPortConfig, true, false, true, true, null);
        if (e != null) {
            while (e.hasMoreElements()) {
                CIMInstance ci = (CIMInstance)e.nextElement();
                portName = (String)ci.getProperty("PortName").getValue().getValue();
                dat = new SerialPortData(portName);
                dat.setDefaults(portName);
                dat.setEnable((Boolean)ci.getProperty("ServiceEnabled").getValue().getValue());
                dat.setTTYLabel((String)ci.getProperty("BaudRate").getValue().getValue());
                dat.setTerminalType((String)ci.getProperty("TerminalType").getValue().getValue());
                dat.setServiceTag((String)ci.getProperty("ServiceTag").getValue().getValue());
                dat.setTTYFlags((Boolean)ci.getProperty("TTYFlag_Init").getValue().getValue(), (Boolean)ci.getProperty("TTYFlag_Bidirectional").getValue().getValue(), (Boolean)ci.getProperty("TTYFlag_CarrierConnect").getValue().getValue());
                dat.setSoftwareCarrier((Boolean)ci.getProperty("SoftwareCarrier").getValue().getValue());
                dat.setPortFlags((Boolean)ci.getProperty("CreateUtmp").getValue().getValue());
                dat.setPrompt((String)ci.getProperty("LoginPrompt").getValue().getValue());
                dat.setComment((String)ci.getProperty("Comment").getValue().getValue());
                dat.setPortMonTag((String)ci.getProperty("PortmonTag").getValue().getValue());
                dat.setServiceCmdLine((String)ci.getProperty("ServiceProgram").getValue().getValue());
                dat.setModules((String)ci.getProperty("StreamsModules").getValue().getValue());
                dat.setTimeoutVal((String)ci.getProperty("Timeout").getValue().getValue());
                dat.setDeviceName((String)ci.getProperty("deviceName").getValue().getValue());
                port_list.addElement(dat);
            }
        }
        return port_list;
    }

    public SerialPortData getPortInfo(String portName) throws CIMException {
        SerialPortData dat = new SerialPortData(portName);
        CIMObjectPath cop = new CIMObjectPath("Solaris_SerialPortConfiguration");
        cop.addKey("PortName", new CIMValue((Object)portName));
        CIMInstance ci = this.cimClient.getInstance(cop, false, true, true, null);
        dat.setDefaults(portName);
        dat.setEnable((Boolean)ci.getProperty("ServiceEnabled").getValue().getValue());
        dat.setTTYLabel((String)ci.getProperty("BaudRate").getValue().getValue());
        dat.setTerminalType((String)ci.getProperty("TerminalType").getValue().getValue());
        dat.setServiceTag((String)ci.getProperty("ServiceTag").getValue().getValue());
        dat.setTTYFlags((Boolean)ci.getProperty("TTYFlag_Init").getValue().getValue(), (Boolean)ci.getProperty("TTYFlag_Bidirectional").getValue().getValue(), (Boolean)ci.getProperty("TTYFlag_CarrierConnect").getValue().getValue());
        dat.setSoftwareCarrier((Boolean)ci.getProperty("SoftwareCarrier").getValue().getValue());
        dat.setPortFlags((Boolean)ci.getProperty("CreateUtmp").getValue().getValue());
        dat.setPrompt((String)ci.getProperty("LoginPrompt").getValue().getValue());
        dat.setComment((String)ci.getProperty("Comment").getValue().getValue());
        dat.setPortMonTag((String)ci.getProperty("PortmonTag").getValue().getValue());
        dat.setServiceCmdLine((String)ci.getProperty("ServiceProgram").getValue().getValue());
        dat.setModules((String)ci.getProperty("StreamsModules").getValue().getValue());
        dat.setTimeoutVal((String)ci.getProperty("Timeout").getValue().getValue());
        dat.setDeviceName((String)ci.getProperty("deviceName").getValue().getValue());
        return dat;
    }

    public void setPortInfo(String portName, SerialPortData portData, boolean diffFlag) throws CIMException {
        CIMInstance ci = new CIMInstance();
        ci.setClassName("Solaris_SerialPortConfiguration");
        ci.setProperty("PortName", new CIMValue((Object)portName));
        ci.setProperty("ServiceTag", new CIMValue((Object)portData.getServiceTag()));
        ci.setProperty("ServiceEnabled", new CIMValue((Object)new Boolean(portData.isEnableSet())));
        ci.setProperty("PortmonTag", new CIMValue((Object)portData.getPortMonTag()));
        ci.setProperty("Comment", new CIMValue((Object)portData.getComment()));
        ci.setProperty("BaudRate", new CIMValue((Object)portData.getTTYLabel()));
        ci.setProperty("TerminalType", new CIMValue((Object)portData.getTerminalType()));
        ci.setProperty("TTYFlag_Init", new CIMValue((Object)new Boolean(portData.isInitializeSet())));
        ci.setProperty("TTYFlag_Bidirectional", new CIMValue((Object)new Boolean(portData.isBidirectionalSet())));
        ci.setProperty("TTYFlag_CarrierConnect", new CIMValue((Object)new Boolean(portData.isConnectOnCarrierSet())));
        ci.setProperty("SoftwareCarrier", new CIMValue((Object)new Boolean(portData.isSoftwareCarrier())));
        ci.setProperty("CreateUtmp", new CIMValue((Object)new Boolean(portData.isUTMPSet())));
        ci.setProperty("LoginPrompt", new CIMValue((Object)portData.getPrompt()));
        ci.setProperty("ServiceProgram", new CIMValue((Object)portData.getServiceCmdLine()));
        ci.setProperty("StreamsModules", new CIMValue((Object)portData.getModules()));
        ci.setProperty("Timeout", new CIMValue((Object)portData.getTimeoutVal()));
        ci.setProperty("deviceName", new CIMValue((Object)portData.getDeviceName()));
    }

    public Vector deletePort(String portName) throws CIMException {
        CIMObjectPath cop = new CIMObjectPath("Solaris_SerialPort");
        cop.addKey("DeviceID", new CIMValue((Object)portName));
        Vector inVec = new Vector();
        Vector outVec = new Vector();
        this.cimClient.invokeMethod(cop, "disablePortService", inVec, outVec);
        return this.getSerialPorts();
    }
}

