/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.productregistry;

import com.sun.wbem.prodreg.ProdRegAPI;
import com.sun.wbem.prodreg.RegistryComponent;
import com.sun.wbem.prodreg.SoftwareProduct;
import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.utility.log.LogUtil;
import java.io.ByteArrayInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMElement;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.ProviderCIMOMHandle;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.InstanceProvider;
import javax.wbem.query.NonJoinExp;
import javax.wbem.query.QueryExp;
import javax.wbem.query.SelectExp;
import javax.wbem.query.SelectList;
import javax.wbem.query.WQLParser;

public class Solaris_Product
implements InstanceProvider,
Authorizable {
    protected ProviderCIMOMHandle cimomhandle = null;
    LogUtil logUtil = null;
    private ProviderUtility prov_util = null;
    private String PROVIDER_NAME = "Solaris_Product";
    public static final String REGISTRY_MODIFY_RIGHT = "solaris.admin.prodreg.modify";
    public static final String REGISTRY_DELETE_RIGHT = "solaris.admin.prodreg.delete";
    public static final String REGISTRY_READ_RIGHT = "solaris.admin.prodreg.read";
    private static boolean library_loaded = false;
    String dName = null;
    String iLocation = null;
    String uLocation = null;
    String Parent = null;
    Vector backward = new Vector();
    Vector Keys = new Vector();
    Vector Values = new Vector();
    String SKU = null;
    long instNum = 0L;
    long duration = 0L;
    String caption = null;
    String description = null;

    public void cleanup() throws CIMException {
    }

    public void initialize(CIMOMHandle cimomhandle) throws CIMException {
        String[] msg = new String[]{"Initializing " + this.PROVIDER_NAME};
        try {
            this.cimomhandle = (ProviderCIMOMHandle)cimomhandle;
            this.logUtil = LogUtil.getInstance((CIMOMHandle)cimomhandle);
            this.prov_util = new ProviderUtility(cimomhandle, this.PROVIDER_NAME);
        }
        catch (CIMException e) {
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_6033", "LM_6034", msg, "Error", false, 0, 0);
            throw new CIMException("CIM_ERR_FAILED", (Object)("Cannot Initialize " + this.PROVIDER_NAME + " with " + e.toString()));
        }
    }

    public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
        String[] msg = new String[]{"getting properties for Solaris_Product"};
        String version = null;
        String uName = null;
        String idnum = null;
        String vendor = null;
        this.prov_util.checkRights(REGISTRY_READ_RIGHT, op);
        CIMInstance ci = null;
        try {
            ProdRegAPI api = new ProdRegAPI(null);
            RegistryComponent[] RegComp = api.getAll();
            for (int i = 0; i < RegComp.length; ++i) {
                RegistryComponent rc = RegComp[i];
                if (!(rc instanceof SoftwareProduct)) continue;
                Enumeration e = op.getKeys().elements();
                while (e.hasMoreElements()) {
                    CIMProperty cp = (CIMProperty)e.nextElement();
                    if (cp.getName().equalsIgnoreCase("IdentifyingNumber")) {
                        idnum = (String)cp.getValue().getValue();
                    }
                    if (cp.getName().equalsIgnoreCase("Name")) {
                        uName = (String)cp.getValue().getValue();
                    }
                    if (cp.getName().equalsIgnoreCase("Version")) {
                        version = (String)cp.getValue().getValue();
                    }
                    if (!cp.getName().equalsIgnoreCase("Vendor")) continue;
                    vendor = (String)cp.getValue().getValue();
                }
                if (!idnum.equalsIgnoreCase(rc.getID())) continue;
                ci = cc.newInstance();
                this.dName = rc.getDisplayName();
                this.iLocation = rc.getLocation();
                this.uLocation = rc.getUninstaller();
                this.backward = rc.getBackwardCompatableVersions();
                Vector AppData = rc.getAppData();
                this.Keys = api.getDataKeys(AppData);
                this.Values = api.getDataValues(AppData);
                this.instNum = rc.getInstanceNumber();
                this.SKU = rc.getDataValue("SKUNumber");
                this.caption = rc.getDataValue("Caption");
                this.description = rc.getDataValue("Description");
                ci.setProperty("IdentifyingNumber", new CIMValue((Object)idnum));
                ci.setProperty("Name", new CIMValue((Object)uName));
                ci.setProperty("Version", new CIMValue((Object)version));
                ci.setProperty("Vendor", new CIMValue((Object)vendor));
                ci.setProperty("InstanceNumber", new CIMValue((Object)new UnsignedInt32(this.instNum)));
                ci.setProperty("DisplayedName", new CIMValue((Object)this.dName));
                ci.setProperty("InstalledLocation", new CIMValue((Object)this.iLocation));
                ci.setProperty("UninstalledLocation", new CIMValue((Object)this.uLocation));
                ci.setProperty("BackwardCompatible", new CIMValue(new Vector(this.backward)));
                ci.setProperty("Keys", new CIMValue(new Vector(this.Keys)));
                ci.setProperty("Values", new CIMValue(new Vector(this.Values)));
                ci.setProperty("SKUNumber", new CIMValue((Object)this.SKU));
                ci.setProperty("Caption", new CIMValue((Object)this.caption));
                ci.setProperty("Description", new CIMValue((Object)this.description));
                if (localOnly) {
                    ci = ci.localElements();
                }
                return ci.filterProperties(propList, includeQualifiers, includeClassOrigin);
            }
        }
        catch (Exception e) {
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_6023", "LM_6024", msg, "Error", false, 0, 0);
            throw new CIMException("CIM_ERR_FAILED", (Object)("getting properties for " + this.PROVIDER_NAME + " with " + e.toString()));
        }
        return null;
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath op, CIMClass cc) throws CIMException {
        this.prov_util.checkRights(REGISTRY_READ_RIGHT, op);
        Vector<CIMObjectPath> prodVect = new Vector<CIMObjectPath>();
        String[] msg = new String[]{"getting properties for Solaris_Product"};
        try {
            ProdRegAPI api = new ProdRegAPI(null);
            RegistryComponent[] RegComp = api.getAll();
            for (int i = 0; i < RegComp.length; ++i) {
                RegistryComponent rc = RegComp[i];
                if (!(rc instanceof SoftwareProduct)) continue;
                CIMObjectPath cop = new CIMObjectPath(op.getObjectName(), op.getNameSpace());
                cop.addKey("IdentifyingNumber", new CIMValue((Object)rc.getID()));
                cop.addKey("Name", new CIMValue((Object)rc.getUniqueName()));
                cop.addKey("Vendor", new CIMValue((Object)rc.getVendor()));
                cop.addKey("Version", new CIMValue((Object)rc.getVersion()));
                prodVect.addElement(cop);
            }
        }
        catch (Exception e) {
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_6023", "LM_6024", msg, "Error", false, 0, 0);
            throw new CIMException("CIM_ERR_FAILED", (Object)("Enumerate Instances  Failed for " + this.PROVIDER_NAME + " with " + e.toString()));
        }
        CIMObjectPath[] copArray = new CIMObjectPath[prodVect.size()];
        prodVect.toArray(copArray);
        return copArray;
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
        String[] msg = new String[]{"getting properties for Solaris_Product"};
        this.prov_util.checkRights(REGISTRY_READ_RIGHT, op);
        Vector<CIMInstance> prodVect = new Vector<CIMInstance>();
        try {
            ProdRegAPI api = new ProdRegAPI(null);
            RegistryComponent[] RegComp = api.getAll();
            for (int i = 0; i < RegComp.length; ++i) {
                RegistryComponent rc = RegComp[i];
                if (!(rc instanceof SoftwareProduct)) continue;
                CIMInstance ci = cc.newInstance();
                ci.setProperty("IdentifyingNumber", new CIMValue((Object)rc.getID()));
                ci.setProperty("Name", new CIMValue((Object)rc.getUniqueName()));
                ci.setProperty("Vendor", new CIMValue((Object)rc.getVendor()));
                ci.setProperty("Version", new CIMValue((Object)rc.getVersion()));
                this.dName = rc.getDisplayName();
                this.iLocation = rc.getLocation();
                this.backward = rc.getBackwardCompatableVersions();
                Vector AppData = rc.getAppData();
                this.Keys = api.getDataKeys(AppData);
                this.Values = api.getDataValues(AppData);
                this.instNum = rc.getInstanceNumber();
                this.SKU = rc.getDataValue("SKUNumber");
                this.caption = rc.getDataValue("Caption");
                this.description = rc.getDataValue("Description");
                ci.setProperty("InstanceNumber", new CIMValue((Object)new UnsignedInt32(this.instNum)));
                ci.setProperty("DisplayedName", new CIMValue((Object)this.dName));
                ci.setProperty("InstalledLocation", new CIMValue((Object)this.iLocation));
                ci.setProperty("BackwardCompatible", new CIMValue(new Vector(this.backward)));
                ci.setProperty("Keys", new CIMValue(new Vector(this.Keys)));
                ci.setProperty("Values", new CIMValue(new Vector(this.Values)));
                ci.setProperty("SKUNumber", new CIMValue((Object)this.SKU));
                ci.setProperty("Caption", new CIMValue((Object)this.caption));
                ci.setProperty("Description", new CIMValue((Object)this.description));
                if (localOnly) {
                    ci = ci.localElements();
                }
                prodVect.addElement(ci.filterProperties(propList, includeQualifiers, includeClassOrigin));
            }
            CIMInstance[] ciArray = new CIMInstance[prodVect.size()];
            prodVect.toArray(ciArray);
            return ciArray;
        }
        catch (Exception e) {
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_6023", "LM_6024", msg, "Error", false, 0, 0);
            throw new CIMException("CIM_ERR_FAILED", (Object)("Enumerate Local Instances Failed for " + this.PROVIDER_NAME + " with " + e.toString()));
        }
    }

    public CIMObjectPath createInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void setInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void deleteInstance(CIMObjectPath cp) throws CIMException {
        String[] msg = new String[]{"deleteInstance for " + this.PROVIDER_NAME};
        String idnum = null;
        this.prov_util.checkRights(REGISTRY_MODIFY_RIGHT, cp);
        try {
            ProdRegAPI api = new ProdRegAPI(null);
            RegistryComponent[] RegComp = api.getAll();
            for (int i = 0; i < RegComp.length; ++i) {
                RegistryComponent rc = RegComp[i];
                if (!(rc instanceof SoftwareProduct)) continue;
                Enumeration e = cp.getKeys().elements();
                while (e.hasMoreElements()) {
                    CIMProperty op = (CIMProperty)e.nextElement();
                    if (!op.getName().equalsIgnoreCase("IdentifyingNumber")) continue;
                    idnum = (String)op.getValue().getValue();
                }
                if (!idnum.equalsIgnoreCase(rc.getID())) continue;
                api.unregister(rc);
            }
        }
        catch (Exception e) {
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_6047", "LM_6048", msg, "Error", false, 0, 0);
            throw new CIMException("CIM_ERR_FAILED", (Object)("Delete Failed for " + this.PROVIDER_NAME + " with " + e.toString()));
        }
    }

    public CIMInstance[] execQuery(CIMObjectPath op, String query, String ql, CIMClass cc) throws CIMException {
        String[] msg = new String[]{"Query Error for " + this.PROVIDER_NAME};
        ByteArrayInputStream in = new ByteArrayInputStream(query.getBytes());
        WQLParser parser = new WQLParser((InputStream)in);
        Vector<CIMElement> result = new Vector<CIMElement>();
        try {
            SelectExp q = (SelectExp)parser.querySpecification();
            SelectList attrs = q.getSelectList();
            NonJoinExp from = (NonJoinExp)q.getFromClause();
            QueryExp where = q.getWhereClause();
            CIMInstance[] ciArray = this.enumerateInstances(op, true, false, false, null, cc);
            for (int i = 0; i < ciArray.length; ++i) {
                if (where != null && !where.apply((CIMElement)ciArray[i])) continue;
                result.addElement(attrs.apply((CIMElement)ciArray[i]));
            }
        }
        catch (Exception e) {
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_6053", "LM_6054", msg, "Error", false, 0, 0);
            throw new CIMException("CIM_ERR_FAILED", (Object)("Query Failed for " + this.PROVIDER_NAME + " with " + e.toString()));
        }
        CIMInstance[] ciArray = new CIMInstance[result.size()];
        result.toArray(ciArray);
        return ciArray;
    }

    public static void debug(String x) {
        try {
            FileWriter fp = new FileWriter("/tmp/debug2", true);
            fp.write("\nDEBUG: = " + x);
            fp.flush();
            fp.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

