/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.printer;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.printer.PrtBuff;
import com.sun.wbem.utility.log.LogUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.InstanceProvider;

public class Solaris_QueueForPrintService
implements InstanceProvider,
Authorizable {
    private CIMOMHandle cimomhandle = null;
    private String prtList = null;
    private String dummy = null;
    LogUtil logUtil = null;
    private ProviderUtility prov_util = null;
    private String PROVIDER_NAME = "Solaris_QueueForPrintService";
    PrtBuff prtbuff = new PrtBuff();
    public static final String PRINTER_MODIFY_RIGHT = "solaris.admin.printer.modify";
    public static final String PRINTER_DELETE_RIGHT = "solaris.admin.printer.delete";
    public static final String PRINTER_READ_RIGHT = "solaris.admin.printer.read";

    public void initialize(CIMOMHandle cimomhandle) throws CIMException {
        this.cimomhandle = cimomhandle;
        this.logUtil = LogUtil.getInstance((CIMOMHandle)cimomhandle);
        this.prov_util = new ProviderUtility(cimomhandle, this.PROVIDER_NAME);
    }

    public void cleanup() throws CIMException {
    }

    public CIMObjectPath createInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void deleteInstance(CIMObjectPath op) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void setInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
        CIMObjectPath prt_queue = null;
        CIMObjectPath p_service = null;
        String[] msg = new String[]{"getInstance for QueueForPrintService"};
        try {
            Enumeration e = op.getKeys().elements();
            while (e.hasMoreElements()) {
                CIMProperty cp = (CIMProperty)e.nextElement();
                if (cp.getName().equalsIgnoreCase("Antecedent")) {
                    p_service = (CIMObjectPath)cp.getValue().getValue();
                }
                if (!cp.getName().equalsIgnoreCase("Dependent")) continue;
                prt_queue = (CIMObjectPath)cp.getValue().getValue();
            }
            CIMInstance ci = cc.newInstance();
            ci.setProperty("Antecedent", new CIMValue(prt_queue));
            ci.setProperty("Dependent", new CIMValue((Object)p_service));
            boolean accepting = false;
            String Q_name = Solaris_QueueForPrintService.parseQueueOBJ(prt_queue.toString(), "DeviceID=");
            accepting = Solaris_QueueForPrintService.IsQueueAccepting(Q_name);
            ci.setProperty("QueueAcceptingFromService", new CIMValue((Object)new Boolean(accepting)));
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_9437", "LM_9438", msg, "Success", false, 0, 0);
            if (localOnly) {
                ci = ci.localElements();
            }
            return ci.filterProperties(propList, includeQualifiers, includeClassOrigin);
        }
        catch (Exception e) {
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_9439", "LM_9440", msg, "Error", false, 0, 0);
            throw new CIMException("CIM_ERR_FAILED", (Object)"getInstance Failed");
        }
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
        Vector<CIMInstance> printSvcQ = new Vector<CIMInstance>();
        String[] msg = new String[]{"enumerating Instances for QueueForPrintService"};
        try {
            this.prtbuff.createPrtFile();
            int num_lines = this.prtbuff.getNumPrinters();
            for (int lines = 0; lines < num_lines; ++lines) {
                CIMInstance ci = cc.newInstance();
                CIMObjectPath p_service = new CIMObjectPath("Solaris_PrintService");
                CIMObjectPath prt_queue = new CIMObjectPath("Solaris_PrintQueue");
                CIMObjectPath p_service_cop = new CIMObjectPath(p_service.getObjectName(), p_service.getNameSpace());
                CIMObjectPath prt_queue_cop = new CIMObjectPath(prt_queue.getObjectName(), prt_queue.getNameSpace());
                this.prtList = this.prtbuff.getPrinter(lines);
                p_service_cop.addKey("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                try {
                    p_service_cop.addKey("DeviceID", new CIMValue((Object)this.prtList));
                }
                catch (Exception e) {
                    throw new CIMException("CIM_ERR_FAILED", (Object)e);
                }
                p_service_cop.addKey("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                try {
                    p_service_cop.addKey("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
                }
                catch (Exception e) {
                    // empty catch block
                }
                p_service_cop.addKey("CreationClassName", new CIMValue((Object)"Solaris_PrintService"));
                prt_queue_cop.addKey("Name", new CIMValue((Object)this.prtList));
                ci.setProperty("Antecedent", new CIMValue((Object)prt_queue_cop));
                ci.setProperty("Dependent", new CIMValue((Object)p_service_cop));
                if (localOnly) {
                    ci = ci.localElements();
                }
                printSvcQ.addElement(ci.filterProperties(propList, includeQualifiers, includeClassOrigin));
            }
            CIMInstance[] ciArray = new CIMInstance[printSvcQ.size()];
            printSvcQ.toArray(ciArray);
            return ciArray;
        }
        catch (Exception e) {
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_9439", "LM_9440", msg, "Error", false, 0, 0);
            throw new CIMException("CIM_ERR_FAILED", (Object)"Enumerate Instances Failed");
        }
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath op, CIMClass cc) throws CIMException {
        Vector<CIMObjectPath> printSvcQ = new Vector<CIMObjectPath>();
        String[] msg = new String[]{"Enumerating Instances for QueueForPrintService"};
        try {
            this.prtbuff.createPrtFile();
            int num_lines = this.prtbuff.getNumPrinters();
            for (int lines = 0; lines < num_lines; ++lines) {
                CIMObjectPath cop = new CIMObjectPath(op.getObjectName(), op.getNameSpace());
                CIMObjectPath p_service = new CIMObjectPath("Solaris_PrintService");
                CIMObjectPath prt_queue = new CIMObjectPath("Solaris_PrintQueue");
                CIMObjectPath p_service_cop = new CIMObjectPath(p_service.getObjectName(), p_service.getNameSpace());
                CIMObjectPath prt_queue_cop = new CIMObjectPath(prt_queue.getObjectName(), prt_queue.getNameSpace());
                this.prtList = this.prtbuff.getPrinter(lines);
                p_service_cop.addKey("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                try {
                    p_service_cop.addKey("DeviceID", new CIMValue((Object)this.prtList));
                }
                catch (Exception e) {
                    throw new CIMException("CIM_ERR_FAILED", (Object)e);
                }
                try {
                    p_service_cop.addKey("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
                }
                catch (Exception e) {
                    // empty catch block
                }
                p_service_cop.addKey("CreationClassName", new CIMValue((Object)"Solaris_PrintService"));
                prt_queue_cop.addKey("Name", new CIMValue((Object)this.prtList));
                cop.addKey("Antecedent", new CIMValue((Object)prt_queue_cop));
                cop.addKey("Dependent", new CIMValue((Object)p_service_cop));
                printSvcQ.addElement(cop);
            }
            CIMObjectPath[] copArray = new CIMObjectPath[printSvcQ.size()];
            printSvcQ.toArray(copArray);
            return copArray;
        }
        catch (Exception e) {
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_9439", "LM_9440", msg, "Error", false, 0, 0);
            throw new CIMException("CIM_ERR_FAILED", (Object)"Enumerate Instances Failed");
        }
    }

    public static boolean IsQueueAccepting(String Q_name) {
        String Q_file = "/usr/sadm/mof/qready.out";
        String buff = null;
        try {
            int c;
            Process p1 = Runtime.getRuntime().exec("lpstat -a " + Q_name);
            InputStream in = p1.getInputStream();
            FileWriter fp = new FileWriter(Q_file, false);
            BufferedReader q_in = new BufferedReader(new FileReader(Q_file));
            while ((c = in.read()) != -1) {
                fp.write((char)c);
            }
            fp.flush();
            fp.close();
            in.close();
            buff = q_in.readLine();
            if (buff != null) {
                if (buff.indexOf("not", 0) > 0) {
                    q_in.close();
                    File f = new File(Q_file);
                    if (f.exists()) {
                        f.delete();
                    }
                    return false;
                }
                q_in.close();
                File f = new File(Q_file);
                if (f.exists()) {
                    f.delete();
                }
                return true;
            }
        }
        catch (IOException e) {
            System.err.println(e);
        }
        return false;
    }

    public static String parseQueueOBJ(String prtBuff, String value) {
        int Q_idx = prtBuff.indexOf(value, 0);
        int len = value.length();
        String Q = null;
        String Q2 = null;
        Q = prtBuff.substring(Q_idx + len, Q_idx + len + 16);
        Q_idx = Q.indexOf(":");
        Q = Q.substring(0, Q_idx);
        Q2 = Q.replace('\"', ' ');
        Q2 = Q2.trim();
        return Q2;
    }

    public CIMInstance[] execQuery(CIMObjectPath op, String query, String ql, CIMClass cc) {
        return null;
    }
}

