/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.printer;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.printer.PrtBuff;
import com.sun.wbem.solarisprovider.printer.Solaris_PrtNative;
import com.sun.wbem.utility.log.LogUtil;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.InstanceProvider;

public class Solaris_Printer
implements InstanceProvider,
Authorizable {
    private CIMOMHandle cimomhandle = null;
    private String prtList = null;
    private String dummy = null;
    LogUtil logUtil = null;
    private ProviderUtility prov_util = null;
    private String PROVIDER_NAME = "Solaris_Printer";
    PrtBuff prtbuff = new PrtBuff();
    public static final String PRINTER_MODIFY_RIGHT = "solaris.admin.printer.modify";
    public static final String PRINTER_DELETE_RIGHT = "solaris.admin.printer.delete";
    public static final String PRINTER_READ_RIGHT = "solaris.admin.printer.read";

    public void initialize(CIMOMHandle cimomhandle) throws CIMException {
        this.cimomhandle = cimomhandle;
        this.logUtil = LogUtil.getInstance((CIMOMHandle)cimomhandle);
        this.prov_util = new ProviderUtility(cimomhandle, this.PROVIDER_NAME);
    }

    public void cleanup() throws CIMException {
    }

    public CIMObjectPath createInstance(CIMObjectPath cop, CIMInstance ci) throws CIMException {
        this.prov_util.checkRights(PRINTER_MODIFY_RIGHT, cop);
        String prtName = null;
        String description = null;
        String printserver = null;
        boolean default_prn = false;
        try {
            prtName = (String)ci.getProperty("DeviceID").getValue().getValue();
        }
        catch (Exception ex) {
            String[] printer = new String[]{prtName};
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_9406", "LM_9407", printer, null, false, 0, 2);
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)prtName);
        }
        try {
            description = (String)ci.getProperty("Description").getValue().getValue();
        }
        catch (Exception e) {
            description = "Added_via_WBEM";
        }
        try {
            printserver = (String)ci.getProperty("PrintServer").getValue().getValue();
        }
        catch (Exception e) {
            try {
                InetAddress host = InetAddress.getLocalHost();
                printserver = host.getHostName();
            }
            catch (Exception ee) {
                throw new CIMException("CIM_ERR_FAILED", (Object)ee);
            }
            try {
                default_prn = (Boolean)ci.getProperty("DefaultPrinter").getValue().getValue();
            }
            catch (Exception ee) {
                default_prn = false;
            }
            try {
                boolean create_ok = this.prtbuff.addQ(prtName, printserver, description, default_prn);
                if (!create_ok) {
                    String[] printer = new String[]{prtName};
                    this.logUtil.writeLog(this.PROVIDER_NAME, "LM_9406", "LM_9407", printer, "Error", false, 0, 0);
                    throw new CIMException("CIM_ERR_FAILED", (Object)"Create Printer Failed");
                }
                String[] printer = new String[]{prtName};
                this.logUtil.writeLog(this.PROVIDER_NAME, "LM_9404", "LM_9405", printer, "Success", false, 0, 0);
            }
            catch (Exception ee) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)e);
            }
        }
        return cop;
    }

    public void deleteInstance(CIMObjectPath cop) throws CIMException {
        String del_prt = null;
        this.prov_util.checkRights(PRINTER_DELETE_RIGHT, cop);
        Enumeration e = cop.getKeys().elements();
        while (e.hasMoreElements()) {
            CIMProperty cp = (CIMProperty)e.nextElement();
            if (!cp.getName().equalsIgnoreCase("DeviceID")) continue;
            del_prt = (String)cp.getValue().getValue();
        }
        try {
            String[] printer;
            if (!this.prtbuff.delPrinter(del_prt)) {
                printer = new String[]{del_prt};
                this.logUtil.writeLog(this.PROVIDER_NAME, "LM_9402", "LM_9402", printer, "Error", false, 0, 0);
                throw new CIMException("CIM_ERR_FAILED", (Object)"Delete Failed");
            }
            printer = new String[]{del_prt};
            this.logUtil.writeLog("Solaris_Printer", "LM_9400", "LM_9401", printer, "Success", false, 0, 0);
        }
        catch (Exception e2) {
            throw new CIMException("CIM_ERR_FAILED", (Object)e2);
        }
    }

    public void setInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        try {
            this.prov_util.checkRights(PRINTER_MODIFY_RIGHT, op);
            String[] msg = new String[]{"set Instance"};
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_9420", "LM_9420", msg, "Error", false, 0, 0);
            throw new CIMException("CIM_ERR_FAILED", (Object)"Set Instance Failed");
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }
    }

    public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
        String[] msg = new String[]{"getInstance for Solaris_Printer"};
        String pserver = null;
        boolean localPrinter = false;
        boolean defaultPrinter = false;
        try {
            Enumeration e = op.getKeys().elements();
            while (e.hasMoreElements()) {
                CIMProperty cp = (CIMProperty)e.nextElement();
                if (!cp.getName().equalsIgnoreCase("DeviceID")) continue;
                this.prtList = (String)cp.getValue().getValue();
            }
            CIMInstance ci = cc.newInstance();
            ci.setProperty("DeviceID", new CIMValue((Object)this.prtList));
            ci.setProperty("Name", new CIMValue((Object)this.prtList));
            String stat = Solaris_PrtNative.getPrtStat(this.prtList, "Description");
            ci.setProperty("PrinterStatus", new CIMValue((Object)new UnsignedInt16(stat)));
            ci.setProperty("Description", new CIMValue((Object)Solaris_PrtNative.getInfo(this.prtList, "Description")));
            ci.setProperty("Status", new CIMValue((Object)Solaris_PrtNative.getInfo(this.prtList, "Status")));
            ci.setProperty("Caption", new CIMValue((Object)Solaris_PrtNative.getInfo(this.prtList, "Caption")));
            ci.setProperty("DetectedErrorState", new CIMValue((Object)new UnsignedInt16(2)));
            pserver = this.prtbuff.getPrintServer(this.prtList);
            ci.setProperty("PrintServer", new CIMValue((Object)pserver));
            if (pserver.equalsIgnoreCase(InetAddress.getLocalHost().getHostName())) {
                localPrinter = true;
            }
            ci.setProperty("LocalPrinter", new CIMValue((Object)new Boolean(localPrinter)));
            defaultPrinter = this.prtbuff.getDefaultPrt(this.prtList);
            ci.setProperty("DefaultPrinter", new CIMValue((Object)new Boolean(defaultPrinter)));
            ci.setProperty("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
            try {
                ci.setProperty("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
            }
            catch (Exception ex) {
                throw new CIMException("CIM_ERR_FAILED");
            }
            ci.setProperty("CreationClassName", new CIMValue((Object)"Solaris_Printer"));
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_9421", "LM_9422", msg, "Success", false, 0, 0);
            if (localOnly) {
                ci = ci.localElements();
            }
            return ci.filterProperties(propList, includeQualifiers, includeClassOrigin);
        }
        catch (Exception e) {
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_9420", "LM_9420", msg, "Error", false, 0, 0);
            throw new CIMException("CIM_ERR_FAILED", (Object)"getInstance Failed");
        }
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
        String[] msg = new String[]{"Enumerating Printers for Solaris_Printer"};
        String pserver = null;
        boolean localPrinter = false;
        boolean defaultPrinter = false;
        try {
            Vector<CIMInstance> printInstances = new Vector<CIMInstance>();
            this.prtbuff.createPrtFile();
            int num_lines = this.prtbuff.getNumPrinters();
            for (int lines = 0; lines < num_lines; ++lines) {
                CIMInstance ci = cc.newInstance();
                this.prtList = this.prtbuff.getPrinter(lines);
                ci.setProperty("DeviceID", new CIMValue((Object)this.prtList));
                ci.setProperty("Name", new CIMValue((Object)this.prtList));
                String stat = Solaris_PrtNative.getPrtStat(this.prtList, "Description");
                ci.setProperty("PrinterStatus", new CIMValue((Object)new UnsignedInt16(stat)));
                ci.setProperty("Description", new CIMValue((Object)Solaris_PrtNative.getInfo(this.prtList, "Description")));
                ci.setProperty("Status", new CIMValue((Object)Solaris_PrtNative.getInfo(this.prtList, "Status")));
                ci.setProperty("Caption", new CIMValue((Object)Solaris_PrtNative.getInfo(this.prtList, "Caption")));
                ci.setProperty("DetectedErrorState", new CIMValue((Object)new UnsignedInt16(2)));
                ci.setProperty("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                ci.setProperty("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
                ci.setProperty("CreationClassName", new CIMValue((Object)"Solaris_Printer"));
                pserver = this.prtbuff.getPrintServer(this.prtList);
                ci.setProperty("PrintServer", new CIMValue((Object)pserver));
                if (pserver.equalsIgnoreCase(InetAddress.getLocalHost().getHostName())) {
                    localPrinter = true;
                }
                ci.setProperty("LocalPrinter", new CIMValue((Object)new Boolean(localPrinter)));
                defaultPrinter = this.prtbuff.getDefaultPrt(this.prtList);
                ci.setProperty("DefaultPrinter", new CIMValue((Object)new Boolean(defaultPrinter)));
                if (localOnly) {
                    ci = ci.localElements();
                }
                printInstances.addElement(ci.filterProperties(propList, includeQualifiers, includeClassOrigin));
            }
            CIMInstance[] ciArray = new CIMInstance[printInstances.size()];
            printInstances.toArray(ciArray);
            return ciArray;
        }
        catch (Exception e) {
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_9421", "LM_9422", msg, "Error", false, 0, 0);
            throw new CIMException("CIM_ERR_FAILED", (Object)"Enumerate Instances Failed");
        }
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath op, CIMClass cc) throws CIMException {
        String[] msg = new String[]{"Enumerating Printers for Solaris_Printer"};
        try {
            Vector<CIMObjectPath> printInstances = new Vector<CIMObjectPath>();
            this.prtbuff.createPrtFile();
            int num_lines = this.prtbuff.getNumPrinters();
            for (int lines = 0; lines < num_lines; ++lines) {
                CIMObjectPath cop = new CIMObjectPath(op.getObjectName(), op.getNameSpace());
                try {
                    this.prtList = this.prtbuff.getPrinter(lines);
                    cop.addKey("DeviceID", new CIMValue((Object)this.prtList));
                }
                catch (Exception e) {
                    throw new CIMException("CIM_ERR_FAILED", (Object)e);
                }
                cop.addKey("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                try {
                    cop.addKey("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
                }
                catch (Exception e) {
                    // empty catch block
                }
                cop.addKey("CreationClassName", new CIMValue((Object)"Solaris_Printer"));
                cop.addKey("Description", new CIMValue((Object)"Add Description"));
                printInstances.addElement(cop);
            }
            CIMObjectPath[] copArray = new CIMObjectPath[printInstances.size()];
            printInstances.toArray(copArray);
            return copArray;
        }
        catch (Exception e) {
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_9421", "LM_9422", msg, "Error", false, 0, 0);
            throw new CIMException("CIM_ERR_FAILED", (Object)"Enumerate Instances Failed");
        }
    }

    public CIMInstance[] execQuery(CIMObjectPath op, String query, String ql, CIMClass cc) {
        return null;
    }
}

