/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.printer;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.printer.PrtBuff;
import com.sun.wbem.solarisprovider.printer.Solaris_PrtNative;
import com.sun.wbem.utility.log.LogUtil;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.InstanceProvider;

public class Solaris_PrintSAP
implements InstanceProvider,
Authorizable {
    private CIMOMHandle cimomhandle = null;
    private String prtList = null;
    PrtBuff prtbuff = new PrtBuff();
    LogUtil logUtil = null;
    private ProviderUtility prov_util = null;
    private String PROVIDER_NAME = "Solaris_PrintSAP";
    public static final String PRINTER_MODIFY_RIGHT = "solaris.admin.printer.modify";
    public static final String PRINTER_DELETE_RIGHT = "solaris.admin.printer.delete";
    public static final String PRINTER_READ_RIGHT = "solaris.admin.printer.read";

    public void initialize(CIMOMHandle cimomhandle) throws CIMException {
        this.cimomhandle = cimomhandle;
        this.logUtil = LogUtil.getInstance((CIMOMHandle)cimomhandle);
        this.prov_util = new ProviderUtility(cimomhandle, this.PROVIDER_NAME);
    }

    public void cleanup() throws CIMException {
    }

    public CIMObjectPath createInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void deleteInstance(CIMObjectPath cop) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void setInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
        String[] msg = new String[]{"getInstance for PrintSAP"};
        try {
            Enumeration e = op.getKeys().elements();
            while (e.hasMoreElements()) {
                CIMProperty cp = (CIMProperty)e.nextElement();
                if (!cp.getName().equalsIgnoreCase("Name")) continue;
                this.prtList = (String)cp.getValue().getValue();
            }
            CIMInstance ci = cc.newInstance();
            ci.setProperty("Name", new CIMValue((Object)this.prtList));
            ci.setProperty("Description", new CIMValue((Object)Solaris_PrtNative.getInfo(this.prtList, "Description")));
            ci.setProperty("Status", new CIMValue((Object)Solaris_PrtNative.getInfo(this.prtList, "Status")));
            ci.setProperty("Caption", new CIMValue((Object)Solaris_PrtNative.getInfo(this.prtList, "Caption")));
            Vector<UnsignedInt16> x = new Vector<UnsignedInt16>();
            Vector<String> protocol = new Vector<String>();
            x.addElement(new UnsignedInt16(3));
            protocol.addElement(new String("Unknown"));
            protocol.addElement(new String("Other"));
            protocol.addElement(new String("SMB"));
            protocol.addElement(new String("BSD"));
            protocol.addElement(new String("SYSV"));
            protocol.addElement(new String("HPNP"));
            protocol.addElement(new String("IPP"));
            protocol.addElement(new String("Local"));
            ci.setProperty("PrintProtocol", new CIMValue(x));
            ci.setProperty("PrintProtocolInfo", new CIMValue(new Vector(protocol)));
            ci.setProperty("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
            try {
                ci.setProperty("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
            }
            catch (Exception ex) {
                // empty catch block
            }
            ci.setProperty("CreationClassName", new CIMValue((Object)"Solaris_PrintSAP"));
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_9433", "LM_9434", msg, "Success", false, 0, 0);
            if (localOnly) {
                ci = ci.localElements();
            }
            return ci.filterProperties(propList, includeQualifiers, includeClassOrigin);
        }
        catch (Exception e) {
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_9435", "LM_9436", msg, "Error", false, 0, 0);
            throw new CIMException("CIM_ERR_FAILED", (Object)"getInstance Failed");
        }
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propList, CIMClass cc) throws CIMException {
        String[] msg = new String[]{"enumerating insstances for PrintSAP"};
        try {
            Vector<CIMInstance> printInstances = new Vector<CIMInstance>();
            this.prtbuff.createPrtFile();
            int num_lines = this.prtbuff.getNumPrinters();
            for (int lines = 0; lines < num_lines; ++lines) {
                this.prtList = this.prtbuff.getPrinter(lines);
                CIMInstance ci = cc.newInstance();
                ci.setProperty("Name", new CIMValue((Object)this.prtList));
                ci.setProperty("Description", new CIMValue((Object)Solaris_PrtNative.getInfo(this.prtList, "Description")));
                ci.setProperty("Status", new CIMValue((Object)Solaris_PrtNative.getInfo(this.prtList, "Status")));
                ci.setProperty("Caption", new CIMValue((Object)Solaris_PrtNative.getInfo(this.prtList, "Caption")));
                Vector<UnsignedInt16> x = new Vector<UnsignedInt16>();
                Vector<String> protocol = new Vector<String>();
                x.addElement(new UnsignedInt16(3));
                protocol.addElement(new String("Unknown"));
                protocol.addElement(new String("Other"));
                protocol.addElement(new String("SMB"));
                protocol.addElement(new String("BSD"));
                protocol.addElement(new String("SYSV"));
                protocol.addElement(new String("HPNP"));
                protocol.addElement(new String("IPP"));
                protocol.addElement(new String("Local"));
                ci.setProperty("PrintProtocol", new CIMValue(x));
                ci.setProperty("PrintProtocolInfo", new CIMValue(new Vector(protocol)));
                ci.setProperty("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                ci.setProperty("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
                ci.setProperty("CreationClassName", new CIMValue((Object)"Solaris_PrintSAP"));
                printInstances.addElement(ci);
            }
            CIMInstance[] ciArray = new CIMInstance[printInstances.size()];
            printInstances.toArray(ciArray);
            return ciArray;
        }
        catch (Exception e) {
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_9435", "LM_9436", msg, "Error", false, 0, 0);
            throw new CIMException("CIM_ERR_FAILED", (Object)"Enumerate Instances Failed");
        }
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath op, CIMClass cc) throws CIMException {
        String[] msg = new String[]{"Enumerating instances for PrintSAP"};
        Vector<CIMObjectPath> printInstances = new Vector<CIMObjectPath>();
        try {
            this.prtbuff.createPrtFile();
            int num_lines = this.prtbuff.getNumPrinters();
            for (int lines = 0; lines < num_lines; ++lines) {
                CIMObjectPath cop = new CIMObjectPath(op.getObjectName(), op.getNameSpace());
                try {
                    this.prtList = this.prtbuff.getPrinter(lines);
                    cop.addKey("Name", new CIMValue((Object)this.prtList));
                }
                catch (Exception e) {
                    throw new CIMException("CIM_ERR_FAILED", (Object)e);
                }
                cop.addKey("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
                try {
                    cop.addKey("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
                }
                catch (Exception e) {
                    // empty catch block
                }
                cop.addKey("CreationClassName", new CIMValue((Object)"Solaris_PrintSAP"));
                printInstances.addElement(cop);
            }
            CIMObjectPath[] copArray = new CIMObjectPath[printInstances.size()];
            printInstances.toArray(copArray);
            return copArray;
        }
        catch (Exception e) {
            this.logUtil.writeLog(this.PROVIDER_NAME, "LM_9435", "LM_9436", msg, "Error", false, 0, 0);
            throw new CIMException("CIM_ERR_FAILED", (Object)"Enumerate Instances Failed");
        }
    }

    public CIMInstance[] execQuery(CIMObjectPath op, String query, String ql, CIMClass cc) {
        return null;
    }
}

