/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.perfmon;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.utility.log.LogUtil;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.CIMProviderException;
import javax.wbem.provider.InstanceProvider;

public class Solaris_CpuUtilizationPerformanceMonitor
implements InstanceProvider {
    public static final String PROVIDERNAME = "Solaris per Cpu Utilization Performance Monitor";
    public static final String CAPTION = "Solaris per Cpu Utilization Statistical Information : CpuID# ";
    private static CIMOMHandle cimomHandle = null;
    private static ProviderUtility provUtil = null;
    private LogUtil logUtil = null;

    public void initialize(CIMOMHandle cimomhandle) throws CIMException {
        cimomHandle = cimomhandle;
        this.logUtil = LogUtil.getInstance((CIMOMHandle)cimomhandle);
        try {
            provUtil = new ProviderUtility(cimomHandle, PROVIDERNAME);
        }
        catch (CIMException e) {
            throw new CIMException("CIM_ERR_FAILED");
        }
    }

    protected static CIMOMHandle getCimomHandle() {
        return cimomHandle;
    }

    protected static ProviderUtility getProviderUtil() {
        return provUtil;
    }

    public void cleanup() throws CIMException {
    }

    public CIMInstance[] execQuery(CIMObjectPath op, String query, String ql, CIMClass cc) throws CIMException {
        try {
            String[] subArgs = new String[]{"execQuery"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_9600", "LM_9603", subArgs, null, false, 0, 0);
        }
        catch (CIMException e) {
            // empty catch block
        }
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMObjectPath createInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        try {
            String[] subArgs = new String[]{"Create Instance"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_9600", "LM_9603", subArgs, null, false, 0, 0);
        }
        catch (CIMException cIMException) {
            // empty catch block
        }
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void deleteInstance(CIMObjectPath op) throws CIMException {
        try {
            String[] subArgs = new String[]{"Delete Instance"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_9600", "LM_9603", subArgs, null, false, 0, 0);
        }
        catch (CIMException cIMException) {
            // empty catch block
        }
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, CIMClass cc) throws CIMException {
        CIMObjectPath targetCpu = null;
        CIMObjectPath statisticalInfo = null;
        try {
            provUtil.checkAuthenticated();
        }
        catch (CIMException e) {
            String[] subArgs = new String[]{"getInstance"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_9600", "LM_9602", subArgs, null, false, 0, 2);
            throw new CIMException("CIM_ERR_ACCESS_DENIED");
        }
        CIMInstance ci = cc.newInstance();
        try {
            Enumeration e = op.getKeys().elements();
            while (e.hasMoreElements()) {
                CIMProperty cp = (CIMProperty)e.nextElement();
                if (cp.getName().equalsIgnoreCase("Stats")) {
                    statisticalInfo = (CIMObjectPath)cp.getValue().getValue();
                }
                if (!cp.getName().equalsIgnoreCase("Element")) continue;
                targetCpu = (CIMObjectPath)cp.getValue().getValue();
            }
            ci.setProperty("Stats", new CIMValue(statisticalInfo));
            ci.setProperty("Element", new CIMValue(targetCpu));
        }
        catch (Exception e) {
            String logMsg = this.writeLog(2, null, null, e);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)logMsg);
        }
        if (localOnly) {
            ci = ci.localElements();
        }
        return ci.filterProperties(propertyList, includeQualifiers, includeClassOrigin);
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath op, CIMClass cc) throws CIMException {
        Vector<CIMObjectPath> instances = new Vector<CIMObjectPath>();
        try {
            provUtil.checkAuthenticated();
        }
        catch (CIMException e) {
            String[] subArgs = new String[]{"enumInstances"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_9600", "LM_9602", subArgs, null, false, 0, 2);
            throw new CIMException("CIM_ERR_ACCESS_DENIED");
        }
        try {
            CIMObjectPath utilObjectPath = new CIMObjectPath("Solaris_CpuUtilizationInformation", op.getNameSpace());
            Enumeration e = cimomHandle.enumerateInstanceNames(utilObjectPath);
            if (e != null) {
                while (e.hasMoreElements()) {
                    CIMObjectPath statsInfoObjectPath = (CIMObjectPath)e.nextElement();
                    if (statsInfoObjectPath == null) continue;
                    CIMObjectPath cop = new CIMObjectPath(op.getObjectName(), op.getNameSpace());
                    cop.addKey("Stats", new CIMValue((Object)statsInfoObjectPath));
                    cop.addKey("Element", new CIMValue((Object)this.buildSolarisProcessorRef(statsInfoObjectPath)));
                    instances.addElement(cop);
                }
            }
        }
        catch (Exception e) {
            String logMsg = this.writeLog(2, null, null, e);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)logMsg);
        }
        CIMObjectPath[] copArray = new CIMObjectPath[instances.size()];
        instances.toArray(copArray);
        return copArray;
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, CIMClass cc) throws CIMException {
        Vector<CIMInstance> instances = new Vector<CIMInstance>();
        try {
            provUtil.checkAuthenticated();
        }
        catch (CIMException e) {
            String[] subArgs = new String[]{"enumInstances"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_9600", "LM_9602", subArgs, null, false, 0, 2);
            throw new CIMException("CIM_ERR_ACCESS_DENIED");
        }
        try {
            CIMObjectPath utilObjectPath = new CIMObjectPath("Solaris_CpuUtilizationInformation", op.getNameSpace());
            Enumeration e = cimomHandle.enumerateInstanceNames(utilObjectPath);
            if (e != null) {
                while (e.hasMoreElements()) {
                    CIMObjectPath statsInfoObjectPath = (CIMObjectPath)e.nextElement();
                    if (statsInfoObjectPath == null) continue;
                    CIMInstance ci = cc.newInstance();
                    ci.setProperty("Stats", new CIMValue((Object)statsInfoObjectPath));
                    ci.setProperty("Element", new CIMValue((Object)this.buildSolarisProcessorRef(statsInfoObjectPath)));
                    if (localOnly) {
                        ci = ci.localElements();
                    }
                    instances.addElement(ci.filterProperties(propertyList, includeQualifiers, includeClassOrigin));
                }
            }
        }
        catch (Exception e) {
            String logMsg = this.writeLog(2, null, null, e);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)logMsg);
        }
        CIMInstance[] ciArray = new CIMInstance[instances.size()];
        instances.toArray(ciArray);
        return ciArray;
    }

    public synchronized void setInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        try {
            String[] subArgs = new String[]{"Set Instance"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_9600", "LM_9603", subArgs, null, false, 0, 0);
        }
        catch (CIMException cIMException) {
            // empty catch block
        }
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    private String getCpuID(CIMObjectPath op) throws CIMException {
        String id = null;
        try {
            Enumeration e = op.getKeys().elements();
            while (e.hasMoreElements()) {
                CIMProperty cp = (CIMProperty)e.nextElement();
                if (!cp.getName().equalsIgnoreCase("DeviceID")) continue;
                id = (String)cp.getValue().getValue();
                break;
            }
        }
        catch (Exception e) {
            String logMsg = this.writeLog(2, null, null, e);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)logMsg);
        }
        return id;
    }

    private CIMObjectPath buildSolarisProcessorRef(CIMObjectPath op) throws CIMProviderException {
        CIMObjectPath cpuObjectPath = null;
        try {
            cpuObjectPath = new CIMObjectPath("Solaris_Processor", op.getNameSpace());
            cpuObjectPath.addKey("DeviceID", new CIMValue((Object)this.getCpuID(op)));
            cpuObjectPath.addKey("CreationClassName", new CIMValue((Object)"Solaris_Processor"));
            cpuObjectPath.addKey("SystemName", new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
            cpuObjectPath.addKey("SystemCreationClassName", new CIMValue((Object)"Solaris_ComputerSystem"));
        }
        catch (Exception e) {
            String logMsg = this.writeLog(2, null, null, e);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)logMsg);
        }
        return cpuObjectPath;
    }

    protected String writeLog(int severity, String msgID, String[] subArg, Exception pex) {
        String retStr = null;
        String msg = null;
        boolean syslog = false;
        try {
            msg = pex.getLocalizedMessage();
            this.logUtil.writeLog(PROVIDERNAME, "LM_9600", msgID, subArg, msg, syslog, 0, severity);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (msgID != null) {
            retStr = this.logUtil.getLocalizedMessage(msgID, subArg);
            retStr = retStr + " " + msg;
        } else {
            retStr = msg;
        }
        return retStr;
    }
}

