/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.patch;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.patch.PProUtil;
import com.sun.wbem.solarisprovider.patch.PatchException;
import com.sun.wbem.solarisprovider.patch.PatchPkgInfo;
import com.sun.wbem.solarisprovider.patch.SolarisPatchObj;
import com.sun.wbem.solarisprovider.patch.SolarisPatchUtil;
import com.sun.wbem.solarisprovider.patch.SpooledPatchInfo;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import javax.wbem.cim.CIMDateTime;

public class SolarisPatchInfo {
    private static final String patchaddCmd = "/usr/sbin/patchadd";
    private static final String patchrmCmd = "/usr/sbin/patchrm";
    private static final String cpCmd = "/usr/bin/cp";
    private static final String rmCmd = "/usr/bin/rm";
    private static final String rmOption = "-rf";
    private static final String displayOpt = "-p";
    private static final String RECONFIGURE_FILE = "/reconfigure";
    private static final String JAR_EXT = ".jar";
    private static final String TMP = "/var/tmp";
    private static final String TMP_DIR_SUFFIX = ".Solaris_Patch.tmp";
    public static final String SYNOPSIS = "Synopsis";
    public static final String RELEASE_DATE = "Date";
    public static final String ARCH = "Relevant Architectures";
    public static final String SOLARIS_RELEASE = "Solaris Release";
    public static final String SUNOS_RELEASE = "SunOS Release";
    public static final String SUNOS_RELEASE_2 = "SunOS release";
    public static final String REQUIRED_PATCHES = "Patches required with this patch";
    public static final String CONFLICTING_PATCHES = "Patches which conflict with this patch";
    public static final String OBSOLETED_PATCHES = "Patches accumulated and obsoleted by this patch";
    private static final String NOT_AVAILABLE = "Not Available";
    private ProviderUtility provUtil;

    public SolarisPatchInfo(ProviderUtility provUtil) {
        this.provUtil = provUtil;
    }

    public Vector getPatchListData() throws PatchException {
        try {
            Vector<SolarisPatchObj> patchList = new Vector<SolarisPatchObj>();
            String[] patchListArr = new String[]{patchaddCmd, displayOpt};
            SolarisPatchUtil spu = new SolarisPatchUtil(this.provUtil);
            Vector result = spu.execScript(patchListArr);
            String[] stdout = (String[])result.elementAt(0);
            for (int i = 0; i < stdout.length; ++i) {
                if (!stdout[i].startsWith("Patch:")) continue;
                patchList.addElement(this.formPatchObj(stdout[i]));
            }
            return patchList;
        }
        catch (PatchException pe) {
            throw pe;
        }
        catch (Exception e) {
            this.provUtil.writeLog(2, "LM_8850", "LM_8851", null, null, null, null, null);
            throw new PatchException("EXM_PATCHLIST_ERR");
        }
    }

    public SolarisPatchObj getPatchData(String patchName) throws PatchException {
        try {
            Vector patchList = new Vector();
            String[] patchListArr = new String[]{patchaddCmd, displayOpt};
            SolarisPatchUtil spu = new SolarisPatchUtil(this.provUtil);
            Vector result = spu.execScript(patchListArr);
            String[] stdout = (String[])result.elementAt(0);
            for (int i = 0; i < stdout.length; ++i) {
                SolarisPatchObj patchObj;
                if (!stdout[i].startsWith("Patch:") || !(patchObj = spu.parseLine(stdout[i])).getPatchName().equals(patchName)) continue;
                return this.formPatchObj(stdout[i]);
            }
            return null;
        }
        catch (PatchException pe) {
            throw pe;
        }
        catch (Exception e) {
            this.provUtil.writeLog(2, "LM_8850", "LM_8851", null, null, null, null, null);
            throw new PatchException("EXM_PATCHLIST_ERR");
        }
    }

    private SolarisPatchObj formPatchObj(String patchData) throws PatchException {
        String pkgName;
        SolarisPatchUtil spu = new SolarisPatchUtil(this.provUtil);
        SolarisPatchObj patchObj = spu.parseLine(patchData);
        String patchName = patchObj.getPatchName();
        String patchBackOut = spu.getPatchBackoutDir(patchName, pkgName = (String)patchObj.getPackages().elementAt(0));
        if (patchBackOut != null) {
            patchObj.setBackoutDir(patchBackOut);
        } else {
            patchObj.setBackUpFiles(false);
        }
        Date date = spu.getPatchInstallDate(patchName);
        if (date != null) {
            CIMDateTime CIMInstallDate = new CIMDateTime(date);
            patchObj.setInstallDate(CIMInstallDate);
        }
        StringBuffer patchREADMEFile = new StringBuffer(50);
        patchREADMEFile.append("/var/sadm/patch");
        patchREADMEFile.append("/");
        patchREADMEFile.append(patchName);
        patchREADMEFile.append("/");
        patchREADMEFile.append("README");
        patchREADMEFile.append(".");
        patchREADMEFile.append(patchName);
        Vector readmeInfo = spu.contentsOfReadmeFile(patchREADMEFile.toString());
        if (readmeInfo != null) {
            String synopsis = PatchPkgInfo.getInfoValue(readmeInfo, SYNOPSIS);
            patchObj.setDescription(synopsis);
            String releaseDate = PatchPkgInfo.getInfoValue(readmeInfo, RELEASE_DATE);
            Calendar cal = spu.convertDate(releaseDate);
            if (cal != null) {
                CIMDateTime CIMReleaseDate = new CIMDateTime(cal);
                patchObj.setReleaseDate(CIMReleaseDate);
            }
            String arch = PatchPkgInfo.getInfoValue(readmeInfo, ARCH);
            patchObj.setArchitecture(arch);
            String solarisRel = PatchPkgInfo.getInfoValue(readmeInfo, SOLARIS_RELEASE);
            patchObj.setSolRelease(solarisRel);
            String sunosRel = PatchPkgInfo.getInfoValue(readmeInfo, SUNOS_RELEASE);
            if (sunosRel.equals("")) {
                sunosRel = PatchPkgInfo.getInfoValue(readmeInfo, SUNOS_RELEASE_2);
                patchObj.setSunOSRelease(sunosRel);
            } else {
                patchObj.setSunOSRelease(sunosRel);
            }
        } else {
            patchObj.setDescription(NOT_AVAILABLE);
        }
        return patchObj;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int addPatch(SolarisPatchObj patchObj) throws PatchException {
        int n;
        block14: {
            String[] cmd;
            String tmpDir = null;
            SolarisPatchUtil spu = new SolarisPatchUtil(this.provUtil);
            SpooledPatchInfo spi = new SpooledPatchInfo(this.provUtil);
            try {
                Vector result;
                File patchFile = new File(patchObj.getPatchDirName() + File.separator + patchObj.getPatchName() + JAR_EXT);
                if (patchFile.exists() && patchFile.isFile()) {
                    tmpDir = TMP + File.separator + patchFile.getName() + TMP_DIR_SUFFIX;
                    if (!new File(tmpDir).mkdir()) {
                        throw new PatchException("EXM_TMP_DIR_CREATE", tmpDir, patchObj.getPatchName());
                    }
                    cmd = new String[]{cpCmd, patchFile.getAbsolutePath(), tmpDir};
                    result = spu.execScript(cmd);
                    Integer exitValue = (Integer)result.elementAt(2);
                    if (exitValue != 0) {
                        throw new PatchException("EXM_PATCH_JAR_COPY", patchObj.getPatchName(), tmpDir);
                    }
                    PProUtil.unjarFiles(tmpDir, patchObj.getPatchName());
                    patchObj.setPatchDirName(tmpDir);
                }
                result = spu.execScript(patchObj.patchAddCmd());
                int err = 1;
                String[] stdout = null;
                if (result != null && result.size() > 0) {
                    stdout = (String[])result.elementAt(0);
                    Integer exitValue = (Integer)result.elementAt(2);
                    err = exitValue;
                }
                String msg = "";
                for (int i = 0; i < stdout.length; ++i) {
                    msg = msg + stdout[i];
                }
                if (err > 0) {
                    this.provUtil.writeLog(2, "LM_8810", "LM_8811", patchObj.getPatchName(), msg, null, null, null);
                    throw new PatchException("EXM_PATCH_ADD_ERR", patchObj.getPatchName(), msg);
                }
                if (err == 0) {
                    boolean reconfigure = spi.isReconfigNeeded(patchObj);
                    if (reconfigure) {
                        this.createReconfigFile();
                    }
                    this.provUtil.writeLog(0, "LM_8812", "LM_8813", patchObj.getPatchName(), msg, null, null, null);
                }
                n = err;
                if (tmpDir == null) break block14;
            }
            catch (PatchException pe) {
                try {
                    throw pe;
                    catch (Exception e) {
                        this.provUtil.writeLog(2, "LM_8810", "LM_8814", null, null, null, null, null);
                        throw new PatchException("EXM_PATCH_DIE");
                    }
                }
                catch (Throwable throwable) {
                    if (tmpDir != null) {
                        String[] cmd2 = new String[]{rmCmd, rmOption, tmpDir};
                        spu.execScript(cmd2);
                    }
                    throw throwable;
                }
            }
            cmd = new String[]{rmCmd, rmOption, tmpDir};
            spu.execScript(cmd);
        }
        return n;
    }

    public int removePatch(String patchName) throws PatchException {
        try {
            SolarisPatchUtil spu = new SolarisPatchUtil(this.provUtil);
            String[] patchListArr = new String[]{patchrmCmd, patchName};
            Vector result = spu.execScript(patchListArr);
            int err = 1;
            String[] stdout = null;
            if (result != null && result.size() > 0) {
                stdout = (String[])result.elementAt(0);
                Integer exitValue = (Integer)result.elementAt(2);
                err = exitValue;
            }
            String msg = "";
            for (int i = 0; i < stdout.length; ++i) {
                msg = msg + stdout[i];
            }
            if (err > 0) {
                this.provUtil.writeLog(2, "LM_8815", "LM_8816", patchName, msg, null, null, null);
                throw new PatchException("EXM_PATCH_REMOVE_ERR", patchName, msg);
            }
            if (err == 0) {
                this.provUtil.writeLog(0, "LM_8817", "LM_8818", patchName, msg, null, null, null);
            }
            return err;
        }
        catch (PatchException pe) {
            throw pe;
        }
        catch (Exception e) {
            this.provUtil.writeLog(2, "LM_8815", "LM_8819", null, null, null, null, null);
            throw new PatchException("EXM_PATCH_DIE");
        }
    }

    private boolean createReconfigFile() throws PatchException {
        File f = new File(RECONFIGURE_FILE);
        try {
            return f.createNewFile();
        }
        catch (IOException e) {
            throw new PatchException("EXM_FAIL_TO_CREATE", RECONFIGURE_FILE, e.getMessage());
        }
    }
}

