/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.patch;

import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.model.PatchPropertyException;
import com.sun.patchpro.model.PatchPropertyNotFoundException;
import com.sun.patchpro.model.PropertyInfo;
import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.patch.PatchException;

public class PatchConfigUtility {
    private PatchProProperties properties;
    private ProviderUtility provUtil;

    PatchConfigUtility(ProviderUtility provUtil) {
        this.provUtil = provUtil;
        this.properties = PatchProProperties.getInstance();
    }

    PropertyInfo[] getPropertyInfos(String[] keys) throws PatchException {
        try {
            return this.properties.getPropertyInfos(keys);
        }
        catch (PatchPropertyException e) {
            this.provUtil.writeLog(2, (Exception)((Object)e));
            throw new PatchException(e.getLocalizedMessage());
        }
    }

    PropertyInfo getPropertyInfo(String key) throws PatchException {
        try {
            return this.properties.getPropertyInfo(key);
        }
        catch (PatchPropertyNotFoundException e) {
            return null;
        }
        catch (PatchPropertyException e) {
            this.provUtil.writeLog(2, (Exception)((Object)e));
            throw new PatchException(e.getLocalizedMessage());
        }
    }

    PropertyInfo[] getAllPropertyInfos() throws PatchException {
        try {
            return this.properties.getAllPropertyInfos();
        }
        catch (PatchPropertyException e) {
            this.provUtil.writeLog(2, (Exception)((Object)e));
            throw new PatchException(e.getLocalizedMessage());
        }
    }

    void unSetProperty(String key) throws PatchException {
        try {
            this.properties.unUpdateProperty(key);
        }
        catch (PatchPropertyException e) {
            throw new PatchException(e.getLocalizedMessage());
        }
    }

    void setProperty(String propertyName, String value) throws PatchException {
        try {
            this.properties.update(propertyName, value);
        }
        catch (PatchPropertyException e) {
            this.provUtil.writeLog(2, (Exception)((Object)e));
            throw new PatchException(e.getLocalizedMessage());
        }
    }

    void cleanup() {
        PatchProProperties.freeInstance();
    }
}

