/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.patch;

import com.sun.patchpro.patch.NoSuchPatchException;
import com.sun.patchpro.patch.Patch;
import com.sun.patchpro.patch.PatchID;
import com.sun.patchpro.patch.PatchList;
import com.sun.wbem.solarisprovider.patch.PPro;
import com.sun.wbem.solarisprovider.patch.PatchException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.wbem.client.Debug;

public class PProUtil {
    public static final String DEF_DOWNLOAD_DIR = "/var/tmp/ppro-patches";
    public static final String VAR_TMP = "/var/tmp";
    private static final String JAR_EXT = ".jar";
    private static final String README_FILE = "README";
    private static final String PKGINFO_FILE = "pkginfo";
    private static final String DIPATCH_FILE = ".diPatch";
    private static final String[] EXECUTABLES = new String[]{"prepatch", "prePatch", "postpatch", "prebackout", "postbackout", "installpatch", "backoutpatch", "download32", "download64", "download", "install", "install_patch", "t3.sh", "t4.sh"};
    private static final String[] NONPRIV_READABLES = new String[]{"checkinstall", "request", "patch_checkinstall"};
    private static final String[] NOT_CONTENT = new String[]{"META-INF/", ".file_attributes.SunOS", ".file_attributes.linux"};

    protected static void extractSignedPatches(PatchList pl, String targetDir) throws PatchException {
        try {
            Patch patch = null;
            String patchID = "";
            int plSize = pl != null ? pl.size() : 0;
            for (int i = 0; i < plSize; ++i) {
                patch = pl.getPatchAt(i);
                patchID = patch.getPatchID().getPatchID();
                PProUtil.unjarFiles(targetDir, patchID);
            }
        }
        catch (PatchException pex) {
            throw pex;
        }
        catch (Exception ex) {
            if (PPro.provUtil != null) {
                PPro.provUtil.writeLog(2, ex);
            }
            throw new PatchException(ex.getLocalizedMessage());
        }
    }

    static void extractPatchInfoFiles(String sourceDir, String targetDir, String patchId) throws PatchException {
        String patchJar = sourceDir + File.separator + patchId + JAR_EXT;
        File patchJarFile = new File(patchJar);
        if (!patchJarFile.exists()) {
            return;
        }
        FileOutputStream fout = null;
        InputStream is = null;
        byte[] buffer = new byte[16384];
        try {
            JarFile jf = new JarFile(patchJarFile, false);
            Enumeration<JarEntry> entries = jf.entries();
            while (entries.hasMoreElements()) {
                JarEntry je = entries.nextElement();
                String entryName = je.getName();
                if (!PProUtil.isContent(entryName) || !entryName.endsWith(DIPATCH_FILE) && !entryName.endsWith(PKGINFO_FILE) && !entryName.endsWith("README." + patchId)) continue;
                String jarEntryFileName = targetDir + File.separator + entryName;
                File jarEntryF = new File(jarEntryFileName);
                if (je.isDirectory()) {
                    if (!jarEntryF.exists()) {
                        jarEntryF.mkdirs();
                    }
                } else {
                    File jarEntryParentF = jarEntryF.getParentFile();
                    if (jarEntryParentF != null) {
                        jarEntryParentF.mkdirs();
                    }
                    if (!jarEntryF.exists()) {
                        jarEntryF.createNewFile();
                    }
                    fout = new FileOutputStream(jarEntryFileName);
                    is = jf.getInputStream(je);
                    int bytesread = 0;
                    while ((bytesread = is.read(buffer, 0, buffer.length)) != -1) {
                        fout.write(buffer, 0, bytesread);
                    }
                    is.close();
                    fout.close();
                    if (PProUtil.isNonprivReadable(je.getName())) {
                        PProUtil.setReadable(jarEntryFileName);
                    }
                }
                jarEntryF = null;
                is = null;
                fout = null;
            }
        }
        catch (IOException ex) {
            throw new PatchException("EXM_DL_PROCESSING", patchId, sourceDir, ex.getLocalizedMessage());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e) {}
            }
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (Exception e) {}
            }
        }
    }

    static void unjarFiles(String sourceDir, String targetDir, String patchId, boolean deleteJar) throws PatchException {
        StringBuffer sourceJar = new StringBuffer(50);
        sourceJar.append(sourceDir);
        sourceJar.append(File.separatorChar);
        sourceJar.append(patchId);
        sourceJar.append(JAR_EXT);
        File patchJar = new File(sourceJar.toString());
        if (!patchJar.exists()) {
            return;
        }
        FileOutputStream fout = null;
        InputStream is = null;
        byte[] buffer = new byte[16384];
        try {
            JarFile jf = new JarFile(patchJar, false);
            StringBuffer jarEntryFNBuf = new StringBuffer(50);
            Enumeration<JarEntry> entries = jf.entries();
            while (entries.hasMoreElements()) {
                JarEntry je = entries.nextElement();
                if (!PProUtil.isContent(je.getName())) continue;
                jarEntryFNBuf.setLength(0);
                jarEntryFNBuf.append(targetDir.toString());
                jarEntryFNBuf.append(File.separatorChar);
                jarEntryFNBuf.append(je.getName());
                String jarEntryFileName = jarEntryFNBuf.toString();
                File jarEntryF = new File(jarEntryFileName);
                if (je.isDirectory()) {
                    if (!jarEntryF.exists()) {
                        jarEntryF.mkdirs();
                    }
                    PProUtil.setExecutable(jarEntryFileName);
                } else {
                    File jarEntryParentF = jarEntryF.getParentFile();
                    if (jarEntryParentF != null) {
                        jarEntryParentF.mkdirs();
                    }
                    if (!jarEntryF.exists()) {
                        jarEntryF.createNewFile();
                    }
                    fout = new FileOutputStream(jarEntryFileName);
                    is = jf.getInputStream(je);
                    int bytesread = 0;
                    while ((bytesread = is.read(buffer, 0, buffer.length)) != -1) {
                        fout.write(buffer, 0, bytesread);
                    }
                    is.close();
                    fout.close();
                    if (PProUtil.isExecutable(je.getName())) {
                        PProUtil.setExecutable(jarEntryFileName);
                    }
                    if (PProUtil.isNonprivReadable(je.getName())) {
                        PProUtil.setReadable(jarEntryFileName);
                    }
                }
                jarEntryF = null;
                is = null;
                fout = null;
            }
            if (deleteJar) {
                patchJar.delete();
            }
        }
        catch (IOException ex) {
            throw new PatchException("EXM_DL_PROCESSING", patchId, sourceDir, ex.getLocalizedMessage());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e) {}
            }
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (Exception e) {}
            }
        }
    }

    static void unjarFiles(String targDir, String patchId) throws PatchException {
        PProUtil.unjarFiles(targDir, targDir, patchId, true);
    }

    private static boolean isExecutable(String name) {
        boolean retValue = false;
        String fileName = PProUtil.getFileName(name);
        if (name.indexOf("/") == name.lastIndexOf("/")) {
            for (int index = 0; index < EXECUTABLES.length; ++index) {
                if (!fileName.equals(EXECUTABLES[index])) continue;
                retValue = true;
                break;
            }
        }
        return retValue;
    }

    private static boolean isNonprivReadable(String name) {
        boolean retValue = false;
        String fileName = PProUtil.getFileName(name);
        for (int index = 0; index < NONPRIV_READABLES.length; ++index) {
            if (!fileName.equals(NONPRIV_READABLES[index])) continue;
            retValue = true;
            break;
        }
        return retValue;
    }

    private static boolean isContent(String name) {
        boolean retValue = true;
        for (int index = 0; index < NOT_CONTENT.length; ++index) {
            if (name.indexOf(NOT_CONTENT[index]) != 0) continue;
            retValue = false;
            break;
        }
        return retValue;
    }

    private static void setExecutable(String path) {
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec("/usr/bin/chmod a+x,ug+r " + path);
            process.waitFor();
        }
        catch (InterruptedException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void setReadable(String path) {
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec("/usr/bin/chmod a+r " + path);
            process.waitFor();
        }
        catch (InterruptedException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String getFileName(String path) {
        int index = path.lastIndexOf("/") + 1;
        return path.substring(index);
    }

    protected static void removeDirectory(String defDownloadDir) throws PatchException {
        try {
            File defDir = new File(defDownloadDir);
            if (defDir.exists()) {
                File[] fileList = defDir.listFiles();
                for (int i = 0; i < fileList.length; ++i) {
                    fileList[i].delete();
                }
                defDir.delete();
            }
        }
        catch (Exception ex) {
            if (PPro.provUtil != null) {
                PPro.provUtil.writeLog(2, ex);
            }
            throw new PatchException(ex.getLocalizedMessage());
        }
    }

    protected static Vector patchListToVector(PatchList patchList) throws PatchException {
        String patchStr = null;
        Vector<String> outVec = new Vector<String>();
        Debug.trace3((String)("Errors found: " + patchList.hasAnyErrors()));
        int plSize = patchList.size();
        Debug.trace3((String)("PatchList size: " + plSize));
        for (int index = 0; index < plSize; ++index) {
            PatchID patchID;
            Patch patch;
            try {
                patch = patchList.getPatchAt(index);
            }
            catch (NoSuchPatchException nspe) {
                throw new PatchException(nspe.getLocalizedMessage());
            }
            if (patch == null || (patchID = patch.getPatchID()) == null || (patchStr = patchID.getPatchID()) == null && patchStr.length() <= 0) continue;
            outVec.addElement(patchStr);
        }
        return outVec;
    }

    protected static void printPatchList(PatchList patchList) throws PatchException {
        if (patchList == null) {
            return;
        }
        System.out.println("Errors found: " + patchList.hasAnyErrors());
        System.out.println("PatchList size: " + patchList.size());
        try {
            for (int index = 0; index < patchList.size(); ++index) {
                System.out.println("Patch: " + patchList.getPatchAt(index).getPatchID().getPatchID());
                boolean error = patchList.hasErrorAt(index);
                if (!error) continue;
                System.out.println("Error: " + patchList.getErrorAt(index));
            }
        }
        catch (NoSuchPatchException nspe) {
            throw new PatchException(nspe.getLocalizedMessage());
        }
    }

    public static String getKeyBoard(String prompt) {
        System.out.print(prompt);
        try {
            byte[] buffer = new byte[100];
            char bytes = (char)System.in.read(buffer);
            if ((char)buffer[bytes - '\u0001'] == '\n') {
                buffer[bytes - '\u0001'] = 0;
            }
            String result = new String(buffer);
            return result.trim();
        }
        catch (Exception e) {
            System.out.println("Exception: " + e);
            e.printStackTrace();
            return new String("");
        }
    }

    public static void dirAvailable(String spoolDir) throws PatchException {
        try {
            File dir = new File(spoolDir);
            if (!dir.exists()) {
                throw new PatchException("EXM_DL_DIR_ACCESS", dir.toString());
            }
            if (!dir.canWrite()) {
                throw new PatchException("EXM_DL_DIR_WRITE", dir.toString());
            }
        }
        catch (Exception ex) {
            String msg = ex.getLocalizedMessage();
            throw new PatchException(msg);
        }
    }
}

