/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.patch;

import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.patch.IPatch;
import com.sun.patchpro.patch.MalformedPatchException;
import com.sun.patchpro.patch.NoSuchPatchException;
import com.sun.patchpro.patch.Patch;
import com.sun.patchpro.patch.PatchAccumulator;
import com.sun.patchpro.patch.PatchID;
import com.sun.patchpro.patch.PatchList;
import com.sun.patchpro.patch.PatchListImpl;
import com.sun.patchpro.util.NoResultException;
import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.patch.PPro;
import com.sun.wbem.solarisprovider.patch.PProUtil;
import com.sun.wbem.solarisprovider.patch.PatchException;
import com.sun.wbem.solarisprovider.patch.SolarisPatchInfo;
import com.sun.wbem.solarisprovider.patch.SolarisPatchObj;
import com.sun.wbem.utility.log.LogUtil;
import java.io.File;
import java.util.Vector;
import javax.wbem.client.Debug;

public class InstallPatchesByPolicy
extends PPro {
    private String spoolDir;
    private String sequesterDir;
    private File spoolDirHandle;
    private Vector patchList;
    private LogUtil logUtil;
    private static final String VERSION = "1";
    private static final String VERSION_HEADER = "~VERSION~";
    private static final String ERROR_HEADER = "~ERROR~";
    private static final String SEQUESTERED_HEADER = "~SEQUESTERED~";
    private static final String EXCLUDED_HEADER = "~EXCLUDED~";
    private static final String ADDED_HEADER = "~ADDED~";
    private static final String NOTFOUND_HEADER = "~NOTFOUND~";
    private static final String INSTALLED_HEADER = "~INSTALLED~";
    private static final String SEQUESTER_SUBDIR = "patchproSequester";

    public InstallPatchesByPolicy(ProviderUtility provUtil, LogUtil logUtil) {
        InstallPatchesByPolicy.provUtil = provUtil;
        this.logUtil = logUtil;
    }

    protected void initialize(Vector patchList, String spoolDir) throws PatchException {
        this.patchList = patchList;
        this.spoolDir = spoolDir;
        this.sequesterDir = spoolDir + System.getProperty("file.separator") + SEQUESTER_SUBDIR;
        if (this.spoolDir != null && this.spoolDir.length() > 0) {
            PProUtil.dirAvailable(this.spoolDir);
        }
        this.spoolDirHandle = new File(spoolDir);
        this.init();
        if (this.model == null) {
            throw new PatchException("EXM_INST_UNEXP_ERR");
        }
        this.analyzeHost();
    }

    protected Vector installPatches() {
        Vector<String> results;
        block28: {
            results = new Vector<String>();
            results.add("~VERSION~1");
            Vector<String> additionalPatches = new Vector<String>();
            try {
                int i;
                PatchProProperties properties = PatchProProperties.getInstance();
                PatchAccumulator accumulator = this.model.getPatchAccumulator();
                PatchListImpl finalPatchList = new PatchListImpl();
                int len = this.patchList != null ? this.patchList.size() : 0;
                for (int i2 = 0; i2 < len; ++i2) {
                    PatchID pid = new PatchID((String)this.patchList.elementAt(i2));
                    finalPatchList = accumulator.getPatchClosure(pid);
                }
                Vector<String> excludedPatches = new Vector<String>();
                String aSpecifiedPatchID = null;
                String aFinalPatchID = null;
                boolean found = false;
                for (i = 0; i < this.patchList.size(); ++i) {
                    found = false;
                    aSpecifiedPatchID = (String)this.patchList.elementAt(i);
                    for (int ii = 0; ii < finalPatchList.size(); ++ii) {
                        aFinalPatchID = finalPatchList.getPatchAt(ii).getPatchID().getPatchID();
                        if (!aSpecifiedPatchID.equals(aFinalPatchID)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    excludedPatches.addElement(aSpecifiedPatchID);
                }
                len = excludedPatches != null ? excludedPatches.size() : 0;
                for (i = 0; i < len; ++i) {
                    results.add(EXCLUDED_HEADER + excludedPatches.elementAt(i));
                }
                if (finalPatchList.size() == 0) {
                    return results;
                }
                additionalPatches = new Vector();
                for (i = 0; i < finalPatchList.size(); ++i) {
                    aFinalPatchID = finalPatchList.getPatchAt(i).getPatchID().getPatchID();
                    if (this.patchList.contains(aFinalPatchID)) continue;
                    additionalPatches.addElement(aFinalPatchID);
                }
                if (additionalPatches.size() > 0) {
                    for (i = 0; i < additionalPatches.size(); ++i) {
                        results.add(ADDED_HEADER + additionalPatches.elementAt(i));
                    }
                }
                File file = null;
                String path = null;
                IPatch patch = null;
                try {
                    for (int i3 = 0; i3 < finalPatchList.size(); ++i3) {
                        patch = (IPatch)finalPatchList.getPatchAt(i3);
                        path = this.spoolDirHandle + System.getProperty("file.separator") + patch.getPatchID().getPatchID() + ".jar";
                        file = new File(path);
                        if (!file.exists()) {
                            results.add(NOTFOUND_HEADER + patch.getPatchID().getPatchID());
                        }
                        file = null;
                        path = null;
                        patch = null;
                    }
                }
                catch (NoSuchPatchException e) {
                    Debug.trace3((String)"---- InstallPatches looking for patches caught ", (Throwable)e);
                }
                properties.setProperty("smpatch.request", "true");
                properties.setProperty("patchpro.patch.sequester.directory", this.sequesterDir);
                properties.setProperty("patchpro.download.directory", this.spoolDir);
                this.prepForThread();
                Debug.trace3((String)"---- InstallPatches about to install");
                this.model.installPatches((PatchList)finalPatchList, this.spoolDirHandle);
                this.waitForThread();
                Debug.trace3((String)"---- InstallPatches install finished ok");
            }
            catch (NoSuchPatchException e) {
                Debug.trace3((String)"---- InstallPatches installing patches (missing) caught ", (Throwable)e);
            }
            catch (MalformedPatchException e) {
                Debug.trace3((String)"---- InstallPatches installing patches (malform) caught ", (Throwable)e);
            }
            catch (NoResultException e) {
                Debug.trace3((String)"InstallPatches installing patches (no result) caught ", (Throwable)e);
            }
            catch (PatchException e) {
                Debug.trace3((String)"InstallPatches installing patches caught ", (Throwable)((Object)e));
            }
            if (this.nonfatalProblems.size() > 0) {
                String logErrors = "";
                for (int i = 0; i < this.nonfatalProblems.size(); ++i) {
                    results.add("~ERROR~ " + (String)this.nonfatalProblems.elementAt(i));
                    logErrors = logErrors + "\n" + " " + (String)this.nonfatalProblems.elementAt(i);
                }
                provUtil.writeLog(2, "LM_8904", "LM_8905", logErrors, null, null, null, null);
            }
            try {
                Debug.trace1((String)"---- InstallPatches getting system patch list");
                SolarisPatchInfo patchInfo = new SolarisPatchInfo(provUtil);
                Vector systemPatchList = patchInfo.getPatchListData();
                String installedList = null;
                Debug.trace1((String)("---- InstallPatches got system patch list: " + systemPatchList));
                for (int i = 0; systemPatchList != null && i < systemPatchList.size(); ++i) {
                    SolarisPatchObj patchObj = (SolarisPatchObj)systemPatchList.elementAt(i);
                    String patchID = patchObj.getPatchName();
                    if (!this.patchList.contains(patchID) && !additionalPatches.contains(patchID)) continue;
                    results.add(INSTALLED_HEADER + patchID);
                    installedList = installedList == null ? patchID : installedList + " ," + patchID;
                }
                if (installedList != null) {
                    provUtil.writeLog(0, "LM_8906", "LM_8907", installedList, null, null, null, null);
                }
                Debug.trace1((String)("---- InstallPatches installedlist: " + installedList));
            }
            catch (PatchException e) {
                Debug.trace3((String)"---- InstallPatches getting installed threw: ", (Throwable)((Object)e));
            }
            try {
                int listSize;
                PatchList uninstalledPatches = this.model.getUninstalledPatches();
                Debug.trace3((String)("---- InstallPatches uninstalled: " + uninstalledPatches));
                if (uninstalledPatches == null || (listSize = uninstalledPatches.size()) == 0) break block28;
                Patch patch = null;
                String logList = null;
                String patchIDStr = null;
                for (int i = 0; i < uninstalledPatches.size(); ++i) {
                    try {
                        patch = uninstalledPatches.getPatchAt(i);
                    }
                    catch (NoSuchPatchException ex) {
                        continue;
                    }
                    patchIDStr = patch.getPatchID().getPatchID();
                    results.add(SEQUESTERED_HEADER + patchIDStr);
                    logList = logList == null ? patchIDStr : logList + " ," + patchIDStr;
                }
                provUtil.writeLog(0, "LM_8902", "LM_8903", this.sequesterDir, logList, null, null, null);
            }
            catch (Exception e) {
                Debug.trace3((String)"InstallPatches getting uninstalled caught ", (Throwable)e);
            }
        }
        return results;
    }
}

