/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.network;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.network.IPSubnetData;
import com.sun.wbem.solarisprovider.network.IPSubnetInfo;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.CIMProviderException;
import javax.wbem.provider.InstanceProvider;

public class Solaris_IPSubnet
implements InstanceProvider {
    private static final String SOLARIS_IP_SUBNET = "Solaris_IPSubnet";
    private static final String SOLARIS_CS = "Solaris_ComputerSystem";
    private static final String SUBNET_NUMBER = "SubnetNumber";
    private static final String SUBNET_MASK = "SubnetMask";
    private static final String ADDRESS_TYPE = "AddressType";
    private static final String NAME = "Name";
    private static final String SYSTEM_CREATION_CLASS_NAME = "SystemCreationClassName";
    private static final String SYSTEM_NAME = "SystemName";
    private static final String CREATION_CLASS_NAME = "CreationClassName";
    private Hashtable hash = null;
    private CIMOMHandle cimomhandle = null;
    private ProviderUtility provUtil = null;
    private static final String providerName = "Solaris_IPSubnet";

    public void initialize(CIMOMHandle cimomhandle) throws CIMException {
        try {
            this.cimomhandle = cimomhandle;
            this.provUtil = new ProviderUtility(cimomhandle, "Solaris_IPSubnet");
        }
        catch (CIMException cex) {
            this.provUtil.writeLog(2, (Exception)((Object)cex));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)cex.toString());
        }
    }

    public void cleanup() throws CIMException {
    }

    public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, CIMClass cc) throws CIMException {
        try {
            String subnetNumber = null;
            IPSubnetData data = null;
            Enumeration e = op.getKeys().elements();
            while (e.hasMoreElements()) {
                CIMProperty cp = (CIMProperty)e.nextElement();
                if (!cp.getName().equalsIgnoreCase(NAME)) continue;
                subnetNumber = (String)cp.getValue().getValue();
            }
            if (subnetNumber == null) {
                return null;
            }
            data = this.getIPSubnetData(subnetNumber);
            CIMInstance ci = this.createNewInstance(cc, data);
            if (localOnly) {
                ci = ci.localElements();
            }
            return ci.filterProperties(propertyList, includeQualifiers, includeClassOrigin);
        }
        catch (Exception ex) {
            this.provUtil.writeLog(2, ex);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.toString());
        }
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, CIMClass cc) throws CIMException {
        Vector<CIMInstance> ipSubnetData = new Vector<CIMInstance>();
        try {
            Enumeration e;
            this.hash = this.getData();
            if (this.hash != null) {
                e = this.hash.elements();
            } else {
                return null;
            }
            while (e.hasMoreElements()) {
                IPSubnetData data = (IPSubnetData)e.nextElement();
                CIMInstance ci = this.createNewInstance(cc, data);
                if (localOnly) {
                    ci = ci.localElements();
                }
                ipSubnetData.addElement(ci.filterProperties(propertyList, includeQualifiers, includeClassOrigin));
            }
        }
        catch (Exception cex) {
            this.provUtil.writeLog(2, cex);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)cex.toString());
        }
        CIMInstance[] ciArray = new CIMInstance[ipSubnetData.size()];
        ipSubnetData.toArray(ciArray);
        return ciArray;
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath op, CIMClass cc) throws CIMException {
        Vector<CIMObjectPath> ipSubnetData = new Vector<CIMObjectPath>();
        try {
            Enumeration e;
            this.hash = this.getData();
            if (this.hash != null) {
                e = this.hash.elements();
            } else {
                return null;
            }
            while (e.hasMoreElements()) {
                CIMObjectPath cop = new CIMObjectPath(op.getObjectName(), op.getNameSpace());
                IPSubnetData data = (IPSubnetData)e.nextElement();
                cop.addKey(NAME, new CIMValue((Object)data.getSubnetNumber()));
                cop.addKey(CREATION_CLASS_NAME, new CIMValue((Object)"Solaris_IPSubnet"));
                cop.addKey(SYSTEM_CREATION_CLASS_NAME, new CIMValue((Object)SOLARIS_CS));
                try {
                    cop.addKey(SYSTEM_NAME, new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                ipSubnetData.addElement(cop);
            }
        }
        catch (Exception cex) {
            this.provUtil.writeLog(2, cex);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)cex.toString());
        }
        CIMObjectPath[] copArray = new CIMObjectPath[ipSubnetData.size()];
        ipSubnetData.toArray(copArray);
        return copArray;
    }

    public void setInstance(CIMObjectPath cop, CIMInstance ci) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMObjectPath createInstance(CIMObjectPath cop, CIMInstance ci) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void deleteInstance(CIMObjectPath cp) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMInstance[] execQuery(CIMObjectPath op, String query, String ql, CIMClass cc) throws CIMException {
        return null;
    }

    private Hashtable getData() throws Exception {
        try {
            IPSubnetInfo data = new IPSubnetInfo();
            Hashtable tmpHash = data.getNetmasksData();
            if (tmpHash != null) {
                return tmpHash;
            }
        }
        catch (Exception e) {
            this.provUtil.writeLog(2, e);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)e.toString());
        }
        return null;
    }

    private IPSubnetData getIPSubnetData(String subnetNumber) throws Exception {
        Hashtable subnetinfoHash = null;
        IPSubnetData subnetinfoData = null;
        try {
            subnetinfoHash = this.getData();
        }
        catch (Exception e) {
            this.provUtil.writeLog(2, e);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)e.toString());
        }
        if (subnetinfoHash == null) {
            return null;
        }
        subnetinfoData = (IPSubnetData)subnetinfoHash.get(subnetNumber);
        if (subnetinfoData == null) {
            return null;
        }
        return subnetinfoData;
    }

    private CIMInstance createNewInstance(CIMClass cc, IPSubnetData data) {
        CIMInstance ci = cc.newInstance();
        ci.setProperty(NAME, new CIMValue((Object)data.getSubnetNumber()));
        ci.setProperty(SUBNET_NUMBER, new CIMValue((Object)data.getSubnetNumber()));
        ci.setProperty(SUBNET_MASK, new CIMValue((Object)data.getSubnetMask()));
        ci.setProperty(ADDRESS_TYPE, new CIMValue((Object)new UnsignedInt16(data.getAddressType())));
        ci.setProperty(CREATION_CLASS_NAME, new CIMValue((Object)"Solaris_IPSubnet"));
        ci.setProperty(SYSTEM_CREATION_CLASS_NAME, new CIMValue((Object)SOLARIS_CS));
        try {
            ci.setProperty(SYSTEM_NAME, new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
        }
        catch (Exception e) {
            // empty catch block
        }
        return ci;
    }
}

