/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.network;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.network.NetworkConfigData;
import com.sun.wbem.solarisprovider.network.NetworkConfigInfo;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.CIMProviderException;
import javax.wbem.provider.InstanceProvider;

public class Solaris_IPProtocolEndpoint
implements InstanceProvider {
    private static final String SOLARIS_IPPE = "Solaris_IPProtocolEndpoint";
    private static final String SOLARIS_CS = "Solaris_ComputerSystem";
    private static final String IP_ADDRESS = "Address";
    private static final String NETMASK = "SubnetMask";
    private static final String ADDRESS_TYPE = "AddressType";
    private static final String IPVERSION_SUPPORT = "IPVersionSupport";
    private static final String DESCRIPTION = "Description";
    private static final String STATUS = "Status";
    private static final String MAX_DATA_SIZE = "MaxDataSize";
    private static final String INDEX = "Index";
    private static final String BROADCAST = "Broadcast";
    private static final String OPTIONS = "OptionsEnabled";
    private static final String NAME = "Name";
    private static final String SYSTEM_CREATION_CLASS_NAME = "SystemCreationClassName";
    private static final String SYSTEM_NAME = "SystemName";
    private static final String CREATION_CLASS_NAME = "CreationClassName";
    private Hashtable hash = null;
    private CIMOMHandle cimomhandle = null;
    private ProviderUtility provUtil = null;
    private static final String providerName = "Solaris_IPProtocolEndpoint";

    public void initialize(CIMOMHandle cimomhandle) throws CIMException {
        try {
            this.cimomhandle = cimomhandle;
            this.provUtil = new ProviderUtility(cimomhandle, "Solaris_IPProtocolEndpoint");
        }
        catch (CIMException cex) {
            this.provUtil.writeLog(2, (Exception)((Object)cex));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)cex.toString());
        }
    }

    public void cleanup() throws CIMException {
    }

    public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, CIMClass cc) throws CIMException {
        try {
            String interfaceName = null;
            NetworkConfigData data = null;
            Enumeration e = op.getKeys().elements();
            while (e.hasMoreElements()) {
                CIMProperty cp = (CIMProperty)e.nextElement();
                if (!cp.getName().equalsIgnoreCase(NAME)) continue;
                interfaceName = (String)cp.getValue().getValue();
            }
            if (interfaceName == null) {
                return null;
            }
            data = this.getNetworkConfigData(interfaceName);
            CIMInstance ci = this.createNewInstance(cc, data);
            if (localOnly) {
                ci = ci.localElements();
            }
            return ci.filterProperties(propertyList, includeQualifiers, includeClassOrigin);
        }
        catch (Exception ex) {
            this.provUtil.writeLog(2, ex);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)ex.toString());
        }
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, CIMClass cc) throws CIMException {
        Vector<CIMInstance> networkConfigData = new Vector<CIMInstance>();
        try {
            Enumeration e;
            this.hash = this.getData();
            if (this.hash != null) {
                e = this.hash.elements();
            } else {
                return null;
            }
            while (e.hasMoreElements()) {
                NetworkConfigData data = (NetworkConfigData)e.nextElement();
                CIMInstance ci = this.createNewInstance(cc, data);
                if (localOnly) {
                    ci = ci.localElements();
                }
                networkConfigData.addElement(ci.filterProperties(propertyList, includeQualifiers, includeClassOrigin));
            }
        }
        catch (Exception cex) {
            this.provUtil.writeLog(2, cex);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)cex.toString());
        }
        CIMInstance[] ciArray = new CIMInstance[networkConfigData.size()];
        networkConfigData.toArray(ciArray);
        return ciArray;
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath op, CIMClass cc) throws CIMException {
        Vector<CIMObjectPath> networkConfigData = new Vector<CIMObjectPath>();
        try {
            Enumeration e;
            this.hash = this.getData();
            if (this.hash != null) {
                e = this.hash.elements();
            } else {
                return null;
            }
            while (e.hasMoreElements()) {
                CIMObjectPath cop = new CIMObjectPath(op.getObjectName(), op.getNameSpace());
                NetworkConfigData data = (NetworkConfigData)e.nextElement();
                cop.addKey(NAME, new CIMValue((Object)data.getInterfaceName()));
                cop.addKey(CREATION_CLASS_NAME, new CIMValue((Object)"Solaris_IPProtocolEndpoint"));
                cop.addKey(SYSTEM_CREATION_CLASS_NAME, new CIMValue((Object)SOLARIS_CS));
                try {
                    cop.addKey(SYSTEM_NAME, new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                networkConfigData.addElement(cop);
            }
        }
        catch (Exception cex) {
            this.provUtil.writeLog(2, cex);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)cex.toString());
        }
        CIMObjectPath[] copArray = new CIMObjectPath[networkConfigData.size()];
        networkConfigData.toArray(copArray);
        return copArray;
    }

    public void setInstance(CIMObjectPath cop, CIMInstance ci) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMObjectPath createInstance(CIMObjectPath cop, CIMInstance ci) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void deleteInstance(CIMObjectPath cp) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMInstance[] execQuery(CIMObjectPath op, String query, String ql, CIMClass cc) throws CIMException {
        return null;
    }

    private Hashtable getData() throws Exception {
        try {
            NetworkConfigInfo data = new NetworkConfigInfo(this.provUtil);
            Hashtable tmpHash = data.initData();
            if (tmpHash != null) {
                return tmpHash;
            }
        }
        catch (Exception e) {
            this.provUtil.writeLog(2, e);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)e.toString());
        }
        return null;
    }

    private NetworkConfigData getNetworkConfigData(String interfaceName) throws Exception {
        Hashtable netinfoHash = null;
        NetworkConfigData netinfoData = null;
        try {
            netinfoHash = this.getData();
        }
        catch (Exception e) {
            this.provUtil.writeLog(2, e);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)e.toString());
        }
        if (netinfoHash == null) {
            return null;
        }
        netinfoData = (NetworkConfigData)netinfoHash.get(interfaceName);
        if (netinfoData == null) {
            return null;
        }
        return netinfoData;
    }

    private CIMInstance createNewInstance(CIMClass cc, NetworkConfigData data) {
        CIMInstance ci = cc.newInstance();
        ci.setProperty(NAME, new CIMValue((Object)data.getInterfaceName()));
        ci.setProperty(IP_ADDRESS, new CIMValue((Object)data.getIPAddress()));
        int addressType = 0;
        String tmp_str = data.getAddressType();
        if (tmp_str.equalsIgnoreCase("IPv4")) {
            addressType = 1;
        }
        ci.setProperty(ADDRESS_TYPE, new CIMValue((Object)new UnsignedInt16(addressType)));
        ci.setProperty(IPVERSION_SUPPORT, new CIMValue((Object)new UnsignedInt16(addressType)));
        ci.setProperty(NETMASK, new CIMValue((Object)data.getNetmask()));
        ci.setProperty(MAX_DATA_SIZE, new CIMValue((Object)data.getMtu()));
        ci.setProperty(INDEX, new CIMValue((Object)data.getIndex()));
        ci.setProperty(OPTIONS, new CIMValue((Object)data.getOptionsEnabled()));
        ci.setProperty(DESCRIPTION, new CIMValue((Object)data.getDescription()));
        ci.setProperty(BROADCAST, new CIMValue((Object)data.getBroadcast()));
        ci.setProperty(STATUS, new CIMValue((Object)"Running"));
        ci.setProperty(CREATION_CLASS_NAME, new CIMValue((Object)"Solaris_IPProtocolEndpoint"));
        ci.setProperty(SYSTEM_CREATION_CLASS_NAME, new CIMValue((Object)SOLARIS_CS));
        try {
            ci.setProperty(SYSTEM_NAME, new CIMValue((Object)InetAddress.getLocalHost().getHostName()));
        }
        catch (Exception e) {
            // empty catch block
        }
        return ci;
    }
}

