/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.eeprom;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.utility.log.LogUtil;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.CIMProviderException;
import javax.wbem.provider.InstanceProvider;

public class Solaris_EepromElementSetting
implements InstanceProvider {
    public static final String PROVIDERNAME = "Solaris Eeprom Provider";
    public static final String CAPTION = "Solaris Eeprom Parameter Configuration.";
    private static CIMOMHandle cimomHandle = null;
    private static ProviderUtility provUtil = null;
    private LogUtil logUtil = null;

    public void initialize(CIMOMHandle cimomhandle) throws CIMException {
        cimomHandle = cimomhandle;
        this.logUtil = LogUtil.getInstance((CIMOMHandle)cimomhandle);
        try {
            provUtil = new ProviderUtility(cimomHandle, PROVIDERNAME);
        }
        catch (CIMException e) {
            throw new CIMException("CIM_ERR_FAILED");
        }
    }

    protected static CIMOMHandle getCimomHandle() {
        return cimomHandle;
    }

    protected static ProviderUtility getProviderUtil() {
        return provUtil;
    }

    public void cleanup() throws CIMException {
    }

    public CIMInstance[] execQuery(CIMObjectPath op, String query, String ql, CIMClass cc) throws CIMException {
        try {
            String[] subArgs = new String[]{"execQuery"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_9633", "LM_9603", subArgs, null, false, 0, 0);
        }
        catch (CIMException e) {
            // empty catch block
        }
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMObjectPath createInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        try {
            String[] subArgs = new String[]{"Create Instance"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_9633", "LM_9603", subArgs, null, false, 0, 0);
        }
        catch (CIMException cIMException) {
            // empty catch block
        }
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void deleteInstance(CIMObjectPath op) throws CIMException {
        try {
            String[] subArgs = new String[]{"Delete Instance"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_9633", "LM_9603", subArgs, null, false, 0, 0);
        }
        catch (CIMException cIMException) {
            // empty catch block
        }
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMInstance getInstance(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, CIMClass cc) throws CIMException {
        CIMObjectPath targetEeprom = null;
        CIMObjectPath eepromSetting = null;
        try {
            provUtil.checkAuthenticated();
        }
        catch (CIMException e) {
            String[] subArgs = new String[]{"getInstance"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_9633", "LM_9602", subArgs, null, false, 0, 2);
            throw new CIMException("CIM_ERR_ACCESS_DENIED");
        }
        CIMInstance ci = cc.newInstance();
        try {
            Enumeration e = op.getKeys().elements();
            while (e.hasMoreElements()) {
                CIMProperty cp = (CIMProperty)e.nextElement();
                if (cp.getName().equalsIgnoreCase("Setting")) {
                    eepromSetting = (CIMObjectPath)cp.getValue().getValue();
                }
                if (!cp.getName().equalsIgnoreCase("Element")) continue;
                targetEeprom = (CIMObjectPath)cp.getValue().getValue();
            }
            ci.setProperty("Setting", new CIMValue(eepromSetting));
            ci.setProperty("Element", new CIMValue(targetEeprom));
        }
        catch (Exception e) {
            String logMsg = this.writeLog(2, null, null, e);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)logMsg);
        }
        if (localOnly) {
            ci = ci.localElements();
        }
        return ci.filterProperties(propertyList, includeQualifiers, includeClassOrigin);
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath op, CIMClass cc) throws CIMException {
        Vector<CIMObjectPath> instances = new Vector<CIMObjectPath>();
        try {
            provUtil.checkAuthenticated();
        }
        catch (CIMException e) {
            String[] subArgs = new String[]{"enumInstances"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_9633", "LM_9602", subArgs, null, false, 0, 2);
            throw new CIMException("CIM_ERR_ACCESS_DENIED");
        }
        try {
            CIMObjectPath settingObjectPath = new CIMObjectPath("Solaris_EepromSetting", op.getNameSpace());
            Enumeration e = cimomHandle.enumerateInstances(settingObjectPath, false, false, true, true, null);
            if (e != null) {
                while (e.hasMoreElements()) {
                    CIMObjectPath eepromSettingObjectPath = (CIMObjectPath)e.nextElement();
                    if (eepromSettingObjectPath == null) continue;
                    CIMObjectPath cop = new CIMObjectPath(op.getObjectName(), op.getNameSpace());
                    cop.addKey("Setting", new CIMValue((Object)eepromSettingObjectPath));
                    cop.addKey("Element", new CIMValue((Object)this.getSolarisEepromReference(op)));
                    instances.addElement(cop);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String logMsg = this.writeLog(2, null, null, e);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)logMsg);
        }
        CIMObjectPath[] copArray = new CIMObjectPath[instances.size()];
        instances.toArray(copArray);
        return copArray;
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath op, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, CIMClass cc) throws CIMException {
        Vector<CIMInstance> instances = new Vector<CIMInstance>();
        try {
            provUtil.checkAuthenticated();
        }
        catch (CIMException e) {
            String[] subArgs = new String[]{"enumInstances"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_9633", "LM_9602", subArgs, null, false, 0, 2);
            throw new CIMException("CIM_ERR_ACCESS_DENIED");
        }
        try {
            CIMObjectPath settingObjectPath = new CIMObjectPath("Solaris_EepromSetting", op.getNameSpace());
            Enumeration e = cimomHandle.enumerateInstances(settingObjectPath, false, false, true, true, null);
            if (e != null) {
                while (e.hasMoreElements()) {
                    CIMObjectPath eepromSettingObjectPath = (CIMObjectPath)e.nextElement();
                    if (eepromSettingObjectPath == null) continue;
                    CIMInstance ci = cc.newInstance();
                    ci.setProperty("Setting", new CIMValue((Object)eepromSettingObjectPath));
                    ci.setProperty("Element", new CIMValue((Object)this.getSolarisEepromReference(op)));
                    if (localOnly) {
                        ci = ci.localElements();
                    }
                    instances.addElement(ci.filterProperties(propertyList, includeQualifiers, includeClassOrigin));
                }
            }
        }
        catch (Exception e) {
            String logMsg = this.writeLog(2, null, null, e);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)logMsg);
        }
        CIMInstance[] ciArray = new CIMInstance[instances.size()];
        instances.toArray(ciArray);
        return ciArray;
    }

    public synchronized void setInstance(CIMObjectPath op, CIMInstance ci) throws CIMException {
        try {
            String[] subArgs = new String[]{"Set Instance"};
            this.logUtil.writeLog(PROVIDERNAME, "LM_9633", "LM_9603", subArgs, null, false, 0, 0);
        }
        catch (CIMException cIMException) {
            // empty catch block
        }
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    private String getParameterName(CIMObjectPath op) throws CIMException {
        String paramName = null;
        try {
            Enumeration e = op.getKeys().elements();
            while (e.hasMoreElements()) {
                CIMProperty cp = (CIMProperty)e.nextElement();
                if (!cp.getName().equalsIgnoreCase("ParameterKey")) continue;
                paramName = (String)cp.getValue().getValue();
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String logMsg = this.writeLog(2, null, null, e);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)logMsg);
        }
        return paramName;
    }

    private CIMObjectPath getSolarisEepromReference(CIMObjectPath op) throws CIMProviderException {
        CIMObjectPath targetEepromObjectPath = null;
        try {
            CIMObjectPath eepromObjectPath = new CIMObjectPath("Solaris_Eeprom", op.getNameSpace());
            Enumeration e = cimomHandle.enumerateInstances(eepromObjectPath, false, false, true, true, null);
            if (e != null) {
                while (e.hasMoreElements() && (targetEepromObjectPath = (CIMObjectPath)e.nextElement()) == null) {
                }
            }
        }
        catch (Exception e) {
            String logMsg = this.writeLog(2, null, null, e);
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)logMsg);
        }
        return targetEepromObjectPath;
    }

    protected String writeLog(int severity, String msgID, String[] subArg, Exception pex) {
        String retStr = null;
        String msg = null;
        boolean syslog = false;
        try {
            msg = pex.getLocalizedMessage();
            this.logUtil.writeLog(PROVIDERNAME, "LM_9600", msgID, subArg, msg, syslog, 0, severity);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (msgID != null) {
            retStr = this.logUtil.getLocalizedMessage(msgID, subArg);
            retStr = retStr + " " + msg;
        } else {
            retStr = msg;
        }
        return retStr;
    }
}

