/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.util;

import com.sun.wbem.cim.CIMClass;
import com.sun.wbem.cim.CIMDataType;
import com.sun.wbem.cim.CIMDateTime;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMFlavor;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMMethod;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMParameter;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.CIMQualifier;
import com.sun.wbem.cim.CIMQualifierType;
import com.sun.wbem.cim.CIMScope;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.cim.UnsignedInt16;
import com.sun.wbem.cim.UnsignedInt32;
import com.sun.wbem.cim.UnsignedInt64;
import com.sun.wbem.cim.UnsignedInt8;
import com.sun.wbem.cim.XmlGenericId;
import com.sun.xml.tree.ElementNode;
import com.sun.xml.tree.TreeWalker;
import java.math.BigInteger;
import java.util.Vector;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class OldXMLParser {
    OldXMLParser() {
    }

    public static CIMClass getCIMClass(Node node) throws CIMException {
        CIMClass cc = new CIMClass();
        Vector<CIMQualifier> q = new Vector<CIMQualifier>();
        Vector<CIMProperty> p = new Vector<CIMProperty>();
        Vector<CIMMethod> m = new Vector<CIMMethod>();
        TreeWalker walker = new TreeWalker(node);
        node = walker.getCurrent();
        while (node != null) {
            String nodename = node.getNodeName();
            if (nodename.equals(XmlGenericId.CLASS)) {
                NamedNodeMap attrs = node.getAttributes();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    Node item = attrs.item(i);
                    String itemname = item.getNodeName();
                    if (itemname.equals("NAME")) {
                        cc.setName(item.getNodeValue());
                        continue;
                    }
                    if (!itemname.equals("SUPERCLASS")) continue;
                    cc.setSuperClass(item.getNodeValue());
                }
                node = walker.getNextElement(null);
                continue;
            }
            if (nodename.equals(XmlGenericId.QUALIFIER)) {
                if (node.getParentNode().getNodeName().equals(XmlGenericId.CLASS)) {
                    CIMQualifier cq = OldXMLParser.getCIMQualifier(node);
                    q.addElement(cq);
                }
                node = node.getNextSibling();
                continue;
            }
            if (nodename.startsWith(XmlGenericId.PROPERTY)) {
                CIMProperty prop = OldXMLParser.getCIMProperty(node);
                p.addElement(prop);
                if (prop.isKey()) {
                    cc.setIsKeyed(true);
                }
                node = node.getNextSibling();
                continue;
            }
            if (nodename.equals(XmlGenericId.METHOD)) {
                m.addElement(OldXMLParser.getCIMMethod(node));
                node = node.getNextSibling();
                continue;
            }
            node = node.getNextSibling();
        }
        if (m.size() > 0) {
            cc.setMethods(m);
        }
        if (q.size() > 0) {
            cc.setQualifiers(q);
        }
        if (p.size() > 0) {
            cc.setProperties(p);
        }
        return cc;
    }

    public static CIMInstance getCIMInstance(Node node) throws CIMException {
        CIMInstance ci = new CIMInstance();
        Vector<CIMQualifier> q = new Vector<CIMQualifier>();
        Vector<CIMProperty> p = new Vector<CIMProperty>();
        ((ElementNode)node).normalize();
        TreeWalker walker = new TreeWalker(node);
        node = walker.getCurrent();
        while (node != null) {
            String nodename = node.getNodeName();
            if (nodename.equals(XmlGenericId.INSTANCENAME)) {
                node = node.getNextSibling();
                continue;
            }
            if (nodename.equals(XmlGenericId.INSTANCE)) {
                ci.setClassName(((ElementNode)node).getAttribute("CLASSNAME"));
                node = node.getFirstChild();
                continue;
            }
            if (nodename.equals(XmlGenericId.QUALIFIER)) {
                q.addElement(OldXMLParser.getCIMQualifier(node));
                node = node.getNextSibling();
                continue;
            }
            if (nodename.startsWith(XmlGenericId.PROPERTY)) {
                p.addElement(OldXMLParser.getCIMProperty(node));
                node = node.getNextSibling();
                continue;
            }
            node = walker.getNextElement(null);
        }
        if (q.size() > 0) {
            ci.setQualifiers(q);
        }
        if (p.size() > 0) {
            ci.setProperties(p);
        }
        return ci;
    }

    public static CIMMethod getCIMMethod(Node node) throws CIMException {
        CIMMethod cm = new CIMMethod();
        Vector<CIMQualifier> q = new Vector<CIMQualifier>();
        Vector<CIMParameter> p = new Vector<CIMParameter>();
        TreeWalker walker = new TreeWalker(node);
        node = walker.getCurrent();
        while (node != null) {
            String nodename = node.getNodeName();
            if (nodename.equals(XmlGenericId.METHOD)) {
                NamedNodeMap attrs = node.getAttributes();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    Node item = attrs.item(i);
                    String itemname = item.getNodeName();
                    if (itemname.equals("NAME")) {
                        cm.setName(item.getNodeValue());
                        continue;
                    }
                    if (itemname.equals("TYPE")) {
                        CIMDataType cdt = CIMDataType.getDataType((String)item.getNodeValue());
                        cm.setType(cdt);
                        continue;
                    }
                    if (itemname.equals("PROPAGATED") || !itemname.equals("CLASSORIGIN")) continue;
                    cm.setOriginClass(item.getNodeValue());
                }
            } else if (nodename.equals(XmlGenericId.QUALIFIER)) {
                q.addElement(OldXMLParser.getCIMQualifier(node));
            } else if (nodename.startsWith(XmlGenericId.PARAMETER)) {
                p.addElement(OldXMLParser.getCIMParameter(node));
            }
            node = walker.getNext();
        }
        if (q.size() > 0) {
            cm.setQualifiers(q);
        }
        if (p.size() > 0) {
            cm.setParameters(p);
        }
        return cm;
    }

    public static CIMObjectPath getCIMObjectPath(Node node) throws CIMException {
        CIMObjectPath cop = new CIMObjectPath();
        TreeWalker walker = new TreeWalker(node);
        node = walker.getCurrent();
        while (node != null) {
            String nodename = node.getNodeName();
            if (!(nodename.equals(XmlGenericId.NAMESPACEPATH) || nodename.equals(XmlGenericId.LOCALNAMESPACEPATH) || nodename.equals(XmlGenericId.CLASSPATH) || nodename.equals(XmlGenericId.LOCALCLASSPATH) || nodename.equals(XmlGenericId.INSTANCEPATH) || nodename.equals(XmlGenericId.LOCALINSTANCEPATH) || nodename.equals(XmlGenericId.OBJECTPATH))) {
                if (nodename.equals(XmlGenericId.VALUE_REFERENCE)) {
                    node = walker.removeCurrent();
                    continue;
                }
                if (nodename.equals(XmlGenericId.HOST)) {
                    String host = OldXMLParser.getTextNode(node);
                    if (host == null || host.length() == 0) continue;
                    cop.setHost(host);
                } else if (nodename.equals(XmlGenericId.NAMESPACE)) {
                    String ns = cop.getNameSpace();
                    ns = ns + "/" + ((ElementNode)node).getAttribute("NAME");
                    cop.setNameSpace(ns);
                    node = node.getNextSibling();
                } else if (nodename.equals(XmlGenericId.CLASSNAME)) {
                    cop.setObjectName(((ElementNode)node).getAttribute("NAME"));
                } else if (nodename.equals(XmlGenericId.INSTANCENAME)) {
                    cop.setObjectName(((ElementNode)node).getAttribute("CLASSNAME"));
                } else if (node.getNodeName() == XmlGenericId.KEYBINDING) {
                    CIMProperty cp = OldXMLParser.getCIMProperty(node);
                    cop.addKey(cp.getName(), cp.getValue());
                    node = walker.removeCurrent();
                    continue;
                }
            }
            node = walker.getNext();
        }
        return cop;
    }

    public static CIMParameter getCIMParameter(Node node) throws CIMException {
        CIMParameter cp = new CIMParameter();
        Vector<CIMQualifier> q = new Vector<CIMQualifier>();
        TreeWalker walker = new TreeWalker(node);
        String cimtype = null;
        String refclassname = null;
        node = walker.getCurrent();
        while (node != null) {
            String nodename = node.getNodeName();
            if (nodename.startsWith(XmlGenericId.PARAMETER)) {
                NamedNodeMap attrs = node.getAttributes();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    Node item = attrs.item(i);
                    String itemname = item.getNodeName();
                    if (itemname.equals("NAME")) {
                        cp.setName(item.getNodeValue());
                        continue;
                    }
                    if (itemname.equals("TYPE")) {
                        cimtype = item.getNodeValue();
                        cp.setType(CIMDataType.getDataType((String)cimtype, (boolean)nodename.endsWith(".ARRAY")));
                        continue;
                    }
                    if (itemname.equals("ARRAYSIZE")) {
                        cp.setSize(Integer.parseInt(item.getNodeValue()));
                        continue;
                    }
                    if (!itemname.equals("REFERENCECLASS")) continue;
                    refclassname = item.getNodeValue();
                }
                if (nodename.endsWith(".REFERENCE")) {
                    cp.setType(new CIMDataType(refclassname != null ? refclassname : ""));
                }
            } else if (nodename.equals(XmlGenericId.QUALIFIER)) {
                node = walker.getCurrent();
                while (node != null) {
                    q.addElement(OldXMLParser.getCIMQualifier(node));
                    node = walker.getNextElement(nodename);
                }
            }
            node = walker.getNext();
        }
        if (q.size() > 0) {
            cp.setQualifiers(q);
        }
        return cp;
    }

    public static CIMProperty getCIMProperty(Node node) throws CIMException {
        CIMProperty cp = new CIMProperty();
        TreeWalker walker = new TreeWalker(node);
        String cimtype = null;
        node = walker.getCurrent();
        while (node != null) {
            String nodename = node.getNodeName();
            if (nodename.startsWith(XmlGenericId.PROPERTY)) {
                NamedNodeMap attrs = node.getAttributes();
                String name = null;
                String origin = null;
                String size = null;
                String propagated = "false";
                String reference = null;
                for (int i = 0; i < attrs.getLength(); ++i) {
                    Node item = attrs.item(i);
                    String itemname = item.getNodeName();
                    if (itemname.equals("NAME")) {
                        name = item.getNodeValue();
                        continue;
                    }
                    if (itemname.equals("TYPE")) {
                        cimtype = item.getNodeValue();
                        cp.setType(CIMDataType.getDataType((String)cimtype, (boolean)nodename.endsWith(".ARRAY")));
                        continue;
                    }
                    if (itemname.equals("CLASSORIGIN")) {
                        origin = item.getNodeValue();
                        continue;
                    }
                    if (itemname.equals("ARRAYSIZE")) {
                        size = item.getNodeValue();
                        continue;
                    }
                    if (itemname.equals("PROPAGATED")) {
                        propagated = item.getNodeValue();
                        continue;
                    }
                    if (!itemname.equals("REFERENCECLASS")) continue;
                    reference = item.getNodeValue();
                }
                if (!propagated.equalsIgnoreCase("true") || origin == null) {
                    // empty if block
                }
                if (name != null) {
                    cp.setName(name);
                }
                if (origin != null) {
                    cp.setOriginClass(origin);
                }
                if (size != null) {
                    cp.setSize(Integer.parseInt(size));
                }
                node = walker.getNextElement(null);
                continue;
            }
            if (nodename.equals(XmlGenericId.QUALIFIER)) {
                cp.addQualifier(OldXMLParser.getCIMQualifier(node));
                node = node.getNextSibling();
                continue;
            }
            if (nodename.equals(XmlGenericId.KEYBINDING)) {
                if (cp.getName().length() == 0) {
                    cp.setName(((ElementNode)node).getAttribute("NAME"));
                }
                node = walker.getNextElement(null);
                continue;
            }
            if (nodename.equals(XmlGenericId.KEYVALUE)) {
                cimtype = ((ElementNode)node).getAttribute("VALUETYPE");
                cp.setValue(OldXMLParser.getCIMValue(node, cimtype));
                break;
            }
            if (nodename.equals(XmlGenericId.VALUE_REFERENCE)) {
                cp.setValue(OldXMLParser.getCIMValue(node, ""));
                cp.setType(new CIMDataType(((CIMObjectPath)cp.getValue().getValue()).getObjectName()));
                break;
            }
            if (nodename.startsWith(XmlGenericId.VALUE)) {
                cp.setValue(OldXMLParser.getCIMValue(node, cimtype));
                break;
            }
            node = node.getNextSibling();
        }
        return cp;
    }

    public static CIMQualifier getCIMQualifier(Node node) throws CIMException {
        CIMQualifier cq = new CIMQualifier();
        String type = null;
        TreeWalker walker = new TreeWalker(node);
        node = walker.getCurrent();
        while (node != null) {
            String nodename = node.getNodeName();
            if (nodename.equals(XmlGenericId.QUALIFIER)) {
                NamedNodeMap attrs = node.getAttributes();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    Node item = attrs.item(i);
                    if (item.getNodeName().equals("NAME")) {
                        cq.setName(item.getNodeValue());
                        continue;
                    }
                    if (item.getNodeName().equals("TYPE")) {
                        type = item.getNodeValue();
                        continue;
                    }
                    if (item.getNodeName().equals("OVERRIDABLE")) {
                        if (item.getNodeValue().equalsIgnoreCase("true")) {
                            cq.addFlavor(new CIMFlavor(0));
                            continue;
                        }
                        cq.addFlavor(new CIMFlavor(1));
                        continue;
                    }
                    if (item.getNodeName().equals("TOSUBCLASS")) {
                        if (item.getNodeValue().equalsIgnoreCase("true")) {
                            cq.addFlavor(new CIMFlavor(3));
                            continue;
                        }
                        cq.addFlavor(new CIMFlavor(2));
                        continue;
                    }
                    if (!item.getNodeName().equals("TRANSLATABLE") || !item.getNodeValue().equalsIgnoreCase("true")) continue;
                    cq.addFlavor(new CIMFlavor(4));
                }
                node = walker.getNextElement(null);
                continue;
            }
            if (nodename.startsWith(XmlGenericId.VALUE)) {
                cq.setValue(OldXMLParser.getCIMValue(node, type));
                break;
            }
            node = walker.getNextElement(null);
        }
        return cq;
    }

    public static CIMQualifierType getCIMQualifierType(Node node) throws CIMException {
        CIMQualifierType cqt = new CIMQualifierType();
        String cimtype = null;
        boolean isarray = false;
        TreeWalker walker = new TreeWalker(node);
        node = walker.getCurrent();
        while (node != null) {
            Node item;
            int i;
            NamedNodeMap attrs;
            String nodename = node.getNodeName();
            if (nodename.equals(XmlGenericId.QUALIFIER_DECLARATION)) {
                attrs = node.getAttributes();
                for (i = 0; i < attrs.getLength(); ++i) {
                    item = attrs.item(i);
                    if (item.getNodeName().equals("NAME")) {
                        cqt.setName(item.getNodeValue());
                        continue;
                    }
                    if (item.getNodeName().equals("TYPE")) {
                        cimtype = item.getNodeValue();
                        continue;
                    }
                    if (item.getNodeName().equals("ISARRAY")) {
                        isarray = item.getNodeValue().equalsIgnoreCase("true");
                        continue;
                    }
                    if (item.getNodeName().equals("ARRAYSIZE")) {
                        cqt.setSize(Integer.parseInt(item.getNodeValue()));
                        continue;
                    }
                    if (item.getNodeName().equals("OVERRIDABLE")) {
                        if (item.getNodeValue().equalsIgnoreCase("true")) {
                            cqt.addFlavor(new CIMFlavor(0));
                            continue;
                        }
                        cqt.addFlavor(new CIMFlavor(1));
                        continue;
                    }
                    if (item.getNodeName().equals("TOSUBCLASS")) {
                        if (item.getNodeValue().equalsIgnoreCase("true")) {
                            cqt.addFlavor(new CIMFlavor(3));
                            continue;
                        }
                        cqt.addFlavor(new CIMFlavor(2));
                        continue;
                    }
                    if (!item.getNodeName().equals("TRANSLATABLE") || !item.getNodeValue().equalsIgnoreCase("true")) continue;
                    cqt.addFlavor(new CIMFlavor(4));
                }
                cqt.setType(CIMDataType.getDataType(cimtype, (boolean)isarray));
                node = walker.getNextElement(null);
                continue;
            }
            if (nodename.startsWith(XmlGenericId.SCOPE)) {
                attrs = node.getAttributes();
                for (i = 0; i < attrs.getLength(); ++i) {
                    item = attrs.item(i);
                    if (item.getNodeName().equals("CLASS") && item.getNodeValue().equalsIgnoreCase("true")) {
                        cqt.addScope(new CIMScope(1));
                        continue;
                    }
                    if (item.getNodeName().equals("ASSOCIATION") && item.getNodeValue().equalsIgnoreCase("true")) {
                        cqt.addScope(new CIMScope(2));
                        continue;
                    }
                    if (item.getNodeName().equals("REFERENCE") && item.getNodeValue().equalsIgnoreCase("true")) {
                        cqt.addScope(new CIMScope(5));
                        continue;
                    }
                    if (item.getNodeName().equals("PROPERTY") && item.getNodeValue().equalsIgnoreCase("true")) {
                        cqt.addScope(new CIMScope(4));
                        continue;
                    }
                    if (item.getNodeName().equals("METHOD") && item.getNodeValue().equalsIgnoreCase("true")) {
                        cqt.addScope(new CIMScope(6));
                        continue;
                    }
                    if (item.getNodeName().equals("PARAMETER") && item.getNodeValue().equalsIgnoreCase("true")) {
                        cqt.addScope(new CIMScope(7));
                        continue;
                    }
                    if (!item.getNodeName().equals("INDICATION") || !item.getNodeValue().equalsIgnoreCase("true")) continue;
                    cqt.addScope(new CIMScope(3));
                }
                node = walker.getNextElement(null);
                continue;
            }
            if (nodename.startsWith(XmlGenericId.VALUE)) {
                cqt.setDefaultValue(OldXMLParser.getCIMValue(node, cimtype));
                break;
            }
            node = walker.getNextElement(null);
        }
        return cqt;
    }

    public static CIMValue getCIMValue(Node node, String type) throws CIMException {
        Vector<Object> o = null;
        TreeWalker walker = new TreeWalker(node);
        node = walker.getCurrent();
        while (node != null) {
            String nodename = node.getNodeName();
            if (nodename.equals(XmlGenericId.KEYVALUE)) {
                o = OldXMLParser.valueObject(node, ((ElementNode)node).getAttribute("VALUETYPE"));
                break;
            }
            if (nodename.equals(XmlGenericId.VALUE)) {
                o = OldXMLParser.valueObject(node, type);
                break;
            }
            if (nodename.equals(XmlGenericId.VALUE_ARRAY)) {
                Vector<Object> v = new Vector<Object>();
                node = walker.getNextElement(XmlGenericId.VALUE);
                while (node != null) {
                    v.addElement(OldXMLParser.valueObject(node, type));
                    node = walker.getNextElement(XmlGenericId.VALUE);
                }
                o = v;
                break;
            }
            if (nodename.equals(XmlGenericId.VALUE_REFERENCE)) {
                o = OldXMLParser.getCIMObjectPath(OldXMLParser.getFirstChildElement(node));
                break;
            }
            node = walker.getNext();
        }
        return new CIMValue(o);
    }

    private static Object valueObject(Node node, String type) throws CIMException {
        Object o = null;
        String value = OldXMLParser.getStringValue(node);
        if (value == null || type == null) {
            return value;
        }
        type = type.length() > 0 ? type : "string";
        int radix = 10;
        if (type.startsWith("sint") && (value.startsWith("0x") || value.startsWith("+0x") || value.startsWith("-0x") || value.startsWith("0X") || value.startsWith("+0X") || value.startsWith("-0X")) || type.startsWith("uint") && (value.startsWith("0x") || value.startsWith("0X"))) {
            radix = 16;
            int dot = (value.indexOf("x") > 0 ? value.indexOf("x") : value.indexOf("X")) + 1;
            String string = value = value.startsWith("-") ? "-" + value.substring(dot) : value.substring(dot);
        }
        if (type.equals("boolean")) {
            o = new Boolean(value);
        } else if (type.equals("char16")) {
            o = new Character(value.charAt(0));
        } else if (type.equals("datetime")) {
            o = new CIMDateTime(value);
        } else if (type.equals("real32")) {
            o = new Float(value);
        } else if (type.equals("real64")) {
            o = new Double(value);
        } else if (type.equals("sint16")) {
            o = Short.valueOf(value, radix);
        } else if (type.equals("sint32")) {
            o = Integer.valueOf(value, radix);
        } else if (type.equals("sint64")) {
            o = Long.valueOf(value, radix);
        } else if (type.equals("sint8")) {
            o = Byte.valueOf(value, radix);
        } else if (type.equals("string")) {
            o = value == null ? (String)o : new String(value);
        } else if (type.equals("uint16")) {
            o = new UnsignedInt16(Integer.valueOf(value, radix).intValue());
        } else if (type.equals("uint32")) {
            o = new UnsignedInt32(Long.valueOf(value, radix).longValue());
        } else if (type.equals("uint64")) {
            o = new UnsignedInt64(new BigInteger(value, radix));
        } else if (type.equals("uint8")) {
            o = new UnsignedInt8(Short.valueOf(value, radix).shortValue());
        } else if (value.indexOf("e") > 0 || value.indexOf("E") > 0) {
            o = new Double(value);
        } else if (value.startsWith("+") || value.startsWith("-")) {
            o = new Long(value);
        }
        return o;
    }

    public static boolean getBooleanValue(Node node) {
        TreeWalker walker = new TreeWalker(node);
        boolean retval = false;
        node = walker.getNextElement(XmlGenericId.VALUE);
        return OldXMLParser.getTextNode(node).equalsIgnoreCase("true");
    }

    public static Node getFirstChildElement(Node node) {
        if (node.hasChildNodes()) {
            NodeList nl = node.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node item = nl.item(i);
                if (item.getNodeType() != 1) continue;
                return item;
            }
        }
        return null;
    }

    public static String getStringValue(Node node) {
        String nodename = node.getNodeName();
        if (nodename.endsWith(XmlGenericId.PARAMVALUE)) {
            node = OldXMLParser.getFirstChildElement(node);
        }
        return OldXMLParser.getTextNode(node);
    }

    public static String getTextNode(Node node) {
        TreeWalker walker = new TreeWalker(node);
        node = walker.getCurrent();
        while (node != null) {
            if (node.getNodeType() == 3 && node != null) {
                return node.getNodeValue();
            }
            node = walker.getNext();
        }
        return null;
    }
}

