/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.util;

import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMNameSpace;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.CIMQualifierType;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.cim.XmlInstance;
import com.sun.xml.tree.XmlDocument;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.PublicKey;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.cim.UnsignedInt64;
import javax.wbem.cim.UnsignedInt8;
import javax.wbem.cimxml.CIMXml;
import javax.wbem.cimxml.CIMXmlFactory;
import javax.wbem.security.SecurityMessage;
import javax.wbem.security.SecurityToken;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ConvertCIMComSunToJavax {
    private static CIMXml xmlImpl = CIMXmlFactory.getCIMXmlImpl();

    public static synchronized Node makeNode(String pXml) throws CIMException {
        try {
            InputSource stream = new InputSource(new ByteArrayInputStream(pXml.getBytes()));
            XmlDocument doc = XmlDocument.createXmlDocument((InputSource)stream, (boolean)false);
            return doc.getDocumentElement();
        }
        catch (SAXException se) {
            throw new CIMException("CIM_ERR_INVALID_CLASS", (Object)se);
        }
        catch (IOException ioe) {
            throw new CIMException("CIM_ERR_FAILED", (Object)ioe);
        }
    }

    public static javax.wbem.cim.CIMQualifierType convertCIMQualifierType(CIMQualifierType pOld) throws CIMException {
        if (pOld == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        XmlInstance xmlInst = new XmlInstance();
        if (!xmlInst.getIncludeClassOrigin()) {
            xmlInst.setIncludeClassOrigin(true);
        }
        String xmlString = xmlInst.qualifierDeclaration(pOld);
        Node node = ConvertCIMComSunToJavax.makeNode(xmlString);
        return xmlImpl.getCIMQualifierType(node);
    }

    public static CIMClass convertCIMClass(com.sun.wbem.cim.CIMClass pOld) throws CIMException {
        if (pOld == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        XmlInstance xmlInst = new XmlInstance();
        if (!xmlInst.getIncludeClassOrigin()) {
            xmlInst.setIncludeClassOrigin(true);
        }
        xmlInst.setIncludeOverridenProperties(true);
        String xmlString = xmlInst.cimClass(pOld);
        Node node = ConvertCIMComSunToJavax.makeNode(xmlString);
        CIMClass cc = xmlImpl.getCIMClass(node);
        Vector<javax.wbem.cim.CIMProperty> nv = new Vector<javax.wbem.cim.CIMProperty>();
        Vector v = pOld.getAllProperties();
        if (v != null && v.size() != 0) {
            for (CIMProperty cp : v) {
                javax.wbem.cim.CIMProperty ncp = cc.getProperty(cp.getName(), cp.getOriginClass());
                if (ncp != null) {
                    ncp.setOverridingProperty(cp.getOverridingProperty());
                }
                nv.addElement(ncp);
            }
        }
        cc.setProperties(nv);
        return cc;
    }

    public static javax.wbem.cim.CIMInstance convertCIMInstance(CIMInstance pOld) throws CIMException {
        if (pOld == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        XmlInstance xmlInst = new XmlInstance();
        if (!xmlInst.getIncludeClassOrigin()) {
            xmlInst.setIncludeClassOrigin(true);
        }
        String xmlString = xmlInst.instance(pOld);
        Node node = ConvertCIMComSunToJavax.makeNode(xmlString);
        javax.wbem.cim.CIMInstance ci = xmlImpl.getCIMInstance(node);
        ConvertCIMComSunToJavax.fixCIMInstance(ci, pOld);
        return ci;
    }

    public static javax.wbem.cim.CIMNameSpace convertCIMNameSpace(CIMNameSpace pOld) throws CIMException {
        if (pOld == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        return new javax.wbem.cim.CIMNameSpace(pOld.getHost(), pOld.getNameSpace());
    }

    public static javax.wbem.cim.CIMValue convertCIMValue(CIMValue pOld) throws CIMException {
        if (pOld == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        XmlInstance xmlInst = new XmlInstance();
        if (!xmlInst.getIncludeClassOrigin()) {
            xmlInst.setIncludeClassOrigin(true);
        }
        String xmlString = xmlInst.value(pOld);
        Node node = ConvertCIMComSunToJavax.makeNode(xmlString);
        com.sun.wbem.cim.CIMDataType dt = null;
        com.sun.wbem.cim.CIMDataType tmpType = pOld.getType();
        if (tmpType != null && tmpType.isArrayType()) {
            int arrayType = tmpType.getType();
            int simpleType = com.sun.wbem.cim.CIMDataType.findSimpleType((int)arrayType);
            dt = com.sun.wbem.cim.CIMDataType.getPredefinedType((int)simpleType);
        } else {
            dt = tmpType;
        }
        return xmlImpl.getCIMValue(node, dt == null ? null : dt.toString());
    }

    public static CIMObjectPath convertCIMObjectPath(com.sun.wbem.cim.CIMObjectPath pOld) throws CIMException {
        if (pOld == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        XmlInstance xmlInst = new XmlInstance();
        if (!xmlInst.getIncludeClassOrigin()) {
            xmlInst.setIncludeClassOrigin(true);
        }
        String xmlString = xmlInst.objectPath(pOld);
        Node node = ConvertCIMComSunToJavax.makeNode(xmlString);
        CIMObjectPath op = xmlImpl.getCIMObjectPath(node);
        ConvertCIMComSunToJavax.fixCIMObjectPath(op, pOld);
        return op;
    }

    public static SecurityMessage convertSecurityMessage(com.sun.wbem.security.SecurityMessage pOld) {
        SecurityMessage newMsg = null;
        byte[] challenge = pOld.getChallenge();
        byte[] response = pOld.getResponse();
        byte[] checkSum = pOld.getChecksum();
        byte[] sessionId = pOld.getSessionId();
        PublicKey pk = pOld.getPublicKey();
        if (pOld.isHello()) {
            byte[] nameSpace = pOld.getNameSpace();
            byte[] userDigest = pOld.getUserDigest();
            byte[] isLabeledSys = pOld.getLabeledSystem();
            byte[] isRoleWsLogin = pOld.getRoleWSLogin();
            newMsg = SecurityMessage.hello((byte[])challenge, (byte[])userDigest, (byte[])nameSpace, (byte[])isLabeledSys, (byte[])isRoleWsLogin, (byte[])checkSum);
        } else if (pOld.isResponse()) {
            newMsg = SecurityMessage.response((byte[])response, (PublicKey)pk, (byte[])sessionId, (byte[])checkSum);
        } else if (pOld.isChallenge()) {
            byte[] salt = pOld.getSalt();
            newMsg = SecurityMessage.challenge((byte[])challenge, (byte[])salt, (byte[])sessionId, (byte[])checkSum);
        } else if (pOld.isResult()) {
            newMsg = SecurityMessage.result((byte[])sessionId, (PublicKey)pk, (byte[])response, (byte[])checkSum);
        } else if (pOld.isError()) {
            String msg = pOld.getMessage();
            newMsg = SecurityMessage.error((String)msg);
        }
        return newMsg;
    }

    public static SecurityToken convertSecurityToken(com.sun.wbem.security.SecurityToken pOld) {
        SecurityToken newTok = new SecurityToken();
        byte[] checkSum = pOld.getChecksum();
        byte[] sig = pOld.getSignature();
        byte[] sessionId = pOld.getSessionId();
        newTok.setChecksum(checkSum);
        newTok.setSignature(sig);
        newTok.setSessionId(sessionId);
        return newTok;
    }

    private static void fixCIMInstance(javax.wbem.cim.CIMInstance inst, CIMInstance pOld) throws CIMException {
        if (inst == null || pOld == null) {
            return;
        }
        Vector v = inst.getProperties();
        if (v == null || v.size() == 0) {
            return;
        }
        for (javax.wbem.cim.CIMProperty cp : v) {
            javax.wbem.cim.CIMValue value;
            CIMDataType type;
            if (cp == null || (type = cp.getType()) == null || (value = cp.getValue()) == null || !type.isReferenceType()) continue;
            CIMProperty cpOld = pOld.getProperty(cp.getName());
            ConvertCIMComSunToJavax.fixCIMObjectPath((CIMObjectPath)value.getValue(), (com.sun.wbem.cim.CIMObjectPath)cpOld.getValue().getValue());
        }
    }

    private static void fixCIMObjectPath(CIMObjectPath path, com.sun.wbem.cim.CIMObjectPath pOld) {
        if (path == null || pOld == null) {
            return;
        }
        Vector v = path.getKeys();
        if (v == null || v.size() == 0) {
            return;
        }
        javax.wbem.cim.CIMProperty[] keys = new javax.wbem.cim.CIMProperty[v.size()];
        v.toArray(keys);
        v = pOld.getKeys();
        if (v == null || v.size() == 0) {
            return;
        }
        CIMProperty[] metakeys = new CIMProperty[v.size()];
        v.toArray(metakeys);
        for (int i = 0; i < keys.length; ++i) {
            ConvertCIMComSunToJavax.fixInstancekeyProperty(keys[i], metakeys);
        }
    }

    private static void fixInstancekeyProperty(javax.wbem.cim.CIMProperty p, CIMProperty[] metakeys) {
        String name = p.getName();
        for (int i = 0; i < metakeys.length; ++i) {
            if (!p.getName().equals(metakeys[i].getName())) continue;
            if (metakeys[i].getType().isReferenceType()) {
                ConvertCIMComSunToJavax.fixCIMObjectPath((CIMObjectPath)p.getValue().getValue(), (com.sun.wbem.cim.CIMObjectPath)metakeys[i].getValue().getValue());
                continue;
            }
            ConvertCIMComSunToJavax.convertType(p, metakeys[i].getType());
        }
    }

    private static void convertType(javax.wbem.cim.CIMProperty p, com.sun.wbem.cim.CIMDataType type) {
        Object value;
        if (p == null) {
            return;
        }
        String cimtype = type.toString();
        if (p != null && p.getValue() != null && (value = p.getValue().getValue()) instanceof String) {
            String strVal = (String)value;
            Object o = ConvertCIMComSunToJavax.valueObject(strVal, cimtype);
            p.setValue(new javax.wbem.cim.CIMValue(o));
            p.setType(new CIMDataType(type.getType()));
        }
    }

    private static Object valueObject(String value, String type) {
        Object o = null;
        type = type.length() > 0 ? type : "string";
        int radix = 10;
        if (type.startsWith("sint") && (value.startsWith("0x") || value.startsWith("+0x") || value.startsWith("-0x") || value.startsWith("0X") || value.startsWith("+0X") || value.startsWith("-0X")) || type.startsWith("uint") && (value.startsWith("0x") || value.startsWith("0X"))) {
            radix = 16;
            int dot = (value.indexOf("x") > 0 ? value.indexOf("x") : value.indexOf("X")) + 1;
            String string = value = value.startsWith("-") ? "-" + value.substring(dot) : value.substring(dot);
        }
        if (type.equals("boolean")) {
            o = Boolean.valueOf(value);
        } else if (type.equals("char16")) {
            o = new Character(value.charAt(0));
        } else if (type.equals("datetime")) {
            o = new CIMDateTime(value);
        } else if (type.equals("real32")) {
            o = new Float(value);
        } else if (type.equals("real64")) {
            o = new Double(value);
        } else if (type.equals("sint16")) {
            o = Short.valueOf(value, radix);
        } else if (type.equals("sint32")) {
            o = Integer.valueOf(value, radix);
        } else if (type.equals("sint64")) {
            o = Long.valueOf(value, radix);
        } else if (type.equals("sint8")) {
            o = Byte.valueOf(value, radix);
        } else if (type.equals("string")) {
            o = value == null ? "" : new String(value);
        } else if (type.equals("uint16")) {
            o = new UnsignedInt16(Integer.valueOf(value, radix).intValue());
        } else if (type.equals("uint32")) {
            o = new UnsignedInt32(Long.valueOf(value, radix).longValue());
        } else if (type.equals("uint64")) {
            o = new UnsignedInt64(new BigInteger(value, radix));
        } else if (type.equals("uint8")) {
            o = new UnsignedInt8(Short.valueOf(value, radix).shortValue());
        } else if (value.indexOf("e") > 0 || value.indexOf("E") > 0) {
            o = new Double(value);
        } else if (value.startsWith("+") || value.startsWith("-")) {
            o = new Long(value);
        }
        return o;
    }
}

