/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class DagTraversor {
    private static final int UNVISITED = 0;
    private static final int VISITING = 1;
    private static final int VISITED = 2;
    private static final int FAILED = 3;
    private String[] nodeNames;
    private String[] dependencies;
    private Callback dcb;
    private HashMap stateMap;

    public DagTraversor(String[] nodeNames, String[] linkNames, Callback callback) {
        this.nodeNames = nodeNames;
        this.dependencies = linkNames;
        this.dcb = callback;
    }

    public void start() {
        if (this.nodeNames == null || this.dependencies == null || this.dcb == null) {
            return;
        }
        this.stateMap = new HashMap();
        for (int i = 0; i < this.nodeNames.length; ++i) {
            List l = this.dag(this.nodeNames[i]);
            if (l == null || l.size() <= 1) continue;
            String[] cycleInfo = new String[l.size()];
            l.toArray(cycleInfo);
            this.dcb.cycleDetected(cycleInfo);
        }
    }

    private List dag(String nodeName) {
        Integer state = (Integer)this.stateMap.get(nodeName);
        if (state != null) {
            int i = state;
            switch (i) {
                case 1: 
                case 3: {
                    ArrayList<String> l = new ArrayList<String>();
                    l.add(nodeName);
                    return l;
                }
                case 2: {
                    return null;
                }
            }
        }
        this.stateMap.put(nodeName, new Integer(1));
        for (int k = 0; k < this.dependencies.length; ++k) {
            String[] dependNodes = this.dcb.dependNodes(nodeName, this.dependencies[k]);
            if (dependNodes == null) continue;
            for (int j = 0; j < dependNodes.length; ++j) {
                List cycleInfo = this.dag(dependNodes[j]);
                if (cycleInfo == null) continue;
                this.stateMap.put(nodeName, new Integer(3));
                cycleInfo.add(0, this.dependencies[k]);
                cycleInfo.add(0, nodeName);
                return cycleInfo;
            }
        }
        this.stateMap.put(nodeName, new Integer(2));
        this.dcb.noCycles(nodeName);
        return null;
    }

    public static interface Callback {
        public String[] dependNodes(String var1, String var2);

        public void noCycles(String var1);

        public void cycleDetected(String[] var1);
    }
}

