/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.client;

import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMNameSpace;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.cimom.AssociatorNamesOperation;
import com.sun.wbem.cimom.AssociatorsOperation;
import com.sun.wbem.cimom.BatchOperationFactory;
import com.sun.wbem.cimom.CIMOMOperation;
import com.sun.wbem.cimom.CIMOMServer;
import com.sun.wbem.cimom.CIMOMUtils;
import com.sun.wbem.cimom.CommonServerSecurityContext;
import com.sun.wbem.cimom.DeliveryHandler;
import com.sun.wbem.cimom.EnumClassOperation;
import com.sun.wbem.cimom.EnumInstanceNamesOperation;
import com.sun.wbem.cimom.EnumInstancesOperation;
import com.sun.wbem.cimom.EventService;
import com.sun.wbem.cimom.GetClassOperation;
import com.sun.wbem.cimom.GetInstanceOperation;
import com.sun.wbem.cimom.LogFile;
import com.sun.wbem.cimom.ReferenceNamesOperation;
import com.sun.wbem.cimom.ReferencesOperation;
import com.sun.wbem.cimom.ServerSecurity;
import com.sun.wbem.cimom.adapter.client.ClientProtocolAdapterIF;
import com.sun.wbem.client.CIMEvent;
import com.sun.wbem.client.CIMOM1Impl;
import com.sun.wbem.client.CIMOM2Impl;
import com.sun.wbem.client.CheckSumGen;
import com.sun.wbem.client.GeneralAPI;
import com.sun.wbem.client.adapter.rmi.RemoteCIMListener;
import com.sun.wbem.util.ConvertCIMComSunToJavax;
import com.sun.wbem.util.ConvertCIMJavaxToComSun;
import java.net.InetAddress;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RMISocketFactory;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMQualifierType;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.client.CIMAssociatorNamesOp;
import javax.wbem.client.CIMAssociatorsOp;
import javax.wbem.client.CIMEnumClassOp;
import javax.wbem.client.CIMEnumInstanceNamesOp;
import javax.wbem.client.CIMEnumInstancesOp;
import javax.wbem.client.CIMGetClassOp;
import javax.wbem.client.CIMGetInstanceOp;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.CIMOperation;
import javax.wbem.client.CIMReferenceNamesOp;
import javax.wbem.client.CIMReferencesOp;
import javax.wbem.client.CIMSecurityException;
import javax.wbem.client.Debug;
import javax.wbem.security.SecurityMessage;
import javax.wbem.security.SecurityToken;
import javax.wbem.security.SecurityUtil;

public class CIMOMSunRMIImpl
implements ClientProtocolAdapterIF {
    static boolean verbose = false;
    private HashMap generalAPIHash = new HashMap();
    private static final String FUNCTION_SET_LISTENER = "setListener";
    private static final String FUNCTION_ASSUME_ROLE = "assumeRole";
    private static final String FUNCTION_ASSOCIATORS = "associators";
    private static final String FUNCTION_ASSOCIATORNAMES = "associatorNames";
    private static final String FUNCTION_REFERENCES = "references";
    private static final String FUNCTION_REFERENCENAMES = "referenceNames";
    private static final String FUNCTION_PERFORMBATCHOPERATIONS = "performOperations";
    private static final String FUNCTION_ENUMERATEINSTANCES = "enumerateInstances";
    private static final String FUNCTION_ENUMERATEINSTANCENAMES = "enumerateInstanceNames";
    private static final String FUNCTION_ENUMERATECLASSES = "enumerateClasses";
    private static final String FUNCTION_GETINSTANCE = "getInstance";
    private static final String FUNCTION_GETCLASS = "getClass";
    private static final String FUNCTION_GETVERSION = "getVersion";
    private HashMap sessionMap = new HashMap();
    private static CheckSumGen cscsg = new CheckSumGen();
    private static final String READ = "read";
    private static final String WRITE = "write";
    private static final String PORT = "PortNumber";
    private static final String RMIPORT = "5987";
    private static final String RMIPORTPROP = "com.sun.wbem.rmiport";
    private static Class fac_class = null;
    CIMOMServer comp;

    public void initialize(CIMOMServer cimom, CIMOMHandle ch) {
        this.comp = cimom;
        DeliveryHandler.registerIndicationHandler((String)"solaris_rmidelivery", (EventService.IndicationHandler)new RMIIndicationHandler());
    }

    public int startService(javax.wbem.cim.CIMInstance cpa) {
        int rmiport;
        try {
            javax.wbem.cim.CIMValue cv = cpa.getProperty(PORT).getValue();
            rmiport = ((UnsignedInt32)cv.getValue()).intValue();
        }
        catch (NullPointerException ex) {
            Debug.trace2((String)"Got exception getting the RMI port number", (Throwable)ex);
            rmiport = Integer.parseInt(System.getProperty(RMIPORTPROP, RMIPORT));
        }
        try {
            Registry reg;
            if (fac_class == null) {
                String fac_str = System.getProperty("com.sun.wbem.rmisocketfactory.class");
                fac_class = fac_str != null ? Class.forName(fac_str) : RMISocketFactory.getDefaultSocketFactory().getClass();
            }
            String hostAddress = InetAddress.getLocalHost().getHostAddress();
            try {
                reg = LocateRegistry.createRegistry(rmiport, (RMIClientSocketFactory)fac_class.newInstance(), (RMIServerSocketFactory)fac_class.newInstance());
            }
            catch (RemoteException e) {
                reg = LocateRegistry.getRegistry(hostAddress, rmiport, (RMIClientSocketFactory)fac_class.newInstance());
                Debug.trace2((String)"Ignoring createRegistry exception", (Throwable)e);
            }
            System.setSecurityManager(new RMISecurityManager());
            reg.rebind("CIMOM2", new CIMOM2Impl(this));
            reg.rebind("CIMOM1", new CIMOM1Impl(this));
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        return 0;
    }

    public int stopService() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SecurityMessage hello(String version, SecurityMessage cm, String clientHost) throws CIMException {
        try {
            ServerSecurity ss = new ServerSecurity();
            ss.setClientHostName(clientHost);
            String us = CIMOMUtils.getUniqueString();
            SecurityMessage sm = ss.generateChallenge(version, cm, us.getBytes());
            HashMap hashMap = this.sessionMap;
            synchronized (hashMap) {
                this.sessionMap.put(us, ss);
            }
            return sm;
        }
        catch (CIMException e) {
            if (verbose) {
                e.printStackTrace();
            }
            throw e;
        }
        catch (Exception e) {
            if (verbose) {
                e.printStackTrace();
            }
            throw new CIMException("CIM_ERR_FAILED", (Object)e);
        }
    }

    private byte[] convertTo16(byte[] sessionKey) {
        byte[] output = new byte[16];
        System.arraycopy(sessionKey, 0, output, 0, 5);
        System.arraycopy(sessionKey, 0, output, 5, 5);
        System.arraycopy(sessionKey, 0, output, 10, 5);
        output[15] = sessionKey[0];
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SecurityMessage credentials(String version, SecurityMessage cm, String clientHost) throws CIMException {
        SecurityMessage sm = null;
        ServerSecurity ss = this.getServerSecurity(new String(cm.getSessionId()));
        ss.setClientHostName(clientHost);
        ServerSecurity serverSecurity = ss;
        synchronized (serverSecurity) {
            byte[] sessionKey = new byte[5];
            SecurityUtil.secrand.nextBytes(sessionKey);
            sessionKey = this.convertTo16(sessionKey);
            try {
                sm = ss.validateResponse(ss.getChallenge(), ss.getShadow(), ss.getPublicKey(), sessionKey, cm);
            }
            catch (CIMException e) {
                HashMap hashMap = this.sessionMap;
                synchronized (hashMap) {
                    this.sessionMap.remove(new String(cm.getSessionId()));
                }
                if (verbose) {
                    e.printStackTrace();
                }
                throw e;
            }
            catch (Exception e) {
                if (verbose) {
                    e.printStackTrace();
                }
                throw new CIMException("CIM_ERR_FAILED", (Object)e);
            }
            return sm;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(String version, SecurityToken st) throws CIMException {
        ServerSecurity ss;
        String[] oarray = new String[]{version, "close"};
        try {
            ss = this.getServerSecurity(new String(st.getSessionId()));
        }
        catch (CIMSecurityException e) {
            return;
        }
        ServerSecurity serverSecurity = ss;
        synchronized (serverSecurity) {
            this.serverSecurityAuthInc(ss, oarray, st);
            HashMap hashMap = this.sessionMap;
            synchronized (hashMap) {
                this.sessionMap.remove(new String(st.getSessionId()));
            }
        }
        this.comp.close(version, ss);
    }

    void deleteNameSpace(String version, javax.wbem.cim.CIMNameSpace parent, javax.wbem.cim.CIMNameSpace nameSpace, SecurityToken st, String[] oarray) throws CIMException {
        javax.wbem.cim.CIMNameSpace validNS = new javax.wbem.cim.CIMNameSpace();
        if (nameSpace == null) {
            nameSpace = new javax.wbem.cim.CIMNameSpace("", "");
        }
        validNS.setNameSpace(parent.getNameSpace() + "\\" + nameSpace.getNameSpace());
        String ns = validNS.getNameSpace().replace('\\', '/');
        String parentNS = ns.substring(0, ns.lastIndexOf("/"));
        ServerSecurity ss = this.serverSecurityDo(oarray, st, WRITE, parentNS, true);
        this.comp.deleteNameSpace(version, parent, nameSpace, ss);
    }

    void createNameSpace(String version, javax.wbem.cim.CIMNameSpace parent, javax.wbem.cim.CIMNameSpace nameSpace, SecurityToken st, String[] oarray) throws CIMException {
        javax.wbem.cim.CIMNameSpace validNS = new javax.wbem.cim.CIMNameSpace();
        if (nameSpace == null) {
            nameSpace = new javax.wbem.cim.CIMNameSpace("", "");
        }
        validNS.setNameSpace(parent.getNameSpace() + "\\" + nameSpace.getNameSpace());
        String ns = validNS.getNameSpace().replace('\\', '/');
        String parentNS = ns.substring(0, ns.lastIndexOf("/"));
        ServerSecurity ss = this.serverSecurityDo(oarray, st, WRITE, parentNS, true);
        this.comp.createNameSpace(version, parent, nameSpace, ss);
    }

    void addCIMElement(String version, javax.wbem.cim.CIMNameSpace nameSpace, CIMObjectPath objectName, CIMQualifierType qt, SecurityToken st, String[] oarray) throws CIMException {
        ServerSecurity ss = this.serverSecurityDo(oarray, st, WRITE, this.getNameSpace(nameSpace, objectName), true);
        this.comp.createQualifierType(version, nameSpace, objectName, qt, ss);
    }

    void addCIMElement(String version, javax.wbem.cim.CIMNameSpace nameSpace, CIMObjectPath objectName, CIMClass cc, SecurityToken st, String[] oarray) throws CIMException {
        ServerSecurity ss = this.serverSecurityDo(oarray, st, WRITE, this.getNameSpace(nameSpace, objectName), true);
        this.comp.createClass(version, nameSpace, objectName, cc, ss);
    }

    CIMObjectPath addCIMElement(String version, javax.wbem.cim.CIMNameSpace nameSpace, CIMObjectPath objectName, javax.wbem.cim.CIMInstance ci, SecurityToken st, String[] oarray) throws CIMException {
        ServerSecurity ss = this.serverSecurityDo(oarray, st, WRITE, this.getNameSpace(nameSpace, objectName), false);
        return this.comp.createInstance(version, nameSpace, objectName, ci, ss);
    }

    void setCIMElement(String version, javax.wbem.cim.CIMNameSpace nameSpace, CIMObjectPath objectName, CIMQualifierType qt, SecurityToken st, String[] oarray) throws CIMException {
        ServerSecurity ss = this.serverSecurityDo(oarray, st, WRITE, this.getNameSpace(nameSpace, objectName), true);
        this.comp.setQualifierType(version, nameSpace, objectName, qt, ss);
    }

    void setCIMElement(String version, javax.wbem.cim.CIMNameSpace nameSpace, CIMObjectPath objectName, CIMClass cc, SecurityToken st, String[] oarray) throws CIMException {
        ServerSecurity ss = this.serverSecurityDo(oarray, st, WRITE, this.getNameSpace(nameSpace, objectName), true);
        this.comp.setClass(version, nameSpace, objectName, cc, ss);
    }

    void setCIMElement(String version, javax.wbem.cim.CIMNameSpace nameSpace, CIMObjectPath objectName, javax.wbem.cim.CIMInstance ci, SecurityToken st, String[] oarray) throws CIMException {
        ServerSecurity ss = this.serverSecurityDo(oarray, st, WRITE, this.getNameSpace(nameSpace, objectName), false);
        this.comp.setInstance(version, nameSpace, objectName, ci, ss);
    }

    void setProperty(String version, javax.wbem.cim.CIMNameSpace nameSpace, CIMObjectPath objectName, String propertyName, javax.wbem.cim.CIMValue cv, SecurityToken st, String[] oarray) throws CIMException {
        ServerSecurity ss = this.serverSecurityDo(oarray, st, WRITE, this.getNameSpace(nameSpace, objectName), false);
        this.comp.setProperty(version, nameSpace, objectName, propertyName, cv, ss);
    }

    Vector execQuery(String version, javax.wbem.cim.CIMNameSpace nameSpace, CIMObjectPath relNS, String query, int ql, SecurityToken st, String[] oarray) throws CIMException {
        ServerSecurity ss = this.serverSecurityDo(oarray, st, READ, this.getNameSpace(nameSpace, relNS), false);
        return this.comp.execQuery(version, nameSpace, relNS, query, "WQL", ss);
    }

    CIMClass getClass(String version, javax.wbem.cim.CIMNameSpace nameSpace, CIMObjectPath objectName, boolean localOnly, SecurityToken st, String[] oarray) throws CIMException {
        ServerSecurity ss = this.serverSecurityDo(oarray, st, READ, this.getNameSpace(nameSpace, objectName), true);
        return this.comp.getClass(version, nameSpace, objectName, new Boolean(localOnly), Boolean.TRUE, Boolean.TRUE, null, ss);
    }

    Vector invokeMethod(String version, javax.wbem.cim.CIMNameSpace nameSpace, CIMObjectPath objectName, String methodName, Vector inParams, SecurityToken st, String[] oarray) throws CIMException {
        ServerSecurity ss = this.serverSecurityDo(oarray, st, WRITE, this.getNameSpace(nameSpace, objectName), false);
        Vector v = this.comp.invokeMethod(version, nameSpace, objectName, methodName, inParams, ss);
        Vector<CIMValue> scVector = new Vector<CIMValue>();
        try {
            Enumeration e = v.elements();
            while (e.hasMoreElements()) {
                CIMValue scValue = ConvertCIMJavaxToComSun.convertCIMValue((javax.wbem.cim.CIMValue)e.nextElement());
                scVector.addElement(scValue);
            }
        }
        catch (Exception e) {
            throw new CIMException("CIM_ERR_FAILED");
        }
        return scVector;
    }

    javax.wbem.cim.CIMInstance getInstance(String version, javax.wbem.cim.CIMNameSpace nameSpace, CIMObjectPath objectName, boolean localOnly, SecurityToken st, String[] oarray) throws CIMException {
        ServerSecurity ss = this.serverSecurityDo(oarray, st, READ, this.getNameSpace(nameSpace, objectName), false);
        return this.comp.getInstance(version, nameSpace, objectName, localOnly, ss);
    }

    javax.wbem.cim.CIMValue getProperty(String version, javax.wbem.cim.CIMNameSpace nameSpace, CIMObjectPath objectName, String propertyName, SecurityToken st, String[] oarray) throws CIMException {
        ServerSecurity ss = this.serverSecurityDo(oarray, st, READ, this.getNameSpace(nameSpace, objectName), false);
        return this.comp.getProperty(version, nameSpace, objectName, propertyName, ss);
    }

    CIMQualifierType getQualifierType(String version, javax.wbem.cim.CIMNameSpace nameSpace, CIMObjectPath objectName, SecurityToken st, String[] oarray) throws CIMException {
        ServerSecurity ss = this.serverSecurityDo(oarray, st, READ, this.getNameSpace(nameSpace, objectName), true);
        return this.comp.getQualifierType(version, nameSpace, objectName, ss);
    }

    void deleteClass(String version, javax.wbem.cim.CIMNameSpace ns, CIMObjectPath path, SecurityToken st, String[] oarray) throws CIMException {
        LogFile.methodEntry((String)"deleteClass");
        ServerSecurity ss = this.serverSecurityDo(oarray, st, WRITE, this.getNameSpace(ns, path), true);
        this.comp.deleteClass(version, ns, path, ss);
    }

    void deleteInstance(String version, javax.wbem.cim.CIMNameSpace ns, CIMObjectPath path, SecurityToken st, String[] oarray) throws CIMException {
        ServerSecurity ss = this.serverSecurityDo(oarray, st, WRITE, this.getNameSpace(ns, path), false);
        this.comp.deleteInstance(version, ns, path, ss);
    }

    void deleteQualifierType(String version, javax.wbem.cim.CIMNameSpace ns, CIMObjectPath path, SecurityToken st, String[] oarray) throws CIMException {
        ServerSecurity ss = this.serverSecurityDo(oarray, st, WRITE, this.getNameSpace(ns, path), true);
        this.comp.deleteQualifierType(version, ns, path, ss);
    }

    Vector enumNameSpace(String version, javax.wbem.cim.CIMNameSpace ns, CIMObjectPath path, boolean deep, SecurityToken st, String[] oarray) throws CIMException {
        ServerSecurity ss = this.serverSecurityDo(oarray, st, READ, this.getNameSpace(ns, path), true);
        return this.comp.enumNameSpace(version, ns, path, deep, ss);
    }

    Vector enumClass(String version, javax.wbem.cim.CIMNameSpace ns, CIMObjectPath path, boolean deep, SecurityToken st, String[] oarray) throws CIMException {
        ServerSecurity ss = this.serverSecurityDo(oarray, st, READ, this.getNameSpace(ns, path), true);
        return this.comp.enumerateClassNames(version, ns, path, new Boolean(deep), ss);
    }

    Vector enumClass(String version, javax.wbem.cim.CIMNameSpace ns, CIMObjectPath path, boolean deep, boolean localOnly, SecurityToken st, String[] oarray) throws CIMException {
        ServerSecurity ss = this.serverSecurityDo(oarray, st, READ, this.getNameSpace(ns, path), true);
        return this.comp.enumerateClasses(version, ns, path, new Boolean(deep), new Boolean(localOnly), Boolean.TRUE, Boolean.TRUE, ss);
    }

    Vector enumInstances(String version, javax.wbem.cim.CIMNameSpace ns, CIMObjectPath path, boolean deep, SecurityToken st, String[] oarray) throws CIMException {
        ServerSecurity ss = this.serverSecurityDo(oarray, st, READ, this.getNameSpace(ns, path), false);
        return this.comp.enumInstances(version, ns, path, deep, ss);
    }

    Vector enumInstances(String version, javax.wbem.cim.CIMNameSpace ns, CIMObjectPath path, boolean deep, boolean localOnly, SecurityToken st, String[] oarray) throws CIMException {
        ServerSecurity ss = this.serverSecurityDo(oarray, st, READ, this.getNameSpace(ns, path), false);
        return this.comp.enumInstances(version, ns, path, deep, localOnly, ss);
    }

    Vector enumQualifierTypes(String version, javax.wbem.cim.CIMNameSpace ns, CIMObjectPath path, SecurityToken st, String[] oarray) throws CIMException {
        ServerSecurity ss = this.serverSecurityDo(oarray, st, READ, this.getNameSpace(ns, path), true);
        Vector qualifierTypes = this.comp.enumQualifierTypes(version, ns, path, ss);
        Vector<com.sun.wbem.cim.CIMObjectPath> qualifierOps = new Vector<com.sun.wbem.cim.CIMObjectPath>();
        if (qualifierTypes != null) {
            ns.setNameSpace("\\" + ns.getNameSpace());
            String nSpace = this.getNameSpace(ns, path);
            Enumeration en = qualifierTypes.elements();
            while (en.hasMoreElements()) {
                CIMQualifierType qt = (CIMQualifierType)en.nextElement();
                CIMObjectPath qtop = new CIMObjectPath(qt.getName(), nSpace);
                try {
                    qualifierOps.addElement(ConvertCIMJavaxToComSun.convertCIMObjectPath(qtop));
                }
                catch (com.sun.wbem.cim.CIMException cimEx) {
                    throw new CIMException("CIM_ERR_FAILED", (Object)qtop.toString());
                }
            }
        } else {
            return qualifierTypes;
        }
        return qualifierOps;
    }

    Vector generalAPI(Vector input) throws CIMException {
        return this._generalAPI(input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServerSecurity getServerSecurity(String s) throws CIMSecurityException {
        HashMap hashMap = this.sessionMap;
        synchronized (hashMap) {
            ServerSecurity ss = (ServerSecurity)this.sessionMap.get(s);
            if (ss == null) {
                throw new CIMSecurityException("NO_SUCH_SESSION", (Object)s);
            }
            return ss;
        }
    }

    private void serverSecurityAuthInc(ServerSecurity ss, String[] oarray, SecurityToken st) throws CIMException {
        ss.authenticateRequest(oarray, st);
        ss.incSessionKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerSecurity serverSecurityDo(String[] oarray, SecurityToken st, String rw, String nameSpace, boolean verify) throws CIMException {
        try {
            ServerSecurity ss;
            ServerSecurity serverSecurity = ss = this.getServerSecurity(new String(st.getSessionId()));
            synchronized (serverSecurity) {
                this.serverSecurityAuthInc(ss, oarray, st);
                return ss;
            }
        }
        catch (CIMException e) {
            if (verbose) {
                e.printStackTrace();
            }
            throw e;
        }
    }

    private String getNameSpace(javax.wbem.cim.CIMNameSpace ns, CIMObjectPath op) {
        if (op == null) {
            op = new CIMObjectPath();
        }
        if (ns == null) {
            ns = new javax.wbem.cim.CIMNameSpace("", "");
        }
        String s = ns.getNameSpace() + "\\" + op.getNameSpace();
        javax.wbem.cim.CIMNameSpace cns = new javax.wbem.cim.CIMNameSpace();
        cns.setNameSpace(s);
        return cns.getNameSpace();
    }

    private Vector _generalAPI(Vector input) throws CIMException {
        SecurityToken st = null;
        ServerSecurity ss = null;
        String functionName = null;
        if (input == null || input.size() < 3) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        try {
            com.sun.wbem.security.SecurityToken oldST = (com.sun.wbem.security.SecurityToken)input.elementAt(0);
            st = ConvertCIMComSunToJavax.convertSecurityToken(oldST);
            functionName = (String)input.elementAt(2);
            ss = this.getServerSecurity(new String(st.getSessionId()));
        }
        catch (Exception ex) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        if (functionName == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        GeneralAPI api = (GeneralAPI)this.generalAPIHash.get(functionName);
        if (api == null) {
            try {
                String className = this.getClass().getName() + "$GeneralAPI_" + functionName;
                Class<?> generalAPIClass = Class.forName(className);
                this.generalAPIHash.put(functionName, generalAPIClass.newInstance());
                api = (GeneralAPI)this.generalAPIHash.get(functionName);
            }
            catch (Exception ex) {
                ss.incSessionKey();
                throw new CIMException("CIM_ERR_NOT_SUPPORTED");
            }
        }
        return api.executeGeneralAPI(this.comp, ss, input);
    }

    private static class GeneralAPI_setListener
    implements GeneralAPI {
        GeneralAPI_setListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Vector executeGeneralAPI(CIMOMServer cimom, ServerSecurity ss, Vector input) throws CIMException {
            if (input.size() != 4) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            try {
                final com.sun.wbem.client.RemoteCIMListener csrl = (com.sun.wbem.client.RemoteCIMListener)input.elementAt(3);
                RemoteCIMListener rl = new RemoteCIMListener(){

                    public void indicationOccured(javax.wbem.client.CIMEvent e, String[] destination) throws RemoteException {
                        CIMEvent cse = null;
                        try {
                            cse = e.getIndication() == null ? new CIMEvent(null) : new CIMEvent(ConvertCIMJavaxToComSun.convertCIMInstance(e.getIndication()));
                        }
                        catch (com.sun.wbem.cim.CIMException cimex) {
                            cimex.printStackTrace();
                        }
                        csrl.indicationOccured(cse);
                    }

                    public void isAvailable() throws RemoteException {
                        csrl.isAvailable();
                    }
                };
                ServerSecurity serverSecurity = ss;
                synchronized (serverSecurity) {
                    ss.setListener(rl);
                }
            }
            catch (Exception ex) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            return null;
        }
    }

    private static class GeneralAPI_references
    implements GeneralAPI {
        GeneralAPI_references() {
        }

        public Vector executeGeneralAPI(CIMOMServer cimom, ServerSecurity ss, Vector input) throws CIMException {
            String version = null;
            SecurityToken st = null;
            Object assocClass = null;
            String resultClass = null;
            String role = null;
            Object resultRole = null;
            javax.wbem.cim.CIMNameSpace ns = null;
            CIMNameSpace csns = null;
            CIMObjectPath op = null;
            com.sun.wbem.cim.CIMObjectPath csop = null;
            boolean includeQualifiers = false;
            boolean includeClassOrigin = false;
            String[] propertyList = null;
            ReferencesOperation oper = null;
            CIMReferencesOp cimop = null;
            if (input.size() != 10) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            try {
                csns = (CIMNameSpace)input.elementAt(3);
                ns = ConvertCIMComSunToJavax.convertCIMNameSpace(csns);
                csop = (com.sun.wbem.cim.CIMObjectPath)input.elementAt(4);
                op = ConvertCIMComSunToJavax.convertCIMObjectPath(csop);
                st = ConvertCIMComSunToJavax.convertSecurityToken((com.sun.wbem.security.SecurityToken)input.elementAt(0));
                resultClass = (String)input.elementAt(5);
                role = (String)input.elementAt(6);
                includeQualifiers = (Boolean)input.elementAt(7);
                includeClassOrigin = (Boolean)input.elementAt(8);
                propertyList = (String[])input.elementAt(9);
                version = (String)input.elementAt(1);
            }
            catch (Exception ex) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            cimop = new CIMReferencesOp(op, resultClass, role, includeQualifiers, includeClassOrigin, propertyList);
            cimop.setNameSpace(ns);
            oper = new ReferencesOperation(cimom, ss, cimop, version);
            String[] oarray = new String[]{version, CIMOMSunRMIImpl.FUNCTION_REFERENCES, cscsg.toString(csns), cscsg.toString(csop), resultClass, role};
            ss.authenticateRequest(oarray, st);
            ss.incSessionKey();
            oper.run();
            Object result = oper.getResult();
            if (result instanceof CIMException) {
                throw (CIMException)((Object)result);
            }
            if (result instanceof Exception) {
                throw new CIMException("CIM_ERR_FAILED", result);
            }
            Vector<Object> sunV = new Vector<Object>();
            try {
                Enumeration e = ((Vector)result).elements();
                while (e.hasMoreElements()) {
                    Object o = e.nextElement();
                    if (o instanceof javax.wbem.cim.CIMInstance) {
                        sunV.addElement(ConvertCIMJavaxToComSun.convertCIMInstance((javax.wbem.cim.CIMInstance)o));
                        continue;
                    }
                    sunV.addElement(ConvertCIMJavaxToComSun.convertCIMClass((CIMClass)o));
                }
            }
            catch (com.sun.wbem.cim.CIMException cimEx) {
                throw new CIMException("CIM_ERR_FAILED", result);
            }
            Vector<Vector<Object>> encapVector = new Vector<Vector<Object>>();
            encapVector.addElement(sunV);
            return encapVector;
        }
    }

    private static class GeneralAPI_referenceNames
    implements GeneralAPI {
        GeneralAPI_referenceNames() {
        }

        public Vector executeGeneralAPI(CIMOMServer cimom, ServerSecurity ss, Vector input) throws CIMException {
            String version = null;
            SecurityToken st = null;
            Object assocClass = null;
            String resultClass = null;
            String role = null;
            Object resultRole = null;
            javax.wbem.cim.CIMNameSpace ns = null;
            CIMNameSpace csns = null;
            CIMObjectPath op = null;
            com.sun.wbem.cim.CIMObjectPath csop = null;
            ReferenceNamesOperation oper = null;
            CIMReferenceNamesOp cimop = null;
            if (input.size() != 7) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            try {
                csns = (CIMNameSpace)input.elementAt(3);
                ns = ConvertCIMComSunToJavax.convertCIMNameSpace(csns);
                csop = (com.sun.wbem.cim.CIMObjectPath)input.elementAt(4);
                op = ConvertCIMComSunToJavax.convertCIMObjectPath(csop);
                st = ConvertCIMComSunToJavax.convertSecurityToken((com.sun.wbem.security.SecurityToken)input.elementAt(0));
                resultClass = (String)input.elementAt(5);
                role = (String)input.elementAt(6);
                version = (String)input.elementAt(1);
            }
            catch (Exception ex) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            cimop = new CIMReferenceNamesOp(op, resultClass, role);
            cimop.setNameSpace(ns);
            oper = new ReferenceNamesOperation(cimom, ss, cimop, version);
            String[] oarray = new String[]{version, CIMOMSunRMIImpl.FUNCTION_REFERENCENAMES, cscsg.toString(csns), cscsg.toString(csop), resultClass, role};
            ss.authenticateRequest(oarray, st);
            ss.incSessionKey();
            oper.run();
            Object result = oper.getResult();
            if (result instanceof CIMException) {
                throw (CIMException)((Object)result);
            }
            if (result instanceof Exception) {
                throw new CIMException("CIM_ERR_FAILED", result);
            }
            Vector<com.sun.wbem.cim.CIMObjectPath> sunV = new Vector<com.sun.wbem.cim.CIMObjectPath>();
            try {
                Enumeration e = ((Vector)result).elements();
                while (e.hasMoreElements()) {
                    sunV.addElement(ConvertCIMJavaxToComSun.convertCIMObjectPath((CIMObjectPath)e.nextElement()));
                }
            }
            catch (com.sun.wbem.cim.CIMException cimEx) {
                throw new CIMException("CIM_ERR_FAILED", result);
            }
            Vector<Vector<com.sun.wbem.cim.CIMObjectPath>> encapVector = new Vector<Vector<com.sun.wbem.cim.CIMObjectPath>>();
            encapVector.addElement(sunV);
            return encapVector;
        }
    }

    private static class GeneralAPI_performOperations
    implements GeneralAPI {
        GeneralAPI_performOperations() {
        }

        public Vector executeGeneralAPI(CIMOMServer cimom, ServerSecurity ss, Vector input) throws CIMException {
            if (input.size() != 4) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            String version = null;
            SecurityToken st = null;
            CIMOperation[] opArray = null;
            try {
                st = ConvertCIMComSunToJavax.convertSecurityToken((com.sun.wbem.security.SecurityToken)input.elementAt(0));
                version = (String)input.elementAt(1);
                opArray = (CIMOperation[])input.elementAt(3);
            }
            catch (Exception ex) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            StringBuffer buff = new StringBuffer();
            for (int i = 0; i < opArray.length; ++i) {
                buff.append(opArray[i].getClass().getName());
            }
            String[] oarray = new String[]{version, buff.toString()};
            ss.authenticateRequest(oarray, st);
            ss.incSessionKey();
            Vector<Object> retObjs = new Vector<Object>();
            for (int i = 0; i < opArray.length; ++i) {
                CIMOperation op = opArray[i];
                CIMOMOperation cimomOp = BatchOperationFactory.getCIMOMOperation((CIMOMServer)cimom, (ServerSecurity)ss, (CIMOperation)op, (String)version);
                cimomOp.run();
                retObjs.addElement(cimomOp.getResult());
            }
            return retObjs;
        }
    }

    private static class GeneralAPI_getVersion
    implements GeneralAPI {
        GeneralAPI_getVersion() {
        }

        public Vector executeGeneralAPI(CIMOMServer cimom, ServerSecurity ss, Vector input) throws CIMException {
            Vector<Integer> outp = new Vector<Integer>();
            outp.addElement(new Integer(2));
            outp.addElement(new Integer(4));
            return outp;
        }
    }

    private static class GeneralAPI_getInstance
    implements GeneralAPI {
        GeneralAPI_getInstance() {
        }

        public Vector executeGeneralAPI(CIMOMServer cimom, ServerSecurity ss, Vector input) throws CIMException {
            String[] propertyList;
            String version = null;
            SecurityToken st = null;
            javax.wbem.cim.CIMNameSpace ns = null;
            CIMNameSpace csns = null;
            CIMObjectPath op = null;
            com.sun.wbem.cim.CIMObjectPath csop = null;
            boolean includeQualifiers = false;
            boolean includeClassOrigin = false;
            boolean localOnly = false;
            GetInstanceOperation oper = null;
            CIMGetInstanceOp cimop = null;
            if (input.size() != 9) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            try {
                csns = (CIMNameSpace)input.elementAt(3);
                ns = ConvertCIMComSunToJavax.convertCIMNameSpace(csns);
                csop = (com.sun.wbem.cim.CIMObjectPath)input.elementAt(4);
                op = ConvertCIMComSunToJavax.convertCIMObjectPath(csop);
                st = ConvertCIMComSunToJavax.convertSecurityToken((com.sun.wbem.security.SecurityToken)input.elementAt(0));
                localOnly = (Boolean)input.elementAt(5);
                includeQualifiers = (Boolean)input.elementAt(6);
                includeClassOrigin = (Boolean)input.elementAt(7);
                propertyList = (String[])input.elementAt(8);
                version = (String)input.elementAt(1);
            }
            catch (Exception ex) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            cimop = new CIMGetInstanceOp(op, localOnly, includeQualifiers, includeClassOrigin, propertyList);
            cimop.setNameSpace(ns);
            oper = new GetInstanceOperation(cimom, ss, cimop, version);
            CheckSumGen csg = new CheckSumGen();
            String[] oarray = new String[]{version, CIMOMSunRMIImpl.FUNCTION_GETINSTANCE, cscsg.toString(csns), cscsg.toString(csop), new Boolean(localOnly).toString()};
            ss.authenticateRequest(oarray, st);
            ss.incSessionKey();
            oper.run();
            Object result = oper.getResult();
            if (result instanceof CIMException) {
                throw (CIMException)((Object)result);
            }
            if (result instanceof Exception) {
                throw new CIMException("CIM_ERR_FAILED", result);
            }
            Vector<CIMInstance> outp = new Vector<CIMInstance>();
            try {
                outp.addElement(ConvertCIMJavaxToComSun.convertCIMInstance((javax.wbem.cim.CIMInstance)result));
            }
            catch (com.sun.wbem.cim.CIMException e) {
                throw new CIMException("CIM_ERR_FAILED", result);
            }
            return outp;
        }
    }

    private static class GeneralAPI_getClass
    implements GeneralAPI {
        GeneralAPI_getClass() {
        }

        public Vector executeGeneralAPI(CIMOMServer cimom, ServerSecurity ss, Vector input) throws CIMException {
            String[] propertyList;
            String version = null;
            SecurityToken st = null;
            javax.wbem.cim.CIMNameSpace ns = null;
            CIMNameSpace csns = null;
            CIMObjectPath op = null;
            com.sun.wbem.cim.CIMObjectPath csop = null;
            boolean includeQualifiers = false;
            boolean includeClassOrigin = false;
            boolean localOnly = false;
            GetClassOperation oper = null;
            CIMGetClassOp cimop = null;
            if (input.size() != 9) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            try {
                csns = (CIMNameSpace)input.elementAt(3);
                ns = ConvertCIMComSunToJavax.convertCIMNameSpace(csns);
                csop = (com.sun.wbem.cim.CIMObjectPath)input.elementAt(4);
                op = ConvertCIMComSunToJavax.convertCIMObjectPath(csop);
                st = ConvertCIMComSunToJavax.convertSecurityToken((com.sun.wbem.security.SecurityToken)input.elementAt(0));
                localOnly = (Boolean)input.elementAt(5);
                includeQualifiers = (Boolean)input.elementAt(6);
                includeClassOrigin = (Boolean)input.elementAt(7);
                propertyList = (String[])input.elementAt(8);
                version = (String)input.elementAt(1);
            }
            catch (Exception ex) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            cimop = new CIMGetClassOp(op, localOnly, includeQualifiers, includeClassOrigin, propertyList);
            cimop.setNameSpace(ns);
            oper = new GetClassOperation(cimom, ss, cimop, version);
            CheckSumGen csg = new CheckSumGen();
            String[] oarray = new String[]{version, CIMOMSunRMIImpl.FUNCTION_GETCLASS, cscsg.toString(csns), cscsg.toString(csop), new Boolean(localOnly).toString()};
            ss.authenticateRequest(oarray, st);
            ss.incSessionKey();
            oper.run();
            Object result = oper.getResult();
            if (result instanceof CIMException) {
                throw (CIMException)((Object)result);
            }
            if (result instanceof Exception) {
                throw new CIMException("CIM_ERR_FAILED", result);
            }
            Vector<com.sun.wbem.cim.CIMClass> outp = new Vector<com.sun.wbem.cim.CIMClass>();
            try {
                outp.addElement(ConvertCIMJavaxToComSun.convertCIMClass((CIMClass)result));
            }
            catch (com.sun.wbem.cim.CIMException e) {
                throw new CIMException("CIM_ERR_FAILED", result);
            }
            return outp;
        }
    }

    private static class GeneralAPI_enumerateInstances
    implements GeneralAPI {
        GeneralAPI_enumerateInstances() {
        }

        public Vector executeGeneralAPI(CIMOMServer cimom, ServerSecurity ss, Vector input) throws CIMException {
            String[] propertyList;
            String version = null;
            SecurityToken st = null;
            javax.wbem.cim.CIMNameSpace ns = null;
            CIMNameSpace csns = null;
            CIMObjectPath op = null;
            com.sun.wbem.cim.CIMObjectPath csop = null;
            boolean includeQualifiers = false;
            boolean includeClassOrigin = false;
            boolean localOnly = false;
            boolean deep = false;
            EnumInstancesOperation oper = null;
            CIMEnumInstancesOp cimop = null;
            if (input.size() != 10) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            try {
                csns = (CIMNameSpace)input.elementAt(3);
                ns = ConvertCIMComSunToJavax.convertCIMNameSpace(csns);
                csop = (com.sun.wbem.cim.CIMObjectPath)input.elementAt(4);
                op = ConvertCIMComSunToJavax.convertCIMObjectPath(csop);
                st = ConvertCIMComSunToJavax.convertSecurityToken((com.sun.wbem.security.SecurityToken)input.elementAt(0));
                deep = (Boolean)input.elementAt(5);
                localOnly = (Boolean)input.elementAt(6);
                includeQualifiers = (Boolean)input.elementAt(7);
                includeClassOrigin = (Boolean)input.elementAt(8);
                propertyList = (String[])input.elementAt(9);
                version = (String)input.elementAt(1);
            }
            catch (Exception ex) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            cimop = new CIMEnumInstancesOp(op, deep, localOnly, includeQualifiers, includeClassOrigin, propertyList);
            cimop.setNameSpace(ns);
            oper = new EnumInstancesOperation(cimom, ss, cimop, version);
            CheckSumGen csg = new CheckSumGen();
            String[] oarray = new String[]{version, CIMOMSunRMIImpl.FUNCTION_ENUMERATEINSTANCES, cscsg.toString(csns), cscsg.toString(csop), new Boolean(deep).toString()};
            ss.authenticateRequest(oarray, st);
            ss.incSessionKey();
            oper.run();
            Object result = oper.getResult();
            if (result instanceof CIMException) {
                throw (CIMException)((Object)result);
            }
            if (result instanceof Exception) {
                throw new CIMException("CIM_ERR_FAILED", result);
            }
            Vector<CIMInstance> sunV = new Vector<CIMInstance>();
            try {
                Enumeration e = ((Vector)result).elements();
                while (e.hasMoreElements()) {
                    sunV.addElement(ConvertCIMJavaxToComSun.convertCIMInstance((javax.wbem.cim.CIMInstance)e.nextElement()));
                }
            }
            catch (com.sun.wbem.cim.CIMException e) {
                throw new CIMException("CIM_ERR_FAILED", (Object)"");
            }
            catch (Exception ee) {
                throw new CIMException("CIM_ERR_FAILED", sunV);
            }
            return sunV;
        }
    }

    private static class GeneralAPI_enumerateInstanceNames
    implements GeneralAPI {
        GeneralAPI_enumerateInstanceNames() {
        }

        public Vector executeGeneralAPI(CIMOMServer cimom, ServerSecurity ss, Vector input) throws CIMException {
            String version = null;
            SecurityToken st = null;
            javax.wbem.cim.CIMNameSpace ns = null;
            CIMNameSpace csns = null;
            CIMObjectPath op = null;
            com.sun.wbem.cim.CIMObjectPath csop = null;
            boolean deep = false;
            EnumInstanceNamesOperation oper = null;
            CIMEnumInstanceNamesOp cimop = null;
            if (input.size() != 5) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            try {
                csns = (CIMNameSpace)input.elementAt(3);
                ns = ConvertCIMComSunToJavax.convertCIMNameSpace(csns);
                csop = (com.sun.wbem.cim.CIMObjectPath)input.elementAt(4);
                op = ConvertCIMComSunToJavax.convertCIMObjectPath(csop);
                version = (String)input.elementAt(1);
                st = ConvertCIMComSunToJavax.convertSecurityToken((com.sun.wbem.security.SecurityToken)input.elementAt(0));
            }
            catch (Exception ex) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            cimop = new CIMEnumInstanceNamesOp(op);
            cimop.setNameSpace(ns);
            oper = new EnumInstanceNamesOperation(cimom, ss, cimop, version);
            CheckSumGen csg = new CheckSumGen();
            String[] oarray = new String[]{version, CIMOMSunRMIImpl.FUNCTION_ENUMERATEINSTANCENAMES, cscsg.toString(csns), cscsg.toString(csop)};
            ss.authenticateRequest(oarray, st);
            ss.incSessionKey();
            oper.run();
            Object result = oper.getResult();
            if (result instanceof CIMException) {
                throw (CIMException)((Object)result);
            }
            if (result instanceof Exception) {
                throw new CIMException("CIM_ERR_FAILED", result);
            }
            Vector<com.sun.wbem.cim.CIMObjectPath> sunV = new Vector<com.sun.wbem.cim.CIMObjectPath>();
            try {
                Enumeration e = ((Vector)result).elements();
                while (e.hasMoreElements()) {
                    sunV.addElement(ConvertCIMJavaxToComSun.convertCIMObjectPath((CIMObjectPath)e.nextElement()));
                }
            }
            catch (com.sun.wbem.cim.CIMException e) {
                throw new CIMException("CIM_ERR_FAILED", result);
            }
            return sunV;
        }
    }

    private static class GeneralAPI_enumerateClasses
    implements GeneralAPI {
        GeneralAPI_enumerateClasses() {
        }

        public Vector executeGeneralAPI(CIMOMServer cimom, ServerSecurity ss, Vector input) throws CIMException {
            String version = null;
            SecurityToken st = null;
            javax.wbem.cim.CIMNameSpace ns = null;
            CIMNameSpace csns = null;
            CIMObjectPath op = null;
            com.sun.wbem.cim.CIMObjectPath csop = null;
            boolean includeQualifiers = false;
            boolean includeClassOrigin = false;
            boolean localOnly = false;
            boolean deep = false;
            EnumClassOperation oper = null;
            CIMEnumClassOp cimop = null;
            if (input.size() != 9) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            try {
                csns = (CIMNameSpace)input.elementAt(3);
                ns = ConvertCIMComSunToJavax.convertCIMNameSpace(csns);
                csop = (com.sun.wbem.cim.CIMObjectPath)input.elementAt(4);
                op = ConvertCIMComSunToJavax.convertCIMObjectPath(csop);
                deep = (Boolean)input.elementAt(5);
                localOnly = (Boolean)input.elementAt(6);
                includeQualifiers = (Boolean)input.elementAt(7);
                includeClassOrigin = (Boolean)input.elementAt(8);
                version = (String)input.elementAt(1);
                st = ConvertCIMComSunToJavax.convertSecurityToken((com.sun.wbem.security.SecurityToken)input.elementAt(0));
            }
            catch (Exception ex) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            cimop = new CIMEnumClassOp(op, deep, localOnly, includeQualifiers, includeClassOrigin);
            cimop.setNameSpace(ns);
            oper = new EnumClassOperation(cimom, ss, cimop, version);
            CheckSumGen csg = new CheckSumGen();
            String[] oarray = new String[]{version, CIMOMSunRMIImpl.FUNCTION_ENUMERATECLASSES, cscsg.toString(csns), cscsg.toString(csop), new Boolean(deep).toString()};
            ss.authenticateRequest(oarray, st);
            ss.incSessionKey();
            oper.run();
            Object result = oper.getResult();
            if (result instanceof CIMException) {
                throw (CIMException)((Object)result);
            }
            if (result instanceof Exception) {
                throw new CIMException("CIM_ERR_FAILED", result);
            }
            Vector<com.sun.wbem.cim.CIMClass> sunV = new Vector<com.sun.wbem.cim.CIMClass>();
            try {
                Enumeration e = ((Vector)result).elements();
                while (e.hasMoreElements()) {
                    sunV.addElement(ConvertCIMJavaxToComSun.convertCIMClass((CIMClass)e.nextElement()));
                }
            }
            catch (com.sun.wbem.cim.CIMException e) {
                throw new CIMException("CIM_ERR_FAILED", result);
            }
            return sunV;
        }
    }

    private static class GeneralAPI_assumeRole
    implements GeneralAPI {
        GeneralAPI_assumeRole() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Vector executeGeneralAPI(CIMOMServer cimom, ServerSecurity ss, Vector input) throws CIMException {
            if (input.size() != 5) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            String role_name = null;
            String role_paswd = null;
            SecurityToken st = null;
            String version = null;
            String functionName = null;
            if (input.size() != 5) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            try {
                functionName = (String)input.elementAt(2);
                role_name = (String)input.elementAt(3);
                role_paswd = (String)input.elementAt(4);
                st = ConvertCIMComSunToJavax.convertSecurityToken((com.sun.wbem.security.SecurityToken)input.elementAt(0));
                version = (String)input.elementAt(1);
            }
            catch (Exception ex) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            try {
                String[] oarray = new String[]{version, functionName, role_name, role_paswd};
                ServerSecurity serverSecurity = ss;
                synchronized (serverSecurity) {
                    ss.authenticateRequest(oarray, st);
                    ss.incSessionKey();
                    ss.assumeRole(role_name, role_paswd);
                }
            }
            catch (CIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CIMException("CIM_ERR_FAILED", (Object)e);
            }
            return null;
        }
    }

    private static class GeneralAPI_associators
    implements GeneralAPI {
        GeneralAPI_associators() {
        }

        public Vector executeGeneralAPI(CIMOMServer cimom, ServerSecurity ss, Vector input) throws CIMException {
            String version = null;
            SecurityToken st = null;
            String assocClass = null;
            String resultClass = null;
            String role = null;
            String resultRole = null;
            javax.wbem.cim.CIMNameSpace ns = null;
            CIMNameSpace csns = null;
            CIMObjectPath op = null;
            com.sun.wbem.cim.CIMObjectPath csop = null;
            boolean includeQualifiers = false;
            boolean includeClassOrigin = false;
            String[] propertyList = null;
            AssociatorsOperation oper = null;
            CIMAssociatorsOp cimop = null;
            if (input.size() != 12) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            try {
                csns = (CIMNameSpace)input.elementAt(3);
                ns = ConvertCIMComSunToJavax.convertCIMNameSpace(csns);
                csop = (com.sun.wbem.cim.CIMObjectPath)input.elementAt(4);
                op = ConvertCIMComSunToJavax.convertCIMObjectPath(csop);
                assocClass = (String)input.elementAt(5);
                resultClass = (String)input.elementAt(6);
                role = (String)input.elementAt(7);
                resultRole = (String)input.elementAt(8);
                version = (String)input.elementAt(1);
                st = ConvertCIMComSunToJavax.convertSecurityToken((com.sun.wbem.security.SecurityToken)input.elementAt(0));
                includeQualifiers = (Boolean)input.elementAt(9);
                includeClassOrigin = (Boolean)input.elementAt(10);
                propertyList = (String[])input.elementAt(11);
            }
            catch (Exception ex) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            cimop = new CIMAssociatorsOp(op, assocClass, resultClass, role, resultRole, includeQualifiers, includeClassOrigin, propertyList);
            cimop.setNameSpace(ns);
            oper = new AssociatorsOperation(cimom, ss, cimop, version);
            String[] oarray = new String[]{version, CIMOMSunRMIImpl.FUNCTION_ASSOCIATORS, cscsg.toString(csns), cscsg.toString(csop), assocClass, resultClass, role, resultRole};
            ss.authenticateRequest(oarray, st);
            ss.incSessionKey();
            oper.run();
            Object result = oper.getResult();
            if (result instanceof CIMException) {
                throw (CIMException)((Object)result);
            }
            if (result instanceof Exception) {
                throw new CIMException("CIM_ERR_FAILED", result);
            }
            Vector<Object> sunV = new Vector<Object>();
            try {
                Enumeration e = ((Vector)result).elements();
                while (e.hasMoreElements()) {
                    Object o = e.nextElement();
                    if (o instanceof javax.wbem.cim.CIMInstance) {
                        sunV.addElement(ConvertCIMJavaxToComSun.convertCIMInstance((javax.wbem.cim.CIMInstance)o));
                        continue;
                    }
                    sunV.addElement(ConvertCIMJavaxToComSun.convertCIMClass((CIMClass)o));
                }
            }
            catch (com.sun.wbem.cim.CIMException cimEx) {
                throw new CIMException("CIM_ERR_FAILED", result);
            }
            Vector<Vector<Object>> encapVector = new Vector<Vector<Object>>();
            encapVector.addElement(sunV);
            return encapVector;
        }
    }

    private static class GeneralAPI_associatorNames
    implements GeneralAPI {
        GeneralAPI_associatorNames() {
        }

        public Vector executeGeneralAPI(CIMOMServer cimom, ServerSecurity ss, Vector input) throws CIMException {
            String version = null;
            SecurityToken st = null;
            String assocClass = null;
            String resultClass = null;
            String role = null;
            String resultRole = null;
            javax.wbem.cim.CIMNameSpace ns = null;
            CIMNameSpace csns = null;
            CIMObjectPath op = null;
            com.sun.wbem.cim.CIMObjectPath csop = null;
            AssociatorNamesOperation oper = null;
            CIMAssociatorNamesOp cimop = null;
            if (input.size() != 9) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            try {
                csns = (CIMNameSpace)input.elementAt(3);
                ns = ConvertCIMComSunToJavax.convertCIMNameSpace(csns);
                csop = (com.sun.wbem.cim.CIMObjectPath)input.elementAt(4);
                op = ConvertCIMComSunToJavax.convertCIMObjectPath(csop);
                assocClass = (String)input.elementAt(5);
                resultClass = (String)input.elementAt(6);
                role = (String)input.elementAt(7);
                resultRole = (String)input.elementAt(8);
                version = (String)input.elementAt(1);
                st = ConvertCIMComSunToJavax.convertSecurityToken((com.sun.wbem.security.SecurityToken)input.elementAt(0));
            }
            catch (Exception ex) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            cimop = new CIMAssociatorNamesOp(op, assocClass, resultClass, role, resultRole);
            cimop.setNameSpace(ns);
            oper = new AssociatorNamesOperation(cimom, ss, cimop, version);
            String[] oarray = new String[]{version, CIMOMSunRMIImpl.FUNCTION_ASSOCIATORNAMES, cscsg.toString(csns), cscsg.toString(csop), assocClass, resultClass, role, resultRole};
            ss.authenticateRequest(oarray, st);
            ss.incSessionKey();
            oper.run();
            Object result = oper.getResult();
            if (result instanceof CIMException) {
                throw (CIMException)((Object)result);
            }
            if (result instanceof Exception) {
                throw new CIMException("CIM_ERR_FAILED", result);
            }
            Vector<com.sun.wbem.cim.CIMObjectPath> sunV = new Vector<com.sun.wbem.cim.CIMObjectPath>();
            try {
                Enumeration e = ((Vector)result).elements();
                while (e.hasMoreElements()) {
                    sunV.addElement(ConvertCIMJavaxToComSun.convertCIMObjectPath((CIMObjectPath)e.nextElement()));
                }
            }
            catch (com.sun.wbem.cim.CIMException cimEx) {
                throw new CIMException("CIM_ERR_FAILED", result);
            }
            Vector<Vector<com.sun.wbem.cim.CIMObjectPath>> encapVector = new Vector<Vector<com.sun.wbem.cim.CIMObjectPath>>();
            encapVector.addElement(sunV);
            return encapVector;
        }
    }

    class RMIIndicationHandler
    implements EventService.IndicationHandler {
        RMIIndicationHandler() {
        }

        private RemoteCIMListener getRemoteListener(javax.wbem.cim.CIMInstance handlerInstance) throws CIMException {
            String sessionID = (String)handlerInstance.getProperty("name").getValue().getValue();
            ServerSecurity ss = (ServerSecurity)CIMOMSunRMIImpl.this.sessionMap.get(sessionID);
            return ss.getListener();
        }

        public CommonServerSecurityContext getSecurityContext(javax.wbem.cim.CIMInstance handlerInstance) {
            String sessionID = (String)handlerInstance.getProperty("name").getValue().getValue();
            return (CommonServerSecurityContext)CIMOMSunRMIImpl.this.sessionMap.get(sessionID);
        }

        public void deliverEvent(javax.wbem.client.CIMEvent e, javax.wbem.cim.CIMInstance handlerInstance) throws CIMException {
            RemoteCIMListener rl = this.getRemoteListener(handlerInstance);
            try {
                rl.indicationOccured(e, null);
            }
            catch (Exception ex) {
                throw new CIMException("CIM_ERR_FAILED", (Object)ex);
            }
        }

        public void ping(javax.wbem.cim.CIMInstance handlerInstance) throws CIMException {
            RemoteCIMListener rl = this.getRemoteListener(handlerInstance);
            try {
                rl.isAvailable();
            }
            catch (Exception ex) {
                throw new CIMException("CIM_ERR_FAILED", (Object)ex);
            }
        }
    }
}

