/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.services.audit;

import com.sun.audit.AuditSession;
import com.sun.management.services.audit.ConsoleAuditEvent;
import com.sun.management.services.audit.ConsoleAuditException;
import com.sun.management.services.audit.ConsoleAuditSession;
import com.sun.management.services.authentication.UserRolePrincipal;
import com.sun.management.services.authorization.AuthorizationServiceFactory;
import com.sun.management.services.common.CCServiceLibrary;
import com.sun.management.services.common.Debug;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.security.auth.Subject;

public class SolarisAuditSession
implements ConsoleAuditSession {
    private static final String[] EVENT_TABLE_IF = new String[]{"com.sun.management.services.audit.ConsoleAuditEvent_Login", "com.sun.management.services.audit.ConsoleAuditEvent_Logout", "com.sun.management.services.audit.ConsoleAuditEvent_RoleLogin", "com.sun.management.services.audit.ConsoleAuditEvent_Authorization"};
    private static final String[] EVENT_TABLE_IMPL = new String[]{"com.sun.management.services.audit.SolarisAuditEvent_Login", "com.sun.management.services.audit.SolarisAuditEvent_Logout", "com.sun.management.services.audit.SolarisAuditEvent_RoleLogin", "com.sun.management.services.audit.SolarisAuditEvent_Authorization"};
    private static final String USER_ROLE_PRINCIPAL_CLASS_NAME = "com.sun.management.services.authentication.UserRolePrincipal";
    private static final String AUDIT_TYPE_SOLARIS = "Solaris";
    private static final String UNKNOWN = "unknown";
    private AuditSession auditSession = null;
    private String prefix = "Audit(Solaris): ";
    private String username = null;
    private String rolename = null;
    private String hostname = null;
    private int portnum = 0;

    public SolarisAuditSession() {
        this(AUDIT_TYPE_SOLARIS, null);
    }

    public SolarisAuditSession(String string) {
        this(string, null);
    }

    public SolarisAuditSession(String string, byte[] byArray) {
        try {
            this.auditSession = new AuditSession(byArray);
        }
        catch (Throwable throwable) {
            Debug.trace1((String)(this.prefix + "error creating audit session: " + throwable.getMessage()));
        }
        if (this.auditSession != null && !this.auditSession.auditOn()) {
            this.auditSession = null;
            Debug.trace1((String)(this.prefix + "auditing subsystem unavailable"));
        }
    }

    public Object getPlatformAuditSession() throws ConsoleAuditException {
        return this.auditSession;
    }

    public String getSessionId() throws ConsoleAuditException {
        if (this.auditSession == null) {
            return null;
        }
        String string = null;
        try {
            string = this.auditSession.getSessionId();
        }
        catch (Throwable throwable) {
            throw new ConsoleAuditException("audit_err_09", throwable.getLocalizedMessage());
        }
        return string;
    }

    public boolean isAuditOn() {
        if (this.auditSession == null) {
            return false;
        }
        return this.auditSession.auditOn();
    }

    public byte[] exportSession() throws ConsoleAuditException {
        if (this.auditSession == null) {
            return null;
        }
        byte[] byArray = null;
        try {
            byArray = this.auditSession.exportSession();
        }
        catch (Throwable throwable) {
            throw new ConsoleAuditException("audit_err_10", throwable.getLocalizedMessage());
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIdentity(Subject subject, String string, int n) {
        Object object;
        if (this.auditSession == null) {
            return;
        }
        String string2 = null;
        String string3 = null;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        UserRolePrincipal userRolePrincipal = (UserRolePrincipal)AuthorizationServiceFactory.getPrincipal((Subject)subject, (String)USER_ROLE_PRINCIPAL_CLASS_NAME);
        if (userRolePrincipal != null) {
            string2 = userRolePrincipal.getUserName();
            string3 = userRolePrincipal.getRoleName();
            try {
                n2 = CCServiceLibrary.getUserId((String)string2);
                n3 = CCServiceLibrary.getGroupId((String)string2);
            }
            catch (Exception exception) {
                Debug.trace1((String)(this.prefix + "error getting user uid: " + exception.getMessage()));
            }
            if (string3 != null) {
                try {
                    n4 = CCServiceLibrary.getUserId((String)string3);
                    n5 = CCServiceLibrary.getGroupId((String)string3);
                }
                catch (Exception exception) {
                    Debug.trace1((String)(this.prefix + "error getting role uid: " + exception.getMessage()));
                }
            }
        } else {
            object = AuthorizationServiceFactory.getPrincipal((Subject)subject, null);
            if (object != null) {
                string2 = object.getName();
            }
        }
        object = this;
        synchronized (object) {
            try {
                this.auditSession.setUser(n2, n3, n2, n3, string, 0);
                if (string3 != null) {
                    this.auditSession.setUser(n4, n5, n4, n5, string, 1);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.username = string2;
            this.rolename = string3;
            this.hostname = string;
            this.portnum = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserName() {
        String string;
        String string2;
        SolarisAuditSession solarisAuditSession = this;
        synchronized (solarisAuditSession) {
            string2 = this.username;
            string = this.rolename;
        }
        if (string2 != null) {
            if (string != null) {
                string2 = string + "(" + string2 + ")";
            }
        } else {
            string2 = UNKNOWN;
        }
        return string2;
    }

    public ConsoleAuditEvent getAuditEvent(String string) throws ConsoleAuditException {
        Class clazz = this.getAuditEventClass(string);
        ConsoleAuditEvent consoleAuditEvent = null;
        try {
            Class[] classArray = new Class[]{ConsoleAuditSession.class};
            Object[] objectArray = new Object[]{this};
            Constructor constructor = clazz.getConstructor(classArray);
            consoleAuditEvent = (ConsoleAuditEvent)constructor.newInstance(objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            Debug.trace1((String)(this.prefix + "new event constructor error: " + throwable.getMessage()));
            throw new ConsoleAuditException("audit_err_06", string, throwable.getMessage());
        }
        catch (Exception exception) {
            Debug.trace1((String)(this.prefix + "new event unexpected error: " + exception.getMessage()));
            throw new ConsoleAuditException("audit_err_06", string, exception.getMessage());
        }
        return consoleAuditEvent;
    }

    public void setLabel(String string) throws ConsoleAuditException {
        Debug.trace1((String)(this.prefix + "setting security label!"));
    }

    public void dispose() {
        Debug.trace3((String)(this.prefix + "clean up session"));
        this.auditSession = null;
    }

    private Class getAuditEventClass(String string) throws ConsoleAuditException {
        String string2 = null;
        if (string != null) {
            for (int i = 0; i < EVENT_TABLE_IF.length; ++i) {
                if (!string.equals(EVENT_TABLE_IF[i])) continue;
                string2 = EVENT_TABLE_IMPL[i];
                break;
            }
        }
        if (string2 == null) {
            String string3 = string == null ? "null" : string;
            Debug.trace1((String)(this.prefix + "unsupported event: " + string3));
            throw new ConsoleAuditException("audit_err_07", string3);
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string2);
        }
        catch (Exception exception) {
            Debug.trace1((String)(this.prefix + "event class not found: " + string2));
            throw new ConsoleAuditException("audit_err_08", string2);
        }
        return clazz;
    }
}

