/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.common.util;

import com.sun.admin.volmgr.common.Device;
import com.sun.admin.volmgr.server.SVMAPI;
import java.rmi.RemoteException;
import java.util.Vector;

public class Util {
    public static String getDeviceBaseName(Device device) {
        int n;
        String string = (String)device.getProperty("name");
        if (string != null && (n = string.indexOf(47)) != -1) {
            String string2 = string.substring(n + 1);
            int n2 = string.indexOf("of ");
            if (n2 != -1) {
                String string3 = string.substring(0, n2 + 3);
                string2 = string3 + string2;
            }
            string = string2;
        }
        return string;
    }

    public static String getDeviceFullName(Device device) {
        return (String)device.getProperty("name");
    }

    private static Device getTypeFromAssociation(SVMAPI sVMAPI, Device device, Object object, String string, boolean bl) {
        Vector vector;
        try {
            vector = bl ? sVMAPI.getDependents(device, string) : sVMAPI.getAntecedents(device, string);
        }
        catch (RemoteException remoteException) {
            return null;
        }
        if (vector != null) {
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                Object object2;
                Device device2 = (Device)vector.get(i);
                if (device2 == null || !object.equals(object2 = device2.getProperty("type"))) continue;
                return device2;
            }
        }
        return null;
    }

    private static Device getDiskSetFromVolume(SVMAPI sVMAPI, Device device) {
        Vector vector;
        Device device2 = Util.getTypeFromAssociation(sVMAPI, device, "Diskset", "ExtentInDiskGroup", true);
        if (device2 != null) {
            return device2;
        }
        try {
            vector = sVMAPI.getAllDependents(device);
        }
        catch (RemoteException remoteException) {
            return null;
        }
        if (vector != null) {
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                Device device3 = (Device)vector.get(i);
                device2 = Util.getDiskSet(sVMAPI, device3);
                if (device2 == null) continue;
                return device2;
            }
        }
        return null;
    }

    private static Device getDiskSetFromHSP(SVMAPI sVMAPI, Device device) {
        return Util.getTypeFromAssociation(sVMAPI, device, "Diskset", "ExtentRedundancyComponent", true);
    }

    private static Device getDiskSetFromDisk(SVMAPI sVMAPI, Device device) {
        return Util.getTypeFromAssociation(sVMAPI, device, "Diskset", "DriveInDiskGroup", true);
    }

    private static Device getDiskSetFromSlice(SVMAPI sVMAPI, Device device) {
        Device device2 = Util.getTypeFromAssociation(sVMAPI, device, "Disk", "ResidesOn", true);
        if (device2 != null) {
            return Util.getDiskSetFromDisk(sVMAPI, device2);
        }
        return null;
    }

    private static Device getDiskSetFromHost(SVMAPI sVMAPI, Device device) {
        return Util.getTypeFromAssociation(sVMAPI, device, "Diskset", "HostInDiskGroup", true);
    }

    public static Device getDiskSet(SVMAPI sVMAPI, Device device) {
        Object object = device.getProperty("type");
        if ("Diskset".equals(object)) {
            return device;
        }
        if ("Concat".equals(object) || "Stripe".equals(object) || "Raid".equals(object) || "Mirror".equals(object) || "Trans".equals(object) || "Metadb".equals(object)) {
            return Util.getDiskSetFromVolume(sVMAPI, device);
        }
        if ("Hsp".equals(object)) {
            return Util.getDiskSetFromHSP(sVMAPI, device);
        }
        if ("Disk".equals(object)) {
            return Util.getDiskSetFromDisk(sVMAPI, device);
        }
        if ("Slice".equals(object) || "HotSpare".equals(object)) {
            return Util.getDiskSetFromSlice(sVMAPI, device);
        }
        if ("Host".equals(object)) {
            return Util.getDiskSetFromHost(sVMAPI, device);
        }
        return null;
    }

    public static String getDiskSetName(SVMAPI sVMAPI, Device device) {
        String string = null;
        Device device2 = Util.getDiskSet(sVMAPI, device);
        if (device2 != null) {
            string = Util.getDeviceFullName(device2);
        }
        return string;
    }
}

