/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.common.util;

import com.sun.admin.volmgr.common.util.CommandResult;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class Command {
    public static final int ERROR_OCCURRED = -1024;
    private String[][] commands;
    private String[] env;
    private boolean successful;
    private String[] stdout;
    private String[] stderr;
    private CommandResult[] results;

    public Command(String[][] stringArray) {
        this.setCommands(stringArray);
    }

    public Command(String[][] stringArray, String[] stringArray2) {
        this(stringArray);
        this.setEnv(stringArray2);
    }

    public Command(String[] stringArray) {
        this(Command.getTokenizedCommands(stringArray));
    }

    public Command(String[] stringArray, String[] stringArray2) {
        this(Command.getTokenizedCommands(stringArray), stringArray2);
    }

    private void setCommands(String[][] stringArray) {
        this.commands = stringArray;
    }

    public String[][] getCommands() {
        return this.commands;
    }

    private void setEnv(String[] stringArray) {
        this.env = stringArray;
    }

    public String[] getEnv() {
        return this.env;
    }

    public synchronized boolean getSuccessful() {
        CommandResult[] commandResultArray = this.getResults();
        for (int i = 0; i < commandResultArray.length; ++i) {
            if (commandResultArray[i].getExitCode() == 0) continue;
            return false;
        }
        return true;
    }

    public synchronized String[] getStdOut() {
        CommandResult[] commandResultArray = this.getResults();
        String[][] stringArray = new String[commandResultArray.length][];
        for (int i = 0; i < commandResultArray.length; ++i) {
            stringArray[i] = commandResultArray[i].getStdOut();
        }
        return Command.combine(stringArray);
    }

    public synchronized String[] getStdErr() {
        CommandResult[] commandResultArray = this.getResults();
        String[][] stringArray = new String[commandResultArray.length][];
        for (int i = 0; i < commandResultArray.length; ++i) {
            stringArray[i] = commandResultArray[i].getStdErr();
        }
        return Command.combine(stringArray);
    }

    private synchronized void setResults(CommandResult[] commandResultArray) {
        this.results = commandResultArray;
    }

    public synchronized CommandResult[] getResults() {
        return this.results;
    }

    public synchronized void exec(boolean bl) {
        String[][] stringArray = this.getCommands();
        String[] stringArray2 = this.getEnv();
        ArrayList<CommandResult> arrayList = new ArrayList<CommandResult>(stringArray.length);
        Runtime runtime = Runtime.getRuntime();
        for (int i = 0; i < stringArray.length; ++i) {
            CommandResult commandResult;
            String[] stringArray3 = stringArray[i];
            try {
                Process process = stringArray2 == null ? runtime.exec(stringArray[i]) : runtime.exec(stringArray[i], stringArray2);
                boolean bl2 = false;
                while (!bl2) {
                    try {
                        process.waitFor();
                        bl2 = true;
                    }
                    catch (InterruptedException interruptedException) {}
                }
                commandResult = new CommandResult(stringArray3, process.exitValue(), Command.inputStreamToArray(process.getInputStream()), Command.inputStreamToArray(process.getErrorStream()));
            }
            catch (IOException iOException) {
                commandResult = new CommandResult(stringArray3, -1024, new String[0], new String[]{iOException.getMessage()});
            }
            arrayList.add(commandResult);
            if (bl && commandResult.getExitCode() != 0) break;
        }
        this.setResults(arrayList.toArray(new CommandResult[arrayList.size()]));
    }

    private static String[][] getTokenizedCommands(String[] stringArray) {
        String[][] stringArray2 = new String[stringArray.length][];
        for (int i = 0; i < stringArray.length; ++i) {
            StringTokenizer stringTokenizer = new StringTokenizer(stringArray[i]);
            stringArray2[i] = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray2[i][n++] = stringTokenizer.nextToken();
            }
        }
        return stringArray2;
    }

    private static String[] combine(String[][] stringArray) {
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            n += stringArray[i].length;
        }
        String[] stringArray2 = new String[n];
        int n2 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < stringArray[i].length; ++j) {
                stringArray2[n2++] = stringArray[i][j];
            }
        }
        return stringArray2;
    }

    private static String[] inputStreamToArray(InputStream inputStream) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                arrayList.add(string);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.exit(1);
        }
        Command command = new Command(new String[][]{stringArray});
        try {
            command.exec(false);
            System.out.println(command.getResults()[0].toString("Command:", "Exit code:", "STDOUT:", "STDERR:"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

