/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.wizards.cards;

import com.sun.admin.volmgr.client.util.Util;
import com.sun.admin.volmgr.client.wizards.cards.ReviewCard;
import com.sun.admin.volmgr.client.wizards.command.HSPCommandFactory;
import com.sun.admin.volmgr.client.wizards.command.VolumeCommandFactory;
import com.sun.admin.volmgr.common.Device;
import javax.swing.JLabel;

public class VolumeReviewCard
extends ReviewCard {
    private static String TITLE = "add_wiz_review_title";
    private static final String HELPFILE = "VolumeReviewCard.html";
    private static String HEADER = "volume_add_wiz_review_header";
    private VolumeCommandFactory vwFactory;
    private HSPCommandFactory hspwFactory;
    private JLabel typeValue;
    private JLabel interlaceValue;
    private JLabel hspValue;

    public VolumeReviewCard(VolumeCommandFactory volumeCommandFactory, HSPCommandFactory hSPCommandFactory) {
        super(TITLE, HELPFILE, HEADER, null);
        this.vwFactory = volumeCommandFactory;
        this.hspwFactory = hSPCommandFactory;
        this.initGUI();
    }

    public String getVolumeType() {
        return Util.getResourceString(this.vwFactory.getVolumeType());
    }

    public String getInterlaceFromFactory() {
        String string;
        long l = this.vwFactory.getInterlaceInBlocks();
        Util.DeviceSize deviceSize = Util.getSizeInGreatestUnits(l, 1001, 1003);
        switch (deviceSize.units) {
            case 1003: {
                string = "param_megabytes";
                break;
            }
            case 1002: {
                string = "param_kilobytes";
                break;
            }
            default: {
                string = "param_blocks";
            }
        }
        return Util.getResourceString(string, new Long(deviceSize.size));
    }

    public String getHSPName() {
        return this.vwFactory.getHSPName();
    }

    protected String[] getCreateHSPCommands() {
        return this.hspwFactory.getCreateHSPCommands();
    }

    private String[] getCreateVolumeCommands() {
        String string = this.vwFactory.getVolumeType();
        String[] stringArray = string == null || string.equals("Concat") ? this.vwFactory.getCreateConcatCommands() : (string.equals("Stripe") ? this.vwFactory.getCreateStripeCommands() : (string.equals("Mirror") ? this.vwFactory.getCreateMirrorCommands() : (string.equals("Raid") ? this.vwFactory.getCreateRAIDCommands() : (string.equals("SoftPartition") ? this.vwFactory.getCreateSoftPartitionCommands() : new String[]{}))));
        return stringArray;
    }

    protected String getDeviceName() {
        return this.vwFactory.getDeviceName();
    }

    public String getDeviceDiskSetName() {
        return this.vwFactory.getDiskSetName();
    }

    protected Device[] getDevices() {
        return this.vwFactory.getComponents();
    }

    protected String[] getCommands() {
        return (String[])Util.getCombinedArray(new String[][]{this.getCreateHSPCommands(), this.getCreateVolumeCommands()});
    }

    protected ReviewCard.LabeledComponent[] getLabeledComponents() {
        ReviewCard.LabeledComponent[] labeledComponentArray = super.getLabeledComponents();
        this.typeValue = new JLabel();
        this.interlaceValue = new JLabel();
        this.hspValue = new JLabel();
        return new ReviewCard.LabeledComponent[]{labeledComponentArray[0], labeledComponentArray[1], new ReviewCard.LabeledComponent("volume_add_wiz_review_type_label", this.typeValue), new ReviewCard.LabeledComponent("volume_add_wiz_review_interlace_label", this.interlaceValue), new ReviewCard.LabeledComponent("volume_add_wiz_review_hsp_label", this.hspValue), labeledComponentArray[2], labeledComponentArray[3]};
    }

    public void refresh() {
        super.refresh();
        String string = this.getVolumeType();
        this.typeValue.setText(string);
        if (string.equals("Stripe") || string.equals("Raid")) {
            this.interlaceValue.setText(this.getInterlaceFromFactory());
        } else {
            this.interlaceValue.setText(Util.getResourceString("not_applicable"));
        }
        String string2 = this.getHSPName();
        if (string2 == null) {
            string2 = Util.getResourceString("hsp_none");
        }
        this.hspValue.setText(string2);
    }

    public boolean finish() {
        String[] stringArray = this.getCreateHSPCommands();
        if (stringArray.length != 0 && !this.executeCmds(stringArray, "hsp_add_cmd")) {
            return false;
        }
        stringArray = this.getCreateVolumeCommands();
        return stringArray.length == 0 || this.executeCmds(stringArray, "volume_add_cmd");
    }
}

