/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.wizards.cards;

import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.volmgr.client.ttk.Spinner;
import com.sun.admin.volmgr.client.ttk.text.LongSpinnerModel;
import com.sun.admin.volmgr.client.ttk.text.SpinnerDataModel;
import com.sun.admin.volmgr.client.util.Util;
import com.sun.admin.volmgr.client.wizards.cards.SimpleVWizardCard;
import com.sun.admin.volmgr.client.wizards.command.VolumeCommandFactory;
import com.sun.admin.volmgr.common.Device;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class GrowSoftPartitionParamCard
extends SimpleVWizardCard {
    private static String TITLE = "GrowSoftPartitionParamCard_title";
    private static final String HELPFILE = "GrowSoftPartitionParamCard.html";
    private static String HEADER = "GrowSoftPartitionParamCard_header";
    private VolumeCommandFactory factory;
    private JComboBox unitsCombo;
    private JTextField growByField;
    private JLabel sizeLabel;
    private JLabel availableLabel;

    public GrowSoftPartitionParamCard(VolumeCommandFactory volumeCommandFactory) {
        super(TITLE, HELPFILE, HEADER);
        this.factory = volumeCommandFactory;
        this.initGUI();
    }

    private long getGrowBySizeInBlocksFromField() {
        long l = 0L;
        try {
            l = Long.parseLong(this.growByField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        switch (this.unitsCombo.getSelectedIndex()) {
            case 4: {
                l <<= 31;
                break;
            }
            case 3: {
                l <<= 21;
                break;
            }
            case 2: {
                l <<= 11;
                break;
            }
            case 1: {
                l <<= 1;
            }
        }
        return l;
    }

    protected Component getMainPanel() {
        this.growByField = new JTextField("1", 5);
        Spinner spinner = new Spinner(this.growByField, (SpinnerDataModel)new LongSpinnerModel(1L, Long.MAX_VALUE));
        this.unitsCombo = new JComboBox<String>(new String[]{Util.getResourceString("blocks"), Util.getResourceString("kilobytes"), Util.getResourceString("megabytes"), Util.getResourceString("gigabytes"), Util.getResourceString("terabytes")});
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)spinner, "Center");
        jPanel.add((Component)this.unitsCombo, "East");
        this.sizeLabel = new JLabel();
        this.availableLabel = new JLabel();
        Component[][] componentArrayArray = new Component[][]{{new JLabel(Util.getResourceString("GrowSoftPartitionParamCard_current_size")), this.sizeLabel}, {new JLabel(Util.getResourceString("GrowSoftPartitionParamCard_avail_space")), this.availableLabel}, {new JLabel(Util.getResourceString("GrowSoftPartitionParamCard_grow_by")), jPanel}};
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets.bottom = 10;
        for (int i = 0; i < componentArrayArray.length; ++i) {
            Component[] componentArray = componentArrayArray[i];
            gridBagConstraints.insets.right = 10;
            gridBagConstraints.gridwidth = 1;
            if (i == componentArrayArray.length - 1) {
                gridBagConstraints.insets.bottom = 0;
            }
            for (int j = 0; j < componentArray.length; ++j) {
                if (j == componentArray.length - 1) {
                    gridBagConstraints.insets.right = 0;
                    gridBagConstraints.gridwidth = 0;
                }
                jPanel2.add(componentArray[j], gridBagConstraints);
            }
        }
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(15, 15));
        jPanel3.add(super.getMainPanel(), "North");
        jPanel3.add((Component)jPanel2, "West");
        return jPanel3;
    }

    public void refresh() {
        int n;
        try {
            Device device = this.factory.getComponents()[0];
            this.sizeLabel.setText(Util.getDeviceSizeWithUnits(device));
            Device device2 = Util.getParentDevicesFromSoftPartition(device)[0];
            this.availableLabel.setText(Util.getReadableSizeWithUnits(Util.getDeviceAvailableSpace(device2) * 512L));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        long l = this.factory.getSoftPartitionSizeInBlocks();
        Util.DeviceSize deviceSize = Util.getSizeInGreatestUnits(l, 1001);
        switch (deviceSize.units) {
            case 1005: {
                n = 4;
                break;
            }
            case 1004: {
                n = 3;
                break;
            }
            case 1003: {
                n = 2;
                break;
            }
            case 1002: {
                n = 1;
                break;
            }
            default: {
                n = 0;
            }
        }
        this.growByField.setText("" + deviceSize.size);
        this.unitsCombo.setSelectedIndex(n);
    }

    public boolean stop(boolean bl) {
        if (bl) {
            long l = this.getGrowBySizeInBlocksFromField();
            if (l <= 0L) {
                new ErrorDialog(null, Util.getResourceString("GrowSoftPartitionParamCard_grow_by_zero_error"));
                return false;
            }
            try {
                Device device = this.factory.getComponents()[0];
                Device device2 = Util.getParentDevicesFromSoftPartition(device)[0];
                long l2 = Util.getDeviceAvailableSpace(device2);
                if (l2 < l) {
                    new ErrorDialog(null, Util.getResourceString("GrowSoftPartitionParamCard_not_enough_space"));
                    return false;
                }
                this.factory.setSoftPartitionSizeInBlocks(l);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return true;
    }
}

