/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.volumes;

import com.sun.admin.cis.common.WarningDialog;
import com.sun.admin.volmgr.client.DeviceTablePropertySheet;
import com.sun.admin.volmgr.client.util.GUIUtil;
import com.sun.admin.volmgr.client.util.Util;
import com.sun.admin.volmgr.client.volumes.ConfVolumePanel;
import com.sun.admin.volmgr.client.wizards.AttachHSPFromVolumeWizard;
import com.sun.admin.volmgr.common.Device;
import com.sun.management.viper.console.gui.VFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;

public class VolumeHSPTablePropertySheet
extends DeviceTablePropertySheet {
    private static final String TITLE = "hsp_props_tab";
    private static String[] PROPKEYS = new String[]{"name", "type"};
    private Device volume;
    private String disksetFlag;
    private JButton attachButton;
    private JButton detachButton;

    public VolumeHSPTablePropertySheet(Device device, String string) {
        super(TITLE, string, PROPKEYS);
        this.volume = device;
    }

    protected synchronized String getDiskSetFlag() {
        if (this.disksetFlag == null) {
            this.disksetFlag = Util.getDiskSetFlag(this.volume);
        }
        return this.disksetFlag;
    }

    private void setButtonState() {
        boolean bl = false;
        boolean bl2 = false;
        if (Util.getApp().getServiceWrapper().hasVolMgrWriteAuth()) {
            if (this.table.getRowCount() == 0) {
                bl = true;
            } else {
                bl2 = true;
            }
        }
        this.attachButton.setEnabled(bl);
        this.detachButton.setEnabled(bl2);
    }

    private void attachHSP() {
        new Thread(){

            public void run() {
                VFrame vFrame = new VFrame();
                Util.makeModal(GUIUtil.getParentJFrame((Component)((Object)VolumeHSPTablePropertySheet.this)), (Window)vFrame, true);
                AttachHSPFromVolumeWizard attachHSPFromVolumeWizard = new AttachHSPFromVolumeWizard(VolumeHSPTablePropertySheet.this.volume);
                attachHSPFromVolumeWizard.init();
                attachHSPFromVolumeWizard.setContainer((Component)vFrame);
                vFrame.showCenter((Component)GUIUtil.getAppFrame());
                attachHSPFromVolumeWizard.start();
            }
        }.start();
    }

    private void detachHSP() {
        int[] nArray = this.table.getSelectedRows();
        if (nArray.length > 1) {
            return;
        }
        String string = Util.getDeviceBaseName(this.volume);
        String[] stringArray = new String[1];
        String[] stringArray2 = new String[1];
        stringArray[0] = Util.getResourceString("hsp_detach_cmd", string);
        stringArray2[0] = Util.getBasedir() + "usr/sbin/metaparam" + this.getDiskSetFlag() + " -h none " + string;
        ActionListener actionListener = Util.getConfirmListener(stringArray, stringArray2);
        String string2 = Util.getResourceString("sure_detach_hsp_from_volume");
        ConfVolumePanel confVolumePanel = new ConfVolumePanel(stringArray2, string2);
        String string3 = new String(Util.getResourceString("warning_detach_hsp_from_volume"));
        WarningDialog warningDialog = new WarningDialog(GUIUtil.getParentJFrame((Component)((Object)this)), string3, (JPanel)confVolumePanel, actionListener, Util.getResourceString("warning_detach"));
    }

    protected Device[] getDevices() {
        Device device = Util.getHSP(this.volume);
        if (device == null) {
            return new Device[0];
        }
        return new Device[]{device};
    }

    protected Component getMainPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        this.attachButton = new JButton();
        this.attachButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VolumeHSPTablePropertySheet.this.attachHSP();
            }
        });
        Util.initButton(this.attachButton, "attach_hsp_to_volume");
        jPanel.add(this.attachButton);
        this.detachButton = new JButton();
        this.detachButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VolumeHSPTablePropertySheet.this.detachHSP();
            }
        });
        Util.initButton(this.detachButton, "detach_hsp_to_volume");
        jPanel.add(this.detachButton);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add(super.getMainPanel(), "Center");
        jPanel2.add((Component)jPanel, "South");
        return jPanel2;
    }

    protected void refresh() {
        super.refresh();
        this.setButtonState();
    }
}

