/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.volumes;

import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.WarningDialog;
import com.sun.admin.volmgr.client.DeviceTablePropertySheet;
import com.sun.admin.volmgr.client.ServiceWrapper;
import com.sun.admin.volmgr.client.util.GUIUtil;
import com.sun.admin.volmgr.client.util.Util;
import com.sun.admin.volmgr.client.volumes.ConfVolumePanel;
import com.sun.admin.volmgr.client.wizards.AddSubmirrorWizard;
import com.sun.admin.volmgr.common.Device;
import com.sun.management.viper.console.gui.VFrame;
import com.sun.management.viper.util.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;

public class MirrorDeviceTablePropertySheet
extends DeviceTablePropertySheet {
    private static final String TITLE = "submirrors_props_tab";
    private static final String HELPFILE = "MirrorDeviceTablePropertySheet.html";
    private Device mirror;
    private String disksetFlag;
    private JButton attachButton;
    private JButton removeButton;
    private JButton onlineButton;
    private JButton offlineButton;

    public MirrorDeviceTablePropertySheet(Device device) {
        super(TITLE, HELPFILE);
        this.mirror = device;
        this.initGUI();
    }

    protected synchronized String getDiskSetFlag() {
        if (this.disksetFlag == null) {
            this.disksetFlag = Util.getDiskSetFlag(this.mirror);
        }
        return this.disksetFlag;
    }

    private void setButtonState() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        ServiceWrapper serviceWrapper = Util.getApp().getServiceWrapper();
        if (serviceWrapper.hasVolMgrWriteAuth()) {
            if (this.table.getSelectedRows().length == 1) {
                bl2 = true;
                bl4 = true;
                bl3 = true;
            }
            if (this.table.getRowCount() <= 3) {
                bl = true;
            }
        }
        this.attachButton.setEnabled(bl);
        this.removeButton.setEnabled(bl2);
        this.onlineButton.setEnabled(bl3);
        this.offlineButton.setEnabled(bl4);
    }

    private void attachComp() {
        new Thread(){

            public void run() {
                Object object;
                Object object2;
                Vector vector = Util.getApp().getServiceWrapper().getAntecedents(MirrorDeviceTablePropertySheet.this.mirror, "BasedOn");
                if (vector.size() == 1 && (object2 = Util.getMountPointFromSubmirror((Device)(object = (Device)vector.get(0)))) != null) {
                    Object[] objectArray = new Object[]{Util.getDeviceBaseName((Device)object), object2, Util.getDeviceBaseName(MirrorDeviceTablePropertySheet.this.mirror)};
                    String string = Util.getResourceString("MirrorDeviceTablePropertySheet_error", objectArray);
                    new ErrorDialog(null, string);
                    return;
                }
                object = new VFrame();
                Util.makeModal(GUIUtil.getParentJFrame((Component)((Object)MirrorDeviceTablePropertySheet.this)), (Window)object, true);
                object2 = new AddSubmirrorWizard(MirrorDeviceTablePropertySheet.this.mirror);
                object2.init();
                object2.setContainer((Component)object);
                object.showCenter((Component)GUIUtil.getAppFrame());
                object2.start();
            }
        }.start();
    }

    private void removeComp() {
        Object object;
        Object object2;
        int[] nArray = this.table.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        String string = Util.getDeviceBaseName(this.mirror);
        String[] stringArray = new String[nArray.length];
        String[] stringArray2 = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            object2 = (Device)this.model.getRow(nArray[i]);
            object = Util.getDeviceBaseName((Device)object2);
            stringArray[i] = Util.getResourceString("detach_submirror_cmd", object);
            stringArray2[i] = Util.getBasedir() + "usr/sbin/metadetach" + this.getDiskSetFlag() + " -f " + string + ' ' + (String)object;
        }
        ActionListener actionListener = Util.getConfirmListener(stringArray, stringArray2);
        object2 = Util.getResourceString("sure_detach_submirror");
        object = new ConfVolumePanel(stringArray2, (String)object2);
        String string2 = new String(Util.getResourceString("warning_detach_submirror"));
        WarningDialog warningDialog = new WarningDialog(GUIUtil.getParentJFrame((Component)((Object)this)), string2, (JPanel)object, actionListener, Util.getResourceString("warning_delete"));
    }

    private void onlineComp() {
        Object object;
        Object object2;
        int[] nArray = this.table.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        String string = Util.getDeviceBaseName(this.mirror);
        String[] stringArray = new String[nArray.length];
        String[] stringArray2 = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            object2 = (Device)this.model.getRow(nArray[i]);
            object = Util.getDeviceBaseName((Device)object2);
            stringArray[i] = Util.getResourceString("online_submirror_cmd", object);
            stringArray2[i] = Util.getBasedir() + "usr/sbin/metaonline" + this.getDiskSetFlag() + ' ' + string + ' ' + (String)object;
        }
        ActionListener actionListener = Util.getConfirmListener(stringArray, stringArray2);
        object2 = Util.getResourceString("sure_online_submirror");
        object = new ConfVolumePanel(stringArray2, (String)object2);
        String string2 = new String(Util.getResourceString("warning_online_submirror"));
        WarningDialog warningDialog = new WarningDialog(GUIUtil.getParentJFrame((Component)((Object)this)), string2, (JPanel)object, actionListener, Util.getResourceString("warning_online"));
    }

    private void offlineComp() {
        Object object;
        Object object2;
        int[] nArray = this.table.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        String string = Util.getDeviceBaseName(this.mirror);
        String[] stringArray = new String[nArray.length];
        String[] stringArray2 = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            object2 = (Device)this.model.getRow(nArray[i]);
            object = Util.getDeviceBaseName((Device)object2);
            stringArray[i] = Util.getResourceString("offline_submirror_cmd", object);
            stringArray2[i] = Util.getBasedir() + "usr/sbin/metaoffline" + this.getDiskSetFlag() + " -f " + string + ' ' + (String)object;
        }
        ActionListener actionListener = Util.getConfirmListener(stringArray, stringArray2);
        object2 = Util.getResourceString("sure_offline_submirror");
        object = new ConfVolumePanel(stringArray2, (String)object2);
        String string2 = new String(Util.getResourceString("warning_offline_submirror"));
        WarningDialog warningDialog = new WarningDialog(GUIUtil.getParentJFrame((Component)((Object)this)), string2, (JPanel)object, actionListener, Util.getResourceString("warning_offline"));
    }

    protected Device[] getDevices() {
        return Util.getComponentsOf(this.mirror);
    }

    public void tableSelectionChanged(ListSelectionEvent listSelectionEvent) {
        this.setButtonState();
    }

    protected Component getMainPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        this.attachButton = new JButton();
        this.attachButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MirrorDeviceTablePropertySheet.this.attachComp();
            }
        });
        Util.initButton(this.attachButton, "attach_submirror");
        jPanel.add(this.attachButton);
        this.removeButton = new JButton();
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MirrorDeviceTablePropertySheet.this.removeComp();
            }
        });
        Util.initButton(this.removeButton, "remove_submirror");
        jPanel.add(this.removeButton);
        this.onlineButton = new JButton();
        this.onlineButton.setFont(ResourceManager.menuFont);
        this.onlineButton.setMargin(new Insets(1, 4, 1, 4));
        this.onlineButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MirrorDeviceTablePropertySheet.this.onlineComp();
            }
        });
        Util.initButton(this.onlineButton, "online_submirror");
        jPanel.add(this.onlineButton);
        this.offlineButton = new JButton();
        this.offlineButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MirrorDeviceTablePropertySheet.this.offlineComp();
            }
        });
        Util.initButton(this.offlineButton, "offline_submirror");
        jPanel.add(this.offlineButton);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add(super.getMainPanel(), "Center");
        jPanel2.add((Component)jPanel, "South");
        return jPanel2;
    }

    protected void refresh() {
        super.refresh();
        this.setButtonState();
    }
}

