/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.volmgr.client.ttk.table;

import com.sun.admin.volmgr.client.ttk.table.EditableRowGroup;
import com.sun.admin.volmgr.client.ttk.table.RowAddable;
import com.sun.admin.volmgr.client.ttk.table.RowGettable;
import com.sun.admin.volmgr.client.ttk.table.RowGroup;
import com.sun.admin.volmgr.client.ttk.table.RowGroupable;
import com.sun.admin.volmgr.client.ttk.table.RowMoveable;
import com.sun.admin.volmgr.client.ttk.table.RowRemovable;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public abstract class GroupableTableModel
extends AbstractTableModel
implements RowGettable,
RowAddable,
RowRemovable,
RowMoveable,
RowGroupable {
    private static boolean BLOCKMOVE = true;
    protected Vector data = new Vector();
    protected String[] columNames;

    public GroupableTableModel(Object[] objectArray) {
        this.addRows(objectArray);
    }

    public GroupableTableModel(Object[] objectArray, String[] stringArray) {
        this(objectArray);
        this.columNames = stringArray;
    }

    public Class getColumnClass(int n) {
        return this.getValueAt(0, n).getClass();
    }

    public int getColumnCount() {
        if (this.columNames != null) {
            return this.columNames.length;
        }
        return 0;
    }

    public String getColumnName(int n) {
        try {
            return this.columNames[n];
        }
        catch (Exception exception) {
            return "";
        }
    }

    public int getRowCount() {
        return this.data.size();
    }

    public synchronized Object getRow(int n) {
        this.assertValidRow(n);
        return ((RowData)this.data.get((int)n)).data;
    }

    public synchronized Object[] getRows(int n, int n2) {
        this.assertValidRange(n, n2);
        Object[] objectArray = new Object[n2 - n + 1];
        for (int i = n; i <= n2; ++i) {
            objectArray[i] = ((RowData)this.data.get((int)i)).data;
        }
        return objectArray;
    }

    public synchronized Object[] getAllRows() {
        int n = this.data.size() - 1;
        if (n >= 0) {
            return this.getRows(0, n);
        }
        return new Object[0];
    }

    public synchronized void addRow(Object object) {
        this.addRow(this.data.size(), object);
    }

    public synchronized void addRow(int n, Object object) {
        this.addRows(n, new Object[]{object});
    }

    public synchronized void addRows(Object[] objectArray) {
        this.addRows(this.data.size(), objectArray);
    }

    public synchronized void addRows(int n, Object[] objectArray) {
        this.assertValidRow(n, this.data.size() + 1);
        RowData[] rowDataArray = new RowData[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            rowDataArray[i] = new RowData();
            rowDataArray[i].data = objectArray[i];
        }
        this.addRows(n, rowDataArray);
        this.fireTableStructureChanged();
    }

    private synchronized void addRows(int n, RowData[] rowDataArray) {
        int n2;
        int n3;
        int n4 = rowDataArray.length;
        boolean bl = false;
        RowGroup rowGroup = null;
        if (n != 0 && n != this.data.size()) {
            rowGroup = (EditableRowGroup)this.getRowGroup(n - 1);
            EditableRowGroup editableRowGroup = (EditableRowGroup)this.getRowGroup(n);
            if (rowGroup != null && editableRowGroup == rowGroup) {
                bl = true;
            }
        }
        if (bl) {
            for (n3 = 0; n3 < n4; ++n3) {
                rowDataArray[n3].group = rowGroup;
            }
            rowGroup.setLastRow(rowGroup.getLastRow() + n4);
            n2 = rowGroup.getLastRow() + 1;
        } else {
            for (n3 = 0; n3 < n4; ++n3) {
                EditableRowGroup editableRowGroup = (EditableRowGroup)rowDataArray[n3].group;
                if (editableRowGroup == null) continue;
                int n5 = editableRowGroup.getLastRow() - editableRowGroup.getFirstRow();
                editableRowGroup.setFirstRow(n + n3);
                editableRowGroup.setLastRow(editableRowGroup.getFirstRow() + n5);
                n3 += n5;
            }
            n2 = n + n3;
        }
        for (n3 = n4 - 1; n3 >= 0; --n3) {
            this.data.add(n, rowDataArray[n3]);
        }
        int n6 = this.data.size();
        for (n3 = n2; n3 < n6; ++n3) {
            EditableRowGroup editableRowGroup = (EditableRowGroup)this.getRowGroup(n3);
            if (editableRowGroup == null) continue;
            editableRowGroup.setFirstRow(editableRowGroup.getFirstRow() + 1);
            editableRowGroup.setLastRow(editableRowGroup.getLastRow() + 1);
            n3 = editableRowGroup.getLastRow();
        }
    }

    public synchronized void removeRow(int n) {
        this.removeRows(n, n);
    }

    public synchronized void removeAllRows() {
        int n = this.data.size();
        if (n > 0) {
            this.removeRows(0, n - 1);
        }
    }

    public synchronized void removeRows(int n, int n2) {
        int n3;
        this.assertValidRange(n, n2);
        this.ungroup(n, n2, false, true);
        for (n3 = n2; n3 >= n; --n3) {
            this.data.remove(n3);
        }
        n3 = n2 - n + 1;
        int n4 = this.data.size();
        for (int i = n; i < n4; ++i) {
            EditableRowGroup editableRowGroup = (EditableRowGroup)this.getRowGroup(i);
            if (editableRowGroup == null) continue;
            if (editableRowGroup.getFirstRow() > n) {
                editableRowGroup.setFirstRow(editableRowGroup.getFirstRow() - n3);
            }
            editableRowGroup.setLastRow(editableRowGroup.getLastRow() - n3);
            i = editableRowGroup.getLastRow();
        }
        this.fireTableStructureChanged();
    }

    private synchronized void setRowGroup(int n, EditableRowGroup editableRowGroup) {
        ((RowData)this.data.get((int)n)).group = editableRowGroup;
    }

    public synchronized RowGroup getRowGroup(int n) {
        this.assertValidRow(n);
        return ((RowData)this.data.get((int)n)).group;
    }

    public synchronized RowGroup[] getAllRowGroups() {
        ArrayList<RowGroup> arrayList = new ArrayList<RowGroup>();
        int n = this.data.size();
        for (int i = 0; i < n; ++i) {
            RowGroup rowGroup = this.getRowGroup(i);
            if (rowGroup == null) continue;
            arrayList.add(rowGroup);
            i = rowGroup.getLastRow();
        }
        RowGroup[] rowGroupArray = new RowGroup[arrayList.size()];
        for (n = 0; n < rowGroupArray.length; ++n) {
            rowGroupArray[n] = (RowGroup)arrayList.get(n);
        }
        return rowGroupArray;
    }

    protected synchronized void group(EditableRowGroup editableRowGroup, int n, int n2) {
        int n3;
        this.assertValidRange(n, n2);
        for (n3 = n; n3 <= n2; ++n3) {
            if (this.getRowGroup(n3) == null) continue;
            throw new ArrayIndexOutOfBoundsException("Row " + n3 + " is already in a group");
        }
        editableRowGroup.setFirstRow(n);
        editableRowGroup.setLastRow(n2);
        for (n3 = n; n3 <= n2; ++n3) {
            RowData rowData = (RowData)this.data.get(n3);
            rowData.group = editableRowGroup;
        }
        this.fireTableStructureChanged();
    }

    public synchronized void group(int n, int n2) {
        this.group(this.createEditableRowGroup(), n, n2);
    }

    private synchronized void ungroup(int n, int n2, boolean bl) {
        this.ungroup(n, n2, bl, false);
    }

    private synchronized void ungroup(int n, int n2, boolean bl, boolean bl2) {
        Object object;
        this.assertValidRange(n, n2);
        int n3 = n2 - n + 1;
        boolean bl3 = this.isCompleteGroup(n, n2);
        if (!bl3) {
            EditableRowGroup editableRowGroup = (EditableRowGroup)this.getRowGroup(n);
            object = (EditableRowGroup)this.getRowGroup(n2);
            boolean bl4 = false;
            if (editableRowGroup != null && editableRowGroup == object) {
                if (bl2) {
                    bl4 = true;
                } else {
                    object = (EditableRowGroup)editableRowGroup.getClone();
                    for (int i = n2 + 1; i <= object.getLastRow(); ++i) {
                        this.setRowGroup(i, (EditableRowGroup)object);
                    }
                }
            }
            if (!bl4) {
                if (editableRowGroup != null) {
                    editableRowGroup.setLastRow(n - 1);
                    if (editableRowGroup.getFirstRow() == editableRowGroup.getLastRow()) {
                        this.setRowGroup(editableRowGroup.getFirstRow(), null);
                    }
                }
                if (object != null) {
                    object.setFirstRow(n2 + 1);
                    if (object.getFirstRow() == object.getLastRow()) {
                        this.setRowGroup(object.getFirstRow(), null);
                    }
                }
            }
        }
        for (int i = n; i <= n2; ++i) {
            object = (RowData)this.data.get(i);
            ((RowData)object).group = null;
        }
        if (bl) {
            this.fireTableStructureChanged();
        }
    }

    public synchronized void ungroup(int n, int n2) {
        this.ungroup(n, n2, true);
    }

    public synchronized void regroup(int n, int n2, int n3) {
        this.assertValidRow(n);
        this.assertValidRange(n2, n3);
        EditableRowGroup editableRowGroup = (EditableRowGroup)this.getRowGroup(n);
        if (editableRowGroup == null) {
            editableRowGroup = this.createEditableRowGroup();
        } else {
            this.ungroup(editableRowGroup.getFirstRow(), editableRowGroup.getLastRow(), false);
        }
        this.group(editableRowGroup, n2, n3);
    }

    public synchronized void moveGroup(int n, int n2) {
        EditableRowGroup editableRowGroup = (EditableRowGroup)this.getRowGroup(n);
        if (editableRowGroup == null) {
            throw new ArrayIndexOutOfBoundsException("Row " + n + " is not in a group");
        }
        this.regroup(n, editableRowGroup.getFirstRow() + n2, editableRowGroup.getLastRow() + n2);
    }

    private boolean exitingGroup(EditableRowGroup editableRowGroup, int n, int n2, int n3) {
        if (editableRowGroup != null) {
            if (n3 == 1 && editableRowGroup.getFirstRow() == n || n3 == -1 && editableRowGroup.getLastRow() == n2) {
                return false;
            }
            for (int i = n; i <= n2; ++i) {
                RowGroup rowGroup = this.getRowGroup(i);
                if (rowGroup != editableRowGroup) continue;
                try {
                    rowGroup = this.getRowGroup(i + n3);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    rowGroup = null;
                }
                if (rowGroup == editableRowGroup) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isCompleteGroup(int n, int n2) {
        EditableRowGroup editableRowGroup = (EditableRowGroup)this.getRowGroup(n);
        return !(editableRowGroup != null && editableRowGroup.getFirstRow() != n || (editableRowGroup = (EditableRowGroup)this.getRowGroup(n2)) != null && editableRowGroup.getLastRow() != n2);
    }

    public synchronized boolean moveRowsUp(int n, int n2) {
        EditableRowGroup editableRowGroup;
        if (!this.canMoveRowsUp(n, n2)) {
            throw new ArrayIndexOutOfBoundsException("Cannot move rows " + n + '-' + n2 + " beyond table boundary");
        }
        boolean bl = true;
        EditableRowGroup editableRowGroup2 = (EditableRowGroup)this.getRowGroup(n2);
        boolean bl2 = this.exitingGroup(editableRowGroup2, n, n2, -1);
        boolean bl3 = false;
        if (!bl2) {
            bl3 = this.isCompleteGroup(n, n2);
        }
        boolean bl4 = false;
        try {
            editableRowGroup = (EditableRowGroup)this.getRowGroup(n - 1);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            editableRowGroup = null;
        }
        if (!(editableRowGroup == null || bl2 && editableRowGroup != this.getRowGroup(n))) {
            for (int i = n; i <= n2; ++i) {
                EditableRowGroup editableRowGroup3 = (EditableRowGroup)this.getRowGroup(i - 1);
                if (editableRowGroup3 != editableRowGroup || (editableRowGroup3 = (EditableRowGroup)this.getRowGroup(i)) == editableRowGroup) continue;
                bl4 = true;
                break;
            }
        }
        if (bl2) {
            int n3 = editableRowGroup2.getFirstRow();
            if (BLOCKMOVE) {
                editableRowGroup2.setFirstRow(n2 + 1);
            } else {
                editableRowGroup2.setFirstRow(editableRowGroup2.getFirstRow() + 1);
            }
            if (editableRowGroup2.getLastRow() == editableRowGroup2.getFirstRow()) {
                this.setRowGroup(editableRowGroup2.getLastRow(), null);
            }
            for (int i = editableRowGroup2.getFirstRow() - 1; i >= n3; --i) {
                this.setRowGroup(i, null);
            }
            bl = false;
        }
        if (bl4) {
            int n4 = editableRowGroup.getLastRow();
            if (BLOCKMOVE) {
                editableRowGroup.setLastRow(n2);
            } else {
                EditableRowGroup editableRowGroup4 = (EditableRowGroup)this.getRowGroup(editableRowGroup.getLastRow() + 1);
                if (editableRowGroup4 == null) {
                    editableRowGroup.setLastRow(editableRowGroup.getLastRow() + 1);
                } else {
                    editableRowGroup.setLastRow(editableRowGroup4.getLastRow());
                }
            }
            for (int i = editableRowGroup.getLastRow(); i > n4; --i) {
                this.setRowGroup(i, editableRowGroup);
            }
            bl = false;
        }
        if (bl) {
            for (int i = n; i <= n2; ++i) {
                EditableRowGroup editableRowGroup5;
                RowData rowData = (RowData)this.data.get(i);
                if (bl3 && (editableRowGroup5 = (EditableRowGroup)rowData.group) != null) {
                    if (i == editableRowGroup5.getFirstRow()) {
                        editableRowGroup5.setFirstRow(editableRowGroup5.getFirstRow() - 1);
                    } else if (i == editableRowGroup5.getLastRow()) {
                        editableRowGroup5.setLastRow(editableRowGroup5.getLastRow() - 1);
                    }
                }
                this.data.remove(i);
                this.data.add(i - 1, rowData);
            }
        }
        this.fireTableStructureChanged();
        return bl;
    }

    public synchronized boolean moveRowsDown(int n, int n2) {
        EditableRowGroup editableRowGroup;
        if (!this.canMoveRowsDown(n, n2)) {
            throw new ArrayIndexOutOfBoundsException("Cannot move rows " + n + '-' + n2 + " beyond table boundary");
        }
        boolean bl = true;
        EditableRowGroup editableRowGroup2 = (EditableRowGroup)this.getRowGroup(n);
        boolean bl2 = this.exitingGroup(editableRowGroup2, n, n2, 1);
        boolean bl3 = false;
        if (!bl2) {
            bl3 = this.isCompleteGroup(n, n2);
        }
        boolean bl4 = false;
        try {
            editableRowGroup = (EditableRowGroup)this.getRowGroup(n2 + 1);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            editableRowGroup = null;
        }
        if (!(editableRowGroup == null || bl2 && editableRowGroup != this.getRowGroup(n2))) {
            for (int i = n2; i >= n; --i) {
                EditableRowGroup editableRowGroup3 = (EditableRowGroup)this.getRowGroup(i + 1);
                if (editableRowGroup3 != editableRowGroup || (editableRowGroup3 = (EditableRowGroup)this.getRowGroup(i)) == editableRowGroup) continue;
                bl4 = true;
                break;
            }
        }
        if (bl2) {
            int n3 = editableRowGroup2.getLastRow();
            if (BLOCKMOVE) {
                editableRowGroup2.setLastRow(n - 1);
            } else {
                editableRowGroup2.setLastRow(editableRowGroup2.getLastRow() - 1);
            }
            if (editableRowGroup2.getFirstRow() == editableRowGroup2.getLastRow()) {
                this.setRowGroup(editableRowGroup2.getFirstRow(), null);
            }
            for (int i = editableRowGroup2.getLastRow() + 1; i <= n3; ++i) {
                this.setRowGroup(i, null);
            }
            bl = false;
        }
        if (bl4) {
            int n4 = editableRowGroup.getFirstRow();
            if (BLOCKMOVE) {
                editableRowGroup.setFirstRow(n);
            } else {
                EditableRowGroup editableRowGroup4 = (EditableRowGroup)this.getRowGroup(editableRowGroup.getFirstRow() - 1);
                if (editableRowGroup4 == null) {
                    editableRowGroup.setFirstRow(editableRowGroup.getFirstRow() - 1);
                } else {
                    editableRowGroup.setFirstRow(editableRowGroup4.getFirstRow());
                }
            }
            for (int i = editableRowGroup.getFirstRow(); i < n4; ++i) {
                this.setRowGroup(i, editableRowGroup);
            }
            bl = false;
        }
        if (bl) {
            for (int i = n2; i >= n; --i) {
                EditableRowGroup editableRowGroup5;
                RowData rowData = (RowData)this.data.get(i);
                if (bl3 && (editableRowGroup5 = (EditableRowGroup)rowData.group) != null) {
                    if (i == editableRowGroup5.getLastRow()) {
                        editableRowGroup5.setLastRow(editableRowGroup5.getLastRow() + 1);
                    } else if (i == editableRowGroup5.getFirstRow()) {
                        editableRowGroup5.setFirstRow(editableRowGroup5.getFirstRow() + 1);
                    }
                }
                this.data.remove(i);
                this.data.add(i + 1, rowData);
            }
        }
        this.fireTableStructureChanged();
        return bl;
    }

    public synchronized boolean moveRowsTo(int n, int n2, int n3) {
        if (!this.canMoveRowsTo(n, n2, n3)) {
            throw new ArrayIndexOutOfBoundsException("Cannot move rows " + n + '-' + n2 + " beyond table boundary");
        }
        if (n == n3) {
            return false;
        }
        int n4 = n2 - n + 1;
        RowData[] rowDataArray = new RowData[n4];
        for (int i = n; i <= n2; ++i) {
            rowDataArray[i - n] = (RowData)this.data.get(i);
        }
        this.removeRows(n, n2);
        if (n3 > n) {
            n3 = n3 <= n2 ? n : (n3 -= n4);
        }
        this.addRows(n3, rowDataArray);
        this.fireTableStructureChanged();
        return true;
    }

    public synchronized boolean canMoveRowsUp(int n, int n2) {
        return this.canMoveRows(n, n2, -1);
    }

    public synchronized boolean canMoveRowsDown(int n, int n2) {
        return this.canMoveRows(n, n2, 1);
    }

    private synchronized boolean canMoveRows(int n, int n2, int n3) {
        try {
            this.assertValidRange(n, n2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return false;
        }
        if (n3 < 0 && n - 1 >= 0 || n3 > 0 && n2 + 1 < this.data.size()) {
            return true;
        }
        EditableRowGroup editableRowGroup = (EditableRowGroup)this.getRowGroup(n3 > 0 ? n : n2);
        return this.exitingGroup(editableRowGroup, n, n2, n3);
    }

    public synchronized boolean canMoveRowsTo(int n, int n2, int n3) {
        try {
            this.assertValidRange(n, n2);
            this.assertValidRow(n3, this.data.size() + 1);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return false;
        }
        return true;
    }

    private void assertValidRow(int n, int n2) {
        if (n < 0 || n >= n2) {
            throw new ArrayIndexOutOfBoundsException("Invalid row: " + n);
        }
    }

    private synchronized void assertValidRow(int n) {
        this.assertValidRow(n, this.data.size());
    }

    private void assertValidRange(int n, int n2) {
        if (n > n2) {
            throw new ArrayIndexOutOfBoundsException("Invalid row range: " + n + '-' + n2);
        }
        this.assertValidRow(n);
        this.assertValidRow(n2);
    }

    protected abstract EditableRowGroup createEditableRowGroup();

    protected static class RowData {
        protected RowGroup group;
        protected Object data;

        protected RowData() {
        }

        public RowGroup getRowGroup() {
            return this.group;
        }

        public Object getData() {
            return this.data;
        }
    }
}

