/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.renderer;

import com.sun.web.ui.component.Button;
import com.sun.web.ui.component.IFrame;
import com.sun.web.ui.component.Icon;
import com.sun.web.ui.component.ImageComponent;
import com.sun.web.ui.component.VersionPage;
import com.sun.web.ui.renderer.AbstractRenderer;
import com.sun.web.ui.theme.Theme;
import com.sun.web.ui.util.RenderingUtilities;
import com.sun.web.ui.util.ThemeUtilities;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class VersionPageRenderer
extends AbstractRenderer {
    private static final String DEFAULT_VERSIONINFO_HEIGHT = "330";
    private static final String DEFAULT_VERSIONBRAND_HEIGHT = "110";

    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        if (context == null || component == null || writer == null) {
            throw new NullPointerException();
        }
        VersionPage versionpage = (VersionPage)component;
        Theme theme = ThemeUtilities.getTheme(context);
        String style = theme.getStyleClass("VERSION_BODY");
        writer.startElement("div", (UIComponent)versionpage);
        writer.writeAttribute("class", (Object)style, null);
        this.renderVersionMasthead(context, versionpage, writer, theme);
        style = theme.getStyleClass("VERSION_MARGIN");
        writer.startElement("div", (UIComponent)versionpage);
        writer.writeAttribute("class", (Object)style, null);
        this.renderVersionInformation(context, versionpage, writer, theme);
        writer.endElement("div");
        this.renderCloseButton(context, versionpage, writer, theme);
        writer.endElement("div");
    }

    protected void renderVersionMasthead(FacesContext context, VersionPage versionpage, ResponseWriter writer, Theme theme) throws IOException {
        UIComponent mhFacet = versionpage.getFacet("identityContent");
        if (mhFacet != null) {
            RenderingUtilities.renderComponent(mhFacet, context);
        } else {
            Icon corplogo;
            try {
                corplogo = theme.getIcon("VERSION_CORPLOGO");
                corplogo.setId(versionpage.getId() + "_versionPageJavaLogo");
            }
            catch (RuntimeException rte) {
                corplogo = null;
            }
            this.renderVersionMastheadImages(context, versionpage, corplogo, writer, theme);
        }
    }

    protected void renderVersionMastheadImages(FacesContext context, VersionPage versionpage, Icon corplogo, ResponseWriter writer, Theme theme) throws IOException {
        String style = theme.getStyleClass("VERSION_MASTHEAD_BODY");
        writer.startElement("div", (UIComponent)versionpage);
        writer.writeAttribute("class", (Object)style, null);
        writer.writeText((Object)"\n", null);
        writer.startElement("table", (UIComponent)versionpage);
        writer.writeAttribute("width", (Object)"100%", null);
        writer.writeAttribute("height", (Object)DEFAULT_VERSIONBRAND_HEIGHT, null);
        writer.writeAttribute("border", (Object)"0", null);
        writer.writeAttribute("cellspacing", (Object)"0", null);
        writer.writeAttribute("cellpadding", (Object)"0", null);
        writer.writeAttribute("title", (Object)"", null);
        writer.startElement("tr", (UIComponent)versionpage);
        style = theme.getStyleClass("VERSION_PRODUCT_TD");
        writer.startElement("td", (UIComponent)versionpage);
        writer.writeAttribute("class", (Object)style, null);
        style = theme.getStyleClass("VERSION_PRODUCT_DIV");
        writer.startElement("div", (UIComponent)versionpage);
        writer.writeAttribute("class", (Object)style, null);
        String id = versionpage.getId();
        int size = 0;
        String altText = null;
        ImageComponent image = new ImageComponent();
        image.setId(id + "_versionPageProductImage");
        image.setUrl(versionpage.getProductImageURL());
        altText = versionpage.getProductImageDescription();
        if (altText != null) {
            image.setAlt(altText);
        }
        if ((size = versionpage.getProductImageHeight()) > 0) {
            image.setHeight(size);
        }
        if ((size = versionpage.getProductImageWidth()) > 0) {
            image.setWidth(size);
        }
        image.setBorder(0);
        RenderingUtilities.renderComponent((UIComponent)image, context);
        writer.endElement("div");
        writer.endElement("td");
        style = theme.getStyleClass("VERSION_LOGO_TD");
        writer.startElement("td", (UIComponent)versionpage);
        writer.writeAttribute("class", (Object)style, null);
        if (corplogo != null) {
            RenderingUtilities.renderComponent((UIComponent)corplogo, context);
        }
        writer.endElement("td");
        writer.endElement("tr");
        writer.endElement("table");
        writer.endElement("div");
    }

    protected void renderVersionInformation(FacesContext context, VersionPage versionpage, ResponseWriter writer, Theme theme) throws IOException {
        String file = versionpage.getVersionInformationFile();
        if (file != null) {
            this.renderVersionInformationFile(context, versionpage, writer);
        } else {
            this.renderVersionInformationInline(context, versionpage, writer, theme);
        }
    }

    protected void renderVersionInformationFile(FacesContext context, VersionPage versionpage, ResponseWriter writer) throws IOException {
        IFrame iframe = new IFrame();
        iframe.setId(versionpage.getId() + "_versionInformationIFrame");
        iframe.setAlign("left");
        iframe.setHeight(DEFAULT_VERSIONINFO_HEIGHT);
        iframe.setWidth("100%");
        iframe.setScrolling("auto");
        iframe.setUrl(versionpage.getVersionInformationFile());
        RenderingUtilities.renderComponent((UIComponent)iframe, context);
    }

    protected void renderVersionInformationInline(FacesContext context, VersionPage versionpage, ResponseWriter writer, Theme theme) throws IOException {
        String text = null;
        String style = theme.getStyleClass("VERSION_HEADER_TEXT");
        writer.startElement("div", (UIComponent)versionpage);
        writer.writeAttribute("class", (Object)style, null);
        text = versionpage.getVersionString();
        if (text != null) {
            writer.writeText((Object)text, "versionString");
        }
        writer.endElement("div");
        style = theme.getStyleClass("VERSION_TEXT");
        writer.startElement("div", (UIComponent)versionpage);
        writer.writeAttribute("class", (Object)style, null);
        text = versionpage.getCopyrightString();
        if (text != null) {
            writer.writeText((Object)text, "copyrightString");
        }
        writer.endElement("div");
    }

    protected void renderCloseButton(FacesContext context, VersionPage versionpage, ResponseWriter writer, Theme theme) throws IOException {
        Button button = new Button();
        button.setId(versionpage.getId() + "_versionPageCloseButton");
        button.setText(ThemeUtilities.getTheme(context).getMessage("Version.closeButton"));
        button.setOnClick("javascript: parent.close(); return false;");
        String style = theme.getStyleClass("VERSION_BUTTON_MARGIN_DIV");
        writer.startElement("div", (UIComponent)versionpage);
        writer.writeAttribute("class", (Object)style, null);
        RenderingUtilities.renderComponent((UIComponent)button, context);
        writer.endElement("div");
        writer.startElement("script", (UIComponent)versionpage);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("document.forms[0]." + button.getId() + ".focus()");
        writer.endElement("script");
    }
}

