/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.client.adapter.http;

import com.sun.xml.tree.XmlDocument;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.wbem.cimxml.CIMXml;
import javax.wbem.cimxml.CIMXmlFactory;
import javax.wbem.client.CIMEvent;
import javax.wbem.client.CIMListener;
import javax.wbem.client.adapter.http.transport.HttpServerRequestHandler;
import javax.wbem.client.adapter.http.transport.InboundRequest;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class HttpEventRequestHandler
extends HttpServerRequestHandler {
    CIMListener clientListener;
    private CIMXml xmlInst;
    private List events = new ArrayList();

    public HttpEventRequestHandler(CIMListener clientListener) {
        this.clientListener = clientListener;
        this.xmlInst = CIMXmlFactory.getCIMXmlImpl();
        EventProcessor ep = new EventProcessor();
        ep.setDaemon(true);
        ep.start();
    }

    public boolean checkAuthentication(InboundRequest request) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(InboundRequest request) {
        try {
            XmlDocument xmlDoc = this.getXmlDocument(request);
            DataOutputStream out = new DataOutputStream(request.getResponseOutputStream());
            String str = request.getHeaderField("CIMExportMethod");
            if (str == null || !str.equals("ExportIndication")) {
                this.do501Error(out);
                return;
            }
            List list = this.events;
            synchronized (list) {
                this.events.add(new CIMEvent(this.xmlInst.getCIMInstance((Node)xmlDoc)));
                this.events.notify();
            }
            xmlDoc = this.xmlInst.getXMLResponse(null, xmlDoc, null);
            xmlDoc.write((OutputStream)out);
        }
        catch (SAXException e) {
            DataOutputStream out = new DataOutputStream(request.getResponseOutputStream());
            e.printStackTrace();
            Exception x = e.getException();
            String message = "Parse Error with Request:\n";
            if (x == null) {
                x = e;
            }
            if (e instanceof SAXParseException) {
                SAXParseException spe = (SAXParseException)e;
                message = message + "** URI: " + spe.getSystemId() + "\n";
                message = message + "** Line: " + spe.getLineNumber() + "\n";
            }
            this.do500Error(out, "XML Parsing error: <b>" + message + "</b>");
            System.out.println(message);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void addResponseHeaderFields(InboundRequest request) {
        request.setRespondHeaderField("CIMOperation", "ExportMethodResponse");
    }

    private class EventProcessor
    extends Thread {
        private EventProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                List list = HttpEventRequestHandler.this.events;
                synchronized (list) {
                    while (HttpEventRequestHandler.this.events.isEmpty()) {
                        try {
                            HttpEventRequestHandler.this.events.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    HttpEventRequestHandler.this.clientListener.indicationOccured((CIMEvent)HttpEventRequestHandler.this.events.remove(0));
                }
            }
        }
    }
}

