/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.client.adapter.http;

import java.io.IOException;
import java.net.InetAddress;
import javax.wbem.client.CIMListener;
import javax.wbem.client.adapter.http.HttpEventRequestHandler;
import javax.wbem.client.adapter.http.transport.HttpServerEndpoint;
import javax.wbem.client.adapter.http.transport.ServerEndpointListener;

class HttpEventListener {
    private String servername;
    private int port;
    private HttpServerEndpoint serverEndPoint;
    private ServerEndpointListener listener = null;
    CIMListener clientListener;

    HttpEventListener(CIMListener clientListener) throws Exception {
        try {
            this.servername = InetAddress.getLocalHost().getHostName();
            this.serverEndPoint = new HttpServerEndpoint(this.servername, 0);
        }
        catch (Exception ex) {
            this.servername = "??";
        }
        this.clientListener = clientListener;
        this.start();
    }

    private synchronized void start() {
        try {
            HttpEventRequestHandler handler = new HttpEventRequestHandler(this.clientListener);
            this.listener = this.serverEndPoint.listen(handler);
            this.port = this.listener.getLocalPort();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void stop() {
        if (this.listener != null) {
            this.listener.close();
        }
    }

    String getHost() {
        return this.servername;
    }

    int getPort() {
        return this.port;
    }
}

