/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.client;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.client.CIMClientAPI;
import javax.wbem.client.CIMListener;
import javax.wbem.client.CIMTransportException;
import javax.wbem.client.Debug;

class CIMClientFactory {
    public static final String XML_PROTOCOL_NAME = "cim-xml";
    public static final String RMI_PROTOCOL_NAME = "cim-rmi";
    private static final String PROP_DEFAULT_FILE = "javax.wbem.client.WbemDefaults";
    private static final String PROP_EXTEND_FILE = "WbemClient";
    private static final String PROP_TRANSPORT = "transport";
    private static final String PROP_PROTOCOL = "protocol";
    private static final String PROP_NAME = "name";
    private static final String PROP_DEFAULT = "default";
    private static final String PROP_CLASS = "client.class";
    private static final String XML_CLASS_NAME = "javax.wbem.client.adapter.http.CIMClientXML";
    private static final String RMI_CLASS_NAME = "javax.wbem.client.adapter.rmi.CIMClientRMI";
    private static Properties props = null;

    CIMClientFactory() {
    }

    public static CIMClientAPI getClientAPI(String version, CIMNameSpace ns, String protocol, int debug, CIMListener clientListener) throws CIMException {
        String temp;
        String propname;
        String proto_name = protocol;
        if ((protocol == null || protocol.trim().length() == 0) && (proto_name = CIMClientFactory.getProperty(propname = "transport.protocol.default")) == null) {
            proto_name = RMI_PROTOCOL_NAME;
        }
        if (!((proto_name = proto_name.toLowerCase()) == null || (temp = CIMClientFactory.getProperty(propname = "transport.protocol.name." + proto_name)) != null && proto_name.equalsIgnoreCase(temp))) {
            proto_name = null;
        }
        if (proto_name == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", "protocol name");
        }
        Debug.trace1("Client adapter protocol name: " + proto_name);
        propname = "transport." + proto_name + "." + PROP_CLASS;
        String classname = CIMClientFactory.getProperty(propname);
        Class<?> cl = null;
        try {
            cl = Class.forName(classname);
        }
        catch (Exception ex) {
            throw new CIMTransportException("CIM_ERR_NOT_FOUND", "protocol class");
        }
        CIMClientAPI cc = null;
        try {
            Class[] paramTypes = new Class[]{String.class, CIMNameSpace.class, CIMListener.class, Integer.class};
            Object[] paramList = new Object[]{version, ns, clientListener, new Integer(debug)};
            Constructor<?> ctr = cl.getConstructor(paramTypes);
            cc = (CIMClientAPI)ctr.newInstance(paramList);
        }
        catch (InvocationTargetException ex) {
            Throwable ax = ex.getTargetException();
            if (ax instanceof CIMException) {
                CIMException cex = (CIMException)ax;
                throw cex;
            }
            throw new CIMTransportException("CIM_ERR_FAILED", (Object)ax);
        }
        catch (Exception ex) {
            throw new CIMTransportException("CIM_ERR_FAILED", (Object)ex);
        }
        return cc;
    }

    private static synchronized String getProperty(String name) throws CIMException {
        if (props == null) {
            CIMClientFactory.initProperties();
        }
        return props.getProperty(name);
    }

    private static List getPropertyList(String name) throws CIMException {
        ArrayList<String> list = new ArrayList<String>();
        if (props == null) {
            CIMClientFactory.initProperties();
        }
        boolean i = false;
        boolean sw = true;
        String prefix = name.concat(".");
        Enumeration<?> en = props.propertyNames();
        while (en.hasMoreElements()) {
            String val;
            String key = (String)en.nextElement();
            if (!key.startsWith(prefix) || (val = props.getProperty(key)) == null) continue;
            list.add(val);
        }
        return list;
    }

    private static void initProperties() throws CIMException {
        if (props == null) {
            props = new Properties();
            try {
                CIMClientFactory.loadProperties(PROP_DEFAULT_FILE);
            }
            catch (Exception ex) {
                Debug.trace1("Error loading WbemDefaults properties.");
                throw new CIMException("CIM_ERR_FAILED", PROP_DEFAULT_FILE);
            }
            try {
                CIMClientFactory.loadProperties(PROP_EXTEND_FILE);
            }
            catch (MissingResourceException ex) {
                Debug.trace1("Error loading properties: WbemClient");
            }
            if (Debug.isOn()) {
                Debug.trace3("Client configuration properties:");
                Enumeration<?> en = props.propertyNames();
                while (en.hasMoreElements()) {
                    String key = (String)en.nextElement();
                    String val = props.getProperty(key);
                    if (val == null) {
                        val = "null";
                    }
                    Debug.trace3("    " + key + " \t" + val);
                }
            }
        }
    }

    private static void loadProperties(String bundle) throws CIMException {
        PropertyResourceBundle prb = (PropertyResourceBundle)ResourceBundle.getBundle(bundle, new Locale("", ""));
        if (prb != null) {
            String val = null;
            Enumeration<String> en = prb.getKeys();
            while (en.hasMoreElements()) {
                String key = en.nextElement();
                try {
                    val = prb.getString(key);
                }
                catch (Exception ex) {
                    key = null;
                }
                if (key == null) continue;
                props.setProperty(key, val);
            }
        }
    }
}

