/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.cimxml;

import com.sun.xml.tree.ElementNode;
import com.sun.xml.tree.TreeWalker;
import com.sun.xml.tree.XmlDocument;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMElement;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMFlavor;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMMethod;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMParameter;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMQualifier;
import javax.wbem.cim.CIMQualifierType;
import javax.wbem.cim.CIMValue;
import javax.wbem.cimxml.CIMXml;
import javax.wbem.cimxml.CIMXmlUtil;
import javax.wbem.cimxml.Response;
import javax.wbem.cimxml.XMLParser;
import javax.wbem.cimxml.XmlConversion;
import javax.wbem.cimxml.XmlInstance;
import javax.wbem.cimxml.XmlResponseIF;
import javax.wbem.client.CIMAssociatorNamesOp;
import javax.wbem.client.CIMAssociatorsOp;
import javax.wbem.client.CIMCreateClassOp;
import javax.wbem.client.CIMCreateInstanceOp;
import javax.wbem.client.CIMCreateNameSpaceOp;
import javax.wbem.client.CIMCreateQualifierTypeOp;
import javax.wbem.client.CIMDeleteClassOp;
import javax.wbem.client.CIMDeleteInstanceOp;
import javax.wbem.client.CIMDeleteNameSpaceOp;
import javax.wbem.client.CIMDeleteQualifierTypeOp;
import javax.wbem.client.CIMEnumClassNamesOp;
import javax.wbem.client.CIMEnumClassOp;
import javax.wbem.client.CIMEnumInstanceNamesOp;
import javax.wbem.client.CIMEnumInstancesOp;
import javax.wbem.client.CIMEnumNameSpaceOp;
import javax.wbem.client.CIMEnumQualifierTypesOp;
import javax.wbem.client.CIMExecQueryOp;
import javax.wbem.client.CIMExport;
import javax.wbem.client.CIMExportIndication;
import javax.wbem.client.CIMGetClassOp;
import javax.wbem.client.CIMGetInstanceOp;
import javax.wbem.client.CIMGetPropertyOp;
import javax.wbem.client.CIMGetQualifierTypeOp;
import javax.wbem.client.CIMInvokeArgsMethodOp;
import javax.wbem.client.CIMInvokeMethodOp;
import javax.wbem.client.CIMOperation;
import javax.wbem.client.CIMReferenceNamesOp;
import javax.wbem.client.CIMReferencesOp;
import javax.wbem.client.CIMSetClassOp;
import javax.wbem.client.CIMSetInstanceOp;
import javax.wbem.client.CIMSetPropertyOp;
import javax.wbem.client.CIMSetQualifierTypeOp;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class CIMXmlImpl
implements CIMXml,
CIMXmlUtil {
    private static final String LOCALONLY = "LocalOnly";
    private static final String DEEPINHERITANCE = "DeepInheritance";
    private static final String INCLUDEQUALIFIERS = "IncludeQualifiers";
    private static final String INCLUDECLASSORIGIN = "IncludeClassOrigin";
    private static final String PROPERTYLIST = "PropertyList";
    private static final String ASSOCCLASS = "AssocClass";
    private static final String OBJECTNAME = "ObjectName";
    private static final String RESULTCLASS = "ResultClass";
    private static final String ROLE = "Role";
    private static final String RESULTROLE = "ResultRole";
    private static final String QUERYLANGUAGE = "QueryLanguage";
    private static final String QUERY = "Query";
    private static final String MODIFYCLASS = "ModifyClass";
    private static final String EXPORTINDICATION = "ExportIndication";
    private static final String QUALIFIERNAME = "QualifierName";
    private static final String PROPERTYNAME = "PropertyName";
    private static final String CIMOPERATION = "CIMOperation";
    private static final String METHODCALL = "MethodCall";
    private static final String CIMBATCH = "CIMBatch";
    private static final String CIMMETHOD = "CIMMethod";
    private static final String CIMEXPORT = "CIMExport";
    private static final String EXPORTMETHODCALL = "ExportMethodCall";
    private static final String CIMEXPORTBATCH = "CIMExportBatch";
    private static final String CIMEXPORTMETHOD = "CIMExportMethod";
    private static final String CIMOBJECT = "CIMObject";
    private static HashMap requestHash = new HashMap();
    private static HashMap exprequestHash = new HashMap();

    public CIMXmlImpl() {
        this.init();
    }

    public XmlDocument getXmlRequest(CIMOperation op) throws CIMException, MalformedURLException {
        XmlInstance xm = new XmlInstance();
        String cimOpName = op.getClass().getName();
        XmlRequest obj = (XmlRequest)requestHash.get(cimOpName.substring(cimOpName.lastIndexOf(".") + 1));
        return this.xmlMsg2xmlDoc(xm, xm.request(obj.getRequest(op, xm)));
    }

    public XmlDocument getXmlRequest(CIMOperation[] ops) throws CIMException, MalformedURLException {
        XmlInstance xm = new XmlInstance();
        Vector<String> calls = new Vector<String>();
        for (int i = 0; i < ops.length; ++i) {
            String cimOpName = ops[i].getClass().getName();
            XmlRequest obj = (XmlRequest)requestHash.get(cimOpName.substring(cimOpName.lastIndexOf(".") + 1));
            calls.addElement(obj.getRequest(ops[i], xm));
        }
        return this.xmlMsg2xmlDoc(xm, xm.request(calls));
    }

    public XmlDocument getXmlRequest(CIMExport op) throws CIMException, MalformedURLException {
        XmlInstance xm = new XmlInstance();
        String cimOpName = op.getClass().getName();
        XmlExpRequest obj = (XmlExpRequest)exprequestHash.get(cimOpName.substring(cimOpName.lastIndexOf(".") + 1));
        return this.xmlMsg2xmlDoc(xm, xm.exprequest(obj.getRequest(op, xm)));
    }

    public XmlDocument getXmlRequest(CIMExport[] ops) throws CIMException, MalformedURLException {
        XmlInstance xm = new XmlInstance();
        Vector<String> calls = new Vector<String>();
        for (int i = 0; i < ops.length; ++i) {
            String cimOpName = ops[i].getClass().getName();
            XmlExpRequest obj = (XmlExpRequest)exprequestHash.get(cimOpName.substring(cimOpName.lastIndexOf(".") + 1));
            calls.addElement(obj.getRequest(ops[i], xm));
        }
        return this.xmlMsg2xmlDoc(xm, xm.exprequest(calls));
    }

    public CIMElement getCIMElement(String str) throws SAXException, IOException {
        XmlInstance xm = new XmlInstance();
        XmlDocument xml = xm.pcdata2Xml(str);
        CIMElement ce = new CIMElement();
        XMLParser parser = new XMLParser();
        TreeWalker walker = new TreeWalker((Node)xml);
        Node node = walker.getCurrent();
        while (node != null) {
            String nodename = node.getNodeName();
            if (nodename.equals("CLASS")) {
                ce = XMLParser.getCIMClass(node);
                break;
            }
            if (nodename.equals("INSTANCE") || nodename.equals("VALUE.NAMEDINSTANCE")) {
                ce = XMLParser.getCIMInstance(node);
                break;
            }
            if (nodename.equals("VALUE.OBJECTWITHPATH")) {
                NodeList nl = node.getChildNodes();
                for (int i = 0; i < nl.getLength(); ++i) {
                    Node item = nl.item(i);
                    if ("CLASS".equalsIgnoreCase(item.getNodeName())) {
                        ce = XMLParser.getCIMClass(item);
                        continue;
                    }
                    if (!"INSTANCE".equalsIgnoreCase(item.getNodeName())) continue;
                    ce = XMLParser.getCIMInstance(item);
                }
                break;
            }
            if (nodename.equals("QUALIFIER.DECLARATION")) {
                ce = XMLParser.getCIMQualifierType(node);
                break;
            }
            if (nodename.startsWith("PROPERTY")) {
                ce = XMLParser.getCIMProperty(node);
                break;
            }
            if (nodename.startsWith("PARAMETER")) {
                ce = XMLParser.getCIMParameter(node);
                break;
            }
            if (nodename.equals("QUALIFIER")) {
                ce = XMLParser.getCIMQualifier(node);
                break;
            }
            if (nodename.equals("METHOD")) {
                ce = XMLParser.getCIMMethod(node);
                break;
            }
            node = walker.getNextElement(null);
        }
        return ce;
    }

    public String CIMElementToXml(CIMElement ce) {
        String str = new String();
        if (ce instanceof CIMClass) {
            str = this.CIMClassToXml((CIMClass)ce, true);
        } else if (ce instanceof CIMInstance) {
            str = this.CIMInstanceToXml((CIMInstance)ce, true);
        } else if (ce instanceof CIMQualifier) {
            str = this.CIMQualifierToXml((CIMQualifier)ce, true);
        } else if (ce instanceof CIMQualifierType) {
            str = this.CIMQualifierTypeToXml((CIMQualifierType)ce, true);
        } else if (ce instanceof CIMMethod) {
            str = this.CIMMethodToXml((CIMMethod)ce, true);
        } else if (ce instanceof CIMParameter) {
            str = this.CIMParameterToXml((CIMParameter)ce, true);
        } else if (ce instanceof CIMProperty) {
            str = this.CIMPropertyToXml((CIMProperty)ce, true);
        }
        return str;
    }

    public String CIMClassToXml(CIMClass cc) {
        XmlInstance xm = new XmlInstance(true);
        return xm.cimClass(cc);
    }

    public String CIMClassToXml(CIMClass cc, boolean showImplied) {
        XmlInstance xm = new XmlInstance(showImplied);
        return xm.cimClass(cc);
    }

    public String CIMClassToXml(CIMClass cc, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, boolean showImplied) {
        XmlInstance xm = new XmlInstance(includeQualifiers, includeClassOrigin, propertyList, showImplied);
        return xm.cimClass(cc);
    }

    public String CIMFlavorToXml(CIMFlavor cf) {
        XmlInstance xm = new XmlInstance(true);
        CIMQualifier cq = new CIMQualifier();
        cq.addFlavor(cf);
        return xm.qualifier(cq);
    }

    public String CIMFlavorToXml(CIMFlavor cf, boolean showImplied) {
        XmlInstance xm = new XmlInstance(showImplied);
        CIMQualifier cq = new CIMQualifier();
        cq.addFlavor(cf);
        return xm.qualifier(cq);
    }

    public String CIMInstanceToXml(CIMInstance ci) {
        XmlInstance xm = new XmlInstance(true);
        return xm.instance(ci);
    }

    public String CIMInstanceToXml(CIMInstance ci, boolean showImplied) {
        XmlInstance xm = new XmlInstance(showImplied);
        return xm.instance(ci);
    }

    public String CIMInstanceToXml(CIMInstance ci, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, boolean showImplied) {
        XmlInstance xm = new XmlInstance(includeQualifiers, includeClassOrigin, propertyList, showImplied);
        return xm.instance(ci);
    }

    public String ConvertCIMInstanceToXml(CIMInstance ci) {
        XmlConversion xm = new XmlConversion(true);
        return xm.instance(ci);
    }

    public String ConvertCIMInstanceToXml(CIMInstance ci, boolean showImplied) {
        XmlConversion xm = new XmlConversion(showImplied);
        return xm.instance(ci);
    }

    public String ConvertCIMInstanceToXml(CIMInstance ci, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, boolean showImplied) {
        XmlConversion xm = new XmlConversion(includeQualifiers, includeClassOrigin, propertyList, showImplied);
        return xm.instance(ci);
    }

    public String CIMMethodToXml(CIMMethod cm) {
        XmlInstance xm = new XmlInstance(true);
        return xm.method(cm, "");
    }

    public String CIMMethodToXml(CIMMethod cm, boolean showImplied) {
        XmlInstance xm = new XmlInstance(showImplied);
        return xm.method(cm, "");
    }

    public String CIMQualifierTypeToXml(CIMQualifierType ct) {
        XmlInstance xm = new XmlInstance(true);
        return xm.qualifierDeclaration(ct);
    }

    public String CIMQualifierTypeToXml(CIMQualifierType ct, boolean showImplied) {
        XmlInstance xm = new XmlInstance(showImplied);
        return xm.qualifierDeclaration(ct);
    }

    public String CIMObjectPathToXml(CIMObjectPath cop) {
        XmlInstance xm = new XmlInstance(true, true, null, true, true, true, true);
        return xm.objectPath(cop);
    }

    public String CIMObjectPathToXml(CIMObjectPath cop, boolean showImplied) {
        XmlInstance xm = new XmlInstance(true, true, null, showImplied, true, true, true);
        return xm.objectPath(cop);
    }

    public String ConvertCIMObjectPathToXml(CIMObjectPath cop) {
        XmlConversion xm = new XmlConversion(true, true, null, true, true, true, true);
        return xm.objectPath(cop);
    }

    public String ConvertCIMObjectPathToXml(CIMObjectPath cop, boolean showImplied) {
        XmlConversion xm = new XmlConversion(true, true, null, showImplied, true, true, true);
        return xm.objectPath(cop);
    }

    public String CIMParameterToXml(CIMParameter cp) {
        XmlInstance xm = new XmlInstance(true);
        return xm.parameter(cp);
    }

    public String CIMParameterToXml(CIMParameter cp, boolean showImplied) {
        XmlInstance xm = new XmlInstance(showImplied);
        return xm.parameter(cp);
    }

    public String CIMPropertyToXml(CIMProperty prop) {
        XmlInstance xm = new XmlInstance(true);
        return xm.property(prop, "");
    }

    public String CIMPropertyToXml(CIMProperty prop, boolean showImplied) {
        XmlInstance xm = new XmlInstance(showImplied);
        return xm.property(prop, "");
    }

    public String CIMQualifierToXml(CIMQualifier cq) {
        XmlInstance xm = new XmlInstance(true);
        return xm.qualifier(cq);
    }

    public String CIMQualifierToXml(CIMQualifier cq, boolean showImplied) {
        XmlInstance xm = new XmlInstance(showImplied);
        return xm.qualifier(cq);
    }

    public String CIMValueToXml(CIMValue cv) {
        XmlInstance xm = new XmlInstance(true);
        return xm.value(cv);
    }

    public String CIMValueToXml(CIMValue cv, boolean showImplied) {
        XmlInstance xm = new XmlInstance(showImplied);
        return xm.value(cv);
    }

    public String CIMNameSpaceToXml(CIMNameSpace cns) {
        XmlInstance xm = new XmlInstance(true);
        return xm.localNameSpacePath(cns);
    }

    public String CIMNameSpaceToXml(CIMNameSpace cns, boolean showImplied) {
        XmlInstance xm = new XmlInstance(showImplied);
        return xm.localNameSpacePath(cns);
    }

    public Vector getCIMResponse(XmlDocument response) throws IOException, CIMException {
        return Response.getCIMResponse(response);
    }

    public XmlDocument getXMLResponse(XmlResponseIF rsp, XmlDocument request, PasswordAuthentication auth) throws IOException, SAXException {
        return Response.getXMLResponse(rsp, request, auth);
    }

    public CIMClass getCIMClass(Node node) {
        return XMLParser.getCIMClass(node);
    }

    public CIMInstance getCIMInstance(Node node) {
        return XMLParser.getCIMInstance(node);
    }

    public CIMMethod getCIMMethod(Node node) {
        return XMLParser.getCIMMethod(node);
    }

    public CIMObjectPath getCIMObjectPath(Node node) {
        return XMLParser.getCIMObjectPath(node);
    }

    public CIMParameter getCIMParameter(Node node) {
        return XMLParser.getCIMParameter(node);
    }

    public CIMProperty getCIMProperty(Node node) {
        return XMLParser.getCIMProperty(node);
    }

    public CIMQualifier getCIMQualifier(Node node) {
        return XMLParser.getCIMQualifier(node);
    }

    public CIMQualifierType getCIMQualifierType(Node node) {
        return XMLParser.getCIMQualifierType(node);
    }

    public CIMValue getCIMValue(Node node, String type) {
        return XMLParser.getCIMValue(node, type);
    }

    public String getStringValue(Node node) {
        return XMLParser.getStringValue(node);
    }

    public boolean getBooleanValue(Node node) {
        return XMLParser.getBooleanValue(node);
    }

    public String getError(CIMException e, boolean showImplied) {
        return Response.getError(e, showImplied);
    }

    public String createInstanceResult(CIMObjectPath ci, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, boolean showImplied) {
        return Response.createInstanceResult(ci, includeQualifiers, includeClassOrigin, propertyList, showImplied);
    }

    public String getClassResult(CIMClass cc, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, boolean showImplied) {
        return Response.getClassResult(cc, includeQualifiers, includeClassOrigin, propertyList, showImplied);
    }

    public String getInstanceResult(CIMInstance ci, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, boolean showImplied) {
        return Response.getInstanceResult(ci, includeQualifiers, includeClassOrigin, propertyList, showImplied);
    }

    public String getPropertyResult(CIMValue cv, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, boolean showImplied) {
        return Response.getPropertyResult(cv, includeQualifiers, includeClassOrigin, propertyList, showImplied);
    }

    public String getQualifierResult(CIMQualifierType qt, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, boolean showImplied) {
        return Response.getQualifierResult(qt, includeQualifiers, includeClassOrigin, propertyList, showImplied);
    }

    public String enumerateClassesResult(Enumeration enum1, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, boolean showImplied) {
        return Response.enumerateClassesResult(enum1, includeQualifiers, includeClassOrigin, propertyList, showImplied);
    }

    public String enumerateClassNamesResult(Enumeration enum1, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, boolean showImplied) {
        return Response.enumerateClassNamesResult(enum1, includeQualifiers, includeClassOrigin, propertyList, showImplied);
    }

    public String enumerateInstancesResult(Enumeration enum1, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, boolean showImplied) {
        return Response.enumerateInstancesResult(enum1, includeQualifiers, includeClassOrigin, propertyList, showImplied);
    }

    public String enumerateInstanceNamesResult(Enumeration enum1, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, boolean showImplied) {
        return Response.enumerateInstanceNamesResult(enum1, includeQualifiers, includeClassOrigin, propertyList, showImplied);
    }

    public String enumerateQualifiersResult(Enumeration enum1, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, boolean showImplied) {
        return Response.enumerateQualifiersResult(enum1, includeQualifiers, includeClassOrigin, propertyList, showImplied);
    }

    public String associatorsResult(Enumeration enum1, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, boolean showImplied) {
        return Response.associatorsResult(enum1, includeQualifiers, includeClassOrigin, propertyList, showImplied);
    }

    public String associatorNamesResult(Enumeration enum1, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, boolean showImplied) {
        return Response.associatorNamesResult(enum1, includeQualifiers, includeClassOrigin, propertyList, showImplied);
    }

    public String referencesResult(Enumeration enum1, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, boolean showImplied) {
        return Response.referencesResult(enum1, includeQualifiers, includeClassOrigin, propertyList, showImplied);
    }

    public String referenceNamesResult(Enumeration enum1, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, boolean showImplied) {
        return Response.referenceNamesResult(enum1, includeQualifiers, includeClassOrigin, propertyList, showImplied);
    }

    public String enumerateNamespaceResult(Enumeration enum1, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, boolean showImplied) {
        return Response.enumerateNamespaceResult(enum1, includeQualifiers, includeClassOrigin, propertyList, showImplied);
    }

    public String execQueryResult(Enumeration enum1, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, boolean showImplied) {
        return Response.execQueryResult(enum1, includeQualifiers, includeClassOrigin, propertyList, showImplied);
    }

    public String invokeMethodResult(Vector v, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, boolean showImplied) {
        return Response.invokeMethodResult(v, includeQualifiers, includeClassOrigin, propertyList, showImplied);
    }

    public String invokeArgsMethodResult(Vector v, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, boolean showImplied) {
        return Response.invokeArgsMethodResult(v, includeQualifiers, includeClassOrigin, propertyList, showImplied);
    }

    private static void xmlAppendBooleanParamValue(StringBuffer xml, XmlInstance xm, String paramName, boolean value) {
        xml.append(xm.iParamValue(paramName, value));
    }

    private static void xmlAppendStringsParamValue(StringBuffer xml, XmlInstance xm, String paramName, String[] value) {
        if (value != null) {
            xml.append(xm.iParamValue(paramName, value));
        }
    }

    private static StringBuffer xmlAppendObjectPath(CIMNameSpace currNs, CIMObjectPath name, XmlInstance xm) {
        StringBuffer xml = CIMXmlImpl.getXmlStringBuffer(currNs, name, xm);
        xml.append(xm.iParamValue(name));
        return xml;
    }

    private static StringBuffer getXmlStringBuffer(CIMNameSpace currNs, CIMObjectPath name, XmlInstance xm) {
        CIMObjectPath absPath = CIMXmlImpl.fixAbsObjectPath(currNs, name);
        return new StringBuffer(xm.localNameSpacePath(absPath));
    }

    private XmlDocument xmlMsg2xmlDoc(XmlInstance xm, String xml) throws CIMException {
        StringBuffer newXml = new StringBuffer(xm.root(xm.message(xml)));
        try {
            return xm.pcdata2Xml(newXml.toString());
        }
        catch (IOException e) {
            throw new CIMException("XMLERROR", (Object)e);
        }
        catch (SAXException e) {
            throw new CIMException("XMLERROR", (Object)e);
        }
    }

    private static CIMObjectPath fixAbsObjectPath(CIMNameSpace nameSpace, CIMObjectPath op) {
        String s = nameSpace.getNameSpace() + "\\" + op.getNameSpace();
        CIMObjectPath rtop = new CIMObjectPath(op.getObjectName(), (Vector)op.getKeys().clone());
        rtop.setHost(op.getHost());
        rtop.setNameSpace(s);
        return rtop;
    }

    private static String xmlRequest(String method, String xml, XmlInstance xm) {
        return xm.call(method, xml);
    }

    void init() {
        requestHash.put("CIMAssociatorNamesOp", new AssociatorNamesXml());
        requestHash.put("CIMAssociatorsOp", new AssociatorsXml());
        requestHash.put("CIMCreateClassOp", new CreateClassXml());
        requestHash.put("CIMCreateInstanceOp", new CreateInstanceXml());
        requestHash.put("CIMCreateNameSpaceOp", new CreateNameSpaceXml());
        requestHash.put("CIMCreateQualifierTypeOp", new CreateQualifierTypeXml());
        requestHash.put("CIMDeleteClassOp", new DeleteClassXml());
        requestHash.put("CIMDeleteInstanceOp", new DeleteInstanceXml());
        requestHash.put("CIMDeleteNameSpaceOp", new DeleteNameSpaceXml());
        requestHash.put("CIMDeleteQualifierTypeOp", new DeleteQualifierTypeXml());
        requestHash.put("CIMEnumClassNamesOp", new EnumClassNamesXml());
        requestHash.put("CIMEnumClassOp", new EnumClassXml());
        requestHash.put("CIMEnumInstanceNamesOp", new EnumInstanceNamesXml());
        requestHash.put("CIMEnumInstancesOp", new EnumInstancesXml());
        requestHash.put("CIMEnumNameSpaceOp", new EnumNameSpaceXml());
        requestHash.put("CIMEnumQualifierTypesOp", new EnumQualifierTypesXml());
        requestHash.put("CIMExecQueryOp", new ExecQueryXml());
        requestHash.put("CIMGetClassOp", new GetClassXml());
        requestHash.put("CIMGetInstanceOp", new GetInstanceXml());
        requestHash.put("CIMGetPropertyOp", new GetPropertyXml());
        requestHash.put("CIMGetQualifierTypeOp", new GetQualifierTypeXml());
        requestHash.put("CIMInvokeMethodOp", new InvokeMethodXml());
        requestHash.put("CIMInvokeArgsMethodOp", new InvokeArgsMethodXml());
        requestHash.put("CIMReferenceNamesOp", new ReferenceNamesXml());
        requestHash.put("CIMReferencesOp", new ReferencesXml());
        requestHash.put("CIMSetClassOp", new SetClassXml());
        requestHash.put("CIMSetInstanceOp", new SetInstanceXml());
        requestHash.put("CIMSetPropertyOp", new SetPropertyXml());
        requestHash.put("CIMSetQualifierTypeOp", new SetQualifierTypeXml());
        exprequestHash.put("CIMExportIndication", new ExportIndicationXml());
    }

    public Map getXmlRequestHeaders(XmlDocument msg) throws CIMException {
        HashMap<String, String> headers = new HashMap<String, String>();
        boolean isBatch = false;
        TreeWalker walker = new TreeWalker((Node)msg);
        String nodename = null;
        Object callname = null;
        Node node = walker.getCurrent();
        while (node != null) {
            nodename = node.getNodeName();
            if (!nodename.equals("CIM")) {
                if (nodename.equals("MESSAGE")) {
                    headers.put("CIMProtocolVersion", ((ElementNode)node).getAttribute("PROTOCOLVERSION"));
                } else {
                    if (nodename.equals("MULTIREQ")) {
                        headers.put(CIMOPERATION, METHODCALL);
                        headers.put(CIMBATCH, CIMBATCH);
                        break;
                    }
                    if (nodename.equals("IMETHODCALL") || nodename.equals("METHODCALL")) {
                        headers.put(CIMOPERATION, METHODCALL);
                        headers.put(CIMMETHOD, ((ElementNode)node).getAttribute("NAME"));
                    } else {
                        if (nodename.equals("MULTIEXPREQ")) {
                            headers.put(CIMEXPORT, EXPORTMETHODCALL);
                            headers.put(CIMEXPORTBATCH, CIMEXPORTBATCH);
                            break;
                        }
                        if (nodename.equals("EXPMETHODCALL")) {
                            headers.put(CIMEXPORT, EXPORTMETHODCALL);
                            headers.put(CIMEXPORTMETHOD, ((ElementNode)node).getAttribute("NAME"));
                            break;
                        }
                        if (nodename.startsWith("LOCAL")) {
                            headers.put(CIMOBJECT, this.objectPath(node));
                            break;
                        }
                    }
                }
            }
            node = walker.getNextElement(null);
        }
        return headers;
    }

    private String objectPath(Node node) throws CIMException {
        String op = "";
        CIMProperty p = null;
        boolean isFirstKey = true;
        boolean isSingleton = false;
        TreeWalker walker = new TreeWalker(node);
        node = walker.getCurrent();
        while (node != null) {
            String nodename = node.getNodeName();
            if (!(nodename.equals("NAMESPACEPATH") || nodename.equals("LOCALNAMESPACEPATH") || nodename.equals("CLASSPATH") || nodename.equals("LOCALCLASSPATH") || nodename.equals("INSTANCEPATH"))) {
                if (nodename.equals("LOCALINSTANCEPATH")) {
                    isSingleton = true;
                } else if (nodename.equals("NAMESPACE")) {
                    op = op.length() > 0 ? op + "/" : op;
                    op = op + ((ElementNode)node).getAttribute("NAME");
                } else if (nodename.equals("CLASSNAME")) {
                    op = op + ":" + ((ElementNode)node).getAttribute("NAME");
                } else if (nodename.equals("INSTANCENAME")) {
                    op = op + ":" + ((ElementNode)node).getAttribute("CLASSNAME");
                } else if (nodename.equals("KEYBINDING")) {
                    isSingleton = false;
                    op = op + (isFirstKey ? "." : ",");
                    isFirstKey = false;
                    op = op + ((ElementNode)node).getAttribute("NAME");
                    p = this.getCIMProperty(node);
                } else if (nodename.equals("KEYVALUE")) {
                    isSingleton = false;
                    op = op + "=";
                    String type = ((ElementNode)node).getAttribute("VALUETYPE");
                    String value = p.getValue().getValue().toString();
                    StringBuffer buf = new StringBuffer(value.length());
                    for (int i = 0; i < value.length(); ++i) {
                        if (value.charAt(i) == '\"') {
                            buf.append("\\");
                        }
                        buf.append(value.charAt(i));
                    }
                    value = buf.toString();
                    op = op + (type.equals("string") ? "\"" + value + "\"" : value);
                } else if (nodename.equals("VALUE.REFERENCE")) {
                    isSingleton = false;
                    op = op + "=" + this.objectPath(walker.getNextElement(null));
                }
            }
            node = walker.getNextElement(null);
        }
        op = op + (isSingleton ? "=@" : "");
        return URLEncoder.encode(op);
    }

    private static class MapNamespace {
        String nstr = null;
        Vector v = null;

        MapNamespace(CIMNameSpace currNs, CIMNameSpace ns) {
            CIMNameSpace newns = new CIMNameSpace();
            newns.setNameSpace(currNs.getNameSpace() + "\\" + ns.getNameSpace());
            this.nstr = newns.getNameSpace();
            this.v = new Vector();
            CIMProperty cp = new CIMProperty("NameSpace");
            cp.setValue(new CIMValue(this.nstr.substring(this.nstr.lastIndexOf("\\") + 1)));
            this.v.addElement(cp);
        }

        CIMNameSpace getMappedNs() {
            CIMNameSpace newns = new CIMNameSpace();
            newns.setNameSpace(this.nstr.substring(0, this.nstr.lastIndexOf("\\")));
            return newns;
        }

        CIMObjectPath getMappedOp() {
            return new CIMObjectPath("__Namespace", this.v);
        }

        CIMInstance getMappedInstance() {
            CIMInstance ci = new CIMInstance();
            ci.setClassName("__Namespace");
            ci.setProperties(this.v);
            return ci;
        }
    }

    private static class SetQualifierTypeXml
    implements XmlRequest {
        private SetQualifierTypeXml() {
        }

        public String getRequest(CIMOperation cimOp, XmlInstance xm) {
            CIMSetQualifierTypeOp obj = (CIMSetQualifierTypeOp)cimOp;
            StringBuffer xml = CIMXmlImpl.getXmlStringBuffer(obj.getNameSpace(), obj.getModelPath(), xm);
            xml.append(xm.iParamValue(obj.getCIMQualifierType()));
            return CIMXmlImpl.xmlRequest("SetQualifier", xml.toString(), xm);
        }
    }

    private static class SetPropertyXml
    implements XmlRequest {
        private SetPropertyXml() {
        }

        public String getRequest(CIMOperation cimOp, XmlInstance xm) {
            CIMSetPropertyOp obj = (CIMSetPropertyOp)cimOp;
            StringBuffer xml = CIMXmlImpl.getXmlStringBuffer(obj.getNameSpace(), obj.getModelPath(), xm);
            xml.append(xm.iParamValue(obj.getModelPath()));
            xml.append(xm.iParamValue(CIMXmlImpl.PROPERTYNAME, obj.getPropertyName()));
            xml.append(xm.iParamValue(obj.getCIMValue()));
            return CIMXmlImpl.xmlRequest("SetProperty", xml.toString(), xm);
        }
    }

    private static class SetInstanceXml
    implements XmlRequest {
        private SetInstanceXml() {
        }

        public String getRequest(CIMOperation cimOp, XmlInstance xm) {
            CIMSetInstanceOp obj = (CIMSetInstanceOp)cimOp;
            String[] propertyList = obj.getPropertyList();
            StringBuffer xml = CIMXmlImpl.getXmlStringBuffer(obj.getNameSpace(), obj.getModelPath(), xm);
            xml.append(xm.iParamValue(obj.getModelPath(), obj.getCIMInstance()) + xm.iParamValue(CIMXmlImpl.INCLUDEQUALIFIERS, obj.isQualifiersIncluded()) + (propertyList != null ? xm.iParamValue(CIMXmlImpl.PROPERTYLIST, propertyList) : ""));
            return CIMXmlImpl.xmlRequest("ModifyInstance", xml.toString(), xm);
        }
    }

    private static class SetClassXml
    implements XmlRequest {
        private SetClassXml() {
        }

        public String getRequest(CIMOperation cimOp, XmlInstance xm) {
            CIMSetClassOp obj = (CIMSetClassOp)cimOp;
            StringBuffer xml = CIMXmlImpl.getXmlStringBuffer(obj.getNameSpace(), obj.getModelPath(), xm);
            xml.append(xm.iParamValue(obj.getCIMClass(), CIMXmlImpl.MODIFYCLASS));
            return CIMXmlImpl.xmlRequest(CIMXmlImpl.MODIFYCLASS, xml.toString(), xm);
        }
    }

    private static class ReferencesXml
    implements XmlRequest {
        private ReferencesXml() {
        }

        public String getRequest(CIMOperation cimOp, XmlInstance xm) {
            CIMReferencesOp obj = (CIMReferencesOp)cimOp;
            StringBuffer xml = CIMXmlImpl.getXmlStringBuffer(obj.getNameSpace(), obj.getModelPath(), xm);
            String resultClass = obj.getResultClass();
            String role = obj.getRole();
            boolean includeQualifiers = obj.isQualifiersIncluded();
            boolean includeClassOrigin = obj.isClassOriginIncluded();
            String[] propertyList = obj.getPropertyList();
            xml.append(xm.iParamValue(CIMXmlImpl.OBJECTNAME, obj.getModelPath()) + (resultClass != null ? xm.iParamValue(CIMXmlImpl.RESULTCLASS, new CIMObjectPath(resultClass)) : "") + (role != null ? xm.iParamValue(CIMXmlImpl.ROLE, role) : "") + (includeQualifiers ? xm.iParamValue(CIMXmlImpl.INCLUDEQUALIFIERS, includeQualifiers) : "") + (includeClassOrigin ? xm.iParamValue(CIMXmlImpl.INCLUDECLASSORIGIN, includeClassOrigin) : "") + (propertyList != null ? xm.iParamValue(CIMXmlImpl.PROPERTYLIST, propertyList) : ""));
            return CIMXmlImpl.xmlRequest("References", xml.toString(), xm);
        }
    }

    private static class ReferenceNamesXml
    implements XmlRequest {
        private ReferenceNamesXml() {
        }

        public String getRequest(CIMOperation cimOp, XmlInstance xm) {
            CIMReferenceNamesOp obj = (CIMReferenceNamesOp)cimOp;
            StringBuffer xml = CIMXmlImpl.getXmlStringBuffer(obj.getNameSpace(), obj.getModelPath(), xm);
            String resultClass = obj.getResultClass();
            String role = obj.getRole();
            xml.append(xm.iParamValue(CIMXmlImpl.OBJECTNAME, obj.getModelPath()) + (resultClass != null ? xm.iParamValue(CIMXmlImpl.RESULTCLASS, new CIMObjectPath(resultClass)) : "") + (role != null ? xm.iParamValue(CIMXmlImpl.ROLE, role) : ""));
            return CIMXmlImpl.xmlRequest("ReferenceNames", xml.toString(), xm);
        }
    }

    private static class InvokeArgsMethodXml
    implements XmlRequest {
        private InvokeArgsMethodXml() {
        }

        public String getRequest(CIMOperation cimOp, XmlInstance xm) {
            CIMInvokeArgsMethodOp obj = (CIMInvokeArgsMethodOp)cimOp;
            CIMObjectPath absPath = CIMXmlImpl.fixAbsObjectPath(obj.getNameSpace(), obj.getModelPath());
            StringBuffer xml = new StringBuffer(xm.localObjectPath(absPath));
            CIMArgument[] args = obj.getInArgs();
            if (args != null && args.length > 0) {
                xml.append(xm.paramValue(args));
            }
            return xm.xcall(obj.getMethodName(), xml.toString());
        }
    }

    private static class InvokeMethodXml
    implements XmlRequest {
        private InvokeMethodXml() {
        }

        public String getRequest(CIMOperation cimOp, XmlInstance xm) {
            CIMInvokeMethodOp obj = (CIMInvokeMethodOp)cimOp;
            CIMObjectPath absPath = CIMXmlImpl.fixAbsObjectPath(obj.getNameSpace(), obj.getModelPath());
            StringBuffer xml = new StringBuffer(xm.localObjectPath(absPath));
            Vector params = obj.getInParams();
            if (params != null && params.size() > 0) {
                for (int i = 0; i < params.size(); ++i) {
                    CIMValue cv = (CIMValue)params.elementAt(i);
                    CIMProperty p = new CIMProperty(xm.getCIMType(cv.getType()), cv);
                    xml.append(xm.paramValue(p));
                }
            }
            return xm.xcall(obj.getMethodName(), xml.toString());
        }
    }

    private static class GetQualifierTypeXml
    implements XmlRequest {
        private GetQualifierTypeXml() {
        }

        public String getRequest(CIMOperation cimOp, XmlInstance xm) {
            CIMGetQualifierTypeOp obj = (CIMGetQualifierTypeOp)cimOp;
            StringBuffer xml = CIMXmlImpl.getXmlStringBuffer(obj.getNameSpace(), obj.getModelPath(), xm);
            xml.append(xm.iParamValue(CIMXmlImpl.QUALIFIERNAME, obj.getModelPath().getObjectName()));
            return CIMXmlImpl.xmlRequest("GetQualifier", xml.toString(), xm);
        }
    }

    private static class GetPropertyXml
    implements XmlRequest {
        private GetPropertyXml() {
        }

        public String getRequest(CIMOperation cimOp, XmlInstance xm) {
            CIMGetPropertyOp obj = (CIMGetPropertyOp)cimOp;
            StringBuffer xml = CIMXmlImpl.getXmlStringBuffer(obj.getNameSpace(), obj.getModelPath(), xm);
            xml.append(xm.iParamValue(obj.getModelPath()));
            xml.append(xm.iParamValue(CIMXmlImpl.PROPERTYNAME, obj.getPropertyName()));
            return CIMXmlImpl.xmlRequest("GetProperty", xml.toString(), xm);
        }
    }

    private static class GetInstanceXml
    implements XmlRequest {
        private GetInstanceXml() {
        }

        public String getRequest(CIMOperation cimOp, XmlInstance xm) {
            CIMGetInstanceOp obj = (CIMGetInstanceOp)cimOp;
            StringBuffer xml = CIMXmlImpl.xmlAppendObjectPath(obj.getNameSpace(), obj.getModelPath(), xm);
            if (!obj.isLocalOnly()) {
                CIMXmlImpl.xmlAppendBooleanParamValue(xml, xm, CIMXmlImpl.LOCALONLY, false);
            }
            if (obj.isQualifiersIncluded()) {
                CIMXmlImpl.xmlAppendBooleanParamValue(xml, xm, CIMXmlImpl.INCLUDEQUALIFIERS, true);
            }
            if (obj.isClassOriginIncluded()) {
                CIMXmlImpl.xmlAppendBooleanParamValue(xml, xm, CIMXmlImpl.INCLUDECLASSORIGIN, true);
            }
            CIMXmlImpl.xmlAppendStringsParamValue(xml, xm, CIMXmlImpl.PROPERTYLIST, obj.getPropertyList());
            return CIMXmlImpl.xmlRequest("GetInstance", xml.toString(), xm);
        }
    }

    private static class GetClassXml
    implements XmlRequest {
        private GetClassXml() {
        }

        public String getRequest(CIMOperation cimOp, XmlInstance xm) {
            CIMGetClassOp obj = (CIMGetClassOp)cimOp;
            StringBuffer xml = CIMXmlImpl.xmlAppendObjectPath(obj.getNameSpace(), obj.getModelPath(), xm);
            if (!obj.isLocalOnly()) {
                CIMXmlImpl.xmlAppendBooleanParamValue(xml, xm, CIMXmlImpl.LOCALONLY, false);
            }
            if (!obj.isQualifiersIncluded()) {
                CIMXmlImpl.xmlAppendBooleanParamValue(xml, xm, CIMXmlImpl.INCLUDEQUALIFIERS, false);
            }
            if (obj.isClassOriginIncluded()) {
                CIMXmlImpl.xmlAppendBooleanParamValue(xml, xm, CIMXmlImpl.INCLUDECLASSORIGIN, true);
            }
            CIMXmlImpl.xmlAppendStringsParamValue(xml, xm, CIMXmlImpl.PROPERTYLIST, obj.getPropertyList());
            return CIMXmlImpl.xmlRequest("GetClass", xml.toString(), xm);
        }
    }

    private static class ExecQueryXml
    implements XmlRequest {
        private ExecQueryXml() {
        }

        public String getRequest(CIMOperation cimOp, XmlInstance xm) {
            CIMExecQueryOp obj = (CIMExecQueryOp)cimOp;
            StringBuffer xml = CIMXmlImpl.getXmlStringBuffer(obj.getNameSpace(), obj.getModelPath(), xm);
            xml.append(xm.iParamValue(CIMXmlImpl.QUERYLANGUAGE, obj.getQueryLanguage()) + xm.iParamValue(CIMXmlImpl.QUERY, obj.getQuery()));
            return CIMXmlImpl.xmlRequest("ExecQuery", xml.toString(), xm);
        }
    }

    private static class EnumQualifierTypesXml
    implements XmlRequest {
        private EnumQualifierTypesXml() {
        }

        public String getRequest(CIMOperation cimOp, XmlInstance xm) {
            CIMEnumQualifierTypesOp obj = (CIMEnumQualifierTypesOp)cimOp;
            StringBuffer xml = CIMXmlImpl.getXmlStringBuffer(obj.getNameSpace(), obj.getModelPath(), xm);
            return CIMXmlImpl.xmlRequest("EnumerateQualifiers", xml.toString(), xm);
        }
    }

    private static class EnumNameSpaceXml
    implements XmlRequest {
        private EnumNameSpaceXml() {
        }

        public String getRequest(CIMOperation cimOp, XmlInstance xm) {
            CIMEnumNameSpaceOp obj = (CIMEnumNameSpaceOp)cimOp;
            CIMObjectPath path = obj.getModelPath();
            path.setObjectName("__Namespace");
            StringBuffer xml = CIMXmlImpl.xmlAppendObjectPath(obj.getNameSpace(), path, xm);
            return CIMXmlImpl.xmlRequest("EnumerateInstanceNames", xml.toString(), xm);
        }
    }

    private static class EnumInstancesXml
    implements XmlRequest {
        private EnumInstancesXml() {
        }

        public String getRequest(CIMOperation cimOp, XmlInstance xm) {
            CIMEnumInstancesOp obj = (CIMEnumInstancesOp)cimOp;
            StringBuffer xml = CIMXmlImpl.xmlAppendObjectPath(obj.getNameSpace(), obj.getModelPath(), xm);
            if (!obj.isLocalOnly()) {
                CIMXmlImpl.xmlAppendBooleanParamValue(xml, xm, CIMXmlImpl.LOCALONLY, false);
            }
            if (!obj.isDeep()) {
                CIMXmlImpl.xmlAppendBooleanParamValue(xml, xm, CIMXmlImpl.DEEPINHERITANCE, false);
            }
            if (obj.isQualifiersIncluded()) {
                CIMXmlImpl.xmlAppendBooleanParamValue(xml, xm, CIMXmlImpl.INCLUDEQUALIFIERS, true);
            }
            if (obj.isClassOriginIncluded()) {
                CIMXmlImpl.xmlAppendBooleanParamValue(xml, xm, CIMXmlImpl.INCLUDECLASSORIGIN, true);
            }
            CIMXmlImpl.xmlAppendStringsParamValue(xml, xm, CIMXmlImpl.PROPERTYLIST, obj.getPropertyList());
            return CIMXmlImpl.xmlRequest("EnumerateInstances", xml.toString(), xm);
        }
    }

    private static class EnumClassXml
    implements XmlRequest {
        private EnumClassXml() {
        }

        public String getRequest(CIMOperation cimOp, XmlInstance xm) {
            CIMEnumClassOp obj = (CIMEnumClassOp)cimOp;
            StringBuffer xml = CIMXmlImpl.xmlAppendObjectPath(obj.getNameSpace(), obj.getModelPath(), xm);
            if (!obj.isLocalOnly()) {
                CIMXmlImpl.xmlAppendBooleanParamValue(xml, xm, CIMXmlImpl.LOCALONLY, false);
            }
            if (obj.isDeep()) {
                CIMXmlImpl.xmlAppendBooleanParamValue(xml, xm, CIMXmlImpl.DEEPINHERITANCE, true);
            }
            if (!obj.isQualifiersIncluded()) {
                CIMXmlImpl.xmlAppendBooleanParamValue(xml, xm, CIMXmlImpl.INCLUDEQUALIFIERS, false);
            }
            if (obj.isClassOriginIncluded()) {
                CIMXmlImpl.xmlAppendBooleanParamValue(xml, xm, CIMXmlImpl.INCLUDECLASSORIGIN, true);
            }
            return CIMXmlImpl.xmlRequest("EnumerateClasses", xml.toString(), xm);
        }
    }

    private static class EnumClassNamesXml
    implements XmlRequest {
        private EnumClassNamesXml() {
        }

        public String getRequest(CIMOperation cimOp, XmlInstance xm) {
            CIMEnumClassNamesOp obj = (CIMEnumClassNamesOp)cimOp;
            StringBuffer xml = CIMXmlImpl.xmlAppendObjectPath(obj.getNameSpace(), obj.getModelPath(), xm);
            if (obj.isDeep()) {
                xml.append(xm.iParamValue(CIMXmlImpl.DEEPINHERITANCE, true));
            }
            return CIMXmlImpl.xmlRequest("EnumerateClassNames", xml.toString(), xm);
        }
    }

    private static class EnumInstanceNamesXml
    implements XmlRequest {
        private EnumInstanceNamesXml() {
        }

        public String getRequest(CIMOperation cimOp, XmlInstance xm) {
            CIMEnumInstanceNamesOp obj = (CIMEnumInstanceNamesOp)cimOp;
            StringBuffer xml = CIMXmlImpl.xmlAppendObjectPath(obj.getNameSpace(), obj.getModelPath(), xm);
            return CIMXmlImpl.xmlRequest("EnumerateInstanceNames", xml.toString(), xm);
        }
    }

    private static class DeleteQualifierTypeXml
    implements XmlRequest {
        private DeleteQualifierTypeXml() {
        }

        public String getRequest(CIMOperation cimOp, XmlInstance xm) {
            CIMDeleteQualifierTypeOp obj = (CIMDeleteQualifierTypeOp)cimOp;
            StringBuffer xml = CIMXmlImpl.getXmlStringBuffer(obj.getNameSpace(), obj.getModelPath(), xm);
            xml.append(xm.iParamValue(CIMXmlImpl.QUALIFIERNAME, obj.getModelPath().getObjectName()));
            return CIMXmlImpl.xmlRequest("DeleteQualifier", xml.toString(), xm);
        }
    }

    private static class DeleteNameSpaceXml
    implements XmlRequest {
        private DeleteNameSpaceXml() {
        }

        public String getRequest(CIMOperation cimOp, XmlInstance xm) {
            CIMDeleteNameSpaceOp obj = (CIMDeleteNameSpaceOp)cimOp;
            MapNamespace mns = new MapNamespace(obj.getNameSpace(), obj.getRelativeNameSpace());
            StringBuffer xml = CIMXmlImpl.xmlAppendObjectPath(mns.getMappedNs(), mns.getMappedOp(), xm);
            return CIMXmlImpl.xmlRequest("DeleteInstance", xml.toString(), xm);
        }
    }

    private static class DeleteInstanceXml
    implements XmlRequest {
        private DeleteInstanceXml() {
        }

        public String getRequest(CIMOperation cimOp, XmlInstance xm) {
            CIMDeleteInstanceOp obj = (CIMDeleteInstanceOp)cimOp;
            StringBuffer xml = CIMXmlImpl.xmlAppendObjectPath(obj.getNameSpace(), obj.getModelPath(), xm);
            return CIMXmlImpl.xmlRequest("DeleteInstance", xml.toString(), xm);
        }
    }

    private static class DeleteClassXml
    implements XmlRequest {
        private DeleteClassXml() {
        }

        public String getRequest(CIMOperation cimOp, XmlInstance xm) {
            CIMDeleteClassOp obj = (CIMDeleteClassOp)cimOp;
            StringBuffer xml = CIMXmlImpl.xmlAppendObjectPath(obj.getNameSpace(), obj.getModelPath(), xm);
            return CIMXmlImpl.xmlRequest("DeleteClass", xml.toString(), xm);
        }
    }

    private static class CreateQualifierTypeXml
    implements XmlRequest {
        private CreateQualifierTypeXml() {
        }

        public String getRequest(CIMOperation cimOp, XmlInstance xm) {
            CIMCreateQualifierTypeOp obj = (CIMCreateQualifierTypeOp)cimOp;
            StringBuffer xml = CIMXmlImpl.getXmlStringBuffer(obj.getNameSpace(), obj.getModelPath(), xm);
            xml.append(xm.iParamValue(obj.getCIMQualifierType()));
            return CIMXmlImpl.xmlRequest("CreateQualifier", xml.toString(), xm);
        }
    }

    private static class CreateNameSpaceXml
    implements XmlRequest {
        private CreateNameSpaceXml() {
        }

        public String getRequest(CIMOperation cimOp, XmlInstance xm) {
            CIMCreateNameSpaceOp obj = (CIMCreateNameSpaceOp)cimOp;
            MapNamespace mns = new MapNamespace(obj.getNameSpace(), obj.getRelativeNameSpace());
            StringBuffer xml = CIMXmlImpl.getXmlStringBuffer(mns.getMappedNs(), mns.getMappedOp(), xm);
            xml.append(xm.iParamValue(mns.getMappedInstance()));
            return CIMXmlImpl.xmlRequest("CreateInstance", xml.toString(), xm);
        }
    }

    private static class CreateInstanceXml
    implements XmlRequest {
        private CreateInstanceXml() {
        }

        public String getRequest(CIMOperation cimOp, XmlInstance xm) {
            CIMCreateInstanceOp obj = (CIMCreateInstanceOp)cimOp;
            StringBuffer xml = CIMXmlImpl.getXmlStringBuffer(obj.getNameSpace(), obj.getModelPath(), xm);
            xml.append(xm.iParamValue(obj.getCIMInstance()));
            return CIMXmlImpl.xmlRequest("CreateInstance", xml.toString(), xm);
        }
    }

    private static class CreateClassXml
    implements XmlRequest {
        private CreateClassXml() {
        }

        public String getRequest(CIMOperation cimOp, XmlInstance xm) {
            CIMCreateClassOp obj = (CIMCreateClassOp)cimOp;
            xm.setShowImplied(true);
            StringBuffer xml = CIMXmlImpl.getXmlStringBuffer(obj.getNameSpace(), obj.getModelPath(), xm);
            xml.append(xm.iParamValue(obj.getCIMClass(), "CreateClass"));
            return CIMXmlImpl.xmlRequest("CreateClass", xml.toString(), xm);
        }
    }

    private static class AssociatorsXml
    implements XmlRequest {
        private AssociatorsXml() {
        }

        public String getRequest(CIMOperation cimOp, XmlInstance xm) {
            CIMAssociatorsOp obj = (CIMAssociatorsOp)cimOp;
            StringBuffer xml = CIMXmlImpl.getXmlStringBuffer(obj.getNameSpace(), obj.getModelPath(), xm);
            String assocClass = obj.getAssociationClass();
            String resultClass = obj.getResultClass();
            String resultRole = obj.getResultRole();
            String role = obj.getRole();
            boolean includeQualifiers = obj.isQualifiersIncluded();
            boolean includeClassOrigin = obj.isClassOriginIncluded();
            String[] propertyList = obj.getPropertyList();
            xml.append(xm.iParamValue(CIMXmlImpl.OBJECTNAME, obj.getModelPath()) + (assocClass != null ? xm.iParamValue(CIMXmlImpl.ASSOCCLASS, new CIMObjectPath(assocClass)) : "") + (resultClass != null ? xm.iParamValue(CIMXmlImpl.RESULTCLASS, new CIMObjectPath(resultClass)) : "") + (resultRole != null ? xm.iParamValue(CIMXmlImpl.RESULTROLE, resultRole) : "") + (role != null ? xm.iParamValue(CIMXmlImpl.ROLE, role) : "") + (includeQualifiers ? xm.iParamValue(CIMXmlImpl.INCLUDEQUALIFIERS, includeQualifiers) : "") + (includeClassOrigin ? xm.iParamValue(CIMXmlImpl.INCLUDECLASSORIGIN, includeClassOrigin) : "") + (propertyList != null ? xm.iParamValue(CIMXmlImpl.PROPERTYLIST, propertyList) : ""));
            return CIMXmlImpl.xmlRequest("Associators", xml.toString(), xm);
        }
    }

    private static class AssociatorNamesXml
    implements XmlRequest {
        private AssociatorNamesXml() {
        }

        public String getRequest(CIMOperation cimOp, XmlInstance xm) {
            CIMAssociatorNamesOp obj = (CIMAssociatorNamesOp)cimOp;
            StringBuffer xml = CIMXmlImpl.getXmlStringBuffer(obj.getNameSpace(), obj.getModelPath(), xm);
            String assocClass = obj.getAssociationClass();
            String resultClass = obj.getResultClass();
            String resultRole = obj.getResultRole();
            String role = obj.getRole();
            xml.append(xm.iParamValue(CIMXmlImpl.OBJECTNAME, obj.getModelPath()) + (assocClass != null ? xm.iParamValue(CIMXmlImpl.ASSOCCLASS, new CIMObjectPath(assocClass)) : "") + (resultClass != null ? xm.iParamValue(CIMXmlImpl.RESULTCLASS, new CIMObjectPath(resultClass)) : "") + (role != null ? xm.iParamValue(CIMXmlImpl.ROLE, role) : "") + (resultRole != null ? xm.iParamValue(CIMXmlImpl.RESULTROLE, resultRole) : ""));
            return CIMXmlImpl.xmlRequest("AssociatorNames", xml.toString(), xm);
        }
    }

    static interface XmlRequest {
        public String getRequest(CIMOperation var1, XmlInstance var2);
    }

    private static class ExportIndicationXml
    implements XmlExpRequest {
        private ExportIndicationXml() {
        }

        public String getRequest(CIMExport cimOp, XmlInstance xm) {
            CIMExportIndication obj = (CIMExportIndication)cimOp;
            return xm.expcall(CIMXmlImpl.EXPORTINDICATION, xm.iParamValue(obj.getIndication()));
        }
    }

    static interface XmlExpRequest {
        public String getRequest(CIMExport var1, XmlInstance var2);
    }
}

