/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.cim;

import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMElement;
import javax.wbem.cim.CIMFlavor;
import javax.wbem.cim.CIMQualifierType;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.MOFFormatter;

public class CIMQualifier
extends CIMElement
implements Cloneable {
    static final long serialVersionUID = 200L;
    private CIMValue value;
    private Vector flavors = new Vector();

    public CIMValue getValue() {
        return this.value;
    }

    public void setValue(CIMValue value) {
        this.value = value;
    }

    public void setDefaults(CIMQualifierType cqt) {
        if (!this.hasValue() && cqt.hasDefaultValue()) {
            CIMValue cv = cqt.getDefaultValue();
            this.value = cv.getType() == null && cqt.getType() != null ? new CIMValue(cv.getValue(), cqt.getType()) : cv;
        }
        if (this.flavors == null || this.flavors.size() == 0) {
            this.flavors = (Vector)cqt.getFlavor().clone();
        }
    }

    public boolean hasFlavor(CIMFlavor flavor) {
        if (this.flavors == null) {
            return false;
        }
        Enumeration e = this.flavors.elements();
        while (e.hasMoreElements()) {
            if (!((CIMFlavor)e.nextElement()).equals(flavor)) continue;
            return true;
        }
        return false;
    }

    public void addFlavor(CIMFlavor newFlavor) {
        if (!this.hasFlavor(newFlavor)) {
            this.flavors.addElement(newFlavor);
        }
    }

    public CIMQualifier() {
        super("");
    }

    public CIMQualifier(String CIMQualifierName) {
        super(CIMQualifierName);
        this.value = null;
        this.flavors = new Vector();
    }

    public CIMQualifier(String CIMQualifierName, CIMQualifierType cgt) {
        this(CIMQualifierName);
        this.setDefaults(cgt);
    }

    public String toString() {
        return this.toMOF();
    }

    public String toMOF() {
        MOFFormatter mf = new MOFFormatter();
        return mf.toString(this);
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CIMQualifier)) {
            return false;
        }
        return super.equals(o);
    }

    public synchronized Object clone() {
        CIMQualifier qe = new CIMQualifier();
        qe.name = this.name;
        qe.identifier = this.identifier;
        qe.value = this.value;
        qe.flavors = (Vector)this.flavors.clone();
        return qe;
    }

    public Vector getFlavor() {
        return this.flavors;
    }
}

