/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.cim;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import javax.wbem.client.Debug;

public class CIMNameSpace
implements Serializable {
    static final long serialVersionUID = 200L;
    private String host = ".";
    private String nameSpace = "\\root\\cimv2";
    private URL hostURL = null;

    private String validateNameSpace(String s) {
        if (s == null || s.length() == 0) {
            return "";
        }
        boolean startindex = false;
        s = s.replace('/', '\\');
        s = s.toLowerCase();
        StringBuffer sb = new StringBuffer("");
        int j = s.length();
        for (int i = 0; i < j; ++i) {
            char c = s.charAt(i);
            sb.append(c);
            if (c != '\\') continue;
            int nextChar = i + 1;
            while (nextChar < j && s.charAt(nextChar) == '\\') {
                i = nextChar++;
            }
        }
        s = sb.toString();
        int endindex = s.length();
        if (endindex > 1 && s.endsWith("\\")) {
            --endindex;
        }
        return s.substring(0, endindex).toLowerCase();
    }

    public CIMNameSpace() {
        this(null);
    }

    public CIMNameSpace(String h) {
        if (h == null) {
            Debug.trace3("Defaulting: host = 'localhost', hostURL = null");
            this.host = "localhost";
        } else {
            try {
                this.hostURL = new URL(h);
                this.host = this.hostURL.getHost();
            }
            catch (MalformedURLException e) {
                if (h.indexOf(47) >= 0 || h.indexOf(92) >= 0) {
                    Debug.trace1("Found '/' or '//' in string.");
                    throw new IllegalArgumentException(h);
                }
                Debug.trace3("Defaulting: host = '" + h + "', hostURL = null");
                this.host = h;
            }
        }
    }

    public CIMNameSpace(String host, String ns) {
        this(host);
        this.nameSpace = this.validateNameSpace(ns);
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public String getHost() {
        return this.host;
    }

    public URL getHostURL() {
        return this.hostURL;
    }

    public void parse(String p) {
        int index = 0;
        String s = p.replace('/', '\\');
        if (s.startsWith("\\\\")) {
            index = s.indexOf("\\", 3);
            this.host = s.substring(2, index);
        }
        if (s.charAt(index) == '\\') {
            ++index;
        }
        this.nameSpace = s.substring(index, s.lastIndexOf("\\"));
    }

    public void setNameSpace(String ns) {
        this.nameSpace = this.validateNameSpace(ns);
    }

    public void setHost(String h) {
        this.host = h;
    }

    public String toString() {
        return "\\\\" + this.host + "\\" + this.nameSpace;
    }
}

